/*
 * Decompiled with CFR 0.152.
 */
package org.afree.chart.plot;

import android.graphics.PathEffect;
import java.io.Serializable;
import java.util.Arrays;
import org.afree.chart.ChartColor;
import org.afree.chart.plot.DrawingSupplier;
import org.afree.graphics.PaintType;
import org.afree.graphics.SolidColor;
import org.afree.graphics.geom.OvalShape;
import org.afree.graphics.geom.Polygon;
import org.afree.graphics.geom.RectShape;
import org.afree.graphics.geom.Shape;
import org.afree.util.ShapeUtilities;

public class DefaultDrawingSupplier
implements DrawingSupplier,
Cloneable,
Serializable {
    private static final long serialVersionUID = -7339847061039422538L;
    public static final PaintType[] DEFAULT_PAINT_TYPE_SEQUENCE = ChartColor.createDefaultPaintArray();
    public static final PathEffect[] DEFAULT_PATH_EFFECT_SEQUENCE = new PathEffect[1];
    public static final PaintType white = new SolidColor(-1);
    public static final PaintType ltGray = new SolidColor(-3355444);
    public static final PaintType[] DEFAULT_OUTLINE_PAINT_TYPE_SEQUENCE = new PaintType[]{ltGray};
    public static final PathEffect[] DEFAULT_OUTLINE_EFFECT_SEQUENCE = new PathEffect[1];
    public static final PaintType[] DEFAULT_FILL_PAINT_TYPE_SEQUENCE = new PaintType[]{white};
    public static final float[] DEFAULT_STROKE_SEQUENCE = new float[]{1.0f};
    public static final float[] DEFAULT_OUTLINE_STROKE_SEQUENCE = new float[]{1.0f};
    public static final Shape[] DEFAULT_SHAPE_SEQUENCE = DefaultDrawingSupplier.createStandardSeriesShapes();
    private transient PaintType[] paintTypeSequence;
    private int paintTypeIndex;
    private transient PathEffect[] pathEffectSequence;
    private int pathEffectIndex;
    private transient PaintType[] outlinePaintTypeSequence;
    private int outlinePaintTypeIndex;
    private transient PathEffect[] outlineEffectSequence;
    private int outlineEffectIndex;
    private transient PaintType[] fillPaintTypeSequence;
    private int fillPaintTypeIndex;
    private transient float[] strokeSequence;
    private int strokeIndex;
    private transient float[] outlineStrokeSequence;
    private int outlineStrokeIndex;
    private transient Shape[] shapeSequence;
    private int shapeIndex;

    public DefaultDrawingSupplier() {
        this(DEFAULT_PAINT_TYPE_SEQUENCE, DEFAULT_FILL_PAINT_TYPE_SEQUENCE, DEFAULT_OUTLINE_PAINT_TYPE_SEQUENCE, DEFAULT_STROKE_SEQUENCE, DEFAULT_PATH_EFFECT_SEQUENCE, DEFAULT_OUTLINE_STROKE_SEQUENCE, DEFAULT_OUTLINE_EFFECT_SEQUENCE, DEFAULT_SHAPE_SEQUENCE);
    }

    public DefaultDrawingSupplier(PaintType[] paintSequence, PaintType[] outlinePaintSequence, float[] strokeSequence, PathEffect[] pathEffectSequence, float[] outlineStrokeSequence, PathEffect[] outlineEffectSequence, Shape[] shapeSequence) {
        this.paintTypeSequence = paintSequence;
        this.fillPaintTypeSequence = DEFAULT_FILL_PAINT_TYPE_SEQUENCE;
        this.outlinePaintTypeSequence = outlinePaintSequence;
        this.strokeSequence = strokeSequence;
        this.pathEffectSequence = pathEffectSequence;
        this.outlineStrokeSequence = outlineStrokeSequence;
        this.outlineEffectSequence = outlineEffectSequence;
        this.shapeSequence = shapeSequence;
    }

    public DefaultDrawingSupplier(PaintType[] paintSequence, PaintType[] fillPaintSequence, PaintType[] outlinePaintSequence, float[] strokeSequence, PathEffect[] pathEffectSequence, float[] outlineStrokeSequence, PathEffect[] outlineEffectSequence, Shape[] shapeSequence) {
        this.paintTypeSequence = paintSequence;
        this.fillPaintTypeSequence = fillPaintSequence;
        this.outlinePaintTypeSequence = outlinePaintSequence;
        this.strokeSequence = strokeSequence;
        this.pathEffectSequence = pathEffectSequence;
        this.outlineStrokeSequence = outlineStrokeSequence;
        this.outlineEffectSequence = outlineEffectSequence;
        this.shapeSequence = shapeSequence;
    }

    public PaintType getNextPaintType() {
        PaintType result = this.paintTypeSequence[this.paintTypeIndex % this.paintTypeSequence.length];
        ++this.paintTypeIndex;
        return result;
    }

    public PathEffect getNextEffect() {
        PathEffect result = this.pathEffectSequence[this.pathEffectIndex % this.pathEffectSequence.length];
        ++this.pathEffectIndex;
        return result;
    }

    public PaintType getNextOutlinePaintType() {
        PaintType result = this.outlinePaintTypeSequence[this.outlinePaintTypeIndex % this.outlinePaintTypeSequence.length];
        ++this.outlinePaintTypeIndex;
        return result;
    }

    public PaintType getNextFillPaintType() {
        PaintType result = this.fillPaintTypeSequence[this.fillPaintTypeIndex % this.fillPaintTypeSequence.length];
        ++this.fillPaintTypeIndex;
        return result;
    }

    public float getNextStroke() {
        float result = this.strokeSequence[this.strokeIndex % this.strokeSequence.length];
        ++this.strokeIndex;
        return result;
    }

    public float getNextOutlineStroke() {
        float result = this.outlineStrokeSequence[this.outlineStrokeIndex % this.outlineStrokeSequence.length];
        ++this.outlineStrokeIndex;
        return result;
    }

    public PathEffect getNextOutlineEffect() {
        PathEffect result = this.outlineEffectSequence[this.outlineEffectIndex % this.outlineEffectSequence.length];
        ++this.outlineEffectIndex;
        return result;
    }

    public Shape getNextShape() {
        Shape result = this.shapeSequence[this.shapeIndex % this.shapeSequence.length];
        ++this.shapeIndex;
        return result;
    }

    public static Shape[] createStandardSeriesShapes() {
        Shape[] result = new Shape[10];
        double size = 6.0;
        double delta = size / 2.0;
        int[] xpoints = null;
        int[] ypoints = null;
        result[0] = new RectShape(-delta, -delta, size, size);
        result[1] = new OvalShape(-delta, -delta, size, size);
        xpoints = DefaultDrawingSupplier.intArray(0.0, delta, -delta);
        ypoints = DefaultDrawingSupplier.intArray(-delta, delta, delta);
        result[2] = new Polygon(xpoints, ypoints, 3);
        xpoints = DefaultDrawingSupplier.intArray(0.0, delta, 0.0, -delta);
        ypoints = DefaultDrawingSupplier.intArray(-delta, 0.0, delta, 0.0);
        result[3] = new Polygon(xpoints, ypoints, 4);
        result[4] = new RectShape(-delta, -delta / 2.0, size, size / 2.0);
        xpoints = DefaultDrawingSupplier.intArray(-delta, delta, 0.0);
        ypoints = DefaultDrawingSupplier.intArray(-delta, -delta, delta);
        result[5] = new Polygon(xpoints, ypoints, 3);
        result[6] = new OvalShape(-delta, -delta / 2.0, size, size / 2.0);
        xpoints = DefaultDrawingSupplier.intArray(-delta, delta, -delta);
        ypoints = DefaultDrawingSupplier.intArray(-delta, 0.0, delta);
        result[7] = new Polygon(xpoints, ypoints, 3);
        result[8] = new RectShape(-delta / 2.0, -delta, size / 2.0, size);
        xpoints = DefaultDrawingSupplier.intArray(-delta, delta, delta);
        ypoints = DefaultDrawingSupplier.intArray(0.0, -delta, delta);
        result[9] = new Polygon(xpoints, ypoints, 3);
        return result;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof DefaultDrawingSupplier)) {
            return false;
        }
        DefaultDrawingSupplier that = (DefaultDrawingSupplier)obj;
        if (!Arrays.equals(this.paintTypeSequence, that.paintTypeSequence)) {
            return false;
        }
        if (this.paintTypeIndex != that.paintTypeIndex) {
            return false;
        }
        if (!Arrays.equals(this.outlinePaintTypeSequence, that.outlinePaintTypeSequence)) {
            return false;
        }
        if (this.outlinePaintTypeIndex != that.outlinePaintTypeIndex) {
            return false;
        }
        if (!Arrays.equals(this.strokeSequence, that.strokeSequence)) {
            return false;
        }
        if (this.strokeIndex != that.strokeIndex) {
            return false;
        }
        if (!Arrays.equals(this.outlineStrokeSequence, that.outlineStrokeSequence)) {
            return false;
        }
        if (this.outlineStrokeIndex != that.outlineStrokeIndex) {
            return false;
        }
        if (!this.equalShapes(this.shapeSequence, that.shapeSequence)) {
            return false;
        }
        return this.shapeIndex == that.shapeIndex;
    }

    private boolean equalShapes(Shape[] s1, Shape[] s2) {
        if (s1 == null) {
            return s2 == null;
        }
        if (s2 == null) {
            return false;
        }
        if (s1.length != s2.length) {
            return false;
        }
        int i = 0;
        while (i < s1.length) {
            if (!ShapeUtilities.equal(s1[i], s2[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private static int[] intArray(double a, double b, double c) {
        return new int[]{(int)a, (int)b, (int)c};
    }

    private static int[] intArray(double a, double b, double c, double d) {
        return new int[]{(int)a, (int)b, (int)c, (int)d};
    }

    public Object clone() throws CloneNotSupportedException {
        DefaultDrawingSupplier clone = (DefaultDrawingSupplier)super.clone();
        return clone;
    }
}

