/*
 * Decompiled with CFR 0.152.
 */
package org.afree.chart.axis;

import android.graphics.PathEffect;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.text.DateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import org.afree.data.time.RegularTimePeriod;
import org.afree.graphics.PaintType;
import org.afree.graphics.SolidColor;
import org.afree.graphics.geom.Font;
import org.afree.io.SerialUtilities;
import org.afree.ui.RectangleInsets;

public class PeriodAxisLabelInfo
implements Cloneable,
Serializable {
    private static final long serialVersionUID = 5710451740920277357L;
    public static final RectangleInsets DEFAULT_INSETS = new RectangleInsets(2.0, 2.0, 2.0, 2.0);
    public static final Font DEFAULT_FONT = new Font("SansSerif", 0, 10);
    public static final PaintType DEFAULT_LABEL_PAINT_TYPE = new SolidColor(-16777216);
    public static final float DEFAULT_DIVIDER_STROKE = 0.5f;
    public static final PaintType DEFAULT_DIVIDER_PAINT_TYPE = new SolidColor(-7829368);
    public static final PathEffect DEFAULT_DIVIDER_EFFECT = null;
    private Class periodClass;
    private RectangleInsets padding;
    private DateFormat dateFormat;
    private Font labelFont;
    private transient PaintType labelPaintType;
    private boolean drawDividers;
    private transient float dividerStroke;
    private transient PaintType dividerPaintType;
    private transient PathEffect dividerEffect;

    public PeriodAxisLabelInfo(Class periodClass, DateFormat dateFormat) {
        this(periodClass, dateFormat, DEFAULT_INSETS, DEFAULT_FONT, DEFAULT_LABEL_PAINT_TYPE, true, 0.5f, DEFAULT_DIVIDER_PAINT_TYPE, DEFAULT_DIVIDER_EFFECT);
    }

    public PeriodAxisLabelInfo(Class periodClass, DateFormat dateFormat, RectangleInsets padding, Font labelFont, PaintType labelPaintType, boolean drawDividers, float dividerStroke, PaintType dividerPaintType, PathEffect dividerEffect) {
        if (periodClass == null) {
            throw new IllegalArgumentException("Null 'periodClass' argument.");
        }
        if (dateFormat == null) {
            throw new IllegalArgumentException("Null 'dateFormat' argument.");
        }
        if (padding == null) {
            throw new IllegalArgumentException("Null 'padding' argument.");
        }
        if (labelFont == null) {
            throw new IllegalArgumentException("Null 'labelFont' argument.");
        }
        if (labelPaintType == null) {
            throw new IllegalArgumentException("Null 'labelPaint' argument.");
        }
        if (dividerStroke == 0.0f) {
            throw new IllegalArgumentException("Null 'dividerStroke' argument.");
        }
        if (dividerPaintType == null) {
            throw new IllegalArgumentException("Null 'dividerPaint' argument.");
        }
        this.periodClass = periodClass;
        this.dateFormat = dateFormat;
        this.padding = padding;
        this.labelFont = labelFont;
        this.labelPaintType = labelPaintType;
        this.drawDividers = drawDividers;
        this.dividerStroke = dividerStroke;
        this.dividerPaintType = dividerPaintType;
        this.dividerEffect = dividerEffect;
    }

    public PeriodAxisLabelInfo(Class periodClass, DateFormat dateFormat, RectangleInsets padding, Font labelFont, PaintType labelPaintType, boolean drawDividers, float dividerStroke, PaintType dividerPaintType) {
        this(periodClass, dateFormat, padding, labelFont, labelPaintType, drawDividers, dividerStroke, dividerPaintType, null);
    }

    public Class getPeriodClass() {
        return this.periodClass;
    }

    public DateFormat getDateFormat() {
        return this.dateFormat;
    }

    public RectangleInsets getPadding() {
        return this.padding;
    }

    public Font getLabelFont() {
        return this.labelFont;
    }

    public PaintType getLabelPaintType() {
        return this.labelPaintType;
    }

    public boolean getDrawDividers() {
        return this.drawDividers;
    }

    public float getDividerStroke() {
        return this.dividerStroke;
    }

    public PaintType getDividerPaintType() {
        return this.dividerPaintType;
    }

    public PathEffect getDividerEffect() {
        return this.dividerEffect;
    }

    public RegularTimePeriod createInstance(Date millisecond, TimeZone zone, Locale locale) {
        RegularTimePeriod result = null;
        try {
            Constructor c = this.periodClass.getDeclaredConstructor(Date.class, TimeZone.class, Locale.class);
            result = (RegularTimePeriod)c.newInstance(millisecond, zone, locale);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof PeriodAxisLabelInfo) {
            PeriodAxisLabelInfo info = (PeriodAxisLabelInfo)obj;
            if (!info.periodClass.equals(this.periodClass)) {
                return false;
            }
            if (!info.dateFormat.equals(this.dateFormat)) {
                return false;
            }
            if (!info.padding.equals(this.padding)) {
                return false;
            }
            if (!info.labelFont.equals(this.labelFont)) {
                return false;
            }
            if (!info.labelPaintType.equals(this.labelPaintType)) {
                return false;
            }
            if (info.drawDividers != this.drawDividers) {
                return false;
            }
            if (info.dividerStroke != this.dividerStroke) {
                return false;
            }
            return info.dividerPaintType.equals(this.dividerPaintType);
        }
        return false;
    }

    public int hashCode() {
        int result = 41;
        result = 37 * this.periodClass.hashCode();
        result = 37 * this.dateFormat.hashCode();
        return result;
    }

    public Object clone() throws CloneNotSupportedException {
        PeriodAxisLabelInfo clone = (PeriodAxisLabelInfo)super.clone();
        return clone;
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        stream.defaultWriteObject();
        SerialUtilities.writePaintType(this.labelPaintType, stream);
        SerialUtilities.writePaintType(this.dividerPaintType, stream);
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        this.labelPaintType = SerialUtilities.readPaintType(stream);
        this.dividerPaintType = SerialUtilities.readPaintType(stream);
    }
}

