/*
 *  TINET (TCP/IP Protocol Stack)
 * 
 *  Copyright (C) 2001-2009 by Dep. of Computer Science and Engineering
 *                   Tomakomai National College of Technology, JAPAN
 *
 *  L쌠҂́Cȉ (1)`(4) ̏CFree Software Foundation 
 *  ɂČ\Ă GNU General Public License  Version 2 ɋL
 *  qĂ𖞂ꍇɌC{\tgEFAi{\tgEFA
 *  ς̂܂ށDȉjgpEEρEĔzziȉC
 *  pƌĂԁj邱Ƃ𖳏ŋD
 *  (1) {\tgEFA\[XR[ȟ`ŗpꍇɂ́CL̒
 *      \C̗pщL̖ۏ؋K肪Ĉ܂܂̌`Ń\[
 *      XR[hɊ܂܂Ă邱ƁD
 *  (2) {\tgEFACCu`ȂǁC̃\tgEFAJɎg
 *      pł`ōĔzzꍇɂ́CĔzzɔhLgip
 *      ҃}jAȂǁjɁCL̒쌠\C̗pщL
 *      ̖ۏ؋Kfڂ邱ƁD
 *  (3) {\tgEFAC@ɑgݍނȂǁC̃\tgEFAJɎg
 *      płȂ`ōĔzzꍇɂ́C̏𖞂ƁD
 *    (a) ĔzzɔhLgip҃}jAȂǁjɁCL̒
 *        쌠\C̗pщL̖ۏ؋Kfڂ邱ƁD
 *  (4) {\tgEFA̗pɂ蒼ړI܂͊ԐړIɐ邢Ȃ鑹
 *      QCL쌠҂TOPPERSvWFNgƐӂ邱ƁD
 *
 *  {\tgEFÁCۏ؂Œ񋟂Ă̂łDL쌠҂
 *  TOPPERSvWFNǵC{\tgEFAɊւāC̓Kp\
 *  ܂߂āCȂۏ؂sȂD܂C{\tgEFA̗pɂ蒼
 *  ړI܂͊ԐړIɐȂ鑹QɊւĂC̐ӔC𕉂ȂD
 * 
 *  @(#) $Id: tcp_var.h,v 1.5 2009/12/24 05:47:21 abe Exp abe $
 */

/*
 * Copyright (c) 1982, 1986, 1993, 1994, 1995
 *	The Regents of the University of California.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *	This product includes software developed by the University of
 *	California, Berkeley and its contributors.
 * 4. Neither the name of the University nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 *	@(#)tcp_var.h	8.4 (Berkeley) 5/24/95
 * $FreeBSD: src/sys/netinet/tcp_var.h,v 1.49.2.1 1999/08/29 16:29:57 peter Exp $
 */
 
#ifndef _TCP_VAR_H_
#define _TCP_VAR_H_

/*
 *  TCP wb_EyC[hANZX}N
 */

#define IP_TCP_HDR_SIZE			(IP_HDR_SIZE + TCP_HDR_SIZE)
#define IF_IP_TCP_HDR_SIZE		(IF_IP_HDR_SIZE + TCP_HDR_SIZE)
#define IF_IP_TCP_HDR_OFFSET		(IF_IP_HDR_SIZE)
#define IF_IP_TCP_SDU_OFFSET		(IF_IP_TCP_HDR_SIZE)

#define GET_TCP_HDR(nbuf,thoff)		((T_TCP_HDR*)((uint8_t*)((nbuf)->buf) + thoff))
#define GET_TCP_OPT(nbuf,thoff)		((uint8_t*)((nbuf)->buf) + thoff + TCP_HDR_SIZE)
#define GET_TCP_SDU(nbuf,thoff)		((uint8_t*)((nbuf)->buf) + thoff + GET_TCP_HDR_SIZE2(nbuf,thoff))

#define GET_TCP_HDR_OFFSET(nbuf)	(GET_IF_IP_HDR_SIZE(nbuf))

#define GET_TCP_HDR_SIZE2(nbuf,thoff)	(TCP_HDR_LEN(GET_TCP_HDR(nbuf,thoff)->doff))
#define GET_IP_TCP_HDR_SIZE2(nbuf,thoff) \
					(GET_IP_HDR_SIZE(GET_IP_HDR(nbuf)) + GET_TCP_HDR_SIZE2(nbuf,thoff))
#define GET_IF_IP_TCP_HDR_SIZE2(nbuf,thoff) \
					(IF_HDR_SIZE + GET_IP_TCP_HDR_SIZE2(nbuf,thoff))

/*
 *  TINET 1.1 Ƃ̌݊̂߂̒`
 */

#if defined(SUPPORT_INET4)

#define IP4_TCP_HDR_SIZE		IP_TCP_HDR_SIZE
#define IF_IP4_TCP_HDR_SIZE		IF_IP_TCP_HDR_SIZE
#define GET_IP4_TCP_HDR_SIZE(nbuf)	GET_IP_TCP_HDR_SIZE(nbuf)	
#define GET_IF_IP4_TCP_HDR_SIZE(nbuf)	GET_IF_IP_TCP_HDR_SIZE(nbuf)	

#endif	/* of #if defined(SUPPORT_INET4) */

/*
 *  TINET 1.3 Ƃ̌݊̂߂̒`
 */

#define	TMIN_TCP_CREPID			TMIN_TCP_REPID
#define	TMIN_TCP_CCEPID			TMIN_TCP_CEPID
#define	TNUM_TCP_CREPID			TNUM_TCP_REPID
#define	TNUM_TCP_CCEPID			TNUM_TCP_CEPID

/*
 *  R[obN֐̒`
 */

typedef ER	(*t_tcp_callback)(ID cepid, FN fncd, void *p_parblk);

/*
 *  TCP t
 */

/* IPv4 p TCP t */
typedef struct t_tcp4_rep {

	/*
	 * ITRON TCP/IP APIATCP tƓo
	 */
	ATR		repatr;		/* t		*/
	T_IPV4EP	myaddr;		/* ̃AhX	*/

#ifdef TCP_CFG_EXTENTIONS
	uint16_t	flags;		/* ttO		*/
	ID		semid_lock;	/* tbN		*/
#endif	/* of #ifdef TCP_CFG_EXTENTIONS */

} T_TCP4_REP;

/* IPv6 p TCP t */
typedef struct t_tcp6_rep {

	/*
	 * ITRON TCP/IP APIATCP tƓo
	 */
	ATR		repatr;		/* t		*/
	T_IPV6EP	myaddr;		/* ̃AhX	*/

#ifdef TCP_CFG_EXTENTIONS
	uint16_t	flags;		/* ttO		*/
	ID		semid_lock;	/* tbN		*/
#endif	/* of #ifdef TCP_CFG_EXTENTIONS */

} T_TCP6_REP;

#if defined(SUPPORT_INET4)
#define T_TCP_REP	T_TCP4_REP
#endif

#if defined(SUPPORT_INET6)
#define T_TCP_REP	T_TCP6_REP
#endif

/*
 *  ttO
 */

#define TCP_REP_FLG_DYNAMIC	UINT_C(0x0400)	/* IE폜\tB	*/
#define TCP_REP_FLG_VALID	UINT_C(0x0800)	/* ς݂ŗLȎtB	*/

/*
 *  TCP ʐM[_
 */

typedef uint32_t T_TCP_SEQ;
typedef uint16_t T_TCP_SEG;
typedef uint16_t T_TCP_WND;

/*
 * ʏ IPv4 TCP ʐM[_
 */
typedef struct t_tcp4_cep {

	/*
	 * ITRON TCP/IP APIATCP ʐM[_Ɠo
	 */
	ATR		cepatr;		/* ʐM[_			*/
	void		*sbuf;		/* MpEBhobt@	*/
	int_t		sbufsz;		/* MpEBhobt@TCY	*/
	void		*rbuf;		/* MpEBhobt@	*/
	int_t		rbufsz;		/* MpEBhobt@TCY	*/
	t_tcp_callback	callback;	/* R[obN֐		*/

	/*
	 * TINET Ǝ̃o
	 */
	uint32_t	flags;		/* ʐM[_tO		*/
	ID		semid_lock;	/* ʐM[_bN		*/
	ID		est_flgid;	/* RlNVԃCxgtO	*/
	ID		snd_flgid;	/* MCxgtO		*/
	ID		rcv_flgid;	/* MCxgtO		*/
	ID		snd_tskid;	/* M^XNʎq		*/
	ID		rcv_tskid;	/* M^XNʎq		*/
	uint8_t		*sbuf_rptr;	/* Mpǂݏo|C^	*/
	uint8_t		*sbuf_wptr;	/* Mp݃|C^	*/
	uint8_t		*rbuf_rptr;	/* Mpǂݏo|C^	*/
	uint8_t		*rbuf_wptr;	/* Mp݃|C^	*/
	T_TCP_SEQ	snd_ssthresh;	/* tsEBhTCY(snd_cwnd)	*/
					/* ̂l			*/
	T_TCP_TIME	rxtcur;		/* ݂̍đ^CAEg	*/
	T_TCP_TIME	srtt;		/* ꂽ RTT		*/
	T_TCP_TIME	rttvar;		/* ꂽU		*/
	T_TCP_WND	snd_cwnd;	/* tsEBhTCY		*/

	/*
	 *  ̍őMZOgTCY	
	 *
	 *    IWił́Aʂ̃ZOg̍őTCY (t_maxseg) ƁA
	 *    IvVt̃ZOg̍őTCY (t_maxopd) ʂ
	 *    ȂĂB́Ã݂C^[lbgł́AIvVt
	 *    ZOĝقƐĂ邽߂łB
	 *    {ł́AőZOgTCYIvVȊÕIvV
	 *    Ȃ̂ŁAt_maxseg ̎gpB
	 */
	T_TCP_SEG	maxseg;

	int16_t		snd_tfn;	/* M쒆 API @\R[h	*/
	int16_t		rcv_tfn;	/* M쒆 API @\R[h	*/

#ifdef TCP_CFG_NON_BLOCKING

	T_IPV4EP 	*p_dstaddr;	/* ̃AhXւ̃|C^	*/
	T_IPV4EP 	*p_myaddr;	/* ̃AhXւ̃|C^	*/
	int16_t		snd_nblk_tfn;	/* M쒆 API @\R[h	*/
	int16_t		rcv_nblk_tfn;	/* M쒆 API @\R[h	*/
	void		*snd_data;	/* Mf[^̈̐擪AhX	*/
	int_t		snd_len;	/* Mf[^̈̒		*/
	void		*rcv_data;	/* Mf[^̈̐擪AhX	*/
	int_t		rcv_len;	/* Mf[^̈̒		*/
	void		**snd_p_buf;	/* Mobt@ւ̃|C^	*/
	void		**rcv_p_buf;	/* Mobt@ւ̃|C^	*/

#endif	/* of #ifdef TCP_CFG_NON_BLOCKING */

#ifdef TCP_CFG_SWBUF_CSAVE
	T_NET_BUF	*swbufq;	/* MEBhobt@L[	*/
#endif	/* of #ifdef TCP_CFG_SWBUF_CSAVE */

	/*
	 *  ȍ~̃o[ tcp_init_cep() ֐Ń[NA[B
	 */

	T_TCP_TIME	timer[NUM_TCP_TIMERS];	/* TCP ̃^C}		*/
	T_IPV4EP	dstaddr;	/* ̃AhX		*/
	T_IPV4EP	myaddr;		/* ̃AhX		*/
	T_TCP4_REP	*rep;		/* t			*/
	T_NET_BUF	*reassq;	/* Mč\L[		*/

#ifdef TCP_CFG_RWBUF_CSAVE
	T_NET_BUF	*rwbufq;	/* MEBhobt@L[	*/
#endif	/* of #ifdef TCP_CFG_RWBUF_CSAVE */

#ifdef TCP_CFG_EXTENTIONS
	T_TCP_HDR	*urg_tcph;	/* ً}f[^̃ZOg TCP wb_	*/
	T_TCP_SEQ	snd_up;		/* Mً}|C^		*/
	T_TCP_SEQ	rcv_up;		/* Mً}|C^		*/
#endif	/* of #ifdef TCP_CFG_EXTENTIONS */

	T_TCP_SEQ	snd_una;	/* mF̍ŏM SEQ ܂	*/
					/* mFꂽő呗M SEQ	*/
	T_TCP_SEQ	snd_max;	/* Mő SEQ		*/
	T_TCP_SEQ	snd_nxt;	/* ɑM SEQ		*/
	T_TCP_SEQ	snd_old_nxt;	/*  snd_nxt			*/
	T_TCP_SEQ	snd_wl1;	/* OEBhXV SEQ	*/
	T_TCP_SEQ	snd_wl2;	/* OEBhXV ACK	*/
	T_TCP_SEQ	iss;		/*  SEQ ̏l		*/
	T_TCP_SEQ	irs;		/*  SEQ ̏l		*/
	T_TCP_SEQ	rcv_nxt;	/* M҂Ăŏ SEQ	*/
	T_TCP_SEQ	rcv_adv;	/* M҂Ăő SEQ	*/
	T_TCP_SEQ	rcv_wnd;	/* M\ȃEBhTCY	*/
	T_TCP_SEQ	rtseq;		/* Ԍvn߂ SEQ		*/
	T_TCP_SEQ	last_ack_sent;	/* ŌɑM ACK		*/
	T_TCP_TIME	idle;		/* ACh			*/
	ER		error;		/* 񓯊ɔG[	*/
	ER		net_error;	/* lbg[ÑG[	*/
	T_TCP_WND	snd_wnd;	/* ̎M\EBhTCY	*/
	T_TCP_WND	max_sndwnd;	/* ܂ł̍ő呗MEBhTCY	*/
	T_TCP_TIME	rtt;		/* 				*/
	uint16_t	swbuf_count;	/* MEBhobt@̎gpTCY	*/
	uint16_t	rwbuf_count;	/* MEBhobt@̎gpTCY	*/
	uint16_t	rcv_buf_len;	/* tcp_rcv_buf ̊Ē	*/
	uint16_t	get_buf_len;	/* tcp_rcv_buf ̊Ē	*/
	uint8_t		rxtshift;	/* đM񐔂 log(2)		*/
	uint8_t		fsm_state;	/* FSM 			*/
	uint8_t		dupacks;	/* đ ACK 			*/

#if defined(TCP_CFG_RWBUF_CSAVE) && defined(TCP_CFG_RWBUF_CSAVE_MAX_QUEUES)
	uint8_t		rwbufq_entries;	/* MEBhobt@L[̃Gg	*/
#endif	/* of #if defined(TCP_CFG_RWBUF_CSAVE) && defined(TCP_CFG_RWBUF_CSAVE_MAX_QUEUES)	*/

} T_TCP4_CEP;

/*
 * Time Wait p IPv4 TCP ʐM[_
 */
typedef struct t_tcp4_twcep {
	int_t		rbufsz;		/* MpEBhobt@TCY	*/
	T_TCP_TIME	timer_2msl;	/* 2MSL ^C}			*/
	T_IPV4EP	dstaddr;	/* ̃AhX		*/
	T_IPV4EP	myaddr;		/* ̃AhX		*/
	T_TCP_SEQ	snd_una;	/* mF̍ŏM SEQ ܂	*/
					/* mFꂽő呗M SEQ	*/
	T_TCP_SEQ	rcv_nxt;	/* M҂Ăŏ SEQ	*/
	uint16_t	rwbuf_count;	/* MEBhobt@̎gpTCY	*/
	uint8_t		fsm_state;	/* FSM 			*/

} T_TCP4_TWCEP;

/*
 * ʏ IPv6 TCP ʐM[_
 */
typedef struct t_tcp6_cep {

	/*
	 * ITRON TCP/IP APIATCP ʐM[_Ɠo
	 */
	ATR		cepatr;		/* ʐM[_			*/
	void		*sbuf;		/* MpEBhobt@	*/
	int_t		sbufsz;		/* MpEBhobt@TCY	*/
	void		*rbuf;		/* MpEBhobt@	*/
	int_t		rbufsz;		/* MpEBhobt@TCY	*/
	t_tcp_callback	callback;	/* R[obN֐		*/

	/*
	 * TINET Ǝ̃o
	 */
	uint32_t	flags;		/* ʐM[_tO		*/
	ID		semid_lock;	/* ʐM[_bN		*/
	ID		est_flgid;	/* RlNVԃCxgtO	*/
	ID		snd_flgid;	/* MCxgtO		*/
	ID		rcv_flgid;	/* MCxgtO		*/
	ID		snd_tskid;	/* M^XNʎq		*/
	ID		rcv_tskid;	/* M^XNʎq		*/
	uint8_t		*sbuf_rptr;	/* Mpǂݏo|C^		*/
	uint8_t		*sbuf_wptr;	/* Mp݃|C^		*/
	uint8_t		*rbuf_rptr;	/* Mpǂݏo|C^		*/
	uint8_t		*rbuf_wptr;	/* Mp݃|C^		*/
	T_TCP_SEQ	snd_ssthresh;	/* tsEBhTCY(snd_cwnd)	*/
					/* ̂l			*/
	T_TCP_TIME	rxtcur;		/* ݂̍đ^CAEg		*/
	T_TCP_TIME	srtt;		/* ꂽ RTT		*/
	T_TCP_TIME	rttvar;		/* ꂽU		*/
	T_TCP_WND	snd_cwnd;	/* tsEBhTCY		*/

	/*
	 *  ̍őMZOgTCY	
	 *
	 *    IWił́Aʂ̃ZOg̍őTCY (t_maxseg) ƁA
	 *    IvVt̃ZOg̍őTCY (t_maxopd) ʂ
	 *    ȂĂB́Ã݂C^[lbgł́AIvVt
	 *    ZOĝقƐĂ邽߂łB
	 *    {ł́AőZOgTCYIvVȊÕIvV
	 *    Ȃ̂ŁAt_maxseg ̎gpB
	 */
	T_TCP_SEG	maxseg;

	T_IPV6EP 	*p_dstaddr;	/* ̃AhXւ̃|C^	*/
	T_IPV6EP 	*p_myaddr;	/* ̃AhXւ̃|C^	*/
	int16_t		snd_tfn;	/* M쒆 API @\R[h	*/
	int16_t		rcv_tfn;	/* M쒆 API @\R[h	*/

#ifdef TCP_CFG_NON_BLOCKING

	int16_t		snd_nblk_tfn;	/* M쒆 API @\R[h	*/
	int16_t		rcv_nblk_tfn;	/* M쒆 API @\R[h	*/
	void		*snd_data;	/* Mf[^̈̐擪AhX	*/
	int_t		snd_len;	/* Mf[^̈̒		*/
	void		*rcv_data;	/* Mf[^̈̐擪AhX	*/
	int_t		rcv_len;	/* Mf[^̈̒		*/
	void		**snd_p_buf;	/* Mobt@ւ̃|C^	*/
	void		**rcv_p_buf;	/* Mobt@ւ̃|C^	*/

#endif	/* of #ifdef TCP_CFG_NON_BLOCKING */

#ifdef TCP_CFG_SWBUF_CSAVE
	T_NET_BUF	*swbufq;	/* MEBhobt@L[	*/
#endif	/* of #ifdef TCP_CFG_SWBUF_CSAVE */

	/*
	 *  ȍ~̃o[ tcp_init_cep() ֐Ń[NA[B
	 */

	T_TCP_TIME	timer[NUM_TCP_TIMERS];	/* TCP ̃^C}		*/
	T_IPV6EP	dstaddr;	/* ̃AhX		*/
	T_IPV6EP	myaddr;		/* ̃AhX		*/
	T_TCP6_REP	*rep;		/* t			*/
	T_NET_BUF	*reassq;	/* Mč\L[		*/

#ifdef TCP_CFG_RWBUF_CSAVE
	T_NET_BUF	*rwbufq;	/* MEBhobt@L[	*/
#endif	/* of #ifdef TCP_CFG_RWBUF_CSAVE */

#ifdef TCP_CFG_EXTENTIONS
	T_TCP_HDR	*urg_tcph;	/* ً}f[^̃ZOg TCP wb_	*/
	T_TCP_SEQ	snd_up;		/* Mً}|C^		*/
	T_TCP_SEQ	rcv_up;		/* Mً}|C^		*/
#endif	/* of #ifdef TCP_CFG_EXTENTIONS */

	T_TCP_SEQ	snd_una;	/* mF̍ŏM SEQ ܂	*/
					/* mFꂽő呗M SEQ	*/
	T_TCP_SEQ	snd_max;	/* Mő SEQ		*/
	T_TCP_SEQ	snd_nxt;	/* ɑM SEQ		*/
	T_TCP_SEQ	snd_old_nxt;	/*  snd_nxt			*/
	T_TCP_SEQ	snd_wl1;	/* OEBhXV SEQ	*/
	T_TCP_SEQ	snd_wl2;	/* OEBhXV ACK	*/
	T_TCP_SEQ	iss;		/*  SEQ ̏l		*/
	T_TCP_SEQ	irs;		/*  SEQ ̏l		*/
	T_TCP_SEQ	rcv_nxt;	/* M҂Ăŏ SEQ	*/
	T_TCP_SEQ	rcv_adv;	/* M҂Ăő SEQ	*/
	T_TCP_SEQ	rcv_wnd;	/* M\ȃEBhTCY	*/
	T_TCP_SEQ	rtseq;		/* Ԍvn߂ SEQ		*/
	T_TCP_SEQ	last_ack_sent;	/* ŌɑM ACK		*/
	T_TCP_TIME	idle;		/* ACh			*/
	ER		error;		/* 񓯊ɔG[		*/
	ER		net_error;	/* lbg[ÑG[	*/
	T_TCP_WND	snd_wnd;	/* ̎M\EBhTCY	*/
	T_TCP_WND	max_sndwnd;	/* ܂ł̍ő呗MEBhTCY	*/
	T_TCP_TIME	rtt;		/* 			*/
	uint16_t	swbuf_count;	/* MEBhobt@̎gpTCY	*/
	uint16_t	rwbuf_count;	/* MEBhobt@̎gpTCY	*/
	uint16_t	rcv_buf_len;	/* tcp_rcv_buf ̊Ē	*/
	uint16_t	get_buf_len;	/* tcp_rcv_buf ̊Ē	*/
	uint8_t		rxtshift;	/* đM񐔂 log(2)		*/
	uint8_t		fsm_state;	/* FSM 			*/
	uint8_t		dupacks;	/* đ ACK 			*/

#if defined(TCP_CFG_RWBUF_CSAVE) && defined(TCP_CFG_RWBUF_CSAVE_MAX_QUEUES)
	uint8_t		rwbufq_entries;	/* MEBhobt@L[̃Gg	*/
#endif	/* of #if defined(TCP_CFG_RWBUF_CSAVE) && defined(TCP_CFG_RWBUF_CSAVE_MAX_QUEUES)	*/

} T_TCP6_CEP;

/*
 * Time Wait p IPv6 TCP ʐM[_
 */
typedef struct t_tcp6_twcep {
	int_t		rbufsz;		/* MpEBhobt@TCY	*/
	T_TCP_TIME	timer_2msl;	/* 2MSL ^C}			*/
	T_IPV6EP	dstaddr;	/* ̃AhX		*/
	T_IPV6EP	myaddr;		/* ̃AhX		*/
	T_TCP_SEQ	snd_una;	/* mF̍ŏM SEQ ܂	*/
					/* mFꂽő呗M SEQ	*/
	T_TCP_SEQ	iss;		/*  SEQ ̏l		*/
	T_TCP_SEQ	irs;		/*  SEQ ̏l		*/
	T_TCP_SEQ	rcv_nxt;	/* M҂Ăŏ SEQ	*/
	T_TCP_WND	snd_wnd;	/* ̎M\EBhTCY	*/
	uint16_t	rwbuf_count;	/* MEBhobt@̎gpTCY	*/
	uint8_t		fsm_state;	/* FSM 			*/

} T_TCP6_TWCEP;

#if defined(SUPPORT_INET4)
#define T_TCP_CEP	T_TCP4_CEP
#define T_TCP_TWCEP	T_TCP4_TWCEP
#endif	/* of #if defined(SUPPORT_INET4) */

#if defined(SUPPORT_INET6)
#define T_TCP_CEP	T_TCP6_CEP
#define T_TCP_TWCEP	T_TCP6_TWCEP
#endif	/* of #if defined(SUPPORT_INET6) */

#define T_TCP_CEP_DEFINED

/*
 *  TCP ʐM[_̏ԃtO
 */

#define TCP_CEP_FLG_ACK_NOW		ULONG_C(0x00000001)	/* ɑ ACK 𑗂B	*/
#define TCP_CEP_FLG_DEL_ACK		ULONG_C(0x00000002)	/* ACK xB		*/
#define TCP_CEP_FLG_SENT_FIN		ULONG_C(0x00000004)	/* FIN 𑗂ĂB		*/
#define TCP_CEP_FLG_NEED_SYN		ULONG_C(0x00000008)	/* SYN 𑗐MB		*/
#define TCP_CEP_FLG_NEED_FIN		ULONG_C(0x00000010)	/* FIN 𑗐MB		*/
#define TCP_CEP_FLG_FORCE		ULONG_C(0x00000020)	/* MB			*/
#define TCP_CEP_FLG_NO_PUSH		ULONG_C(0x00000040)	/* push ȂB		*/
#define TCP_CEP_FLG_NO_DELAY		ULONG_C(0x00000080)	/* xȂB			*/
#define TCP_CEP_FLG_FORCE_CLEAR		ULONG_C(0x00000100)	/* MtONA[B*/
#define TCP_CEP_FLG_POST_OUTPUT		ULONG_C(0x00000200)	/* MJnB		*/
#define TCP_CEP_FLG_RESERVE_OUTPUT	ULONG_C(0x00000400)	/* M\񂷂B		*/
#define TCP_CEP_FLG_DYNAMIC		ULONG_C(0x00001000)	/* IE폜\ʐM[_B	*/
#define TCP_CEP_FLG_VALID		ULONG_C(0x00002000)	/* ς݂ŗLȒʐM[_B	*/
#define TCP_CEP_FLG_CLOSE_AFTER_OUTPUT	ULONG_C(0x00004000)	/* MRlNVB*/
#define TCP_CEP_FLG_RESTORE_NEXT_OUTPUT	ULONG_C(0x00008000)	/* MAsnd_nxt ɖ߂B*/

/* MEBhobt@̏ȃRs[@\ */
#define TCP_CEP_FLG_WBCS_NBUF_REQ	ULONG_C(0x00080000)	/* lbg[Nobt@ėv	*/
#define TCP_CEP_FLG_WBCS_MASK		ULONG_C(0x00070000)	/* }XN			*/
#define TCP_CEP_FLG_WBCS_FREE		ULONG_C(0x00000000)	/* MEBhobt@gp	*/
#define TCP_CEP_FLG_WBCS_WOPEN_PEND	ULONG_C(0x00010000)	/* ̎MEBh̊J҂	*/
#define TCP_CEP_FLG_WBCS_NBUF_PEND	ULONG_C(0x00020000)	/* lbg[Nobt@\҂	*/
#define TCP_CEP_FLG_WBCS_NBUF_RSVD	ULONG_C(0x00030000)	/* lbg[Nobt@\ς	*/
#define TCP_CEP_FLG_WBCS_NBUF_READY	ULONG_C(0x00040000)	/* lbg[Nobt@čς	*/
#define TCP_CEP_FLG_WBCS_SEND_READY	ULONG_C(0x00050000)	/* M\			*/
#define TCP_CEP_FLG_WBCS_SENT		ULONG_C(0x00060000)	/* Mς݂ŁAACK҂		*/
#define TCP_CEP_FLG_WBCS_ACKED		ULONG_C(0x00070000)	/* Mς݂ŁAACK		*/

/*
 *  ʐM[_CxgtO
 */

#define TCP_CEP_EVT_ESTABLISHED		ULONG_C(0x00000001)	/* RlNVm		*/
#define TCP_CEP_EVT_CLOSED		ULONG_C(0x00000002)	/* gp			*/
#define TCP_CEP_EVT_SWBUF_READY		ULONG_C(0x00000004)	/* MEBhobt@	*/
#define TCP_CEP_EVT_RWBUF_READY		ULONG_C(0x00000008)	/* MEBhobt@f[^	*/
#define TCP_CEP_EVT_ALL			ULONG_C(0xffffffff)	/* SCxg			*/

/*
 *  ǉ API @\EۃR[h
 */

/* TCP ֌W */

#define TFN_TCP_UNDEF		(0)

/*
 *  srtt:   ꂽ RTT
 *  rttvar: ꂽU
 *  rtt:    肳ꂽ
 *
 *  ꂽ RTT (srtt) ƕꂽU (rttvar) 
 *  ^ŌvZ邽߂ɁAVtgăXP[B
 *  srtt  2 i_ȉ 3 rbgA
 *  rttvar  2 i_ȉ 2 rbgێB
 */

#define TCP_DELTA_SHIFT		2
			/*  = rtt/8 + srtt*7/8 ̌vẐ߂̃Vtgl	*/
#define TCP_SRTT_SHIFT		(TCP_DELTA_SHIFT + 3)
					/* srtt ̃VtglA3(+2)rbg	*/
#define TCP_RTTVAR_SHIFT	(TCP_DELTA_SHIFT + 2)
					/* rttvar ̃VtglA2(+2)rbg	*/
#define TCP_SRTT_SCALE		(1<<TCP_SRTT_SHIFT)
#define TCP_RTTVAR_SCALE	(1<<TCP_RTTVAR_SHIFT)

/*
 *  ē]Jnđ ACK ̂l
 */

#define MAX_TCP_REXMT_THRESH	3

/*
 *  Mč\L[ł TCP wb_
 */

typedef struct t_tcp_q_hdr {
	uint16_t	sport;		/* M|[gԍ			*/
	uint16_t	dport;		/* |[gԍ			*/

	uint32_t	seq;		/* SEQ ԍ				*/

	T_NET_BUF 	*next;		/* ̃ZOgA ACK ԍ(ack)	*/

	uint8_t		doff;		/* f[^ItZbg(4rbg)	*/
	uint8_t		flags;		/* tO(6rbg)			*/
	uint16_t	soff;		/* SDU ItZbgA̓EBhTCY(win)	*/

	uint16_t	slen;		/* SDU A̓`FbNT(sum)	*/
	uint16_t	urp;		/* ً}|C^iSDU ␳j		*/
} T_TCP_Q_HDR;

#define GET_TCP_Q_HDR(nbuf,thoff)	((T_TCP_Q_HDR*)((uint8_t*)((nbuf)->buf) + thoff))
#define GET_TCP_IP_Q_HDR(nbuf)		((T_TCP_IP_Q_HDR*)GET_IP_HDR(nbuf))

/*
 *  IuWFNg ID ̍ŏl̒`
 */

#define	TMIN_TCP_REPID		1	/* TCP t   ID ̍ŏl			*/
#define	TMIN_TCP_CEPID		1	/* TCP ʐM[_ ID ̍ŏl			*/
#define	TMIN_TCP_TWCEPID	1	/* Time Wait p TCP ʐM[_ ID ̍ŏl	*/

/*
 *  ZOgif[^ȂjTCỸlbg[Nobt@
 */

typedef struct t_net_buf_cseg {
	uint16_t	len;	/* f[^̒		*/
	uint8_t		idix;	/* mpfid ̃CfbNX	*/
	uint8_t		flags;	/* tO		*/
#ifdef IF_ETHER_NIC_NET_BUF_ALIGN
	uint8_t		nalign[IF_ETHER_NIC_NET_BUF_ALIGN];
#endif
#if CPU_NET_ALIGN == 4 && IF_HDR_ALIGN != 4
	uint8_t		halign[4 - IF_HDR_ALIGN];
#endif
	uint8_t		buf[IF_HDR_SIZE + IP_HDR_SIZE + TCP_HDR_SIZE];
				/* obt@{		*/
} T_NET_BUF_CSEG;

#ifdef SUPPORT_MIB

/*
 *  SNMP  Ǘx[X (MIB)
 */

typedef struct t_tcp_stats {
	uint32_t	tcpActiveOpens;
	uint32_t	tcpPassiveOpens;
	uint32_t	tcpAttemptFails;
	uint32_t	tcpEstabResets;
/*	uint32_t	tcpCurrEstab;*/
	uint32_t	tcpInSegs;
	uint32_t	tcpOutSegs;
	uint32_t	tcpRetransSegs;
	uint32_t	tcpInErrs;
	uint32_t	tcpOutRsts;
} T_TCP_STATS;

#endif	/* of #ifdef SUPPORT_MIB */

/*
 *  ֐V~[V}N
 */

#define VAID_TCP_REPID(id)	(TMIN_TCP_REPID<=(id)&&(id)<=tmax_tcp_repid)
#define VAID_TCP_CEPID(id)	(TMIN_TCP_CEPID<=(id)&&(id)<=tmax_tcp_cepid)

#define INDEX_TCP_REP(id)	((id)-TMIN_TCP_REPID)
#define INDEX_TCP_CEP(id)	((id)-TMIN_TCP_CEPID)

#define GET_TCP_REP(id)		(&(tcp_rep[INDEX_TCP_REP(id)]))
#define GET_TCP_CEP(id)		(&(tcp_cep[INDEX_TCP_CEP(id)]))

#define GET_TCP_REPID(rep)	((ID)(((rep)-tcp_rep)+TMIN_TCP_REPID))
#define GET_TCP_CEPID(cep)	((ID)(((cep)-tcp_cep)+TMIN_TCP_CEPID))
#define GET_TCP_TWCEPID(cep)	((ID)(((cep)-tcp_twcep)+TMIN_TCP_TWCEPID))

#define IS_TFN_TCP_RCV(t)	((t)==TFN_TCP_ACP_CEP||(t)==TFN_TCP_RCV_DAT||\
				 (t)==TFN_TCP_CLS_CEP||\
				 (t)==TFN_TCP_RCV_BUF||(t)==TFN_TCP_REL_BUF||\
				 (t)==TFN_TCP_RCV_OOB)

#define VALID_TFN_TCP_CAN(t)	((t)==TFN_TCP_ACP_CEP||(t)==TFN_TCP_CON_CEP||\
				 (t)==TFN_TCP_CLS_CEP||\
				 (t)==TFN_TCP_SND_DAT||(t)==TFN_TCP_RCV_DAT||\
				 (t)==TFN_TCP_GET_BUF||(t)==TFN_TCP_RCV_BUF||\
				 (t)==TFN_TCP_SND_OOB||\
				 (t)==TFN_TCP_ALL)

#define VALID_URG_POINTER(urg)	(TCP_CFG_URG_OFFSET==0||urg!=0)

#define VALID_TCP_CEP(cep)	(((cep)->flags&TCP_CEP_FLG_VALID)!=0)
#define DYNAMIC_TCP_CEP(cep)	(((cep)->flags&TCP_CEP_FLG_DYNAMIC)!=0)

#ifdef TCP_CFG_EXTENTIONS

#define VALID_TCP_REP(rep)	(((rep)->flags&TCP_REP_FLG_VALID)!=0)
#define DYNAMIC_TCP_REP(rep)	(((rep)->flags&TCP_REP_FLG_DYNAMIC)!=0)

#else	/* of #ifdef TCP_CFG_EXTENTIONS */

#define VALID_TCP_REP(rep)	(true)
#define DYNAMIC_TCP_REP(rep)	(false)

#endif	/* of #ifdef TCP_CFG_EXTENTIONS */

/*
 *  Sϐ
 */

extern T_TCP_REP tcp_rep[];
extern T_TCP_CEP tcp_cep[];
extern uint8_t tcp_initialized;
extern const ID tmax_tcp_repid;
extern const ID tmax_tcp_cepid;
extern T_TCP_TWCEP tcp_twcep[];

#ifdef SUPPORT_MIB

extern T_TCP_STATS tcp_stats;

#endif	/* of #ifdef SUPPORT_MIB */

/*
 *  Inline ֐
 */

#ifndef TCP_CFG_RWBUF_CSAVE

/*
 *  TCP ʐM[_̎MEBhobt@̏ȃRs[@\
 *  ̏ꍇ͉Ȃ߂̃_~[̊֐
 */

/*
 *  tcp_free_rwbufq -- MEBhobt@L[B
 */

Inline void
tcp_free_rwbufq_ncs (T_TCP_CEP *cep)
{
}

#endif	/* of #ifndef TCP_CFG_RWBUF_CSAVE */

#ifdef TCP_CFG_SWBUF_CSAVE_ONLY

/*
 *  TCP ʐM[_̑MEBhobt@̏ȃRs[@\݂̂
 *  L̏ꍇ͉Ȃ߂̃_~[̊֐
 */

/*
 *  tcp_read_swbuf_cs -- MEBhobt@f[^ǂݏoB
 */

Inline void
tcp_read_swbuf_cs (T_TCP_CEP *cep, T_NET_BUF *output, uint_t len, uint_t doff)
{
}

#endif	/* of #ifdef TCP_CFG_SWBUF_CSAVE_ONLY */

#ifndef TCP_CFG_SWBUF_CSAVE

/*
 *  TCP ʐM[_̑MEBhobt@̏ȃRs[@\
 *  ̏ꍇ͉Ȃ߂̃_~[̊֐
 */

/*
 *  tcp_free_swbufq -- MEBhobt@L[B
 */

Inline void
tcp_free_swbufq_ncs (T_TCP_CEP *cep)
{
}

/*
 *  tcp_alloc_swbuf -- MEBhobt@p̃lbg[Nobt@̊蓖ĂwB
 */

Inline void
tcp_alloc_swbuf_ncs (T_TCP_CEP *cep)
{
}

/*
 *  tcp_push_res_nbuf -- lbg[Nobt@\񂷂B
 */

Inline T_NET_BUF *
tcp_push_res_nbuf_ncs (T_NET_BUF *nbuf)
{
	return nbuf;
}

/*
 *  tcp_pull_res_nbuf -- \񂵂Ălbg[Nobt@ԂB
 */

Inline T_NET_BUF *
tcp_pull_res_nbuf_ncs (ATR nbatr)
{
	return NULL;
}

#endif	/* of #ifndef TCP_CFG_SWBUF_CSAVE */

/*
 *  TCP ʐM[_̎MEBhobt@̏ȃRs[@\̐؂ւ}N
 */

#ifdef TCP_CFG_RWBUF_CSAVE

#ifdef TCP_CFG_RWBUF_CSAVE_ONLY

#define TCP_FREE_RWBUFQ(cep)			tcp_free_rwbufq_cs(cep)
#define TCP_DROP_RWBUF(cep,len)			tcp_drop_rwbuf_cs(cep,len)
#define TCP_READ_RWBUF(cep,data,len)		tcp_read_rwbuf_cs(cep,data,len)
#define TCP_GET_RWBUF_ADDR(cep,buf)		tcp_get_rwbuf_addr_cs(cep,buf)
#define TCP_WRITE_RWBUF(cep,input,thoff)	tcp_write_rwbuf_cs(cep,input,thoff)

#else	/* of #ifdef TCP_CFG_RWBUF_CSAVE_ONLY */

#define TCP_FREE_RWBUFQ(cep)			tcp_free_rwbufq(cep)
#define TCP_DROP_RWBUF(cep,len)			tcp_drop_rwbuf(cep,len)
#define TCP_READ_RWBUF(cep,data,len)		tcp_read_rwbuf(cep,data,len)
#define TCP_GET_RWBUF_ADDR(cep,buf)		tcp_get_rwbuf_addr(cep,buf)
#define TCP_WRITE_RWBUF(cep,input,thoff)	tcp_write_rwbuf(cep,input,thoff)

#endif	/* of #ifdef TCP_CFG_RWBUF_CSAVE_ONLY */

#else	/* of #ifdef TCP_CFG_RWBUF_CSAVE */

#define TCP_FREE_RWBUFQ(cep)			tcp_free_rwbufq_ncs(cep)
#define TCP_DROP_RWBUF(cep,len)			tcp_drop_rwbuf_ncs(cep,len)
#define TCP_READ_RWBUF(cep,data,len)		tcp_read_rwbuf_ncs(cep,data,len)
#define TCP_GET_RWBUF_ADDR(cep,buf)		tcp_get_rwbuf_addr_ncs(cep,buf)
#define TCP_WRITE_RWBUF(cep,input,thoff)	tcp_write_rwbuf_ncs(cep,input,thoff)

#endif	/* of #ifdef TCP_CFG_RWBUF_CSAVE */

/*
 *  TCP ʐM[_̑MEBhobt@̏ȃRs[@\̐؂ւ}N
 */

#ifdef TCP_CFG_SWBUF_CSAVE

#define TCP_PUSH_RES_NBUF(nbuf)			tcp_push_res_nbuf(nbuf)
#define TCP_PULL_RES_NBUF(atr)			tcp_pull_res_nbuf(atr)

#ifdef TCP_CFG_SWBUF_CSAVE_ONLY

#define TCP_FREE_SWBUFQ(cep)			tcp_free_swbufq_cs(cep)
#define TCP_ALLOC_SWBUF(cep)			tcp_alloc_swbuf_cs(cep)
#define TCP_DROP_SWBUF(cep,len)			tcp_drop_swbuf_cs(cep,len)
#define TCP_WRITE_SWBUF(cep,data,len)		tcp_write_swbuf_cs(cep,data,len)
#define TCP_READ_SWBUF(cep,output,len,doff)	tcp_read_swbuf_cs(cep,output,len,doff)
#define TCP_WAIT_SWBUF(cep,tmout)		tcp_wait_swbuf_cs(cep,tmout)
#define TCP_GET_SWBUF_ADDR(cep,buf)		tcp_get_swbuf_addr_cs(cep,buf)
#define TCP_SEND_SWBUF(cep,len)			tcp_send_swbuf_cs(cep,len)
#define TCP_IS_SWBUF_FULL(cep)			tcp_is_swbuf_full_cs(cep)

#else	/* of #ifdef TCP_CFG_SWBUF_CSAVE_ONLY */

#define TCP_FREE_SWBUFQ(cep)			tcp_free_swbufq(cep)
#define TCP_ALLOC_SWBUF(cep)			tcp_alloc_swbuf(cep)
#define TCP_DROP_SWBUF(cep,len)			tcp_drop_swbuf(cep,len)
#define TCP_WRITE_SWBUF(cep,data,len)		tcp_write_swbuf(cep,data,len)
#define TCP_READ_SWBUF(cep,output,len,doff)	tcp_read_swbuf(cep,output,len,doff)
#define TCP_WAIT_SWBUF(cep,tmout)		tcp_wait_swbuf(cep,tmout)
#define TCP_GET_SWBUF_ADDR(cep,buf)		tcp_get_swbuf_addr(cep,buf)
#define TCP_SEND_SWBUF(cep,len)			tcp_send_swbuf(cep,len)
#define TCP_IS_SWBUF_FULL(cep)			tcp_is_swbuf_full(cep)

#endif	/* of #ifdef TCP_CFG_SWBUF_CSAVE_ONLY */

#else	/* of #ifdef TCP_CFG_SWBUF_CSAVE */

#define TCP_READ_SWBUF(cep,output,len,doff)	tcp_read_swbuf_ncs(cep,output,len,doff)
#define TCP_FREE_SWBUFQ(cep)			tcp_free_swbufq_ncs(cep)
#define TCP_ALLOC_SWBUF(cep)			tcp_alloc_swbuf_ncs(cep)
#define TCP_PUSH_RES_NBUF(nbuf)			tcp_push_res_nbuf_ncs(nbuf)
#define TCP_PULL_RES_NBUF(atr)			tcp_pull_res_nbuf_ncs(atr)
#define TCP_DROP_SWBUF(cep,len)			tcp_drop_swbuf_ncs(cep,len)
#define TCP_WRITE_SWBUF(cep,data,len)		tcp_write_swbuf_ncs(cep,data,len)
#define TCP_WAIT_SWBUF(cep,tmout)		tcp_wait_swbuf_ncs(cep,tmout)
#define TCP_GET_SWBUF_ADDR(cep,buf)		tcp_get_swbuf_addr_ncs(cep,buf)
#define TCP_SEND_SWBUF(cep,len)			tcp_send_swbuf_ncs(cep,len)
#define TCP_IS_SWBUF_FULL(cep)			tcp_is_swbuf_full_ncs(cep)

#endif	/* of #ifdef TCP_CFG_SWBUF_CSAVE */

/*
 *  ֐
 */

extern uint_t tcp_input (T_NET_BUF **inputp, uint_t *offp, uint_t *nextp);
extern void tcp_init (void);
extern void tcp_init_iss (void);
extern T_TCP_CEP *tcp_close (T_TCP_CEP *cep);
extern T_TCP_CEP *tcp_drop  (T_TCP_CEP *cep, ER errno);
extern void tcp_respond (T_NET_BUF *nbuf, T_TCP_CEP *cep,
                         T_TCP_SEQ ack, T_TCP_SEQ seq, uint_t rbfree, uint8_t flags);
extern void tcp_set_header (T_NET_BUF *nbuf, T_TCP_CEP *cep, uint_t thoff, uint_t optlen);
extern ER tcp_get_segment (T_NET_BUF **nbuf, T_TCP_CEP *cep,
                           uint_t optlen, uint_t len, uint_t maxlen, ATR nbatr, TMO tmout);
extern void tcp_init_cep (T_TCP_CEP *cep);
extern void tcp_notify (T_NET_BUF *input, int code);
extern T_TCP_TIME tcp_rexmt_val (T_TCP_CEP *cep);
extern void tcp_set_persist_timer (T_TCP_CEP *cep);
extern void tcp_cancel_timers (T_TCP_CEP *cep);
extern void tcp_alloc_auto_port (T_TCP_CEP *cep);
extern ER tcp_alloc_port (T_TCP_CEP *cep, uint16_t portno);
extern void tcp_move_twcep (T_TCP_CEP *cep);
extern ER tcp_lock_cep (ID cepid, T_TCP_CEP **p_cep, FN tfn);
extern void tcp_free_reassq (T_TCP_CEP *cep);
extern ER tcp_can_send_more (T_TCP_CEP *cep, FN fncd, TMO tmout);
extern ER tcp_can_recv_more (ER *error, T_TCP_CEP *cep, FN fncd, TMO tmout);
extern uint8_t tcp_move_ra2rw (T_TCP_CEP *cep, uint8_t flags);
extern uint8_t tcp_write_raque (T_NET_BUF *input, T_TCP_CEP *cep, uint_t thoff, uint8_t flags);
extern ER tcp_wait_rwbuf (T_TCP_CEP *cep, TMO tmout);
extern T_TCP_CEP *tcp_user_closed (T_TCP_CEP *cep);

/*
 *  TCP ʐM[_̎MEBhobt@p֐
 */

/*
 *  TCP ʐM[_̎MEBhobt@̏ȃRs[@\L̏ꍇA
 *  ֐̑IɎgpB
 */

extern void tcp_free_rwbufq (T_TCP_CEP *cep);
extern void tcp_drop_rwbuf (T_TCP_CEP *cep, uint_t len);
extern void tcp_write_rwbuf (T_TCP_CEP *cep, T_NET_BUF *input, uint_t tcpoff);
extern uint_t tcp_read_rwbuf (T_TCP_CEP *cep, void *data, uint_t len);
extern uint_t tcp_get_rwbuf_addr (T_TCP_CEP *cep, void **p_buf);

/*
 *  TCP ʐM[_̎MEBhobt@̏ȃRs[@\p֐
 */

extern void tcp_free_rwbufq_cs (T_TCP_CEP *cep);
extern void tcp_drop_rwbuf_cs (T_TCP_CEP *cep, uint_t len);
extern void tcp_write_rwbuf_cs (T_TCP_CEP *cep, T_NET_BUF *input, uint_t tcpoff);
extern uint_t tcp_read_rwbuf_cs (T_TCP_CEP *cep, void *data, uint_t len);
extern uint_t tcp_get_rwbuf_addr_cs (T_TCP_CEP *cep, void **p_buf);

/*
 *  TCP ʐM[_̎MEBhobt@́yzȃRs[@\p֐
 */

extern void tcp_free_rwbufq_ncs (T_TCP_CEP *cep);
extern void tcp_drop_rwbuf_ncs (T_TCP_CEP *cep, uint_t len);
extern void tcp_write_rwbuf_ncs (T_TCP_CEP *cep, T_NET_BUF *input, uint_t tcpoff);
extern uint_t tcp_read_rwbuf_ncs (T_TCP_CEP *cep, void *data, uint_t len);
extern uint_t tcp_get_rwbuf_addr_ncs (T_TCP_CEP *cep, void **p_buf);

/*
 *  TCP ʐM[_̑MEBhobt@p֐
 */

/*
 *  TCP ʐM[_̑MEBhobt@̏ȃRs[@\L̏ꍇA
 *  ֐̑IɎgpB
 */

extern void tcp_free_swbufq (T_TCP_CEP *cep);
extern void tcp_drop_swbuf (T_TCP_CEP *cep, uint_t len);
extern ER_UINT tcp_write_swbuf (T_TCP_CEP *cep, void *data, uint_t len);
extern void tcp_read_swbuf (T_TCP_CEP *cep, T_NET_BUF *output, uint_t len, uint_t doff);
extern void tcp_send_swbuf (T_TCP_CEP *cep, uint_t len);
extern ER_UINT tcp_get_swbuf_addr (T_TCP_CEP *cep, void **p_buf);
extern ER tcp_wait_swbuf (T_TCP_CEP *cep, TMO tmout);
extern T_NET_BUF *tcp_push_res_nbuf (T_NET_BUF *buf);
extern T_NET_BUF *tcp_pull_res_nbuf (ATR nbatr);
extern void tcp_alloc_swbuf (T_TCP_CEP *cep);
extern bool_t tcp_is_swbuf_full (T_TCP_CEP *cep);
extern void tcp_init_swbuf (T_TCP_CEP *cep);

/*
 *  TCP ʐM[_̑MEBhobt@̏ȃRs[@\p֐
 */

extern void tcp_free_swbufq_cs (T_TCP_CEP *cep);
extern void tcp_drop_swbuf_cs (T_TCP_CEP *cep, uint_t len);
extern ER_UINT tcp_write_swbuf_cs (T_TCP_CEP *cep, void *data, uint_t len);
extern void tcp_read_swbuf_cs (T_TCP_CEP *cep, T_NET_BUF *output, uint_t len, uint_t doff);
extern void tcp_send_swbuf_cs (T_TCP_CEP *cep, uint_t len);
extern ER_UINT tcp_get_swbuf_addr_cs (T_TCP_CEP *cep, void **p_buf);
extern ER tcp_wait_swbuf_cs (T_TCP_CEP *cep, TMO tmout);
extern void tcp_alloc_swbuf_cs (T_TCP_CEP *cep);
extern bool_t tcp_is_swbuf_full_cs (T_TCP_CEP *cep);

/*
 *  TCP ʐM[_̑MEBhobt@́yzȃRs[@\p֐
 */

extern void tcp_free_swbufq_ncs (T_TCP_CEP *cep);
extern void tcp_drop_swbuf_ncs (T_TCP_CEP *cep, uint_t len);
extern ER_UINT tcp_write_swbuf_ncs (T_TCP_CEP *cep, void *data, uint_t len);
extern void tcp_read_swbuf_ncs (T_TCP_CEP *cep, T_NET_BUF *output, uint_t len, uint_t doff);
extern void tcp_send_swbuf_ncs (T_TCP_CEP *cep, uint_t len);
extern ER_UINT tcp_get_swbuf_addr_ncs (T_TCP_CEP *cep, void **p_buf);
extern ER tcp_wait_swbuf_ncs (T_TCP_CEP *cep, TMO tmout);
extern T_NET_BUF *tcp_push_res_nbuf_ncs (T_NET_BUF *buf);
extern T_NET_BUF *tcp_pull_res_nbuf_ncs (ATR nbatr);
extern void tcp_alloc_swbuf_ncs (T_TCP_CEP *cep);
extern bool_t tcp_is_swbuf_full_ncs (T_TCP_CEP *cep);

/*
 *  tcp_find_cep -- |[gԍ TCP ʐM[_𓾂B
 *
 *    : myaddr ́A
 *          TINET-1.2 lbg[NoCgI[_A
 *          TINET-1.1 ܂ł́AzXgoCgI[_
 */
extern T_TCP_CEP *tcp_find_cep (T_IN_ADDR *dstaddr,  uint16_t dstport,
                                T_IN_ADDR *peeraddr, uint16_t peerport);

/*
 *  TCP wb_̃g[Xo͋@\p֐
 */
extern void tcp_output_trace (T_NET_BUF *output, T_TCP_CEP *cep);
extern void tcp_input_trace  (T_NET_BUF *input,  T_TCP_CEP *cep);

/* TCP o̓^XN */

extern void	tcp_output_task(intptr_t exinf);

#endif	/* of #ifndef _TCP_VAR_H_ */
