/*
 *  TINET (TCP/IP Protocol Stack)
 * 
 *  Copyright (C) 2001-2009 by Dep. of Computer Science and Engineering
 *                   Tomakomai National College of Technology, JAPAN
 *
 *  L쌠҂́Cȉ (1)`(4) ̏CFree Software Foundation 
 *  ɂČ\Ă GNU General Public License  Version 2 ɋL
 *  qĂ𖞂ꍇɌC{\tgEFAi{\tgEFA
 *  ς̂܂ށDȉjgpEEρEĔzziȉC
 *  pƌĂԁj邱Ƃ𖳏ŋD
 *  (1) {\tgEFA\[XR[ȟ`ŗpꍇɂ́CL̒
 *      \C̗pщL̖ۏ؋K肪Ĉ܂܂̌`Ń\[
 *      XR[hɊ܂܂Ă邱ƁD
 *  (2) {\tgEFACCu`ȂǁC̃\tgEFAJɎg
 *      pł`ōĔzzꍇɂ́CĔzzɔhLgip
 *      ҃}jAȂǁjɁCL̒쌠\C̗pщL
 *      ̖ۏ؋Kfڂ邱ƁD
 *  (3) {\tgEFAC@ɑgݍނȂǁC̃\tgEFAJɎg
 *      płȂ`ōĔzzꍇɂ́C̏𖞂ƁD
 *    (a) ĔzzɔhLgip҃}jAȂǁjɁCL̒
 *        쌠\C̗pщL̖ۏ؋Kfڂ邱ƁD
 *  (4) {\tgEFA̗pɂ蒼ړI܂͊ԐړIɐ邢Ȃ鑹
 *      QCL쌠҂TOPPERSvWFNgƐӂ邱ƁD
 *
 *  {\tgEFÁCۏ؂Œ񋟂Ă̂łDL쌠҂
 *  TOPPERSvWFNǵC{\tgEFAɊւāC̓Kp\
 *  ܂߂āCȂۏ؂sȂD܂C{\tgEFA̗pɂ蒼
 *  ړI܂͊ԐړIɐȂ鑹QɊւĂC̐ӔC𕉂ȂD
 * 
 *  @(#) $Id: tcp_input.c,v 1.5 2009/12/24 05:47:21 abe Exp abe $
 */

/*
 * Copyright (c) 1982, 1986, 1988, 1990, 1993, 1994, 1995
 *	The Regents of the University of California.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *	This product includes software developed by the University of
 *	California, Berkeley and its contributors.
 * 4. Neither the name of the University nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 *	@(#)tcp_input.c	8.12 (Berkeley) 5/24/95
 * $FreeBSD: src/sys/netinet/tcp_input.c,v 1.82.2.3 1999/10/14 11:49:38 des Exp $
 */

#include <string.h>

#ifdef TARGET_KERNEL_ASP

#include <kernel.h>
#include <sil.h>
#include <t_syslog.h>
#include "kernel_cfg.h"

#endif	/* of #ifdef TARGET_KERNEL_ASP */

#ifdef TARGET_KERNEL_JSP

#include <s_services.h>
#include <t_services.h>
#include "kernel_id.h"

#endif	/* of #ifdef TARGET_KERNEL_JSP */

#include <tinet_defs.h>
#include <tinet_config.h>

#include <net/if.h>
#include <net/if_ppp.h>
#include <net/if_loop.h>
#include <net/ethernet.h>
#include <net/net.h>
#include <net/net_var.h>
#include <net/net_buf.h>
#include <net/net_timer.h>
#include <net/net_count.h>

#include <netinet/in.h>
#include <netinet/in_var.h>
#include <netinet6/in6.h>
#include <netinet6/in6_var.h>
#include <netinet6/nd6.h>
#include <netinet/in_itron.h>
#include <netinet/ip.h>
#include <netinet/ip_var.h>
#include <netinet/ip6.h>
#include <netinet6/ip6_var.h>
#include <netinet/ip_icmp.h>
#include <netinet/tcp.h>
#include <netinet/tcp_timer.h>
#include <netinet/tcp_var.h>
#include <netinet/tcp_fsm.h>
#include <netinet/tcp_seq.h>

#ifdef SUPPORT_TCP

/*
 *  ߂l
 *
 *      RET_OK		
 *	RET_DROP	G[AZOgjB
 *	RET_RST_DROP	G[ARST 𑗐MAZOgjB
 */

#define RET_OK		(0)
#define RET_NEED_OUTPUT	(1)
#define RET_RETURN	(2)
#define RET_DROP	(-1)
#define RET_RST_DROP	(-2)

/*
 *  ֐
 */

static void close_connection	(T_TCP_CEP *cep, bool_t *needoutput);
static void set_rexmt_timer	(T_TCP_CEP *cep,  T_TCP_TIME rtt);
static uint8_t reassemble		(T_NET_BUF *input, T_TCP_CEP *cep, uint_t thoff, uint8_t flags);
static ER drop_after_ack	(T_NET_BUF *input, T_TCP_CEP *cep, uint_t thoff);
static ER listening		(T_NET_BUF *input, T_TCP_CEP *cep, uint_t thoff, T_TCP_SEQ iss);
static ER proc_ack1		(T_NET_BUF *input, T_TCP_CEP *cep, uint_t thoff, bool_t *needoutput);
static ER proc_ack2		(T_NET_BUF *input, T_TCP_CEP *cep, uint_t thoff, bool_t *needoutput);
static ER syn_sent		(T_TCP_HDR *tcph,  T_TCP_CEP *cep);
static void trim_length		(T_TCP_HDR *tcph,  T_TCP_CEP *cep);
static void parse_option	(T_TCP_HDR *tcph,  T_TCP_CEP *cep);
static bool_t update_wnd		(T_TCP_HDR *tcph,  T_TCP_CEP *cep);
static void proc_urg		(T_TCP_HDR *tcph,  T_TCP_CEP *cep);

#if defined(NUM_TCP_TW_CEP_ENTRY) && NUM_TCP_TW_CEP_ENTRY > 0

/*
 *  ^XN Time Wait  CEP @\
 */

/*
 *  ֐
 */

static T_TCP_TWCEP*tcp_find_twcep (T_IN_ADDR *dstaddr,  uint16_t dstport,
                                   T_IN_ADDR *peeraddr, uint16_t peerport);

/*
 *  ϐ
 */

T_TCP_TWCEP tcp_twcep[NUM_TCP_TW_CEP_ENTRY];

/*
 *  tcp_find_twcep -- |[gԍ Time Wait p TCP ʐM[_𓾂B
 *
 *    : dstaddr ́Albg[NoCgI[_
 */

static T_TCP_TWCEP*
tcp_find_twcep (T_IN_ADDR *dstaddr, uint16_t dstport, T_IN_ADDR *peeraddr, uint16_t peerport)
{
	T_TCP_TWCEP*	twcep;
	
	/*
	 *  Ԃ TIME WAIT ŁA
	 *  IP AhXƃ|[gԍvʐM[_TB
	 */
	for (twcep = &tcp_twcep[NUM_TCP_TW_CEP_ENTRY]; twcep -- != tcp_twcep; ) {
		if (twcep->fsm_state == TCP_FSM_TIME_WAIT                   &&
		    IN_IS_DSTADDR_ACCEPT (&twcep->myaddr.ipaddr,  dstaddr)  &&
		    IN_ARE_NET_ADDR_EQUAL(&twcep->dstaddr.ipaddr, peeraddr) &&
		    dstport  == twcep->myaddr.portno                        &&
		    peerport == twcep->dstaddr.portno)
			return twcep;
	}

	return NULL;
}

/*
 *  Kvȏ Time Wait p TCP ʐM[_ɈڂāA
 *  W TCP ʐM[_JB
 */

void
tcp_move_twcep (T_TCP_CEP *cep)
{
	T_TCP_TWCEP*	twcep;

	/* 󂫂 Time Wait p TCP ʐM[_TB*/
	for (twcep = &tcp_twcep[NUM_TCP_TW_CEP_ENTRY]; twcep -- != tcp_twcep; ) {
		if (twcep->fsm_state != TCP_FSM_TIME_WAIT) {

			/*
			 *  ʐM[_bNA
			 *  Kvȏ Time Wait p TCP ʐM[_ɈڂB
			 */
			syscall(wai_sem(cep->semid_lock));
			twcep->rbufsz		= cep->rbufsz;
			twcep->dstaddr		= cep->dstaddr;
			twcep->myaddr		= cep->myaddr;
			twcep->snd_una		= cep->snd_una;
			twcep->rcv_nxt		= cep->rcv_nxt;
			twcep->rwbuf_count	= cep->rwbuf_count;
			twcep->fsm_state	= cep->fsm_state;
			twcep->timer_2msl	= cep->timer[TCP_TIM_2MSL];

			/* ʐM[_bNB*/
			syscall(sig_sem(cep->semid_lock));

			/* W TCP ʐM[_JB*/
			tcp_close(cep);

			break;
		}
	}
}

#endif	/* of #if defined(NUM_TCP_TW_CEP_ENTRY) && NUM_TCP_TW_CEP_ENTRY > 0 */

/*
 *  parse_option -- TCP wb_̃IvV͂B
 */

static void
parse_option (T_TCP_HDR *tcph, T_TCP_CEP *cep)
{
	uint8_t	*opt, type = 0;
	uint_t	len, ol, ssize;

	opt = (uint8_t*)tcph + TCP_HDR_SIZE;
	len = (uint_t)(TCP_HDR_LEN(tcph->doff) - TCP_HDR_SIZE);
	while (len > 0 && (type = *opt) != TCP_OPT_EOL) {
		if (type == TCP_OPT_NOP)
			ol = 1u;
		else {
			if (len < 2)
				break;
			ol = *(opt + 1);
			if (ol < 2 || ol > len)
				break;
		}
		switch (type) {
		case TCP_OPT_NOP:
			break;
		case TCP_OPT_MAXSEG:
			if ((ol == TCP_OPT_LEN_MAXSEG) && (tcph->flags & TCP_FLG_SYN)) {
				ssize = ntohs(*(uint16_t*)(opt + 2));
				if (ssize > MAX_TCP_SND_SEG)
					cep->maxseg = MAX_TCP_SND_SEG;
				else if (ssize < TCP_MINMSS)
					cep->maxseg = TCP_MINMSS;
				else
					cep->maxseg = ssize;
			}
			break;

		case TCP_OPT_WINDOW:
		case TCP_OPT_SACK_PERM:
		case TCP_OPT_TIMESTAMP:
		case TCP_OPT_CC:
		case TCP_OPT_CCNEW:
		case TCP_OPT_CCECHO:
			syslog(LOG_INFO, "[TCP] unsup opt: %d.", type);
			break;

		default:
			syslog(LOG_NOTICE, "[TCP] unexp opt: %d.", type);
			break;
		}
		opt += ol;
		len -= ol;
	}
}

/*
 *  set_rexmt_timer -- VԂWAđ^C}XVB
 */

static void
set_rexmt_timer (T_TCP_CEP *cep, T_TCP_TIME rtt)
{
	T_TCP_TIME delta;

	NET_COUNT_TCP(net_count_tcp[NC_TCP_RTT_UPDATES], 1);
	if (cep->srtt != 0) {
		/*
		 *  srtt: ꂽ RTT
		 *
		 *  vꂽ RTT (rtt) ƌ݂̕ꂽ RTT (srtt) ̍ (delta) ߂B
		 *
		 *  delta  2 rbgVtg ( 4 {) lŕێB
		 *  srtt   5 rbgVtg (32 {) lŕێĂB
		 *
		 *    delta = rtt / 8 - srtt / 8
		 *
		 *  V srtt 
		 *
		 *    srtt = rtt / 8 + srtt * 7 / 8
		 *         = srtt + (rtt / 8 - srtt / 8)
		 *
		 *  ŌvZB
		 *  ̂߁Artt  2 rbgVtgAsrtt  (5 - 2) rbgEVtg delta ߂B
		 */
		delta = ((rtt - 1) << TCP_DELTA_SHIFT) - (cep->srtt >> (TCP_SRTT_SHIFT - TCP_DELTA_SHIFT));
		cep->srtt += delta;
		if (cep->srtt <= 0)
			cep->srtt = 1;

		/*
		 *  delta ̐Βl | delta | ߂B
		 */
		if (delta < 0)
			delta = - delta;

		/*
		 *  rttvar: ꂽU
		 *
		 *  rttvar  4 rbgVtg (16 {) lŕێĂB
		 *
		 *    delta = |delta| / 4 - rttvar / 4
		 *
		 *  V rttvar 
		 *
		 *    rttvar = |delta|/ 4 + rttvar * 3 /4
		 *           = rttvar + (|delta| / 4 - rttvar / 4)
		 *
		 *  ŌvZB
		 */
		delta -= cep->rttvar >> (TCP_RTTVAR_SHIFT - TCP_DELTA_SHIFT);
		cep->rttvar += delta;
		if (cep->rttvar <= 0)
			cep->rttvar = 1;
	}
	else {
		/*
		 *  ܂ srtt ̐ݒ肪sĂȂƂ́Avꂽ RTT gpB
		 *  ꂽ RTT (srtt) ɂ́ARTT  5 rbgVtg (32{) lB
		 *  ꂽU (rttvar) ɂ́ARTT  1/2  4 rbgVtg (16{) lB
		 */
		cep->srtt   = rtt <<  TCP_SRTT_SHIFT;
		cep->rttvar = rtt << (TCP_RTTVAR_SHIFT - 1);
	}

	/*
	 *  rtt ̑IAđ񐔂ZbgB
	 */
	cep->rtt = cep->rxtshift = 0;

	/*
	 *  RTT ɋŏl  rtt + 2 ̑傫Ȓl̕đ^CAEg̍ŏlɂB
	 */
	if (rtt + 2 < TCP_TVAL_MIN)
		cep->rxtcur = tcp_range_set(tcp_rexmt_val(cep),
		                            (T_TCP_TIME)TCP_TVAL_MIN,
		                            (T_TCP_TIME)TCP_TVAL_MAX_REXMT);
	else
		cep->rxtcur = tcp_range_set(tcp_rexmt_val(cep),
		                            (T_TCP_TIME)(rtt + 2),
		                            (T_TCP_TIME)TCP_TVAL_MAX_REXMT);
}

/*
 *  reassemble -- MZOgč\BԒʂɎMƂ̏
 */

static uint8_t
reassemble (T_NET_BUF *input, T_TCP_CEP *cep, uint_t thoff, uint8_t flags)
{
	T_TCP_Q_HDR 	*qhdr;
	T_TCP_HDR	*tcph;

	tcph = GET_TCP_HDR(input, thoff);
	if (tcph->sum > cep->rbufsz - cep->rwbuf_count) {
		/*
		 *  MEBhobt@ɋ󂫂ȂƂ͔jB
		 */
		NET_COUNT_TCP(net_count_tcp[NC_TCP_RECV_DROP_SEGS], 1);
		syscall(rel_net_buf(input));
		cep->flags |= TCP_CEP_FLG_ACK_NOW;
		flags &= ~TCP_FLG_FIN;
	}
	else if (tcph->seq == cep->rcv_nxt &&
	         cep->reassq == NULL &&
	         cep->fsm_state == TCP_FSM_ESTABLISHED) {
		/*
		 *  ԒʂɃZOgM̏
		 *  MZOg̕בւ͕svȂ̂
		 *  ̂܂܎MEBhobt@ɏށB
		 */

#ifdef TCP_CFG_DELAY_ACK

		cep->flags |= TCP_CEP_FLG_DEL_ACK;

#else/* of #ifdef TCP_CFG_DELAY_ACK */

		cep->flags |= TCP_CEP_FLG_ACK_NOW;

#endif/* of #ifdef TCP_CFG_DELAY_ACK */

		qhdr = GET_TCP_Q_HDR(input, thoff);

		/*  TCP wb_̈ʒuۑB*/
		GET_TCP_IP_Q_HDR(input)->thoff = thoff;

		/* SDU ̃ItZbgi̓EBhTCYjZbgB*/
		qhdr->soff = 0;

		/* f[^MEBhobt@ɏށB*/
		TCP_WRITE_RWBUF(cep, input, thoff);
	}
	else {
		flags = tcp_write_raque(input, cep, thoff, flags);
		cep->flags |= TCP_CEP_FLG_ACK_NOW;
	}
	return flags;
}

/*
 *  listening -- 󓮃I[vāCԂ LISTEN ̏
 *
 *    ߂l:
 *      RET_OK		
 *	RET_DROP	G[AZOgjB
 *	RET_RST_DROP	G[ARST 𑗐MAZOgjB
 */

static ER
listening (T_NET_BUF *input, T_TCP_CEP *cep, uint_t thoff, T_TCP_SEQ iss)
{
	T_IP_HDR	*iph;
	T_TCP_HDR	*tcph;

	iph  = GET_IP_HDR(input);
	tcph = GET_TCP_HDR(input, thoff);

	/* 
	 *  tO RST ZbgĂΔjB
	 */
	if (tcph->flags & TCP_FLG_RST)
		return RET_DROP;

	/*  
	 *  tO ACK ZbgĂꂢ΁A
	 *  Zbg𑗂ĔjB
	 */
	if (tcph->flags & TCP_FLG_ACK)
		return RET_RST_DROP;

	/* 
	 *  tO SYN ZbgĂȂ΂ΔjB
	 */
	if ((tcph->flags & TCP_FLG_SYN) == 0)
		return RET_DROP;

#if defined(SUPPORT_INET4)

#ifdef SUPPORT_LOOP

	/*
	 *  ̂Ƃ͔jB
	 *    E|[gԍŁAM IP AhX B
	 *      A[J[vobN (127.0.0.1) ȂǂB
	 *    E}`LXgAhX
	 */

	if (tcph->dport == tcph->sport &&
	    (iph->dst == iph->src && ntohl(iph->src) != IPV4_ADDR_LOOPBACK))
		return RET_DROP;

#else	/* of #ifdef SUPPORT_LOOP */

	/*
	 *  ̂Ƃ͔jB
	 *    E|[gԍŁAM IP AhX B
	 *    E}`LXgAhX
	 */

	if (tcph->dport == tcph->sport && iph->dst == iph->src)
		return RET_DROP;

#endif	/* of #ifdef SUPPORT_LOOP */

#endif	/* of #if defined(SUPPORT_INET4) */

#if defined(SUPPORT_INET6)

	/*
	 *  ̂Ƃ͔jB
	 *    E|[gԍŁAM IP AhX B
	 *    E}`LXgAhX
	 */

	if (tcph->dport == tcph->sport && IN_ARE_ADDR_EQUAL(&iph->dst, &iph->src))
		return RET_DROP;

#endif	/* of #if defined(SUPPORT_INET6) */

	if (IN_IS_NET_ADDR_MULTICAST(&iph->dst))
		return RET_DROP;

	/* ̃AhXL^B*/
	IN_COPY_TO_HOST(&cep->dstaddr.ipaddr, &iph->src);
	cep->dstaddr.portno = tcph->sport;

	/* IvVB*/
	parse_option(tcph, cep);

	/* V[PXԍB*/
	if (tcp_iss == 0)
		tcp_init_iss();

	/* ̃V[PXԍ̏lL^B*/
	if (iss != 0)
		cep->iss = iss;
	else
		cep->iss = tcp_iss;

	tcp_iss += TCP_ISS_INCR() / 4;

	/* ̃V[PXԍ̏lL^B*/
	cep->irs = tcph->seq;

	/* MV[PXԍB*/
	init_send_seq(cep);
	init_receive_seq(cep);

	/* MEChTCYݒ肷B*/
	cep->snd_wnd = tcph->win;

	/* ŏIݒ */
	cep->flags    |= TCP_CEP_FLG_ACK_NOW;
	cep->fsm_state = TCP_FSM_SYN_RECVD;
	cep->timer[TCP_TIM_KEEP] = TCP_TVAL_KEEP_INIT;

	return RET_OK;
}

/*
 *  syn_sent -- \I[vāAԂ SYN Mς̏
 *
 *    ߂l:
 *      RET_OK		
 *	RET_DROP	G[AZOgjB
 *	RET_RST_DROP	G[ARST 𑗐MAZOgjB
 */

static ER
syn_sent (T_TCP_HDR *tcph, T_TCP_CEP *cep)
{
	ER error = RET_OK;

	/*
	 *  肩MmFėĂA
	 *
	 *    ACK <= iss && Mő SEQ (snd_max) < ACK
	 *
	 *  ȂAZbg𑗂ăZOgjB
	 */
	if ((tcph->flags & TCP_FLG_ACK) &&
	    (SEQ_LE(tcph->ack, cep->iss) || SEQ_GT(tcph->ack, cep->snd_max)))
		return RET_RST_DROP;

	/*
	 *  RST/ACK tỎ΁A|[gJĂȂ
	 *  ƂӖĂB
	 */
	if (tcph->flags & TCP_FLG_RST) {
		if (tcph->flags & TCP_FLG_ACK) {
			cep->net_error = EV_CNNRF;
			cep = tcp_drop(cep, E_CLS);
		}
		return RET_DROP;
	}

	/*
	 *  SYN tOȂ΃ZOgjB
	 */
	if ((tcph->flags & TCP_FLG_SYN) == 0)
		return RET_DROP;

	cep->snd_wnd = tcph->win;	/* snd_wnd: ̎M\EBhTCY	*/
	cep->irs     = tcph->seq;	/* irs:     ̃V[PXԍ̏l	*/
	init_receive_seq(cep);		/* MV[PXԍB		*/

	if (tcph->flags & TCP_FLG_ACK) {
		/*
		 *  ACK tOƂ̏
		 *
		 *  M҂Ăő SEQ (rcv_adv) 
		 *  M\ȃEBhTCY (rcv_wnd) i߂B
		 */
		cep->rcv_adv += cep->rcv_wnd;	/* rcv_adv: M҂Ăő SEQ	*/
						/* rcv_wnd: M\ȃEBhTCY		*/

		/* mF̍ŏM SEQ (snd_una)  SYN  (1 INebg) i߂B*/
		cep->snd_una ++;

#ifdef TCP_CFG_DELAY_ACK

		if (tcph->sum != 0)		/* tcph->sum  SDU  */
			cep->flags |= TCP_CEP_FLG_DEL_ACK;
		else
			cep->flags |= TCP_CEP_FLG_ACK_NOW;

#else/* of #ifdef TCP_CFG_DELAY_ACK */

		cep->flags |= TCP_CEP_FLG_ACK_NOW;

#endif/* of #ifdef TCP_CFG_DELAY_ACK */

		if (cep->flags & TCP_CEP_FLG_NEED_FIN) {
			/*
			 *  CEP  FIN MvĂ΁A
			 *  ؒfJnA
			 *  CEP ̏Ԃ FIN Wait 1 ɂB
			 */
			cep->fsm_state = TCP_FSM_FIN_WAIT_1;
			cep->flags  &= ~TCP_CEP_FLG_NEED_FIN;
			tcph->flags &= ~TCP_FLG_SYN;
		}
		else {
			/*
			 *  肩 ACK ꂽ̂ŁA
			 *  CEP ̏Ԃ RlNVJ݊ԂɂB
			 */
			cep->timer[TCP_TIM_KEEP] = TCP_TVAL_KEEP_IDLE;
			cep->fsm_state  = TCP_FSM_ESTABLISHED;
			NET_COUNT_MIB(tcp_stats.tcpActiveOpens, 1);
			syscall(set_flg(cep->est_flgid, TCP_CEP_EVT_ESTABLISHED));

#ifdef TCP_CFG_NON_BLOCKING

			if (cep->snd_nblk_tfn == TFN_TCP_CON_CEP) {

				/* ̃AhXRs[B*/
				*cep->p_dstaddr = cep->dstaddr;

				if (IS_PTR_DEFINED(cep->callback)) {

#ifdef TCP_CFG_NON_BLOCKING_COMPAT14

					NET_COUNT_TCP(net_count_tcp[NC_TCP_CONNECTS], 1);
					(*cep->callback)(GET_TCP_CEPID(cep), cep->snd_nblk_tfn, E_OK);

#else	/* of #ifdef TCP_CFG_NON_BLOCKING_COMPAT14 */

					ER	error = E_OK;

					NET_COUNT_TCP(net_count_tcp[NC_TCP_CONNECTS], 1);
					(*cep->callback)(GET_TCP_CEPID(cep), cep->snd_nblk_tfn, (void*)&error);

#endif	/* of #ifdef TCP_CFG_NON_BLOCKING_COMPAT14 */

				}
				else {
					syslog(LOG_WARNING, "[TCP] no call back, CEP: %d.", GET_TCP_CEPID(cep));
					error = RET_RST_DROP;
				}
				cep->p_dstaddr = NULL;
				cep->snd_tskid = TA_NULL;
				cep->snd_tfn   = cep->snd_nblk_tfn = TFN_TCP_UNDEF;
			}
			else

#endif	/* of #ifdef TCP_CFG_NON_BLOCKING */

				NET_COUNT_TCP(net_count_tcp[NC_TCP_CONNECTS], 1);
		}
	}
	else {
		/* ACK tOȂƂ́AACK 𑗂āACEP ̏Ԃ SYN Mς݂ɂB*/
		cep->flags |= TCP_CEP_FLG_ACK_NOW;
		cep->timer[TCP_TIM_REXMT] = 0;
		cep->fsm_state  = TCP_FSM_SYN_RECVD;
	}

	return error;
}

/*
 *  trim_length -- M SDU 𒲐B
 */

static void
trim_length (T_TCP_HDR *tcph, T_TCP_CEP *cep)
{
	tcph->seq ++;
	if (tcph->sum > cep->rcv_wnd) {		/* : tcph->sum  SDU  */
		/*
		 *  SDU MEBhTCY傫Ƃ́AMEBhTCYȍ~
		 *  jAFIN ɉȂƂŁAjf[^đB
		 */
		tcph->sum    = (uint16_t)cep->rcv_wnd;
		tcph->flags &= ~TCP_FLG_FIN;
	}
	cep->snd_wl1 = tcph->seq - 1;		/* cep->snd_wl1: EBhXV SEQ ԍ	*/

#ifdef TCP_CFG_EXTENTIONS
	cep->rcv_up  = tcph->seq;		/* cep->rcv_up : Mً}|C^	*/
#endif
}

/*
 *  proc_ack2 -- ACK ̏ (2)
 *
 *    ߂l
 *
 *      RET_OK		
 *      RET_RETURN	A^[B
 *	RET_DROP	G[AZOgjB
 *	RET_RST_DROP	G[ARST 𑗐MAZOgjB
 */

static ER
proc_ack2 (T_NET_BUF *input, T_TCP_CEP *cep, uint_t thoff, bool_t *needoutput)
{
	T_TCP_HDR	*tcph;
	ER		ret = RET_OK;
	uint32_t	acked;
	bool_t		ourfinisacked = false;

	tcph = GET_TCP_HDR(input, thoff);

	/*
	 *  ɎMmFꂽ ACK A܂mFĂȂ
	 *  ŏM SEQ (snd_una) ƁAMEBhobt@
	 *  폜Ă悢INebg (acked) ɂȂB
	 */
	acked = tcph->ack - cep->snd_una;
	NET_COUNT_TCP(net_count_tcp[NC_TCP_RECV_ACKS], 1);

	/*
	 *  Ԍv (rtt) ݒ肳ĂāAvJn SEQ 
	 *   ACK MA^C}obNItLZA
	 *  đ^C}Đݒ肷B
	 */
	if (cep->rtt && SEQ_GT(tcph->ack, cep->rtseq)) {
		set_rexmt_timer(cep, cep->rtt);
	}

	/*
	 *  SĂ̖mFf[^ ACK ꂽAđ^C}~A
	 *  ĊJL (ɏo͂)B
	 *  AACK ׂAɑ̃f[^ȂAđ^C}
	 *  ݂̍đ^CAEgݒ肷B
	 */
	if (tcph->ack == cep->snd_max) {	/* cep->snd_max: Mő SEQ */

#ifdef TCP_CFG_SWBUF_CSAVE

		/*
		 * MEBhobt@̏ȃRs[@\L̏ꍇ́A
		 * Mς݂ŁAACK܂ōđ^C}ύXȂB
		 */
		if ((cep->flags & TCP_CEP_FLG_WBCS_MASK) == TCP_CEP_FLG_WBCS_ACKED)
			cep->timer[TCP_TIM_REXMT] = 0;

#else	/* of #ifdef TCP_CFG_SWBUF_CSAVE */

		cep->timer[TCP_TIM_REXMT] = 0;

#endif	/* of #ifdef TCP_CFG_SWBUF_CSAVE */

		*needoutput = true;
	}
	else if (cep->timer[TCP_TIM_PERSIST] == 0) {
	 	cep->timer[TCP_TIM_REXMT] = cep->rxtcur;	/* cep->rxtcur: ݂̍đ^CAEg */
	}

	/* 肪MmFf[^Ƃ̏ */
	if (acked) {
		uint32_t cw   = cep->snd_cwnd;	/* cep->snd_cwnd: tsEBhTCY	*/
		uint32_t incr = cep->maxseg;		/* cep->maxseg:   őZOgTCY	*/

		/*
		 *  Vɑ肪MmFf[^Ƃ́A
		 *  tsEBhTCY傫B
		 *  tsEBhTCY (snd_cwnd) 
		 *  tsEBhTCŶl (snd_ssthresh) 傫Ƃ
		 *  ts𐧌sB
		 *
		 *    snd_cwnd = snd_cwnd + maxseg * maxseg / snd_cwnd;
		 *
		 *  Ƃ́AX[X^[gsB
		 *
		 *    snd_cwnd = snd_cwnd + maxseg
		 *
		 */
		if (cw > cep->snd_ssthresh)
			/* ts𐧌 */
			incr = incr * incr / cw;

		if (cw + incr < MAX_TCP_WIN_SIZE)
			cep->snd_cwnd = (uint16_t)(cw + incr);
		else
			cep->snd_cwnd = MAX_TCP_WIN_SIZE;

		/*
		 *  MEBhobt@A肪MmFf[^ (acked) ̃f[^폜B
		 */
		if (acked > cep->swbuf_count) {
			cep->snd_wnd -= cep->swbuf_count;
			TCP_DROP_SWBUF(cep, (uint_t)cep->swbuf_count);
			ourfinisacked = true;
		}
		else {
			cep->snd_wnd -= (uint16_t)acked;
			TCP_DROP_SWBUF(cep, (uint_t)acked);
			ourfinisacked = false;
		}

		/* MEBhobt@ɋ󂫂łƂm点B*/
		syscall(set_flg(cep->snd_flgid, TCP_CEP_EVT_SWBUF_READY));

		/*
		 *  BmFĂȂŏM SEQ (snd_una) 
		 *  񑗒BmFꂽ ACK ܂Ői߁A
		 *  ̑Mf[^ SEQ (snd_nxt) AV
		 *  BmFĂȂŏM SEQ (snd_una)
		 *  ܂Ői߂B
		 */
		cep->snd_una += acked;
		if (SEQ_LT(cep->snd_nxt, cep->snd_una))
			cep->snd_nxt = cep->snd_una;

		/*
		 *  Ԃɂ蕪
		 */
		switch (cep->fsm_state) {
		case TCP_FSM_FIN_WAIT_1:	/* APP IAFIN Mς݁AACK ҂ */
			if (ourfinisacked) {
				cep->fsm_state = TCP_FSM_FIN_WAIT_2;
				cep->timer[TCP_TIM_2MSL] = TCP_TVAL_KEEP_COUNT * TCP_TVAL_KEEP_INTERVAL;
			}
			break;
		case TCP_FSM_CLOSING:		/* N[YAFIN ς݁AACK ҂ */
			if (ourfinisacked) {
				/*
				 *  M FIN mFĂΏԂύXA
				 *  ׂẴ^C}ZbgA2MSL ^C}ݒ肷B
				 */
				cep->fsm_state = TCP_FSM_TIME_WAIT;
				tcp_cancel_timers(cep);
				cep->timer[TCP_TIM_2MSL] = 2 * TCP_TVAL_MSL;
			}
			break;
		case TCP_FSM_LAST_ACK:		/* APP IAACK ҂ */
			if (ourfinisacked) {
				/*
				 *  M FIN mFĂ΁Acep N[YA
				 *  ZOgjB
				 */
				cep = tcp_close(cep);
				ret = RET_DROP;
			}
			break;
		case TCP_FSM_TIME_WAIT:		/* 肩 FIN Mς݁Aԑ҂ */
			/*
			 *  肩 FIN đꂽBx2MSL ^C}ݒ肵A
			 *  ACK MAZOgjB
			 */
			cep->timer[TCP_TIM_2MSL] = 2 * TCP_TVAL_MSL;
			return drop_after_ack(input, cep, thoff);
		}
	}

	return ret;
}

/*
 *  proc_ack1 -- ACK ̏ (1)
 *
 *    ߂l:
 *      RET_OK		
 *      RET_RETURN	A^[B
 *	RET_DROP	G[AZOgjB
 *	RET_RST_DROP	G[ARST 𑗐MAZOgjB
 *
 */

static ER
proc_ack1 (T_NET_BUF *input, T_TCP_CEP *cep, uint_t thoff, bool_t *needoutput)
{
	T_TCP_HDR *tcph = GET_TCP_HDR(input, thoff);

	switch (cep->fsm_state) {
	case TCP_FSM_SYN_RECVD:		/* SYN MASYN Mς	*/

		/* ԂύXB*/
		if (cep->flags & TCP_CEP_FLG_NEED_FIN) {
			cep->fsm_state  = TCP_FSM_FIN_WAIT_1;
			cep->flags &= ~TCP_CEP_FLG_NEED_FIN;
		}
		else {
			cep->timer[TCP_TIM_KEEP] = TCP_TVAL_KEEP_IDLE;
			cep->fsm_state  = TCP_FSM_ESTABLISHED;

			/* TCP ʐM[_TCP tB*/
			cep->rep = NULL;

			syscall(set_flg(cep->est_flgid, TCP_CEP_EVT_ESTABLISHED));

#ifdef TCP_CFG_NON_BLOCKING

			if (cep->rcv_nblk_tfn == TFN_TCP_ACP_CEP) {

				/* ̃AhXRs[B*/
				*cep->p_dstaddr = cep->dstaddr;

				if (IS_PTR_DEFINED(cep->callback)) {

#ifdef TCP_CFG_NON_BLOCKING_COMPAT14

					NET_COUNT_MIB(tcp_stats.tcpPassiveOpens, 1);
					NET_COUNT_TCP(net_count_tcp[NC_TCP_ACCEPTS], 1);
					(*cep->callback)(GET_TCP_CEPID(cep), cep->rcv_nblk_tfn, E_OK);

#else	/* of #ifdef TCP_CFG_NON_BLOCKING_COMPAT14 */

					ER	error = E_OK;

					NET_COUNT_MIB(tcp_stats.tcpPassiveOpens, 1);
					NET_COUNT_TCP(net_count_tcp[NC_TCP_ACCEPTS], 1);
					(*cep->callback)(GET_TCP_CEPID(cep), cep->rcv_nblk_tfn, (void*)&error);

#endif	/* of #ifdef TCP_CFG_NON_BLOCKING_COMPAT14 */

					cep->p_dstaddr = NULL;
					cep->rcv_tskid = TA_NULL;
					cep->rcv_tfn   = cep->rcv_nblk_tfn = TFN_TCP_UNDEF;
				}
				else {
					syslog(LOG_WARNING, "[TCP] no call back, CEP: %d.", GET_TCP_CEPID(cep));
					cep->p_dstaddr = NULL;
					cep->rcv_tskid = TA_NULL;
					cep->rcv_tfn   = cep->rcv_nblk_tfn = TFN_TCP_UNDEF;
					return RET_RST_DROP;
				}
			}

			if (cep->snd_nblk_tfn == TFN_TCP_CON_CEP) {

				/* ̃AhXRs[B*/
				*cep->p_dstaddr = cep->dstaddr;

				if (IS_PTR_DEFINED(cep->callback)) {

#ifdef TCP_CFG_NON_BLOCKING_COMPAT14

					NET_COUNT_MIB(tcp_stats.tcpActiveOpens, 1);
					NET_COUNT_TCP(net_count_tcp[NC_TCP_CONNECTS], 1);
					(*cep->callback)(GET_TCP_CEPID(cep), cep->snd_nblk_tfn, E_OK);

#else	/* of #ifdef TCP_CFG_NON_BLOCKING_COMPAT14 */

					ER	error = E_OK;

					NET_COUNT_MIB(tcp_stats.tcpActiveOpens, 1);
					NET_COUNT_TCP(net_count_tcp[NC_TCP_CONNECTS], 1);
					(*cep->callback)(GET_TCP_CEPID(cep), cep->snd_nblk_tfn, (void*)&error);

#endif	/* of #ifdef TCP_CFG_NON_BLOCKING_COMPAT14 */

					cep->p_dstaddr = NULL;
					cep->snd_tskid = TA_NULL;
					cep->snd_tfn   = cep->snd_nblk_tfn = TFN_TCP_UNDEF;
				}
				else {
					syslog(LOG_WARNING, "[TCP] no call back, CEP: %d.", GET_TCP_CEPID(cep));
					cep->p_dstaddr = NULL;
					cep->snd_tskid = TA_NULL;
					cep->snd_tfn   = cep->snd_nblk_tfn = TFN_TCP_UNDEF;
					return RET_RST_DROP;
				}
			}

#endif	/* of #ifdef TCP_CFG_NON_BLOCKING */

			if (cep->rcv_tfn == TFN_TCP_ACP_CEP) {
				NET_COUNT_MIB(tcp_stats.tcpPassiveOpens, 1);
				NET_COUNT_TCP(net_count_tcp[NC_TCP_ACCEPTS], 1);
			}

			if (cep->snd_tfn == TFN_TCP_CON_CEP) {
				NET_COUNT_MIB(tcp_stats.tcpActiveOpens, 1);
				NET_COUNT_TCP(net_count_tcp[NC_TCP_CONNECTS], 1);
			}
		}

		/*
		 *  SDU Ȃ FIN ĂȂ΁Atcp_move_ra2rw() ďoB
		 */
		if (tcph->sum == 0 && (tcph->flags & TCP_FLG_FIN) == 0)		/* tcph->sum  SDU  */
			tcph->flags = tcp_move_ra2rw(cep, tcph->flags);
		
		cep->snd_wl1 = tcph->seq - 1;	/* snd_wl1: EBhXV SEQ */

		/* break; ɗB*/
	
	case TCP_FSM_ESTABLISHED:	/* RlNVJ݊		*/
	case TCP_FSM_FIN_WAIT_1:	/* IāAFIN Mς		*/
	case TCP_FSM_FIN_WAIT_2:	/* IAFIN `BmFMAFIN҂*/
	case TCP_FSM_CLOSE_WAIT:	/* FIN MAN[Y҂		*/
	case TCP_FSM_CLOSING:		/* IAFIN ς݁AACK ҂	*/
	case TCP_FSM_LAST_ACK:		/* FIN MAIAACK ҂	*/
	case TCP_FSM_TIME_WAIT:		/* IAԑ҂		*/

		if (SEQ_LE(tcph->ack, cep->snd_una)) {

			/*
			 *  MmF ACK  mF̍ŏM SEQ (snd_una) ƓȑÔƂ̏
			 *  ܂Ad ACK MƂӖĂB
			 */

			if (tcph->sum == 0 && tcph->win == cep->snd_wnd) {	/* tcph->sum  SDU  */

				/*
				 *  SDU ȂÃEBhTCYύXĂȂ΁A
				 *  łɑMZOg̒ŁAACK (tcph->ack) 
				 *   SEQ n܂ZOgArŏ\B
				 *  ̏ꍇ́Aē]ƍJosB
				 */
				NET_COUNT_TCP(net_count_tcp[NC_TCP_RECV_DUP_ACKS], 1);

				if (cep->timer[TCP_TIM_REXMT] == 0 || tcph->ack != cep->snd_una) {

					/*
					 *  đ^C}ZbgĂȂƂA
					 *  ܂́AACK (tcph->ack) ƖmF̍ŏM SEQ
					 *  vȂƂ́Ad ACK  0 ɂB
					 */
					cep->dupacks = 0;
				}

				else if (++ cep->dupacks == MAX_TCP_REXMT_THRESH) {

					/*
					 *  d ACK l (W 3) ɂȂ
					 *  ē]JnB
					 */
					uint_t		win;

					/*
					 *  tsEBhTCY(snd_cwnd)̂lݒ肷B
					 *
					 *    ̎M\EBhTCY (snd_wnd) 
					 *    tsEBhTCY (snd_cwnd)  1/2B
					 *    A2 * maxseg ȏB
					 *
					 */
					if (cep->snd_wnd < cep->snd_cwnd)
						win = cep->snd_wnd / 2 / cep->maxseg;
					else
						win = cep->snd_cwnd / 2 / cep->maxseg;
					if (win < 2)
						win = 2;
					cep->snd_ssthresh = win * cep->maxseg;

					/* đ^C}ƉԂZbgB*/
					cep->timer[TCP_TIM_REXMT] = 0;
					cep->rtt = 0;

					/* ZOg𑗐MB*/
					cep->snd_old_nxt = cep->snd_nxt;
					cep->snd_nxt     = tcph->ack;
					cep->snd_cwnd    = cep->maxseg;

					/*
					 *  snd_nxt ɖ߂悤ɐݒ肵
					 *  MwB
					 */
					cep->flags |=  TCP_CEP_FLG_POST_OUTPUT |
					               TCP_CEP_FLG_FORCE       |
					               TCP_CEP_FLG_FORCE_CLEAR |
					               TCP_CEP_FLG_RESTORE_NEXT_OUTPUT;
					sig_sem(SEM_TCP_POST_OUTPUT);

					/* tsEBhTCYXVB*/
					cep->snd_cwnd = (uint16_t)(cep->snd_ssthresh
					                   + cep->maxseg * cep->dupacks);
					
					return RET_DROP;
				}

				else if (cep->dupacks > MAX_TCP_REXMT_THRESH) {

					/*
					 *  d ACK l (W 3) 𒴂
					 *  tsEBhTCY𑝉ȂđB
					 */
					cep->snd_cwnd += cep->maxseg;

					/* MwB*/
					cep->flags |=  TCP_CEP_FLG_POST_OUTPUT;
					sig_sem(SEM_TCP_POST_OUTPUT);

					return RET_DROP;
				}
			} 
			else
				cep->dupacks = 0;
			break;
		}

		/*
		 *  MmF ACK  mF̍ŏM SEQ (snd_una) ȍ~̂Ƃ̏
		 */
		if (cep->dupacks >= MAX_TCP_REXMT_THRESH && cep->snd_cwnd > cep->snd_ssthresh)
		 	/*
			 *  ē]sĂƂ́AtsEBhTCYl܂Ŗ߂B
			 */
			cep->snd_cwnd = (uint16_t)cep->snd_ssthresh;
	
		cep->dupacks = 0;

		if (SEQ_GT(tcph->ack, cep->snd_max))
			/*
			 *  M ACK Mő SEQ 𒴂ĂƂ̏
			 */
			return drop_after_ack(input, cep, thoff);

		if (cep->flags & TCP_CEP_FLG_NEED_SYN) {
			/*
			 *  SYN MvāAmF̍ŏM SEQ i߂B
			 */
			cep->flags &= ~TCP_CEP_FLG_NEED_SYN;
			cep->snd_una ++;
		}
		
		return proc_ack2(input, cep, thoff, needoutput);
		break;
	}
	return RET_OK;
}

/*
 *  update_wnd -- EBhTCYXVB
 *
 *    ߂l: MKvȂ true ԂB
 */

static bool_t
update_wnd (T_TCP_HDR *tcph, T_TCP_CEP *cep)
{

	/*
	 *  XV
	 *
	 *    ACK tOZbgĂ &&
	 *    (OEBhXV SEQ (snd_wl1)  SEQ O ||
	 *     OEBhXV SEQ (snd_wl1)  SEQ Ɠ &&
	 *     (OEBhXV ACK (snd_wl2)  ACK O ||
	 *      (OEBhXV ACK (snd_wl2)  ACK Ɠ &&
	 *       WIN ̎M\EBhTCY (snd_wnd) 傫
	 *       )
	 *      )
	 *     )
	 */
	if ((tcph->flags & TCP_FLG_ACK) &&
	    (SEQ_LT(cep->snd_wl1, tcph->seq) ||
	     (cep->snd_wl1 == tcph->seq &&
	      (SEQ_LT(cep->snd_wl2, tcph->ack) ||
	       (cep->snd_wl2 == tcph->ack && tcph->win > cep->snd_wnd))))) {

		cep->snd_wnd = tcph->win;
		cep->snd_wl1 = tcph->seq;
		cep->snd_wl2 = tcph->ack;

		if (cep->snd_wnd > cep->max_sndwnd)
			/* ܂ł̍ő呗MEBhTCYXVB*/
			cep->max_sndwnd = cep->snd_wnd;

#ifdef TCP_CFG_SWBUF_CSAVE

		if ((cep->flags & TCP_CEP_FLG_WBCS_MASK) == TCP_CEP_FLG_WBCS_WOPEN_PEND) {

			/*
			 *  MEBhobt@p̃lbg[Nobt@蓖ĒŁA
			 *  ̎MEBh󂭂̂҂ĂƂ̏
			 */
			if (cep->snd_wnd > 0) {

				/*
				 *  ̎MEBh󂢂Ƃ́A
				 *  MEBhobt@p̃lbg[Nobt@蓖ĂĊJB
				 */
				cep->flags = (cep->flags & ~TCP_CEP_FLG_WBCS_MASK)
				                         |  TCP_CEP_FLG_WBCS_FREE |  TCP_CEP_FLG_POST_OUTPUT;
				sig_sem(SEM_TCP_POST_OUTPUT);
			}
		}

#endif	/* of #ifdef TCP_CFG_SWBUF_CSAVE */

		return true;
	}
	else
		return false;
}

/*
 *  proc_urg -- ً}f[^̃ZOg̏
 */

#ifdef TCP_CFG_EXTENTIONS

static void
proc_urg (T_TCP_HDR *tcph, T_TCP_CEP *cep)
{
	if ((tcph->flags & TCP_FLG_URG) && VALID_URG_POINTER(tcph->urp) &&
	    TCP_FSM_HAVE_RCVD_FIN(cep->fsm_state) == 0) {

		/* ً}f[^̃ZOg̏ */

		NET_COUNT_TCP(net_count_tcp[NC_TCP_RECV_URG_SEGS], 1);
		if (tcph->urp + cep->rwbuf_count > cep->rbufsz) {

			/*
			 *  ً}|C^̈ʒuMEBhobt@
			 *  ͈͂𒴂Ƃ͉ȂB
			 */
			tcph->urp    = 0;
			tcph->flags &= ~TCP_FLG_URG;
		}

		if (SEQ_GT(tcph->seq + tcph->urp, cep->rcv_up))
			/* ً}|C^XVꂽƂ̏ */
			cep->rcv_up = tcph->seq + tcph->urp;

		if ((tcph->flags & TCP_FLG_URG) && (tcph->urp + TCP_CFG_URG_OFFSET) < tcph->sum) {	/* tcph->sum  TCP  SDU  */

			/*
			 *  ً}|C^̈ʒuAMZOg̏ꍇ́A
			 *  R[obN֐ĂяoB
			 */
			cep->urg_tcph = tcph;
			if (IS_PTR_DEFINED(cep->callback)) {

#ifdef TCP_CFG_NON_BLOCKING_COMPAT14

				(*cep->callback)(GET_TCP_CEPID(cep), TEV_TCP_RCV_OOB, (void*)(uint32_t)1);

#else	/* of #ifdef TCP_CFG_NON_BLOCKING_COMPAT14 */

				uint32_t	len = 1;

				(*cep->callback)(GET_TCP_CEPID(cep), TEV_TCP_RCV_OOB, (void*)&len);

#endif	/* of #ifdef TCP_CFG_NON_BLOCKING_COMPAT14 */

			}
			else {
				syslog(LOG_WARNING, "[TCP] no call back for OOB, CEP: %d.", GET_TCP_CEPID(cep));
			}

			if (cep->urg_tcph != NULL) {
				/* R[obN֐ tcp_rcv_oob() ďoȂB*/
				cep->urg_tcph = NULL;
				tcph->urp = 0;
			}
			else {
				/* 
				 *  R[obN֐ tcp_rcv_oob() ďóA
				 *  SDU ̕␳lݒ肷B
				 */
				tcph->urp = 1;
			}
		}
		else if (tcph->urp > 0) {
			tcph->urp = 0;
		}

	}
	else if (SEQ_GT(cep->rcv_nxt, cep->rcv_up)) {
		cep->rcv_up = cep->rcv_nxt;
		tcph->urp = 0;
	}
}

#else	/* of #ifdef TCP_CFG_EXTENTIONS */

static void
proc_urg (T_TCP_HDR *tcph, T_TCP_CEP *cep)
{
	tcph->urp = 0;
}

#endif	/* of #ifdef TCP_CFG_EXTENTIONS */

/*
 *  drop_after_ack -- MZOgjAACK Ԃ (: OƂ͍ĂȂ)B
 *
 *    ߂l:
 *      RET_RETURN	A^[B
 *	RET_RST_DROP	G[ARST 𑗐MAZOgjB
 */

static ER
drop_after_ack (T_NET_BUF *input, T_TCP_CEP *cep, uint_t thoff)
{
	T_TCP_HDR *tcph = GET_TCP_HDR(input, thoff);

	/*
	 *    SYN MԂŁAACK BmFĂȂŏM SEQ (snd_una) 
	 *    O̒lAMꂽő SEQ (snd_max) ̒l̏ꍇ́A RST 
	 *    ďIB́A"LAND" DoS Uւ̖hłAUꂽ SYN
	 *    ZOg𑗐MÂ|[gԂł ACK Xg[hB
	 */
	if (cep->fsm_state == TCP_FSM_SYN_RECVD && (tcph->flags & TCP_FLG_ACK) &&
	    (SEQ_GT(cep->snd_una, tcph->ack) ||
	     SEQ_GT(tcph->ack, cep->snd_max)))
		return RET_RST_DROP;

	syscall(rel_net_buf(input));

	/* MwB*/
	cep->flags |=  TCP_CEP_FLG_ACK_NOW | TCP_CEP_FLG_POST_OUTPUT;
	sig_sem(SEM_TCP_POST_OUTPUT);
	return RET_RETURN;
}

/*
 *  close_connection -- RlNVJA肩 FIN MB
 */

static void
close_connection (T_TCP_CEP *cep, bool_t *needoutput)
{
	if (TCP_FSM_HAVE_RCVD_FIN(cep->fsm_state) == 0) {

#ifdef TCP_CFG_DELAY_ACK

		if (cep->flags & TCP_CEP_FLG_NEED_SYN)
			cep->flags |= TCP_CEP_FLG_DEL_ACK;
		else
			cep->flags |= TCP_CEP_FLG_ACK_NOW;

#else/* of #ifdef TCP_CFG_DELAY_ACK */

		cep->flags |= TCP_CEP_FLG_ACK_NOW;

#endif/* of #ifdef TCP_CFG_DELAY_ACK */

		cep->rcv_nxt ++;
	}

	switch (cep->fsm_state) {
	case TCP_FSM_SYN_RECVD:		/* SYN MASYN Mς	*/
	case TCP_FSM_ESTABLISHED:	/* RlNVJ݊		*/
		cep->fsm_state = TCP_FSM_CLOSE_WAIT;
		break;

	case TCP_FSM_FIN_WAIT_1:	/* APP IAFIN Mς݁AACK ҂ */
		cep->fsm_state = TCP_FSM_CLOSING;
		break;

	case TCP_FSM_FIN_WAIT_2:	/* 肩 FIN ҂ */
		cep->fsm_state = TCP_FSM_TIME_WAIT;
		tcp_cancel_timers(cep);
		cep->timer[TCP_TIM_2MSL] = 2 * TCP_TVAL_MSL;

		/*
		 *  FIN WAIT 2 Ԃł́A
		 *  M͉\ł邪AłɑM͏IĂB
		 *  ̑MÎŁA̓^XN̂݋NB
		 */
		syscall(set_flg(cep->snd_flgid, TCP_CEP_EVT_SWBUF_READY));

#if defined(NUM_TCP_TW_CEP_ENTRY) && NUM_TCP_TW_CEP_ENTRY > 0

		/* 肩 FIN ɑ΂ĉԂB*/
		tcp_respond(NULL, cep, cep->rcv_nxt, cep->snd_una,
		            cep->rbufsz - cep->rwbuf_count, TCP_FLG_ACK);
		cep->flags &= ~TCP_CEP_FLG_ACK_NOW;
		*needoutput = false;

		/*
		 *  Kvȏ Time Wait p TCP ʐM[_ɈڂāA
		 *  W TCP ʐM[_JB
		 */
		tcp_move_twcep(cep);

#endif	/* of #if defined(NUM_TCP_TW_CEP_ENTRY) && NUM_TCP_TW_CEP_ENTRY > 0 */

		break;

	case TCP_FSM_TIME_WAIT:		/* 肩 FIN Mς݁Aԑ҂ */
		cep->timer[TCP_TIM_2MSL] = 2 * TCP_TVAL_MSL;
		break;
	}
}

/*
 *  tcp_input -- TCP ̓͊֐
 *
 *	: input ɂ IF wb_ IP wb_擪ɂB
 */

uint_t
tcp_input (T_NET_BUF **inputp, uint_t *offp, uint_t *nextp)
{
	T_NET_BUF	*input = *inputp;
	T_IP_HDR	*iph;
	T_TCP_HDR	*tcph;
	T_TCP_CEP	*cep = NULL;
	T_TCP_SEQ	iss = 0;
	ER		ret;
	bool_t		needoutput = false;
	int_t		rbfree;
	int32_t		todrop, win;
	uint16_t	seglen;
	uint8_t		flags;

#if defined(NUM_TCP_TW_CEP_ENTRY) && NUM_TCP_TW_CEP_ENTRY > 0
	T_TCP_TWCEP	*twcep;
#endif	/* of #if defined(NUM_TCP_TW_CEP_ENTRY) && NUM_TCP_TW_CEP_ENTRY > 0 */

	NET_COUNT_TCP(net_count_tcp[NC_TCP_RECV_OCTETS],
	              input->len - GET_IF_IP_HDR_SIZE(input));
	NET_COUNT_TCP(net_count_tcp[NC_TCP_RECV_SEGS], 1);
	NET_COUNT_MIB(tcp_stats.tcpInSegs, 1);

	/* wb_`FbNB*/
	if (input->len < IF_IP_TCP_HDR_SIZE) {
		NET_COUNT_TCP(net_count_tcp[NC_TCP_RECV_BAD_HEADERS], 1);
		goto drop;
	}

	iph  = GET_IP_HDR(input);
	tcph = GET_TCP_HDR(input, *offp);

	seglen  = input->len - *offp;				/* TCP ̃ZOg */

	if (IN_CKSUM(input, IPPROTO_TCP, *offp, (uint_t)seglen) != 0) {
		NET_COUNT_TCP(net_count_tcp[NC_TCP_RECV_BAD_CKSUMS], 1);
		goto drop;
	}

	/* TCP wb_`FbNB*/
	if (TCP_HDR_LEN(tcph->doff) < TCP_HDR_SIZE || TCP_HDR_LEN(tcph->doff) > seglen) {
		NET_COUNT_TCP(net_count_tcp[NC_TCP_RECV_BAD_HEADERS], 1);
		goto drop;
	}
	tcph->sum = seglen - TCP_HDR_LEN(tcph->doff);		/*  tcph->sum  TCP  SDU  */

	/*
	 *  SYN  FIN ̗rbgZbgĂΔjBnmap ̑΍
	 *  ARFC1644 T/TCP g@\ƋB
	 */
	if ((tcph->flags & (TCP_FLG_SYN | TCP_FLG_FIN)) == (TCP_FLG_SYN | TCP_FLG_FIN))
		goto drop;

	/* lbg[NI[_[zXgI[_[ɕϊB*/

	NTOHL(tcph->seq);
	NTOHL(tcph->ack);
	NTOHS(tcph->win);
	NTOHS(tcph->urp);
	NTOHS(tcph->sport);
	NTOHS(tcph->dport);

find_cep:

#if defined(NUM_TCP_TW_CEP_ENTRY) && NUM_TCP_TW_CEP_ENTRY > 0

	/*
	 *  Ԃ Time Wait  CEP TB
	 */
	twcep = tcp_find_twcep(&iph->dst, tcph->dport, &iph->src, tcph->sport);
	if (twcep != NULL) {

		if (tcph->flags & TCP_FLG_RST)		/* RST tOMƂ͖B*/
			goto drop;
		else {

			/*
			 *    TCP ʐM[_ Time Wait ̎AzXgZOgƂ́A
			 *    zXg FIN ɑ΂鎩zXg ACK ZOgr
			 *    ƂӖĂ̂ŁAACK ZOgđB
			 */

			/* zXgI[_[lbg[NI[_[ɖ߂B*/
			HTONS(tcph->sport);
			HTONS(tcph->dport);

			tcp_respond(input, NULL, twcep->rcv_nxt, twcep->snd_una, twcep->rbufsz - twcep->rwbuf_count, TCP_FLG_ACK);
		}
		return IPPROTO_DONE;
	}
	else
		/* W TCP ʐM[_𓾂B*/
		cep = tcp_find_cep(&iph->dst, tcph->dport, &iph->src, tcph->sport);

#else	/* of #if defined(NUM_TCP_TW_CEP_ENTRY) && NUM_TCP_TW_CEP_ENTRY > 0 */

	/* TCP ʐM[_𓾂B*/
	cep = tcp_find_cep(&iph->dst, tcph->dport, &iph->src, tcph->sport);

#endif	/* of #if defined(NUM_TCP_TW_CEP_ENTRY) && NUM_TCP_TW_CEP_ENTRY > 0 */

	/*
	 *  TCP ʐM[_Ȃꍇ CEP ̏ԂN[YȂjB
	 */
	if (cep == NULL) {
		syslog(LOG_INFO, "[TCP] unexp port: %d.", tcph->dport);
		goto reset_drop;
	}

#ifdef TCP_CFG_TRACE

	tcp_input_trace(input, cep);

#endif	/* of #ifdef TCP_CFG_TRACE */


	if (cep->fsm_state == TCP_FSM_CLOSED)
		goto drop;

	/*
	 *  RlNVJݍς݂ŃZOgMƂ́A
	 *  AChԂƐmF^C}ZbgB
	 */
	cep->idle = 0;
	if (TCP_FSM_HAVE_ESTABLISHED(cep->fsm_state)) {
		cep->timer[TCP_TIM_KEEP] = TCP_TVAL_KEEP_IDLE;
	}

	/* CEP ̏Ԃ LISTEN ȊO̎́AIvVB*/
	if (cep->fsm_state != TCP_FSM_LISTEN)
		parse_option(tcph, cep);

	/*
	 *  M\EBhTCYvZB
	 *
	 *  rcv_nxt:     M҂Ăŏ SEQiȑO͎Mς݁j
	 *  rcv_adv:     M҂Ăő SEQ
	 *  rbufsz:      MEBhobt@TCY
	 *  rwbuf_count:  MEBhobt@ɂf[^
	 *  tcph->sum:   M SDU TCY
	 *
	 *  MZOgL[ɘA
	 *  \̂ tcph->sum lB
	 *
	 */
	win = cep->rbufsz - (cep->rwbuf_count + tcph->sum);
	if (win < 0)
		win = 0;
	if (win > (int32_t)(cep->rcv_adv - cep->rcv_nxt))
		cep->rcv_wnd = win;
	else
		cep->rcv_wnd = cep->rcv_adv - cep->rcv_nxt;

	/* CEP ̏Ԃɂ菈sB*/

	if (cep->fsm_state == TCP_FSM_LISTEN) {		/* 󓮃I[v (LISTEN) ̏B*/
		if ((ret = listening(input, cep, *offp, iss)) == RET_RST_DROP)
			goto reset_drop;
		else if (ret == RET_DROP)
			goto drop;
		trim_length(tcph, cep);			/* M SDU 𒲐B*/

		if (tcph->flags & TCP_FLG_ACK) {	/* ACK tȌ */
			if ((ret = proc_ack2(input, cep, *offp, &needoutput)) == RET_DROP)
				goto drop;
			else if (ret == RET_RST_DROP)
				goto reset_drop;
			else if (ret == RET_RETURN)
				return IPPROTO_DONE;
		}
	}
	else if (cep->fsm_state == TCP_FSM_SYN_SENT) {	/* \I[vASYN Mς	*/
		if ((ret = syn_sent(tcph, cep)) == RET_RST_DROP)
			goto reset_drop;
		else if (ret == RET_DROP)
			goto drop;
		trim_length(tcph, cep);			/* M SDU 𒲐B*/

		if (tcph->flags & TCP_FLG_ACK) {	/* ACK tȌ */
			if ((ret = proc_ack2(input, cep, *offp, &needoutput)) == RET_DROP)
				goto drop;
			else if (ret == RET_RST_DROP)
				goto reset_drop;
			else if (ret == RET_RETURN)
				return IPPROTO_DONE;
		}
	}
	else {
		if (cep->fsm_state == TCP_FSM_SYN_RECVD) {	/* SYN MASYN Mς	*/
			/*
			 *  肩MmFėĂA
			 *
			 *    ACK <= mF̍ŏM SEQ (snd_una) &&
			 *           Mő     SEQ (snd_max) < ACK
			 *
			 *  ȂAZbg𑗂ăZOgjB
			 */
			if ((tcph->flags & TCP_FLG_ACK) &&
			    (SEQ_LE(tcph->ack, cep->snd_una) ||
			     SEQ_GT(tcph->ack, cep->snd_max)))
			     	goto reset_drop;
		}

		/* 
		 *  RST tOMƂ̏ (ُؒf)
		 */
		if (tcph->flags & TCP_FLG_RST) {
			if (SEQ_GE(tcph->seq, cep->last_ack_sent) &&
			    SEQ_LT(tcph->seq, cep->last_ack_sent + cep->rcv_wnd)) {
				/*
				 *  MZOg SEQ AŌɑM ACK (last_ack_sent)
				 *  AMEChETCY܂ł̊Ԃ̏
				 */
				switch (cep->fsm_state) {
				case TCP_FSM_SYN_RECVD:		/* SYN MASYN Mς		*/

					cep->net_error = EV_CNNRF;	/* ڑs\ */
					cep->error     = E_CLS;
					NET_COUNT_TCP(net_count_tcp[NC_TCP_RECV_RSTS], 1);
					NET_COUNT_MIB(tcp_stats.tcpAttemptFails, 1);
					cep = tcp_close(cep);
					break;

				case TCP_FSM_ESTABLISHED:	/* RlNVJ݊			*/
				case TCP_FSM_CLOSE_WAIT:	/* FIN MAN[Y҂		*/
					NET_COUNT_MIB(tcp_stats.tcpEstabResets, 1);
					/* fallthrough */

				case TCP_FSM_FIN_WAIT_1:	/* IāAFIN Mς		*/
				case TCP_FSM_FIN_WAIT_2:	/* IAFIN `BmFMAFIN҂	*/

					cep->net_error = EV_CNRST;	/* ڑZbg */
					cep->error     = E_CLS;
					NET_COUNT_TCP(net_count_tcp[NC_TCP_RECV_RSTS], 1);
					/* no break; */

				case TCP_FSM_CLOSING:		/* IAFIN ς݁AACK ҂	*/
				case TCP_FSM_LAST_ACK:		/* FIN MAIAACK ҂	*/

					cep = tcp_close(cep);
					break;
				}
			}
			goto drop;
		}

		/*
		 *  CEP ̏Ԃ SYN MASYN Mς݂̏ꍇ́A
		 *  MEBhɎ܂悤Ƀf[^
		 *  OɁA̐ڑɂpPbgǂ؂B
		 *
		 *    M SEQ <  SEQ ̏l (irs)
		 *
		 *  ́A"LAND" DoS U̖hłB
		 */
		if (cep->fsm_state == TCP_FSM_SYN_RECVD && SEQ_LT(tcph->seq, cep->irs)) {
			goto reset_drop;
		}

		/*
		 *  M҂Ăŏ SEQ (rcv_nxt) - M SEQ 
		 *  ȂArcv_nxt ȑÕf[^͂łɎMĂ̂ŁA̕
		 *  폜B
		 *                           <---------- rcv_wnd --------->
		 *                           rcv_nxt                      rcv_nxt + rcv_wnd
		 *                           v                            v
		 *                      -----+----------------------------+-----
		 *                           |                            |
		 *                      -----+----------------------------+-----
		 *           +----------------------+
		 *           |***************|      |
		 *           +----------------------+
		 *           ^                      ^
		 *           seq                    seq + len
		 *           <---------------> 폜B
		 */
		todrop = cep->rcv_nxt - tcph->seq;
		if (todrop > 0) {

			/*
			 *  SYN tOĂƂ́A̕ (1 INebg)
			 *  SEQ i߁Aً}|C^ƍ폜钷𒲐B
			 */
			if (tcph->flags & TCP_FLG_SYN) {
				tcph->flags &= ~TCP_FLG_SYN;
				tcph->seq ++;
				if (tcph->urp > 1)
					tcph->urp --;
				else
					tcph->flags &= ~TCP_FLG_URG;
				todrop --;
			}

			/*
			 *  폜钷 SDU 蒷A܂AM҂Ă
			 *  ŏ SEQ (rcv_nxt) ɒBĂȂA
			 *  폜钷 SDU ƓŁAFIN tOĂȂ
			 *  Sč폜B
			 */
			if ( todrop >  tcph->sum ||		/* tcph->sum  TCP  SDU  */
			    (todrop == tcph->sum && (tcph->flags & TCP_FLG_FIN) == 0)) {
				tcph->flags &= ~TCP_FLG_FIN;
				cep->flags |= TCP_CEP_FLG_ACK_NOW;
				todrop = tcph->sum;		/* tcph->sum  TCP  SDU  */
			}

			/*
			 *  SDU Oɋl߂B
			 */
			if (todrop < tcph->sum) {		/* tcph->sum  TCP  SDU  */
				memcpy(GET_TCP_SDU(input, *offp),
				       GET_TCP_SDU(input, *offp) + todrop, (size_t)(tcph->sum - todrop));
			}

			/*
			 *  SEQ  SDU 𒲐B
			 */
			tcph->seq +=     todrop;
			tcph->sum -= (uint16_t)todrop;	/* tcph->sum  TCP  SDU  */

			/*
			 *  ً}|C^𒲐B
			 */
			if (tcph->urp > todrop)
				tcph->urp -= (uint16_t)todrop;
			else {
				tcph->flags &= ~TCP_FLG_URG;
				tcph->urp = 0;
			}

			NET_COUNT_TCP(net_count_tcp[NC_TCP_RECV_DUP_SEGS], 1);
		}

		/*  
		 *  [U^XNIɁAf[^M
		 *  ꍇ́ARST 𑗂B
		 */
		if (cep->fsm_state == TCP_FSM_LAST_ACK && tcph->sum > 0) {	/* tcph->sum  TCP  SDU  */
			cep = tcp_close(cep);
			goto reset_drop;
		}

		/*
		 *  MZOgMEBh𒴂ꍇ́A
		 *  B
		 *
		 *       <---------- rcv_wnd --------->
		 *       rcv_nxt                      (rcv_nxt + rcv_wnd)
		 *       v                            v
		 *  -----+----------------------------+-----
		 *       |                            |
		 *  -----+----------------------------+-----
		 *                    +----------------------+
		 *                    |               |******|
		 *                    +----------------------+
		 *                    ^                      ^
		 *                    seq                    seq + len
		 *                                     <-----> 폜B
		 */
		todrop = (tcph->seq + tcph->sum) - (cep->rcv_nxt + cep->rcv_wnd);	/* tcph->sum  TCP  SDU  */
		if (todrop > 0) {
			if (todrop > tcph->sum) {					/* tcph->sum  TCP  SDU  */
				/*
				 *  M SDU ̑SĂMEBh𒴂ꍇB
				 *
				 *  TIME_WAIT ɁAVȐڑvM
				 *  ÂڑjAVȐڑJnB
				 *  ASEQ ͑OiłȂ΂ȂȂB
				 */
				if ((tcph->flags & TCP_FLG_SYN) &&
				    cep->fsm_state == TCP_FSM_TIME_WAIT &&
				    SEQ_GT(tcph->seq, cep->rcv_nxt)) {
					iss = cep->snd_nxt + TCP_ISS_INCR();
					tcp_close(cep);
					syscall(dly_tsk(0));
					goto find_cep;
				    	}

				/*
				 *  MEBh 0 ŁAM SEQ 
				 *  M҂Ăŏ SEQ vƂ
				 *  ACK ԂBȊO̓f[^jAACK ԂB
				 */
				if (cep->rcv_wnd == 0 && (tcph->seq == cep->rcv_nxt || tcph->sum == 0)) {
					cep->flags |= TCP_CEP_FLG_ACK_NOW;
				}
				else if (drop_after_ack(input, cep, *offp) == RET_RST_DROP)
					goto reset_drop;
				else {
					return IPPROTO_DONE;
				}
			}
			tcph->sum -= (uint16_t)todrop;	/* tcph->sum  TCP  SDU  */
			tcph->flags &= ~(TCP_FLG_PUSH | TCP_FLG_FIN);
		}

		/*
		 *  ASYN ZbgĂ΁A
		 *  G[Ȃ̂ RST 𑗂AڑjB
		 */
		if (tcph->flags & TCP_FLG_SYN) {
			cep->net_error = EV_CNRST;
			cep = tcp_drop(cep, E_CLS);
			goto reset_drop;
		}

		/*
		 *  AACK ZbgĂȂꍇ́A
		 *  Ԃ SYN Mς݂
		 *  SYN 𑗐M悤ƂĂ΁A𑱂邪A
		 *  ȊO̓ZOgjďIB
		 */
		if ((tcph->flags & TCP_FLG_ACK) == 0) {
			if (!(cep->fsm_state == TCP_FSM_SYN_RECVD || (cep->flags & TCP_CEP_FLG_NEED_SYN)))
				goto drop;
		}
		else {
			/*
			 * ACK ̏
			 */
			ret = proc_ack1(input, cep, *offp, &needoutput);
			if (ret == RET_DROP)
				goto drop;
			else if (ret == RET_RST_DROP)
				goto reset_drop;
			else if (ret == RET_RETURN)
				return IPPROTO_DONE;
		}
	}

/* step 6 */

	/* MEBhXVB*/
	if (update_wnd(tcph, cep) == true)
		needoutput = true;

	/* ً}f[^B*/
	proc_urg(tcph, cep);

/* do data */

	/*
	 *  SDU 邩AFIN 𖢎M̏ԂŁAŏ FIN MƂA
	 *  MZOgL[ net_buf ǉB
	 *  ȊȌꍇ́AZOgjB
	 */
	flags = tcph->flags;
	if ((tcph->sum > 0 || (flags & TCP_FLG_FIN)) &&		/* tcph->sum  TCP  SDU  */
	    TCP_FSM_HAVE_RCVD_FIN(cep->fsm_state) == 0) {
		flags = reassemble(input, cep, *offp, flags);
	}
	else {
		syscall(rel_net_buf(input));
		flags &= ~TCP_FLG_FIN;
	}

	/*
	 *  FIN MRlNVN[YB
	 */
	if (flags & TCP_FLG_FIN)
		close_connection(cep, &needoutput);

	/* o͂sIB*/
	if (needoutput == true || (cep->flags & TCP_CEP_FLG_ACK_NOW)) {
		/* MwB*/
		cep->flags |=  TCP_CEP_FLG_POST_OUTPUT;
		sig_sem(SEM_TCP_POST_OUTPUT);
	}

	return IPPROTO_DONE;

reset_drop:
	/*
	 *  RST M
	 */

	if ((tcph->flags & TCP_FLG_RST) || IN_IS_NET_ADDR_MULTICAST(&iph->dst))
		goto drop;

	/* zXgI[_[lbg[NI[_[ɖ߂B*/

	HTONS(tcph->sport);
	HTONS(tcph->dport);

	if (cep == NULL)
		rbfree = 0;
	else
		rbfree = cep->rbufsz - cep->rwbuf_count;

	if (tcph->flags & TCP_FLG_ACK) {
		tcp_respond(input, cep, 0, tcph->ack, rbfree, TCP_FLG_RST);
	}
	else {
		if (tcph->flags & TCP_FLG_SYN)
			tcph->sum ++;		/* tcph->sum  SDU  */
		tcp_respond(input, cep, tcph->seq + tcph->sum, 0, rbfree, TCP_FLG_RST | TCP_FLG_ACK);
	}

	/* input  tcp_respoond ŕԋpB*/
	NET_COUNT_TCP(net_count_tcp[NC_TCP_SEND_RSTS], 1);
	NET_COUNT_MIB(tcp_stats.tcpOutRsts, 1);
	return IPPROTO_DONE;

drop:
	NET_COUNT_TCP(net_count_tcp[NC_TCP_RECV_DROP_SEGS], 1);
	NET_COUNT_MIB(tcp_stats.tcpInErrs, 1);
	syscall(rel_net_buf(input));
	return IPPROTO_DONE;
}

#endif	/* of #ifdef SUPPORT_TCP */
