//------------------------------------------------------------------------------
//  TOPPERS/ASP Windows Debug Environment
//  Copyright (C) 2010-2013 Cores Co., Ltd. Japan
//------------------------------------------------------------------------------
// $Id: UnitSim.cs 115 2013-02-11 02:13:05Z nagasima $
#include "StdAfx.h"
#include "WinKernel.h"
#include "SifEtherCtrl.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

#define ASSERT(cond)

extern CKernel *g_Kernel;

CSifEtherCtrl::CSifEtherCtrl(TEtherReg *etherReg, int txIntNo, int rxIntNo,
	int devNo)
{
	m_EtherReg = etherReg;
	m_TxIntNo = txIntNo;
	m_RxIntNo = rxIntNo;
	m_DevNo = devNo;

	InitializeCriticalSection(&m_Lock);

	m_Timer = -1;
	m_Term = ectIdle;
	m_Timer = -1;
	m_TxDsp = NULL;
	m_SendBufPos = 0;
	m_RxDsp = NULL;
	m_RecvBuf = NULL;
	m_RecvBufPos = 0;

	InitializeCriticalSection(&m_Lock);

	// lݒ
	memset(m_EtherReg, 0, sizeof(*m_EtherReg));
	m_EtherReg->IPGT = 0x00000013;
	m_EtherReg->IPGR = 0x00000E13;
	m_EtherReg->CLRT = 0x0000380F;
	m_EtherReg->LMAX = 0x00000600;
	m_EtherReg->LSTTXDP = (TEtherDescriper *)0xFFFFFFFF;
	m_EtherReg->LSTRXDP = (TEtherDescriper *)0xFFFFFFFF;
}

CSifEtherCtrl::~CSifEtherCtrl()
{
	TEtherCtrlDataNode *Node;

	while(!m_RecvQueue.empty()){
		// 荞݋֎~
		Lock();

		// L[玟̃bZ[W擾
		Node = m_RecvQueue.front();
		m_RecvQueue.pop_front();
		delete (unsigned char *)Node;

		// 荞݋
		Unlock();
	}

	DeleteCriticalSection(&m_Lock);
}

unsigned char CSifEtherCtrl::GetByte(unsigned int Addr)
{
	throw 1;
}

void CSifEtherCtrl::SetByte(unsigned int Addr, unsigned char Value)
{
	throw 1;
}

unsigned short CSifEtherCtrl::GetUInt16(unsigned int Addr)
{
	throw 1;
}

void CSifEtherCtrl::SetUInt16(unsigned int Addr, unsigned short Value)
{
	throw 1;
}

unsigned int CSifEtherCtrl::GetUInt32(unsigned int Addr)
{
	unsigned int Value;
	unsigned int *Reg = (unsigned int *)m_EtherReg;
	int Index;

	Index = (int)Addr - (int)Reg;

	if((Index < 0) && (Index >= sizeof(TEtherReg))){
		throw 1;
	}

	Value = Reg[Index / sizeof(*Reg)];

	switch (Index)
	{
	case &((TEtherReg *)0)->MIIC:
		break;
	case &((TEtherReg *)0)->FSTATUS:
		m_EtherReg->FSTATUS = 0;
		break;
	case &((TEtherReg *)0)->TXSTATUS:
		m_EtherReg->TXSTATUS = 0;
		break;
	case &((TEtherReg *)0)->RXSTATUS:
		m_EtherReg->RXSTATUS = 0;
		break;
	case &((TEtherReg *)0)->INTMS:
		m_EtherReg->INTMS.RBEI = 0;
		m_EtherReg->INTMS.RECI = 0;
		m_EtherReg->INTMS.RXI = 0;
		m_EtherReg->INTMS.TBEI = 0;
		m_EtherReg->INTMS.TECI = 0;
		m_EtherReg->INTMS.TXI = 0;
		break;
	case &((TEtherReg *)0)->MRDD:
		((TEtherMRDDReg *)&Value)->PRSD = m_PhyReg[m_EtherReg->MADR.RGAD];
		break;
	default:
		break;
	}

	return Value;
}

void CSifEtherCtrl::SetUInt32(unsigned int Addr, unsigned int Value)
{
	unsigned int *Reg = (unsigned int *)m_EtherReg;
	int Index;

	Index = (int)Addr - (int)Reg;

	if((Index < 0) && (Index >= sizeof(TEtherReg))){
		throw 1;
	}

	switch (Index)
	{
	case &((TEtherReg *)0)->MIIC:
		if(m_EtherReg->MIIC.MIRST != ((TEtherMIICReg *)&Value)->MIRST){
			m_MacReset = ((TEtherMIICReg *)&Value)->MIRST == 0;
		}
		break;
	case &((TEtherReg *)0)->MWTD:
		{
			unsigned short PhyReg = ((TEtherMWTDReg *)&Value)->CTLD;
			switch (m_EtherReg->MADR.RGAD)
			{
			// Basic Mode Control
			case 0:
				// Reset
				if((PhyReg & 0x8000) != 0)
				{
					PhyReg &= ~0x8000;
					m_PhyReg[1] = 0x7827;
				}
			default:
				break;
			}
			m_PhyReg[m_EtherReg->MADR.RGAD] = PhyReg;
		}
		break;
	case &((TEtherReg *)0)->RSTCNT:
		if(((TEtherRSTCNTReg *)&Value)->SFTRST == 1){
			m_FifoReset = true;
		}
		else if(((TEtherRSTCNTReg *)&Value)->RFFLSH == 1){
		}
		else if(((TEtherRSTCNTReg *)&Value)->TFFLSH == 1){
		}
		Value = 0;
		break;
	case &((TEtherReg *)0)->SFTRST:
		if(((TEtherSFTRSTReg *)&Value)->SFTRST == 1){
			m_SoftReset = true;
		}
		Value = 0;
		break;
	case &((TEtherReg *)0)->TRANSCTL:
		if(((TEtherTRANSCTLReg *)&Value)->TXEN == 0){
			((TEtherTRANSCTLReg *)&Value)->TXEN_STA = 0;
		}
		if(((TEtherTRANSCTLReg *)&Value)->RXEN == 0){
			((TEtherTRANSCTLReg *)&Value)->RXEN_STA = 0;
		}
		break;
	case &((TEtherReg *)0)->ETHMODE:
		if(((TEtherETHMODEReg *)&Value)->TXS == 0){
			Lock();
			if(m_Term == ectIdle)
			{
				m_EtherReg->LSTTXDP = m_TxDsp;
				m_TxDsp = m_EtherReg->TXDP;
				m_Term = ectSend;
				m_Timer = 0;
				g_Kernel->OnSetEvent();
			}
			Unlock();
		}
		if(((TEtherETHMODEReg *)&Value)->RXS == 0){
			Lock();
			if(m_Term == ectIdle)
			{
				m_EtherReg->LSTRXDP = m_RxDsp;
				m_RxDsp = m_EtherReg->RXDP;

				if(m_RecvBuf != NULL){
					m_Term = ectRecv;
					m_Timer = 0;
					g_Kernel->OnSetEvent();
				}
			}
			Unlock();
		}
		Value = 0;
		break;
	case &((TEtherReg *)0)->INTMS:
		Value &= 0x07000700;
		break;
	}

	Reg[Index / sizeof(*Reg)] = Value;

	return;
}

__int64 CSifEtherCtrl::GetTimer()
{
	return m_Timer;
}

void CSifEtherCtrl::Progress(__int64 Timer)
{
	if(m_Timer == -1)
		return;

	m_Timer -= Timer;
	if(m_Timer < 0){
		m_Timer = 0;
	}
}

void CSifEtherCtrl::CallTimeOut(__int64 Frequency)
{
	if(m_Timer != 0)
		return;

	Lock();

	switch(m_Term){
	case ectSend:
		for(;;){
			// obt@EfBXNv^
			if(m_TxDsp->T == 0){
				// Mς݂̃obt@EfBXNv^
				if(m_TxDsp->U == 1)
				{
					m_EtherReg->LSTTXDP = m_TxDsp;
					m_TxDsp = NULL;
					m_EtherReg->INTMS.TECI = 1;
					// MI
					if(g_Kernel->KernelFlag())
						g_Kernel->Interrupt(m_TxIntNo);
					m_Term = ectTxInt;
					m_Timer = 1;
				}
				else{
					// M
					memcpy(&m_SendBuf[m_SendBufPos], m_TxDsp->Pointer, m_TxDsp->Size);
					m_SendBufPos += m_TxDsp->Size;
					if(m_TxDsp->E == 1){
						g_Kernel->Output(m_DevNo, m_SendBuf, m_SendBufPos);
					}
					m_TxDsp->U = 1;
					m_TxDsp++;

					m_EtherReg->INTMS.TXI = 1;
					if(g_Kernel->KernelFlag())
						g_Kernel->Interrupt(m_TxIntNo);
					m_Term = ectTxInt;
					m_Timer = 1;
				}
				goto end;
			}
			// NE|C^
			else if(m_TxDsp->E == 0){
				m_EtherReg->LSTTXDP = m_TxDsp;
				m_TxDsp = (TEtherDescriper *)m_TxDsp->Pointer;
			}
			// GhEIuE`FC
			else{
				m_EtherReg->LSTTXDP = m_TxDsp;
				m_TxDsp = NULL;
			}

			if(m_TxDsp == NULL){
				m_EtherReg->INTMS.TECI = 1;
				if(g_Kernel->KernelFlag())
					g_Kernel->Interrupt(m_TxIntNo);
				m_Term = ectTxInt;
				m_Timer = 1;
				goto end;
			}
		}
		break;
	case ectTxInt:
		// 荞ݏI܂ŃXbhXCb`
		if((g_Kernel->InterruptEnabled(m_TxIntNo) || g_Kernel->InProcIntr(m_TxIntNo)) && g_Kernel->KernelFlag()){
			m_Timer = 0;
			m_Term = ectTxInt;
			goto end;
		}
		break;
	case ectRecv:
		for(;;){
			// obt@EfBXNv^
			if(m_RxDsp->T == 0){
				// Mς݂̃obt@EfBXNv^
				if(m_RxDsp->U == 1)
				{
					m_EtherReg->LSTRXDP = m_RxDsp;
					m_RxDsp = NULL;
					m_EtherReg->INTMS.RECI = 1;
					// MI
					if(g_Kernel->KernelFlag())
						g_Kernel->Interrupt(m_RxIntNo);
					m_Term = ectRxInt;
					m_Timer = 1;
				}
				else{
					unsigned int len = m_RxDsp->Size;
					if(len > (m_RecvBuf->Size - m_RecvBufPos))
						len = m_RecvBuf->Size - m_RecvBufPos;
					m_RxDsp->Size = len;
					// M
					memcpy(m_RxDsp->Pointer, &m_RecvBuf->Data[m_RecvBufPos], len);
					m_RecvBufPos += len;
					if(m_RecvBufPos >= m_RecvBuf->Size){
						if(m_RecvQueue.empty()){
							m_RecvBuf = NULL;
						}
						else{
							m_RecvBuf = m_RecvQueue.front();
							m_RecvQueue.pop_front();
						}
						m_RecvBufPos = 0;

						m_RxDsp->E = 1;
					}
					m_RxDsp->U = 1;
					m_RxDsp->Status = 0;
					m_RxDsp->S = 1;
					m_RxDsp++;

					m_EtherReg->INTMS.RXI = 1;
					if(g_Kernel->KernelFlag())
						g_Kernel->Interrupt(m_RxIntNo);
					m_Term = ectRxInt;
					m_Timer = 1;
				}
				goto end;
			}
			// NE|C^
			else if(m_RxDsp->E == 0){
				m_EtherReg->LSTRXDP = m_RxDsp;
				m_RxDsp = (TEtherDescriper *)m_RxDsp->Pointer;
			}
			// GhEIuE`FC
			else{
				m_EtherReg->LSTRXDP = m_RxDsp;
				m_RxDsp = NULL;
			}

			if(m_RxDsp == NULL)
			{
				m_EtherReg->INTMS.RECI = 1;
				if(g_Kernel->KernelFlag())
					g_Kernel->Interrupt(m_RxIntNo);
				m_Term = ectRxInt;
				m_Timer = 1;
				goto end;
			}
		}
		break;
	case ectRxInt:
		// 荞ݏI܂ŃXbhXCb`
		if((g_Kernel->InterruptEnabled(m_RxIntNo) || g_Kernel->InProcIntr(m_RxIntNo)) && g_Kernel->KernelFlag()){
			m_Timer = 0;
			m_Term = ectRxInt;
			goto end;
		}
		break;
	default:
		goto end;
	}

	// M
	if((m_RecvBuf != NULL) && (m_RxDsp != NULL) && (m_RxDsp->U == 0)){
		m_Timer = 1;
		m_Term = ectRecv;
	}
	// M
	else if((m_TxDsp != NULL) && (m_TxDsp->U == 0)){
		m_Timer = 1;
		m_Term = ectSend;
	}
	else{
		m_Timer = -1;
		m_Term = ectIdle;
	}

end:
	Unlock();
}

void CSifEtherCtrl::Receive(const void *Data, int Size)
{
	static const unsigned char BrodcastAddr[6] = { 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF };
	TEtherCtrlDataNode *Node = (TEtherCtrlDataNode *)new unsigned char[(int)&((TEtherCtrlDataNode *)0)->Data + Size];

	Node->Size = Size;
	memcpy((unsigned char *)&Node->Data, Data, Size);

	bool recv = (m_EtherReg->AFR.PRO == 1);

	// MACAhXmF
	unsigned char *MacAddr = &((unsigned char *)&m_EtherReg->LSA1)[2];
	if(!recv
		&& (memcmp(Node->EthernetData.DstAddr, MacAddr, sizeof(MacAddr)) == 0))
	{
		recv = true;
	}

	// u[hLXgAhXmF
	if(!recv && (m_EtherReg->AFR.ABC == 1)
		&& (memcmp(Node->EthernetData.DstAddr, BrodcastAddr, sizeof(BrodcastAddr)) == 0))
	{
		recv = true;
	}

	if(!recv)
	{
		delete Node;
		return;
	}

	// 荞݋֎~
	Lock();

	if(m_RecvBuf == NULL){
		m_RecvBuf = Node;
		m_RecvBufPos = 0;

		if(m_Term == ectIdle){
			m_Timer = 1;
			m_Term = ectRecv;
			g_Kernel->OnSetEvent();
		}
	}
	else{
		// bZ[WL[CO
		m_RecvQueue.push_back(Node);
	}

	// 荞݋
	Unlock();
}
