﻿//------------------------------------------------------------------------------
// Embedded Software Simulation Base Classes
// Copyright (C) 2010-2011 Cores Co., Ltd. Japan
//------------------------------------------------------------------------------
// $Id: IScenarioHost.cs 88 2011-04-05 11:03:57Z nagasima $
using System;
using System.Collections;
using System.Collections.Generic;
using System.Text;

namespace SimBase
{
	public class UnitOutputEventArgs : EventArgs
	{
		IUnitSim m_Unit;
		int m_Kind;
		byte[] m_Data;

		public UnitOutputEventArgs(IUnitSim unit, int kind, byte[] data)
		{
			m_Unit= unit;
			m_Kind = kind;
			m_Data = data;
		}

		public IUnitSim Unit
		{
			get { return m_Unit; }
		}

		public int Kind
		{
			get { return m_Kind; }
		}

		public byte[] Data
		{
			get { return m_Data; }
		}
	}

	public delegate void UnitOutputEventHandlear(IScenarioHost sender, UnitOutputEventArgs e);
	public delegate void UnitSwitchedEventHandlear(IScenarioHost sender, IUnitSim unit);

	public interface IScenarioHost
	{
		INamedList<IUnitSim> Units { get; }
		INamedList<IViewForm> Views { get; }
		IUnitSim CurrentUnit { get; set; }
		IViewForm CurrentView { get; set; }
		event UnitOutputEventHandlear UnitOutput;
		event UnitSwitchedEventHandlear UnitSwitched;
		int SetTimer(int interval, Delegate method, params Object[] args);
		bool KiiTimer(int timerID);
		IUnitSim CreateUnit(string typeName);
		IViewForm CreateView(string typeName, IUnitSim unit, params IUnitSim[] units);
		IViewForm OpenView(string typeName, IUnitSim unit, params IUnitSim[] units);
		void CloseView(string key, IUnitSim unit);
		void SwitchUnit(string unitName);
		void ShowView(IViewForm view);
	}
}
