/*
 *  TINET (TCP/IP Protocol Stack)
 * 
 *  Copyright (C) 2001-2009 by Dep. of Computer Science and Engineering
 *                   Tomakomai National College of Technology, JAPAN
 *
 *  L쌠҂́Cȉ (1)`(4) ̏CFree Software Foundation 
 *  ɂČ\Ă GNU General Public License  Version 2 ɋL
 *  qĂ𖞂ꍇɌC{\tgEFAi{\tgEFA
 *  ς̂܂ށDȉjgpEEρEĔzziȉC
 *  pƌĂԁj邱Ƃ𖳏ŋD
 *  (1) {\tgEFA\[XR[ȟ`ŗpꍇɂ́CL̒
 *      \C̗pщL̖ۏ؋K肪Ĉ܂܂̌`Ń\[
 *      XR[hɊ܂܂Ă邱ƁD
 *  (2) {\tgEFACCu`ȂǁC̃\tgEFAJɎg
 *      pł`ōĔzzꍇɂ́CĔzzɔhLgip
 *      ҃}jAȂǁjɁCL̒쌠\C̗pщL
 *      ̖ۏ؋Kfڂ邱ƁD
 *  (3) {\tgEFAC@ɑgݍނȂǁC̃\tgEFAJɎg
 *      płȂ`ōĔzzꍇɂ́C̏𖞂ƁD
 *    (a) ĔzzɔhLgip҃}jAȂǁjɁCL̒
 *        쌠\C̗pщL̖ۏ؋Kfڂ邱ƁD
 *  (4) {\tgEFA̗pɂ蒼ړI܂͊ԐړIɐ邢Ȃ鑹
 *      QCL쌠҂TOPPERSvWFNgƐӂ邱ƁD
 *
 *  {\tgEFÁCۏ؂Œ񋟂Ă̂łDL쌠҂
 *  TOPPERSvWFNǵC{\tgEFAɊւāC̓Kp\
 *  ܂߂āCȂۏ؂sȂD܂C{\tgEFA̗pɂ蒼
 *  ړI܂͊ԐړIɐȂ鑹QɊւĂC̐ӔC𕉂ȂD
 * 
 *  @(#) $Id: ppp_modem.c,v 1.5 2009/12/24 05:42:40 abe Exp abe $
 */

/* 
 *  PPP f
 */

#include <string.h>

#include <t_services.h>
#include "kernel_id.h"

#include <tinet_defs.h>
#include <tinet_config.h>

#include <net/if.h>
#include <net/if_ppp.h>
#include <net/net.h>
#include <net/net_buf.h>
#include <net/net_count.h>
#include <net/ppp.h>
#include <net/ppp_var.h>
#include <net/ppp_fsm.h>
#include <net/ppp_hdlc.h>
#include <net/ppp_modem.h>
#include <net/ppp_lcp.h>

#ifdef SUPPORT_PPP

/*
 *  Sϐ
 */

uint8_t	modem_state = PPP_MODEM_DOWN;	/* f̏		*/

/*
 *  f͕
 */

#define MODEM_RCODE_OK		0
#define MODEM_RCODE_CONNECT	1
#define MODEM_RCODE_RING	2
#define MODEM_RCODE_NO_CARRIER	3
#define MODEM_RCODE_ERROR	4
#define MODEM_RCODE_NO_DIALTONE	5
#define MODEM_RCODE_BUSY	6
#define MODEM_RCODE_DELAYED	7

/*
 *  ϐ
 */

static uint8_t *modem_rcode[] = {
	"OK",
	"CONNECT",
	"RING",
	"NO CARRIER",
	"ERROR",
	"NO DIALTONE",
	"BUSY",
	"DELAYED"
};

static int_t dial_retry;

/*
 *  ֐
 */

static void do_dial (void);
static void modem_putstr (uint8_t *str);
static void modem_wait (uint8_t *line);
static void modem_putline (uint8_t *line);

/*
 *  modem_getline -- fs
 */

T_NET_BUF *
modem_getline (T_NET_BUF *nbuf, uint16_t size)
{
	uint8_t *buf;

	buf = nbuf->buf;
	size --;			/* '\0' ̕ */
	while (size > 0 && (*buf = HDLC_raw_getoctet()) != '\r') {
		buf  ++;
		size --;
	}
	*buf = '\0';
	HDLC_raw_getoctet();		/* \n ǂݔ΂B*/
	nbuf->len = buf - nbuf->buf;
	return nbuf;
}

/*
 *  f
 *
 *	߂l: f̃UgR[h
 */

int_t
modem_cntl (T_NET_BUF *input)
{
	int_t	code;

	code = sizeof(modem_rcode) / sizeof(uint8_t*) - 1;
	while (strcmp(modem_rcode[code], input->buf) != 0) {
		if (code == 0)
			return modem_state;
		code --;
	}

	switch (modem_state) {

	case PPP_MODEM_UP:
		if (code == MODEM_RCODE_RING)
			modem_state = PPP_MODEM_RING;
		break;

	case PPP_MODEM_DIAL:
		if (code == MODEM_RCODE_CONNECT) {
			syslog(LOG_NOTICE, "[MODEM] up.");
			modem_state = PPP_MODEM_CONNECT;
			lcp_open(PPP_OPEN_ACTIVE);
			sig_sem(SEM_MODEM_READY);
		}
		else {
			syslog(LOG_NOTICE, "[MODEM] dial failed '%s'.", modem_rcode[code]);
			if (-- dial_retry == 0) {
				syslog(LOG_WARNING, "[MODEM] dial failed %d times.", MODEM_CFG_RETRY_CNT);
				modem_state = PPP_MODEM_UP;
			}
			else {
				syscall(dly_tsk(MODEM_CFG_RETRY_WAIT));
				do_dial();
			}
		}
		break;

	case PPP_MODEM_RING:
		if (code == MODEM_RCODE_CONNECT) {
			syslog(LOG_NOTICE, "[MODEM] up.");
			modem_state = PPP_MODEM_CONNECT;
			lcp_open(PPP_OPEN_PASSIVE);
		}
		else
			modem_state = PPP_MODEM_UP;
		break;

	default:
		if (code == MODEM_RCODE_NO_CARRIER) {
			if (lcp_fsm.state == PPP_FSM_OPENED)
				lcp_close();
			syslog(LOG_NOTICE, "[MODEM] down.");
			modem_state = PPP_MODEM_UP;
		}
		break;

	}

	return code;
}

/*
 *  init_modem -- fB
 */

void
init_modem (void)
{
	modem_putline("AT");

#ifdef MODEM_CFG_INIT

	modem_putline(MODEM_CFG_INIT);

#endif	/* of #ifdef MODEM_CFG_INIT */

	modem_state = PPP_MODEM_UP;
}

/*
 *  wait_modem -- ڑ܂ő҂B
 *
 *	߂l: ڑɎs E_OBJ ԂB
 */

ER
wait_modem (void)
{
	ER error = E_OK;

	if (modem_state == PPP_MODEM_UP) {
		dial();
	}

	if (modem_state != PPP_MODEM_CONNECT) {
		/* ڑ܂ő҂B*/
		wai_sem(SEM_MODEM_READY);
		if (modem_state != PPP_MODEM_CONNECT)
			error = E_OBJ;
	}

	return error;
}

/*
 *  dial -- _CBgC񐔂ZbgB
 */

void
dial (void)
{
	do_dial();
	dial_retry = MODEM_CFG_RETRY_CNT;
	modem_state = PPP_MODEM_DIAL;
}

/*
 *  do_dial -- _CBdial() ̉֐
 */

static void
do_dial (void)
{
	syslog(LOG_NOTICE, "[MODEM] dial: %s.", MODEM_CFG_PHONE_NUMBER);
	modem_putstr(MODEM_CFG_DIAL);
	modem_putstr(MODEM_CFG_PHONE_NUMBER);
	modem_putstr("\r");
}

/*
 *  modem_putstr -- fo
 */

static void
modem_putstr (uint8_t *str)
{
	while (*str)
		HDLC_raw_putoctet(*str ++);
}

/*
 *  modem_wait -- f當҂
 */

static void
modem_wait (uint8_t *line)
{
	int_t ch, state, len = strlen(line);

	state = len;
	while (state != 0) {
		ch = HDLC_raw_getoctet();
		if (ch != line[len - state])
			state = len;
		if (ch == line[len - state])
			state --;
	}
}

/*
 *  modem_putline -- fso
 */

static void
modem_putline (uint8_t *line)
{
	modem_putstr(line);
	modem_putstr("\r");
	modem_wait("OK\r\n");
}

#endif	/* fo #ifdef SUPPORT_PPP */
