/*------------------------------------------------------------------------------*/
/* TOPPERS/ASP Windows Debug Environment                                        */
/* Copyright (C) 2010-2013 Cores Co., Ltd. Japan                                */
/*------------------------------------------------------------------------------*/
/* $Id: v850ecreg.h 115 2013-02-11 02:13:05Z nagasima $ */

#ifndef V850ECRegH
#define V850ECRegH

#include "target_stddef.h"

#define MIICTL			((uint8_t *)0xFFFFFBE0)		/* C[TlbgERg[EWX^ */
#define MIICTL_MIIEN	0x01

#define MACC1			((uint32_t *)0x002E0000)	/* MACݒ背WX^1 R/W 00000000H */
#define MACC1_SRXEN		0x00000200					/* MCl[u */
#define MACC1_CRCEN		0x00000008					/* CRCt */
#define MACC1_PADEN		0x00000004					/* PADt */
#define MACC1_FULLD		0x00000002					/* SdCl[u */

#define MACC2			((uint32_t *)0x002E0004)	/* MACݒ背WX^2 R/W 00000000H */
#define MACC2_MCRST		0x00000400					/* MAC䕔\tgEGAEZbg */
#define MACC2_RFRST		0x00000200					/* MubNE\tgEGAEZbg */
#define MACC2_TFRST		0x00000100					/* MubNE\tgEGAEZbg */

#define IPGT			((uint32_t *)0x002E0008)	/* Back-to-Back IPGWX^ R/W 00000013H */
#define IPGR			((uint32_t *)0x002E000C)	/* NON Back-to-Back IPGWX^ R/W 00000E13H */
#define CLRT			((uint32_t *)0x002E0010)	/* RWEWX^ R/W 0000380FH */
#define LMAX			((uint32_t *)0x002E0014)	/* őpPbgWX^ R/W 00000600H */
#define LSA1			((uint32_t *)0x002E0054)	/* Xe[VEAhXEWX^1 R/W 00000000H */
#define LSA2			((uint32_t *)0x002E0058)	/* Xe[VEAhXEWX^2 R/W 00000000H */
#define PTVR			((uint32_t *)0x002E005C)	/* |[YE^C}l[hEWX^ R 00000000H */
#define VLTP			((uint32_t *)0x002E0064)	/* VLAN^CvEWX^ R/W 00000000H */

#define MIIC			((uint32_t *)0x002E0080)	/* MIIRtBM|VEWX^ R/W 00000000H */
#define MIIC_MIRST		0x00008000					/* VAE}lWgEC^tF[XEubNE\tgEGAEZbg */
#define MIIC_CLKS_50MHZ	0x00000008					/* MDC̕ݒ 50 MHzȉi20j */

#define MCMD			((uint32_t *)0x002E0094)	/* MIIR}hEWX^ W 00000000H */
#define MADR			((uint32_t *)0x002E0098)	/* MIIAhXEWX^ R/W 00000000H */
#define MWTD			((uint32_t *)0x002E009C)	/* MIICgEf[^EWX^ R/W 00000000H */
#define MRDD			((uint32_t *)0x002E00A0)	/* MII[hEf[^EWX^ R/W 00000000H */
#define MIND			((uint32_t *)0x002E00A4)	/* MIICWP[^EWX^ R 00000000H */

#define AFR				((uint32_t *)0x002E00C8)	/* AhXEtB^EWX^ R/W 00000000H */
#define AFR_ABC			0x00000001					/* u[hLXgM */

#define HT1				((uint32_t *)0x002E00CC)	/* HASHe[uEWX^1 R/W 00000000H */
#define HT2				((uint32_t *)0x002E00D0)	/* HASHe[uEWX^2 R/W 00000000H */
#define CAR1			((uint32_t *)0x002E00DC)	/* L[EWX^1 R/W 00000000H */
#define CAR2			((uint32_t *)0x002E00E0)	/* L[EWX^2 R/W 00000000H */
#define CAM1			((uint32_t *)0x002E0130)	/* L[E}XNEWX^1 R/W 00000000H */
#define CAM2			((uint32_t *)0x002E0134)	/* L[E}XNEWX^2 R/W 00000000H */
#define RBYT			((uint32_t *)0x002E0140)	/* MoCgEJE^ R/W 00000000H */
#define RPKT			((uint32_t *)0x002E0144)	/* MpPbgEJE^ R/W 00000000H */
#define RFCS			((uint32_t *)0x002E0148)	/* MFCSG[Et[EJE^ R/W 00000000H */
#define RMCA			((uint32_t *)0x002E014C)	/* M}`LXgEpPbgEJE^ R/W 00000000H */
#define RBCA			((uint32_t *)0x002E0150)	/* Mu[hLXgEpPbgEJE^ R/W 00000000H */
#define RXCF			((uint32_t *)0x002E0154)	/* MRg[Et[EpPbgEJE^ R/W 00000000H */
#define RXPF			((uint32_t *)0x002E0158)	/* M|[YEt[EpPbgEJE^ R/W 00000000H */
#define RXUO			((uint32_t *)0x002E015C)	/* M`Rg[EpPbgEJE^ R/W 00000000H */
#define RALN			((uint32_t *)0x002E0160)	/* MACgEG[EJE^ R/W 00000000H */
#define RFLR			((uint32_t *)0x002E0164)	/* Mt[G[EJE^ R/W 00000000H */
#define RCDE			((uint32_t *)0x002E0168)	/* MR[hEG[EJE^ R/W 00000000H */
#define RFCR			((uint32_t *)0x002E016C)	/* MFalse Carrier JE^ R/W 00000000H */
#define RUND			((uint32_t *)0x002E0170)	/* MA_TCYEpPbgEJE^ R/W 00000000H */
#define ROVR			((uint32_t *)0x002E0174)	/* MI[oTCYEpPbgEJE^ R/W 00000000H */
#define RFRG			((uint32_t *)0x002E0178)	/* MtOgEJE^ R/W 00000000H */
#define RJBR			((uint32_t *)0x002E017C)	/* MWo[EJE^ R/W 00000000H */
#define R64				((uint32_t *)0x002E0180)	/* M64oCgEt[EJE^ R/W 00000000H */
#define R127			((uint32_t *)0x002E0184)	/* M65-127oCgEt[EJE^ R/W 00000000H */
#define R255			((uint32_t *)0x002E0188)	/* M128-255oCgEt[EJE^ R/W 00000000H */
#define R511			((uint32_t *)0x002E018C)	/* M256-511oCgEt[EJE^ R/W 00000000H */
#define R1K				((uint32_t *)0x002E0190)	/* M512-1023oCgEt[EJE^ R/W 00000000H */
#define RMAX			((uint32_t *)0x002E0194)	/* M1024-RMAXoCgEt[EJE^ R/W 00000000H */
#define RVBT			((uint32_t *)0x002E0198)	/* MLoCgEJE^ R/W 00000000H */
#define TBYT			((uint32_t *)0x002E01C0)	/* MoCgEJE^ R/W 00000000H */
#define TPKT			((uint32_t *)0x002E01C4)	/* MpPbgEJE^ R/W 00000000H */
#define TFCS			((uint32_t *)0x002E01C8)	/* MFCSG[Et[EJE^ R/W 00000000H */
#define TMCA			((uint32_t *)0x002E01CC)	/* M}`LXgEpPbgEJE^ R/W 00000000H */
#define TBCA			((uint32_t *)0x002E01D0)	/* Mu[hLXgEpPbgEJE^ R/W 00000000H */
#define TUCA			((uint32_t *)0x002E01D4)	/* MjLXgEpPbgEJE^ R/W 00000000H */
#define TXPF			((uint32_t *)0x002E01D8)	/* M|[YERg[Et[EJE^ R/W 00000000H */
#define TDFR			((uint32_t *)0x002E01DC)	/* MxpPbgEJE^ R/W 00000000H */
#define TXDF			((uint32_t *)0x002E01E0)	/* MߏxpPbgEJE^ R/W 00000000H */
#define TSCL			((uint32_t *)0x002E01E4)	/* MVOERWEpPbgEJE^ R/W 00000000H */
#define TMCL			((uint32_t *)0x002E01E8)	/* M}`vERWEpPbgEJE^ R/W 00000000H */
#define TLCL			((uint32_t *)0x002E01EC)	/* MCgERWEpPbgEJE^ R/W 00000000H */
#define TXCL			((uint32_t *)0x002E01F0)	/* MߏRWEpPbgEJE^ R/W 00000000H */
#define TNCL			((uint32_t *)0x002E01F4)	/* Mg[^ERWEJE^ R/W 00000000H */
#define TCSE			((uint32_t *)0x002E01F8)	/* MLAEZXEG[EJE^ R/W 00000000H */
#define TIME			((uint32_t *)0x002E01FC)	/* MACG[EJE^ R/W 00000000H */

#define MFFCONT			((uint32_t *)0x002E0200)	/* FIFORg[ERg[EWX^ R/W 00000000H */
#define MFFCONT_RXSDMA	0x00008000
#define MFFCONT_APS		0x00000800
#define MFFCONT_APL		0x00000400
#define MFFCONT_RXEN	0x00000100					/* MCl[u */
#define MFFCONT_TXEN	0x00000001					/* MCl[u */

#define RSTCNT			((uint32_t *)0x002E0204)	/* \tgEZbg䃌WX^ R/W 00000000H */
#define RSTCNT_SFTRST	0x00000001					/* \tgEGAEZbg */

#define FLOWTHRESH		((uint32_t *)0x002E0218)	/* t[臒lWX^ R/W 06000200H */
#define PAUSETM			((uint32_t *)0x002E021C)	/* |[YE^C}lWX^ R/W 7FFFFFFFH */

#define RXERSEL			((uint32_t *)0x002E0220)	/* MG[IWX^ R/W 00000001H */
#define RXERSEL_RLENE	0x80000000					/* MpPbgEOXEG[ */
#define RXERSEL_VLAN	0x40000000					/* VLANpPbgM */
#define RXERSEL_USOP	0x20000000					/* `IyR[hERg[EpPbgM */
#define RXERSEL_RPCF	0x10000000					/* |[YERg[EpPbgM */
#define RXERSEL_RCFR	0x08000000					/* Rg[EpPbgM */
#define RXERSEL_DBNB	0x04000000					/* huEju܂ރpPbg̎M */
#define RXERSEL_RLOR	0x00400000					/* OXEtB[hC1500zpPbg̎M */
#define RXERSEL_RLER	0x00200000					/* OXEtB[hCf[^EtB[hƕsv */
#define RXERSEL_RCRCE	0x00100000					/* CRCG[ */
#define RXERSEL_RXER	0x00080000					/* RXERo */
#define RXERSEL_CEPS	0x00040000					/* False Carriero */
#define RXERSEL_REPS	0x00020000					/* vAu+SFD܂ł̃pPbgC邢̓f[^1ju */
#define RXERSEL_PAIG	0x00010000					/*   */
#define RXERSEL_TXRX	0x00000002					/* MACM̃RWoꍇ */
#define RXERSEL_DVCF	0x00000001					/* MACMpPbgLȃRg[EpPbgłƔfꍇ */

#define TXSTMONI1		((uint32_t *)0x002E0230)	/* MXe[^XEj^1WX^ R 00000000H */
#define TXSTMONI2		((uint32_t *)0x002E0234)	/* MXe[^XEj^2WX^ R 00000000H */
#define TXFINF1			((uint32_t *)0x002E0238)	/* MXe[^X1WX^ R 00000800H */
#define TXFINF2			((uint32_t *)0x002E023C)	/* MXe[^X2WX^ R 00000001H */
#define RXSTMONI		((uint32_t *)0x002E0240)	/* MXe[^XEj^EWX^ R 00000000H */
#define RXFINF1			((uint32_t *)0x002E0244)	/* MXe[^X1WX^ R 00000000H */
#define RXFINF2			((uint32_t *)0x002E0248)	/* MXe[^X2WX^ R 00000800H */
#define RXFINF3			((uint32_t *)0x002E024C)	/* MXe[^X3WX^ R 00000001H */

#define FSTATUS			((uint32_t *)0x002E0250)	/* FIFOXe[^X荞݃WX^ R 00000000H */
#define FSTATUS_MASK	((uint32_t *)0x002E0254)	/* FIFOXe[^X荞݃}XNEWX^ R/W 01011FFFH */
#define FSTATUS_MASK_TACOF	0x01000000				/* TXABTCNTWX^iTX ABORT COUNTjI[ot[ */
#define FSTATUS_MASK_RACOF	0x00010000				/* RXABTCNTWX^iRX ABORT COUNTjI[ot[ */
#define FSTATUS_MASK_TSUP	0x00001000				/* Tx Status Update */
#define FSTATUS_MASK_TFNRTY	0x00000800				/* MFIFO AbortiMFIFO Not Retryj */
#define FSTATUS_MASK_TFWE	0x00000400				/* MFIFO݃G[ */
#define FSTATUS_MASK_RFFE	0x00000080				/* MFIFO Flag Error */
#define FSTATUS_MASK_RSUP	0x00000040				/* MXe[^XEj^EWX^iRXSTMONIjXV */
#define FSTATUS_MASK_RFWE	0x00000010				/* MFIFO Write Error */
#define FSTATUS_MASK_RFOF	0x00000008				/* MFIFOI[ot[ */
#define FSTATUS_MASK_RFFLW	0x00000002				/* MFIFO̗eʂCFLOWTHRESH.FLOWTHR̐ݒlȏɂȂ */
#define FSTATUS_MASK_RFZP	0x00000001				/* MFIFO̗eʂCFLOWTHRESH.ZPTHR̐ݒlȏɂȂ */

#define TXSTATUS		((uint32_t *)0x002E0258)	/* MXe[^X荞݃WX^ R 00000000H */
#define TXSTATUS_MASK	((uint32_t *)0x002E025C)	/* Me[^X荞݃}XNEWX^ R/W 000101FFH */
#define TXSTATUS_MASK_TAB	0x00010000				/* MA{[g */
#define TXSTATUS_MASK_TGNT	0x00000080				/* LMAXz钷̃pPbg𑗐M */
#define TXSTATUS_MASK_LCOL	0x00000040				/* CgERWo */
#define TXSTATUS_MASK_ECOL	0x00000020				/* őՓˉ񐔂zՓ˂ */
#define TXSTATUS_MASK_TEDFR	0x00000010				/* ߏ著Mxo */
#define TXSTATUS_MASK_TDFR	0x00000008				/* Mx */
#define TXSTATUS_MASK_TFLOR	0x00000004				/* OXEtB[h1500傫 */
#define TXSTATUS_MASK_TFLER	0x00000002				/* OXEtB[hf[^EtB[hƕsv */
#define TXSTATUS_MASK_TCRCE	0x00000001				/* CRCG[ */

#define RXSTATUS		((uint32_t *)0x002E0260)	/* MXe[^X荞݃WX^ R 00000000H */
#define RXSTATUS_MASK	((uint32_t *)0x002E0264)	/* MXe[^X荞݃}XNEWX^ R/W 00007FFFH */
#define RXSTATUS_MASK_RLENE	0x00004000				/* MpPbgEOXEG[ */
#define RXSTATUS_MASK_VLAN	0x00002000				/* VLANpPbgM */
#define RXSTATUS_MASK_USOP	0x00001000				/* `IyR[hERg[EpPbgM */
#define RXSTATUS_MASK_RPCF	0x00000800				/* |[YERg[EpPbgM */
#define RXSTATUS_MASK_RCFR	0x00000400				/* Rg[EpPbgM */
#define RXSTATUS_MASK_DBNB	0x00000200				/* huEju܂ރpPbg̎M */
#define RXSTATUS_MASK_RLOR	0x00000100				/* OXEtB[hC1500zpPbg̎M */
#define RXSTATUS_MASK_RLER	0x00000080				/* OXEtB[hCf[^EtB[hƕsv */
#define RXSTATUS_MASK_RCRCE	0x00000040				/* MCRCG[ */
#define RXSTATUS_MASK_RXER	0x00000020				/* RXERo */
#define RXSTATUS_MASK_CEPS	0x00000010				/* False Carriero */
#define RXSTATUS_MASK_REPS	0x00000008				/* vAu+SFD܂ł̃pPbgC邢̓f[^1ju */
#define RXSTATUS_MASK_PAIG	0x00000004				/* O̎MĈꂩɓĂ͂܂ */
#define RXSTATUS_MASK_TXRX	0x00000002				/* dMiMJnjɑMJniRWj */
#define RXSTATUS_MASK_DVCF	0x00000001				/* MpPbgLiG[܂܂ȂjRg[EpPbgłꍇ */

#define TXABTCNT		((uint32_t *)0x002E0270)	/* MA{[gEJE^ R/W 00000000H */
#define RXABTCNT		((uint32_t *)0x002E0274)	/* MA{[gEJE^ R/W 00000000H */
#define ETHMODE			((uint32_t *)0x002E0300)	/* RAEt@NV䃌WX^ R/W 00000000H */
#define ETHMODE_RXS		0x00040000					/* M */
#define ETHMODE_TXS		0x00020000					/* M */

#define INTMS			((uint32_t *)0x002E0304)	/* 荞ݐ䃌WX^ R/W 07000700H */
#define INTMS_RBEMSK	0x04000000					/* RBEI荞݃}XN */
#define INTMS_RECMSK	0x02000000					/* RECI荞݃}XN */
#define INTMS_RXMSK		0x01000000					/* RXI荞݃}XN */
#define INTMS_RBEI		0x00040000					/* Mf[^Eobt@EANZXEG[荞 */
#define INTMS_RECI		0x00020000					/* MiDMAjGhEIuE`FC荞 */
#define INTMS_RXI		0x00010000					/* pPbgMiDMAj̊荞 */
#define INTMS_TBEMSK	0x00000400					/* TBEI荞݃}XN */
#define INTMS_TECMSK	0x00000200					/* TECI荞݃}XN */
#define INTMS_TXMSK		0x00000100					/* TXI荞݃}XN */
#define INTMS_TBEI		0x00000004					/* Mf[^Eobt@EANZXEG[荞 */
#define INTMS_TECI		0x00000002					/* MiDMAjGhEIuE`FC荞 */
#define INTMS_TXI		0x00000001					/* pPbgMiDMAj̊荞 */

#define TRANSCTL		((uint32_t *)0x002E0308)	/* ]䃌WX^ R/W 00030000H */
#define TRANSCTL_RXEN_STA	0x02000000				/* MXe[^XErbg */
#define TRANSCTL_TXEN_STA	0x01000000				/* MXe[^XErbg */
#define TRANSCTL_RXEN	0x00020000					/* MCl[u */
#define TRANSCTL_TXEN	0x00010000					/* MCl[u */
#define TRANSCTL_RXCHKSMEN	0x00000001				/* M`FbNTt@\̃I^It */

#define SFTRST			((uint32_t *)0x002E030C)	/* \tgEGAEZbg䃌WX^ R/W 00000000H */
#define SFTRST_SFTRST	0x00000001					/* \tgEGAEZbg */

#define DMACM			((uint32_t *)0x002E0310)	/* DMAC[h䃌WX^ R/W 00000010H */
#define DMACM_SINGLE	0x00000000					/* VO] */
#define DMACM_BURST4	0x00000300					/* 4r[gCNgo[Xg */
#define DMACM_BURST8	0x00000500					/* 8r[gCNgo[Xg */
#define DMACM_BURST16	0x00000700					/* 16r[gCNgo[Xg */

#define RXDP			((uint32_t *)0x002E0320)	/* MfBXNv^E|C^EWX^ R/W FFFFFFFCH */
#define LSTRXDP			((uint32_t *)0x002E0324)	/* ŏIMfBXNv^E|C^EWX^ R FFFFFFFCH */
#define TXDP			((uint32_t *)0x002E0328)	/* MfBXNv^E|C^EWX^ R/W FFFFFFFCH */
#define LSTTXDP			((uint32_t *)0x002E032C)	/* ŏIMfBXNv^E|C^EWX^ R FFFFFFFCH */

/* obt@EfBXNv^ */
typedef struct t_v850ec_desc {
	uint32_t	size : 16;
	uint32_t	status : 10;
	uint32_t	over : 1;
	uint32_t	rinfo : 1;
	uint32_t	error : 1;
	uint32_t	used : 1;
	uint32_t	last : 1;
	uint32_t	link : 1;
	uint8_t*	addr;
} T_V850EC_DESC;

#define IF_V850EC_RXBUF_PAGE_SIZE	1520
#define IF_V850EC_BUF_PAGE_COUNT	4

#endif /* V850ECRegH */
