/*
 *  TINET (TCP/IP Protocol Stack)
 * 
 *  Copyright (C) 2001-2009 by Dep. of Computer Science and Engineering
 *                   Tomakomai National College of Technology, JAPAN
 *
 *  L쌠҂́Cȉ (1)`(4) ̏CFree Software Foundation 
 *  ɂČ\Ă GNU General Public License  Version 2 ɋL
 *  qĂ𖞂ꍇɌC{\tgEFAi{\tgEFA
 *  ς̂܂ށDȉjgpEEρEĔzziȉC
 *  pƌĂԁj邱Ƃ𖳏ŋD
 *  (1) {\tgEFA\[XR[ȟ`ŗpꍇɂ́CL̒
 *      \C̗pщL̖ۏ؋K肪Ĉ܂܂̌`Ń\[
 *      XR[hɊ܂܂Ă邱ƁD
 *  (2) {\tgEFACCu`ȂǁC̃\tgEFAJɎg
 *      pł`ōĔzzꍇɂ́CĔzzɔhLgip
 *      ҃}jAȂǁjɁCL̒쌠\C̗pщL
 *      ̖ۏ؋Kfڂ邱ƁD
 *  (3) {\tgEFAC@ɑgݍނȂǁC̃\tgEFAJɎg
 *      płȂ`ōĔzzꍇɂ́C̏𖞂ƁD
 *    (a) ĔzzɔhLgip҃}jAȂǁjɁCL̒
 *        쌠\C̗pщL̖ۏ؋Kfڂ邱ƁD
 *  (4) {\tgEFA̗pɂ蒼ړI܂͊ԐړIɐ邢Ȃ鑹
 *      QCL쌠҂TOPPERSvWFNgƐӂ邱ƁD
 *
 *  {\tgEFÁCۏ؂Œ񋟂Ă̂łDL쌠҂
 *  TOPPERSvWFNǵC{\tgEFAɊւāC̓Kp\
 *  ܂߂āCȂۏ؂sȂD܂C{\tgEFA̗pɂ蒼
 *  ړI܂͊ԐړIɐȂ鑹QɊւĂC̐ӔC𕉂ȂD
 * 
 *  @(#) $Id: ppp_ccp.c,v 1.5 2009/12/24 05:42:40 abe Exp abe $
 */

/*
 * ccp.c - PPP Compression Control Protocol.
 *
 * Copyright (c) 1994 The Australian National University.
 * All rights reserved.
 *
 * Permission to use, copy, modify, and distribute this software and its
 * documentation is hereby granted, provided that the above copyright
 * notice appears in all copies.  This software is provided without any
 * warranty, express or implied. The Australian National University
 * makes no representations about the suitability of this software for
 * any purpose.
 *
 * IN NO EVENT SHALL THE AUSTRALIAN NATIONAL UNIVERSITY BE LIABLE TO ANY
 * PARTY FOR DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES
 * ARISING OUT OF THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF
 * THE AUSTRALIAN NATIONAL UNIVERSITY HAVE BEEN ADVISED OF THE POSSIBILITY
 * OF SUCH DAMAGE.
 *
 * THE AUSTRALIAN NATIONAL UNIVERSITY SPECIFICALLY DISCLAIMS ANY WARRANTIES,
 * INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY
 * AND FITNESS FOR A PARTICULAR PURPOSE.  THE SOFTWARE PROVIDED HEREUNDER IS
 * ON AN "AS IS" BASIS, AND THE AUSTRALIAN NATIONAL UNIVERSITY HAS NO
 * OBLIGATION TO PROVIDE MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS,
 * OR MODIFICATIONS.
 */

/*
 *	   PPP Compression Control Protocol (CCP) Module
 *
 *	    Written by Toshiharu OHNO (tony-o@iij.ad.jp)
 *
 *   Copyright (C) 1994, Internet Initiative Japan, Inc. All rights reserverd.
 *
 * Redistribution and use in source and binary forms are permitted
 * provided that the above copyright notice and this paragraph are
 * duplicated in all such forms and that any documentation,
 * advertising materials, and other materials related to such
 * distribution and use acknowledge that the software was developed
 * by the Internet Initiative Japan, Inc.  The name of the
 * IIJ may not be used to endorse or promote products derived
 * from this software without specific prior written permission.
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED
 * WARRANTIES OF MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 *
 * $FreeBSD: src/usr.sbin/ppp/ccp.c,v 1.54.2.2 2000/08/19 09:29:59 brian Exp $
 *
 *	TODO:
 *		o Support other compression protocols
 */

/*
 *  \Aׂ݂͂ċ
 */

#include <t_services.h>

#include <net/if.h>
#include <net/if_ppp.h>
#include <net/net_buf.h>
#include <net/net_debug.h>
#include <net/net_count.h>
#include <net/ppp.h>
#include <net/ppp_var.h>
#include <net/ppp_fsm.h>
#include <net/ppp_ccp.h>

/*
 *  ֐
 */

static void ccp_init (void);
static void ccp_input (T_NET_BUF *nbuf);
static void ccp_protrej (void);
static void ccp_lowerup (void);
static void ccp_lowerdown (void);
static void ccp_open (void);
static void ccp_close (void);

/*
 * FSM ďoR[obN
 */

static int_t  ccp_reqci	(T_PPP_FSM *fsm, T_NET_BUF *nbuf);
					/* ̍\mFB	*/

/*
 *  Sϐ
 */

T_PPP_FSM_CALLBACKS ccp_callbacks = {
	NULL,				/* \ZbgB	*/
	NULL,				/* \̒ԂB		*/
	NULL,				/* \ǉB		*/
	NULL,				/* ACK MƂ̏	*/
	NULL,				/* NAK MƂ̏	*/
	NULL,				/* REJ MƂ̏	*/
	ccp_reqci,			/* ̍\mFB	*/
	NULL,				/* NڑmB		*/
	NULL,				/* NڑB		*/
	NULL,				/* ʑwJnB		*/
	NULL,				/* ʑwIB		*/
	NULL,				/* đB			*/
	NULL,				/* s CP MƂ̏	*/
};

T_PPP_FSM ccp_fsm = {
	&ccp_callbacks,			/* R[obN֐		*/
	PPP_CCP,			/* vgR			*/
};

T_PPP_PROTENT ccp_protent = {
	PPP_CCP,
	ccp_init,			/* 			*/
	ccp_input,			/* 				*/
	ccp_protrej,			/* Proto-REJ M		*/
	ccp_lowerup,			/* ʑwN		*/
	ccp_lowerdown,			/* ʑw~		*/
	ccp_open,			/* I[v			*/
	ccp_close,			/* N[Y			*/
	NULL,				/* f[^			*/
};

/*
 *  ccp_init -- CCP W[̏
 */

static void
ccp_init (void)
{
	fsm_init(&ccp_fsm);
}

/*
 *  ccp_input -- CCP 
 */

static void
ccp_input (T_NET_BUF *nbuf)
{
	NET_COUNT_PPP_CCP(net_count_ppp_ccp_in_octets,  nbuf->len);
	NET_COUNT_PPP_CCP(net_count_ppp_ccp_in_packets, 1);
	fsm_input(&ccp_fsm, nbuf);
}

/*
 *  ccp_reqci -- ̍\͂B
 */

static int_t
ccp_reqci (T_PPP_FSM *fsm, T_NET_BUF *nbuf)
{
/*
 *  \Aׂ݂͂ẴIvVۂB
 */
	return nbuf->len > (sizeof(T_PPP_HDR) + sizeof(T_PPP_CP_HDR)) ? PPP_CONFREJ : PPP_CONFACK;
}

/*
 *  ccp_protrej -- Proto-REJ MƂ̏
 */

static void
ccp_protrej (void)
{
	fsm_lowerdown(&ccp_fsm);
}

/*
 *  ccp_lowerup -- CCP ʑwNB
 */

static void
ccp_lowerup (void)
{
	fsm_lowerup(&ccp_fsm);
}

/*
 *  ccp_lowerdown -- CCP ʑw~B
 */

static void
ccp_lowerdown (void)
{
	fsm_lowerdown(&ccp_fsm);
}

/*
 *  ccp_open -- CCP ̃I[v
 */

static void
ccp_open (void)
{
	fsm_open(&ccp_fsm);
}

/*
 *  ccp_close -- CCP ̃N[Y
 */

static void
ccp_close (void)
{
	fsm_close(&ccp_fsm);
}
