/*
 *  TINET (TCP/IP Protocol Stack)
 * 
 *  Copyright (C) 2001-2009 by Dep. of Computer Science and Engineering
 *                   Tomakomai National College of Technology, JAPAN
 *
 *  L쌠҂́Cȉ (1)`(4) ̏CFree Software Foundation 
 *  ɂČ\Ă GNU General Public License  Version 2 ɋL
 *  qĂ𖞂ꍇɌC{\tgEFAi{\tgEFA
 *  ς̂܂ށDȉjgpEEρEĔzziȉC
 *  pƌĂԁj邱Ƃ𖳏ŋD
 *  (1) {\tgEFA\[XR[ȟ`ŗpꍇɂ́CL̒
 *      \C̗pщL̖ۏ؋K肪Ĉ܂܂̌`Ń\[
 *      XR[hɊ܂܂Ă邱ƁD
 *  (2) {\tgEFACCu`ȂǁC̃\tgEFAJɎg
 *      pł`ōĔzzꍇɂ́CĔzzɔhLgip
 *      ҃}jAȂǁjɁCL̒쌠\C̗pщL
 *      ̖ۏ؋Kfڂ邱ƁD
 *  (3) {\tgEFAC@ɑgݍނȂǁC̃\tgEFAJɎg
 *      płȂ`ōĔzzꍇɂ́C̏𖞂ƁD
 *    (a) ĔzzɔhLgip҃}jAȂǁjɁCL̒
 *        쌠\C̗pщL̖ۏ؋Kfڂ邱ƁD
 *  (4) {\tgEFA̗pɂ蒼ړI܂͊ԐړIɐ邢Ȃ鑹
 *      QCL쌠҂TOPPERSvWFNgƐӂ邱ƁD
 *
 *  {\tgEFÁCۏ؂Œ񋟂Ă̂łDL쌠҂
 *  TOPPERSvWFNǵC{\tgEFAɊւāC̓Kp\
 *  ܂߂āCȂۏ؂sȂD܂C{\tgEFA̗pɂ蒼
 *  ړI܂͊ԐړIɐȂ鑹QɊւĂC̐ӔC𕉂ȂD
 * 
 *  @(#) $Id: tcp_subr_ncs.c,v 1.5 2009/12/24 05:47:21 abe Exp abe $
 */

/*
 * Copyright (c) 1982, 1986, 1988, 1990, 1993, 1995
 *	The Regents of the University of California.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *	This product includes software developed by the University of
 *	California, Berkeley and its contributors.
 * 4. Neither the name of the University nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 *	@(#)tcp_subr.c	8.2 (Berkeley) 5/24/95
 * $FreeBSD: src/sys/netinet/tcp_subr.c,v 1.49.2.4 1999/08/29 16:29:55 peter Exp $
 */

#include <string.h>

#ifdef TARGET_KERNEL_ASP

#include <kernel.h>
#include <sil.h>
#include <t_syslog.h>
#include "kernel_cfg.h"

#endif	/* of #ifdef TARGET_KERNEL_ASP */

#ifdef TARGET_KERNEL_JSP

#include <s_services.h>
#include <t_services.h>
#include "kernel_id.h"

#endif	/* of #ifdef TARGET_KERNEL_JSP */

#include <tinet_defs.h>
#include <tinet_config.h>

#include <net/if.h>
#include <net/if_ppp.h>
#include <net/if_loop.h>
#include <net/ethernet.h>
#include <net/if_arp.h>
#include <net/ppp_ipcp.h>
#include <net/net.h>
#include <net/net_var.h>
#include <net/net_buf.h>
#include <net/net_timer.h>
#include <net/net_count.h>

#include <netinet/in.h>
#include <netinet6/in6.h>
#include <netinet6/in6_var.h>
#include <netinet/in_var.h>
#include <netinet/ip.h>
#include <netinet/ip_var.h>
#include <netinet/ip6.h>
#include <netinet6/ip6_var.h>
#include <netinet6/nd6.h>
#include <netinet/tcp.h>
#include <netinet/tcp_timer.h>
#include <netinet/tcp_var.h>
#include <netinet/tcp_fsm.h>
#include <netinet/tcp_seq.h>
#include <netinet/in_itron.h>

#ifdef SUPPORT_TCP

#ifndef TCP_CFG_SWBUF_CSAVE_ONLY

/*
 *  TCP ʐM[_̑MEBhobt@̏ȃRs[@\
 */

/*
 *  tcp_read_swbuf -- MEBhobt@f[^ǂݏoB
 */

void
tcp_read_swbuf_ncs (T_TCP_CEP *cep, T_NET_BUF *output, uint_t len, uint_t doff)
{
	uint8_t	*wptr, *rptr;

	/* SDU ̑傫`FbNB*/
	if (GET_IP_SDU_SIZE(GET_IP_HDR(output)) < GET_TCP_HDR_SIZE2(output, IF_IP_TCP_HDR_OFFSET) + len) {
		syslog(LOG_INFO, "[TCP] shrink SUD len: %d -> %d",
		       (uint16_t)len, (uint16_t)(GET_IP_SDU_SIZE(GET_IP_HDR(output)) - GET_TCP_HDR_SIZE2(output, IF_IP_TCP_HDR_OFFSET)));
		len = GET_IP_SDU_SIZE(GET_IP_HDR(output)) - GET_TCP_HDR_SIZE2(output, IF_IP_TCP_HDR_OFFSET);
	}

	wptr = GET_TCP_SDU(output, IF_IP_TCP_HDR_OFFSET);

	/* ʐM[_bNB*/
	syscall(wai_sem(cep->semid_lock));

	rptr = cep->sbuf_rptr + doff;
	if (rptr - (uint8_t*)cep->sbuf > cep->sbufsz) {

		/* ]JnMEBhobt@̏I𒴂Ƃ̏@*/
		rptr = (uint8_t*)cep->sbuf_rptr - (cep->sbufsz - doff);
	}
	else if (len + (rptr - (uint8_t*)cep->sbuf) > cep->sbufsz) {
		uint_t sub;

		/* ]͈͂EhƂ̏ */
		sub = (uint_t)(cep->sbufsz - (rptr - (uint8_t*)cep->sbuf));
		memcpy((void*)wptr, rptr, (size_t)sub);
		len  -= sub;
		wptr += sub;
		rptr  = (uint8_t*)cep->sbuf;
	}
	memcpy((void*)wptr, rptr, (size_t)len);

	NET_COUNT_TCP(net_count_tcp[NC_TCP_SEND_DATA_SEGS],   1);
	NET_COUNT_TCP(net_count_tcp[NC_TCP_SEND_DATA_OCTETS], len);

	/* ʐM[_̃bNB*/
	syscall(sig_sem(cep->semid_lock));
}

/*
 *  tcp_drop_swbuf -- MEBhobt@w肳ꂽINebg폜B
 */

void
tcp_drop_swbuf_ncs (T_TCP_CEP *cep, uint_t len)
{
	uint_t	last;

	/* ʐM[_bNB*/
	syscall(wai_sem(cep->semid_lock));

	last = cep->swbuf_count;

	if (cep->sbuf_rptr + len > (uint8_t*)cep->sbuf + cep->sbufsz)
		/* EhƂ̌vZ */
		cep->sbuf_rptr -= cep->sbufsz - len;
	else
		cep->sbuf_rptr += len;
	cep->swbuf_count -= (uint16_t)len;

	/* ʐM[_̃bNB*/
	syscall(sig_sem(cep->semid_lock));

#ifdef TCP_CFG_NON_BLOCKING

	if (cep->snd_nblk_tfn == TFN_TCP_GET_BUF) {	/* mubLOR[ */

		/* ʐM[_bNB*/
		syscall(wai_sem(cep->semid_lock));

		/* Mf[^vZB*/
		if (cep->sbufsz - cep->swbuf_count > cep->sbufsz - (cep->sbuf_wptr - (uint8_t*)cep->sbuf))
			/* ݃|C^EhƂ́A݃|C^瑗MEBhobt@̏I܂ */
			len = (uint_t)(cep->sbufsz - (cep->sbuf_wptr - (uint8_t*)cep->sbuf));
		else
			len = cep->sbufsz - cep->swbuf_count;

		/* ʐM[_̃bNB*/
		syscall(sig_sem(cep->semid_lock));

		if (len > 0) {

			/* tcp_get_buf ̊Ēݒ肷B*/
			cep->get_buf_len = len;

			/* MEBhobt@̃AhXԂB*/
			*cep->snd_p_buf = cep->sbuf_wptr;

			if (IS_PTR_DEFINED(cep->callback))
#ifdef TCP_CFG_NON_BLOCKING_COMPAT14

				(*cep->callback)(GET_TCP_CEPID(cep), cep->snd_nblk_tfn, (void*)(uint32_t)len);

#else	/* of #ifdef TCP_CFG_NON_BLOCKING_COMPAT14 */

				(*cep->callback)(GET_TCP_CEPID(cep), cep->snd_nblk_tfn, (void*)&len);

#endif	/* of #ifdef TCP_CFG_NON_BLOCKING_COMPAT14 */

			else
				syslog(LOG_WARNING, "[TCP] no call back, CEP: %d.", GET_TCP_CEPID(cep));

			/* LĂ^XN ID  API @\R[hNA[B*/
			cep->snd_tskid = TA_NULL;
			cep->snd_tfn   = cep->snd_nblk_tfn = TFN_TCP_UNDEF;
		}
	}

#ifdef TCP_CFG_EXTENTIONS

	else if (cep->snd_nblk_tfn == TFN_TCP_SND_DAT ||
	         cep->snd_nblk_tfn == TFN_TCP_SND_OOB) {	/* mubLOR[ */

#else	/* of #ifdef TCP_CFG_EXTENTIONS */

	else if (cep->snd_nblk_tfn == TFN_TCP_SND_DAT) {	/* mubLOR[ */

#endif	/* of #ifdef TCP_CFG_EXTENTIONS */

		ER_UINT	error;

	 	/* MEBhobt@Ƀf[^ށB*/
		error = TCP_WRITE_SWBUF(cep, cep->snd_data, (uint_t)cep->snd_len);

#ifdef TCP_CFG_EXTENTIONS

		/* Mً}|C^ݒ肷B*/
	        if (cep->snd_nblk_tfn == TFN_TCP_SND_OOB)
			cep->snd_up = cep->snd_una + error;

#endif	/* of #ifdef TCP_CFG_EXTENTIONS */

		if (IS_PTR_DEFINED(cep->callback))

#ifdef TCP_CFG_NON_BLOCKING_COMPAT14

			(*cep->callback)(GET_TCP_CEPID(cep), cep->snd_nblk_tfn, (void*)error);

#else	/* of #ifdef TCP_CFG_NON_BLOCKING_COMPAT14 */

			(*cep->callback)(GET_TCP_CEPID(cep), cep->snd_nblk_tfn, (void*)&error);

#endif	/* of #ifdef TCP_CFG_NON_BLOCKING_COMPAT14 */

		else
			syslog(LOG_WARNING, "[TCP] no call back, CEP: %d.", GET_TCP_CEPID(cep));

		/* LĂ^XN ID  API @\R[hNA[B*/
		cep->snd_tskid = TA_NULL;
		cep->snd_tfn   = cep->snd_nblk_tfn = TFN_TCP_UNDEF;
	}
	else {

#endif	/* of #ifdef TCP_CFG_NON_BLOCKING */

		/* MEBhobt@ɋ󂫂oo̓^XNNB*/
		if (last == cep->sbufsz && cep->swbuf_count < cep->sbufsz)
			syscall(set_flg(cep->snd_flgid, TCP_CEP_EVT_SWBUF_READY));

#ifdef TCP_CFG_NON_BLOCKING

	}

#endif	/* of #ifdef TCP_CFG_NON_BLOCKING */

	if (cep->swbuf_count > 0) {
		/* MEBhobt@Ƀf[^Ώo͂|XgB*/
		cep->flags |= TCP_CEP_FLG_POST_OUTPUT;
		sig_sem(SEM_TCP_POST_OUTPUT);
	}
}

/*
 *  tcp_write_swbuf -- MEBhobt@Ƀf[^ށB
 */

ER_UINT
tcp_write_swbuf_ncs (T_TCP_CEP *cep, void *data, uint_t len)
{
	uint_t	offset;

	/* ʐM[_bNB*/
	syscall(wai_sem(cep->semid_lock));

	/* len ƑMEBhobt@̋󂫂̏ڂf[^ɂB*/
	if (len > (cep->sbufsz - cep->swbuf_count))
		len = cep->sbufsz - cep->swbuf_count;

	/* ݃|C^EhƂ̏ */
	if (len > cep->sbufsz - (cep->sbuf_wptr - (uint8_t*)cep->sbuf)) {
		offset = (uint_t)(cep->sbufsz - (cep->sbuf_wptr -(uint8_t*)cep->sbuf));
		memcpy(cep->sbuf_wptr, data, (size_t)offset);
		cep->sbuf_wptr  = (uint8_t*)cep->sbuf;
		cep->swbuf_count += offset;
	}
	else
		offset = 0;

	memcpy(cep->sbuf_wptr, (void*)((uint8_t*)data + offset), (size_t)(len - offset));
	cep->sbuf_wptr  += len - offset;
	cep->swbuf_count += len - offset;

	/* ʐM[_̃bNB*/
	syscall(sig_sem(cep->semid_lock));

	return (ER_UINT)len;
}

/*
 *  tcp_wait_swbuf -- MEBhobt@󂭂̂҂B
 */

ER
tcp_wait_swbuf_ncs (T_TCP_CEP *cep, TMO tmout)
{
	ER	error;
	FLGPTN	flag;

	while (cep->swbuf_count >= cep->sbufsz) {
		/*
		 *  MEBhobt@̋󂫂Ȃ΁Ao͂|XgāA
		 *  MEBhobt@󂭂܂ő҂B
		 */
		cep->flags |= TCP_CEP_FLG_POST_OUTPUT;
		sig_sem(SEM_TCP_POST_OUTPUT);

		if ((error = twai_flg(cep->snd_flgid, TCP_CEP_EVT_SWBUF_READY, TWF_ORW, &flag, tmout)) != E_OK) {
			return error;
		}
		syscall(clr_flg(cep->snd_flgid, (FLGPTN)(~TCP_CEP_EVT_SWBUF_READY)));

		/*
		 *  Mł邩ACEP  FSM ԂB
		 *  MEBhobt@󂭂܂ő҂ԂɁAMs\ɂȂꍇ́A
		 *  RlNVؒfꂽƂӖĂB
		 */
		if (!TCP_FSM_CAN_SEND_MORE(cep->fsm_state)) {
			return E_CLS;
		}
	}

	return E_OK;
}
/*
 *  tcp_get_swbuf_addr -- MEBhobt@̋󂫃AhXlB
 */

ER_UINT
tcp_get_swbuf_addr_ncs (T_TCP_CEP *cep, void **p_buf)
{
	uint_t	len;

	/* ʐM[_bNB*/
	syscall(wai_sem(cep->semid_lock));

	/* MEBhobt@̋󂫃AhX̐擪ݒ肷B*/
	*p_buf = cep->sbuf_wptr;

	/* MEBhobt@̋󂫃TCYvZB*/
	if (cep->sbufsz - cep->swbuf_count > cep->sbufsz - (cep->sbuf_wptr - (uint8_t*)cep->sbuf))
		/* ݃|C^EhƂ́A݃|C^瑗MEBhobt@̏I܂ */
		len = (uint_t)(cep->sbufsz - (cep->sbuf_wptr - (uint8_t*)cep->sbuf));
	else
		len = cep->sbufsz - cep->swbuf_count;

	/* ʐM[_̃bNB*/
	syscall(sig_sem(cep->semid_lock));

	/* MEBhobt@̋󂫃f[^ݒ肵A̒lԂB*/
	cep->get_buf_len = len;
	return (ER_UINT)len;
}

/*
 *  tcp_send_swbuf -- MEBhobt@̃f[^𑗐M\ɂB
 */

void
tcp_send_swbuf_ncs (T_TCP_CEP *cep, uint_t len)
{
	/* ʐM[_bNB*/
	syscall(wai_sem(cep->semid_lock));

	cep->sbuf_wptr  += len;
	cep->swbuf_count += len;

	/* ݃|C^EhƂ̏ */
	if (cep->sbuf_wptr >= (uint8_t*)cep->sbuf + cep->sbufsz)
		cep->sbuf_wptr  = (uint8_t*)cep->sbuf;

	/* tcp_get_buf ̊ĒZbgB*/
	cep->get_buf_len = 0;

	/* ʐM[_̃bNB*/
	syscall(sig_sem(cep->semid_lock));

	/* MEBhobt@t̂Ƃ͋IɑMB*/
	if (cep->swbuf_count >= cep->sbufsz)
		cep->flags |= TCP_CEP_FLG_FORCE | TCP_CEP_FLG_FORCE_CLEAR;
}

/*
 *  tcp_is_swbuf_full -- MEBhobt@t`FbNB
 */

bool_t
tcp_is_swbuf_full_ncs (T_TCP_CEP *cep)
{
	return cep->swbuf_count >= cep->sbufsz;
}

#endif	/* of #ifndef TCP_CFG_SWBUF_CSAVE_ONLY */

#ifndef TCP_CFG_RWBUF_CSAVE_ONLY

/*
 *  TCP ʐM[_̎MEBhobt@̏ȃRs[@\
 */

/*
 *  tcp_drop_rwbuf -- MEBhobt@w肳ꂽINebg폜B
 */

void
tcp_drop_rwbuf_ncs (T_TCP_CEP *cep, uint_t len)
{
	cep->rwbuf_count -= len;
	cep->rbuf_rptr  += len;

	/* ǂݏo|C^EhƂ̏ */
	if (cep->rbuf_rptr >= (uint8_t*)cep->rbuf + cep->rbufsz)
		cep->rbuf_rptr  = (uint8_t*)cep->rbuf;
}

/*
 *  tcp_read_rwbuf -- MEBhobt@w肳ꂽINebgǂݏoB
 */

uint_t
tcp_read_rwbuf_ncs (T_TCP_CEP *cep, void *data, uint_t len)
{
	uint_t	offset;

	/* ʐM[_bNB*/
	syscall(wai_sem(cep->semid_lock));

	/* len ƎMEBhobt@̃f[^̏of[^ɂB*/
	if (len > cep->rwbuf_count)
		len = cep->rwbuf_count;

	/* ǂݏo|C^EhƂ̏ */
	if (len > cep->rbufsz - (cep->rbuf_rptr - (uint8_t*)cep->rbuf)) {
		offset = (uint_t)(cep->rbufsz - (cep->rbuf_rptr -(uint8_t*)cep->rbuf));
		memcpy(data, cep->rbuf_rptr, (size_t)offset);
		cep->rwbuf_count -= offset;
		cep->rbuf_rptr   = (uint8_t*)cep->rbuf;
	}
	else
		offset = 0;

	memcpy((void*)((uint8_t*)data + offset), cep->rbuf_rptr, (size_t)(len - offset));
	cep->rwbuf_count -= len - offset;
	cep->rbuf_rptr  += len - offset;

	/* ʐM[_̃bNB*/
	syscall(sig_sem(cep->semid_lock));

	return len;
}

/*
 *  tcp_get_rwbuf_addr -- MEBhobt@̋󂫃AhXlB
 */

uint_t
tcp_get_rwbuf_addr_ncs (T_TCP_CEP *cep, void **p_buf)
{
	uint_t	len;

	/* ʐM[_bNB*/
	syscall(wai_sem(cep->semid_lock));

	/* MEBhobt@̃f[^vZB*/
	if (cep->rwbuf_count > cep->rbufsz - (cep->rbuf_rptr - (uint8_t*)cep->rbuf))
		/* |C^EhƂ͎MEBhobt@̏I܂ */
		len = (uint_t)(cep->rbufsz - (cep->rbuf_rptr - (uint8_t*)cep->rbuf));
	else
		len = cep->rwbuf_count;

	/* MEBhobt@̃f[^̃AhX̐擪ݒ肷B*/
	*p_buf = cep->rbuf_rptr;

	/* ʐM[_̃bNB*/
	syscall(sig_sem(cep->semid_lock));

	/* MEBhobt@̃f[^ݒ肵A̒lԂB*/
	cep->rcv_buf_len = len;
	return len;
}

/*
 *  tcp_write_rwbuf -- MEBhobt@Ƀf[^ށB
 *
 *    :
 *	 input ́AT_TCP_Q_HDR ɂ胊NA
 *	בւIĂȂ΂ȂȂB܂A
 *	ǉf[^́AMEBhobt@Ɏ܂邱ƁB
 */

void
tcp_write_rwbuf_ncs (T_TCP_CEP *cep, T_NET_BUF *input, uint_t thoff)
{
	T_TCP_Q_HDR	*qhdr;
	uint_t		offset, inlen, last;

	/* ʐM[_bNB*/
	syscall(wai_sem(cep->semid_lock));

	qhdr  = (T_TCP_Q_HDR*)GET_TCP_HDR(input, thoff);

	/* Mς݃V[PXԍXVB*/
	cep->rcv_nxt += qhdr->slen;

	last  = cep->rwbuf_count;
	inlen = qhdr->slen;

	/* ً}f[^ SDU ␳sB*/
	if (qhdr->urp > 0 && inlen > 0) {
		inlen      -= qhdr->urp;
		qhdr->slen -= qhdr->urp;
		qhdr->urp   = 0;
	}

	/*
	 *  FIN tOtZOg inlen == 0 ɂȂ邱ƂB
	 *  ́AAvP[VɁA肩炱ȏf[^
	 *  ȂƂm点邽߂łB
	 */
	if (inlen > 0) {

		/* ݃|C^EhƂ̏ */
		if (inlen > cep->rbufsz - (cep->rbuf_wptr - (uint8_t*)cep->rbuf)) {
			offset = (uint_t)(cep->rbufsz - (cep->rbuf_wptr - (uint8_t*)cep->rbuf));
			memcpy(cep->rbuf_wptr, (void*)(GET_TCP_SDU(input, thoff) + qhdr->soff), (size_t)offset);
			cep->rbuf_wptr   = (uint8_t*)cep->rbuf;
			cep->rwbuf_count += offset;
			inlen           -= offset;
		}
		else
			offset	= 0;

		memcpy(cep->rbuf_wptr, (void*)(GET_TCP_SDU(input, thoff) + qhdr->soff + offset), (size_t)inlen);
		cep->rbuf_wptr  += inlen;
		cep->rwbuf_count += inlen;

		NET_COUNT_TCP(net_count_tcp[NC_TCP_RECV_DATA_SEGS],   1);
		NET_COUNT_TCP(net_count_tcp[NC_TCP_RECV_DATA_OCTETS], inlen);
	}

	syscall(rel_net_buf(input));

#ifdef TCP_CFG_NON_BLOCKING

	if (cep->rcv_nblk_tfn == TFN_TCP_RCV_BUF) {	/* mubLOR[ */

		int_t	len;

		/* MEBhobt@̋󂫃f[^vZB*/
		if (cep->rwbuf_count > cep->rbufsz - (cep->rbuf_rptr - (uint8_t*)cep->rbuf)) {
			/* |C^EhƂ͎MEBhobt@̏I܂ */
			len = (uint_t)(cep->rbufsz - (cep->rbuf_rptr - (uint8_t*)cep->rbuf));
		}
		else
			len = cep->rwbuf_count;

		/* ʐM[_̃bNB*/
		syscall(sig_sem(cep->semid_lock));

		/*
		 *  FIN tOtZOg inlen == 0 ɂȂ邱ƂB
		 *  ́AAvP[VɁA肩炱ȏf[^
		 *  ȂƂm点邽߂łB
		 */
		if (len > 0 || inlen == 0) {

			/* tcp_rcv_buf ̊Ēݒ肷B*/
			cep->rcv_buf_len = len;

			/* MEBhobt@̃AhXԂB*/
			*cep->rcv_p_buf = cep->rbuf_rptr;


			if (IS_PTR_DEFINED(cep->callback))

#ifdef TCP_CFG_NON_BLOCKING_COMPAT14

				(*cep->callback)(GET_TCP_CEPID(cep), cep->rcv_nblk_tfn, (void*)(uint32_t)len);

#else	/* of #ifdef TCP_CFG_NON_BLOCKING_COMPAT14 */

				(*cep->callback)(GET_TCP_CEPID(cep), cep->rcv_nblk_tfn, (void*)&len);

#endif	/* of #ifdef TCP_CFG_NON_BLOCKING_COMPAT14 */

			else
				syslog(LOG_WARNING, "[TCP] no call back, CEP: %d.", GET_TCP_CEPID(cep));

			if (len == 0) {

				/*
				 *  ʐM[_bNāA
				 *  MEBhobt@L[̃lbg[Nobt@B
				 */
				syscall(wai_sem(cep->semid_lock));
				TCP_FREE_RWBUFQ(cep);
				syscall(sig_sem(cep->semid_lock));
			}
		}

		/* LĂ^XN ID  API @\R[hNA[B*/
		cep->rcv_tskid = TA_NULL;
		cep->rcv_tfn   = cep->rcv_nblk_tfn = TFN_TCP_UNDEF;
	}

	else if (cep->rcv_nblk_tfn == TFN_TCP_RCV_DAT) {	/* mubLOR[ */
		ER_UINT	len;

		/* ʐM[_̃bNB*/
		syscall(sig_sem(cep->semid_lock));

		/* MEBhobt@f[^oB*/
		if ((len = TCP_READ_RWBUF(cep, cep->rcv_data, (uint_t)cep->rcv_len)) > 0) {
			/* ɃEBhETCYςƂm点邽ߏo͂|XgB*/
			cep->flags |= TCP_CEP_FLG_POST_OUTPUT;
			sig_sem(SEM_TCP_POST_OUTPUT);
		}

		/*
		 *  FIN tOtZOg inlen == 0 ɂȂ邱ƂB
		 *  ́AAvP[VɁA肩炱ȏf[^
		 *  ȂƂm点邽߂łB
		 */
		if (len > 0 || inlen == 0) {

			if (IS_PTR_DEFINED(cep->callback))

#ifdef TCP_CFG_NON_BLOCKING_COMPAT14

				(*cep->callback)(GET_TCP_CEPID(cep), cep->rcv_nblk_tfn, (void*)(uint32_t)len);

#else	/* of #ifdef TCP_CFG_NON_BLOCKING_COMPAT14 */

				(*cep->callback)(GET_TCP_CEPID(cep), cep->rcv_nblk_tfn, (void*)&len);

#endif	/* of #ifdef TCP_CFG_NON_BLOCKING_COMPAT14 */

			else
				syslog(LOG_WARNING, "[TCP] no call back, CEP: %d.", GET_TCP_CEPID(cep));
		}

		/* LĂ^XN ID  API @\R[hNA[B*/
		cep->rcv_tskid = TA_NULL;
		cep->rcv_tfn   = cep->rcv_nblk_tfn = TFN_TCP_UNDEF;

	}
	else {

#endif	/* of #ifdef TCP_CFG_NON_BLOCKING */

		/* ʐM[_̃bNB*/
		syscall(sig_sem(cep->semid_lock));

		if (inlen == 0 && cep->rwbuf_count == 0) {
			/*
			 *  MEBhobt@̃f[^ 0 ŁA
			 *  肩 FIN tOtZOgMƂ́A
			 *  ʐM[_bNāA
			 *  MEBhobt@L[̃lbg[Nobt@B
			 */
			syscall(wai_sem(cep->semid_lock));
			TCP_FREE_RWBUFQ(cep);
			syscall(sig_sem(cep->semid_lock));
		}

		/*
		 *  MEBhobt@Ƀf[^邩A inlen == 0 ̎A̓^XNNB
		 *  FIN tOtZOg inlen == 0 ɂȂ邱ƂB
		 *  ́AAvP[VɁA肩炱ȏf[^
		 *  ȂƂm点邽߂łB
		 */
		if ((last == 0 && cep->rwbuf_count > 0) || inlen == 0)
			syscall(set_flg(cep->rcv_flgid, TCP_CEP_EVT_RWBUF_READY));

#ifdef TCP_CFG_NON_BLOCKING

	}

#endif	/* of #ifdef TCP_CFG_NON_BLOCKING */

}

#endif	/* of #ifndef TCP_CFG_RWBUF_CSAVE_ONLY */

#endif	/* of #ifdef SUPPORT_TCP */
