/*
 *  TINET (TCP/IP Protocol Stack)
 * 
 *  Copyright (C) 2001-2009 by Dep. of Computer Science and Engineering
 *                   Tomakomai National College of Technology, JAPAN
 *
 *  L쌠҂́Cȉ (1)`(4) ̏CFree Software Foundation 
 *  ɂČ\Ă GNU General Public License  Version 2 ɋL
 *  qĂ𖞂ꍇɌC{\tgEFAi{\tgEFA
 *  ς̂܂ށDȉjgpEEρEĔzziȉC
 *  pƌĂԁj邱Ƃ𖳏ŋD
 *  (1) {\tgEFA\[XR[ȟ`ŗpꍇɂ́CL̒
 *      \C̗pщL̖ۏ؋K肪Ĉ܂܂̌`Ń\[
 *      XR[hɊ܂܂Ă邱ƁD
 *  (2) {\tgEFACCu`ȂǁC̃\tgEFAJɎg
 *      pł`ōĔzzꍇɂ́CĔzzɔhLgip
 *      ҃}jAȂǁjɁCL̒쌠\C̗pщL
 *      ̖ۏ؋Kfڂ邱ƁD
 *  (3) {\tgEFAC@ɑgݍނȂǁC̃\tgEFAJɎg
 *      płȂ`ōĔzzꍇɂ́C̏𖞂ƁD
 *    (a) ĔzzɔhLgip҃}jAȂǁjɁCL̒
 *        쌠\C̗pщL̖ۏ؋Kfڂ邱ƁD
 *  (4) {\tgEFA̗pɂ蒼ړI܂͊ԐړIɐ邢Ȃ鑹
 *      QCL쌠҂TOPPERSvWFNgƐӂ邱ƁD
 *
 *  {\tgEFÁCۏ؂Œ񋟂Ă̂łDL쌠҂
 *  TOPPERSvWFNǵC{\tgEFAɊւāC̓Kp\
 *  ܂߂āCȂۏ؂sȂD܂C{\tgEFA̗pɂ蒼
 *  ړI܂͊ԐړIɐȂ鑹QɊւĂC̐ӔC𕉂ȂD
 * 
 *  @(#) $Id: if_v850ec.c,v 1.5 2009/12/24 05:46:31 abe Exp abe $
 */

/*
 * Copyright (c) 1995, David Greenman
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice unmodified, this list of conditions, and the following
 *    disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 * $FreeBSD: src/sys/i386/isa/if_ed.c,v 1.148.2.4 1999/09/25 13:08:18 nyan Exp $
 */

/*
 * Device driver for National Semiconductor DS8390/WD83C690 based ethernet
 *   adapters. By David Greenman, 29-April-1993
 *
 * Currently supports the Western Digital/SMC 8003 and 8013 series,
 *   the SMC Elite Ultra (8216), the 3Com 3c503, the NE1000 and NE2000,
 *   and a variety of similar clones.
 *
 */

#ifdef TARGET_KERNEL_ASP

#define CAST(type, val)		((type)(val))

#include <kernel.h>
#include <sil.h>
#include <t_syslog.h>
#include "kernel_cfg.h"
#include "target_config.h"

#endif	/* of #ifdef TARGET_KERNEL_ASP */

#ifdef TARGET_KERNEL_JSP

#include <s_services.h>
#include <t_services.h>
#include "kernel_id.h"

#endif	/* of #ifdef TARGET_KERNEL_JSP */

#include <tinet_defs.h>
#include <tinet_config.h>

#include <net/if.h>
#include <net/ethernet.h>
#include <net/if_arp.h>
#include <net/net.h>
#include <net/net_timer.h>
#include <net/net_count.h>
#include <net/net_buf.h>

#include "if_v850ecreg.h"

/*
 *   RAM ̃y[Ww
 */

#define V850EC_INT_TXBUF_START	(V850EC_INT_RAM_BASE / V850EC_PAGE_SIZE)
#define V850EC_INT_TXBUF_STOP	(V850EC_INT_RAM_BASE / V850EC_PAGE_SIZE + IF_V850EC_TXBUF_PAGE_SIZE)
#define V850EC_INT_RXBUF_START	 V850EC_INT_TXBUF_STOP
#define V850EC_INT_RXBUF_STOP	((V850EC_INT_RAM_BASE + V850EC_INT_RAM_SIZE) / V850EC_PAGE_SIZE)

/*
 *  lbg[NC^tF[XɈˑ\tgEFA 
 */

typedef struct t_v850ec_softc {
	uint32_t	nic_addr;			/* NIC ̃x[XAhX		*/
	uint32_t	asic_addr;			/* ASIC ̃x[XAh		*/
	uint16_t	txb_len[NUM_IF_V850EC_TXBUF];	/* Mobt@̃INebg	*/
	uint8_t		txb_inuse;			/* gp̑Mobt@		*/
	uint8_t		txb_insend;			/* M̑Mobt@		*/
	uint8_t		txb_write;			/* ޑMobt@		*/
	uint8_t		txb_send;			/* M鑗Mobt@		*/
	uint8_t		rxb_read;			/* ǂݍގMy[W		*/
} T_V850EC_SOFTC;

/*
 *  lbg[NC^tF[X̃\tgEFA
 */

/* lbg[NC^tF[XɈˑ\tgEFA */

static T_V850EC_SOFTC v850ec_softc = {
	V850EC_BASE_ADDRESS + V850EC_NIC_OFFSET,	/* NIC ̃x[XAhX		*/
	V850EC_BASE_ADDRESS + V850EC_ASIC_OFFSET,	/* ASIC ̃x[XAhX		*/
};

/* lbg[NC^tF[XɈˑȂ\tgEFA */


T_IF_SOFTC if_softc = {
	{0,},					/* lbg[NC^tF[X̃AhX	*/
	0,					/* M^CAEg			*/
	&v850ec_softc,				/* fBoCXˑ̃\tgEFA	*/
	SEM_IF_V850EC_SBUF_READY,			/* MZ}tH			*/
	SEM_IF_V850EC_RBUF_READY,			/* MZ}tH			*/

#ifdef SUPPORT_INET6

	IF_MADDR_INIT,				/* }`LXgAhXXg	*/

#endif	/* of #ifdef SUPPORT_INET6 */
};

/*
 *  Ǐϐ
 */

static void v850ec_pio_readmem (T_V850EC_SOFTC *sc, uint32_t src, uint8_t *dst, uint16_t amount);
static T_NET_BUF *v850ec_get_frame (T_V850EC_SOFTC *sc, uint32_t ring, uint16_t len);
static void v850ec_xmit (T_IF_SOFTC *ic);
static void v850ec_stop (T_V850EC_SOFTC *sc);
static void v850ec_init_sub (T_IF_SOFTC *ic);
static void v850ec_setrcr (T_IF_SOFTC *ic);

#ifdef SUPPORT_INET6

static uint32_t ds_crc (uint8_t *addr);
static void ds_getmcaf (T_IF_SOFTC *ic, uint32_t *mcaf);

/*
 *  ds_crc -- C[TlbgAhX CRC vZB
 */

#define POLYNOMIAL	0x04c11db6

static uint32_t
ds_crc (uint8_t *addr)
{
	uint32_t	crc = ULONG_C(0xffffffff);
	int_t		carry, len, bit;
	uint8_t		byte;

	for (len = ETHER_ADDR_LEN; len -- > 0; ) {
		byte = *addr ++;
		for (bit = 8; bit -- > 0; ) {
			carry   = ((crc & ULONG_C(0x80000000)) ? 1 : 0) ^ (byte & UINT_C(0x01));
			crc   <<= 1;
			byte   >>= 1;
			if (carry)
				crc = (crc ^ POLYNOMIAL) | carry;
		}
	}
	return crc;
}

#undef POLYNOMIAL

/*
 *  ds_getmcaf -- }`LXgAhX̃Xg}`LXgAhX
 *                tB^vZB
 */

static void
ds_getmcaf (T_IF_SOFTC *ic, uint32_t *mcaf)
{
	uint32_t	count, index;
	uint8_t		*af = (uint8_t*)mcaf;

	mcaf[0] = mcaf[1] = 0;

	for (count = MAX_IF_MADDR_CNT; count -- > 0; ) {
		index = ds_crc(ic->maddrs[count].lladdr) >> 26;
		af[index >> 3] |= 1 << (index & 7);
	}
}

/*
 * v850ec_setrcr -- M\WX^ (RCR) ݒ肷B
 */

static void
v850ec_setrcr (T_IF_SOFTC *ic)
{
	T_V850EC_SOFTC	*sc = ic->sc;
	int_t		ix;
	uint32_t	mcaf[2];

	/* WX^y[W 1 IB*/
	sil_wrb_mem((uint8_t *)(sc->nic_addr + V850EC_P0_CR),
	                 V850EC_CR_RD2 | V850EC_CR_PAGE1 | V850EC_CR_STP);

	/* }`LXgtB^vZB*/
	ds_getmcaf(ic, mcaf);

	/* }`LXg̎Mݒ */
	for (ix = 0; ix < 8; ix ++)
		sil_wrb_mem((uint8_t *)(sc->nic_addr + V850EC_P1_MAR(ix)), ((uint8_t *)mcaf)[ix]);

	/* WX^y[W 0 IB*/
	sil_wrb_mem((uint8_t *)(sc->nic_addr + V850EC_P0_CR),
	            V850EC_CR_RD2 | V850EC_CR_PAGE0 | V850EC_CR_STP);

	/* }`LXgƃjLXgAhX̂ݎM悤ɐݒ肷B*/
	sil_wrb_mem((uint8_t *)(sc->nic_addr + V850EC_P0_RCR), V850EC_RCR_AM);

	/* NIC NB*/
	sil_wrb_mem((uint8_t *)(sc->nic_addr + V850EC_P0_CR),
	            V850EC_CR_RD2 | V850EC_CR_PAGE0 | V850EC_CR_STA);
}

/*
 * v850ec_addmulti -- }`LXgAhXǉB
 */

ER
v850ec_addmulti (T_IF_SOFTC *ic)
{
	v850ec_setrcr(ic);
	return E_OK;
}

#endif	/* of #ifdef SUPPORT_INET6 */

/*
 * v850ec_pio_readmem -- vO I/O g NIC ̃f[^ǂݍ
 */

static void
v850ec_pio_readmem (T_V850EC_SOFTC *sc, uint32_t src, uint8_t *dst, uint16_t amount)
{
	/* WX^y[W 0 IADMA ~B*/
	sil_wrb_mem((uint8_t *)(sc->nic_addr + V850EC_P0_CR),
	            V850EC_CR_RD2 | V850EC_CR_PAGE0 | V850EC_CR_STA);

	/* DMA ]ݒ肷B*/
	sil_wrb_mem((uint8_t *)(sc->nic_addr + V850EC_P0_RBCR0), amount);
	sil_wrb_mem((uint8_t *)(sc->nic_addr + V850EC_P0_RBCR1), amount >> 8);

	/* NIC ̓]AhXݒ肷B*/
	sil_wrb_mem((uint8_t *)(sc->nic_addr + V850EC_P0_RSAR0), src);
	sil_wrb_mem((uint8_t *)(sc->nic_addr + V850EC_P0_RSAR1), src >> 8);

	/* DMA ǂݍ݂IB*/
	sil_wrb_mem((uint8_t *)(sc->nic_addr + V850EC_P0_CR),
	            V850EC_CR_RD0 | V850EC_CR_PAGE0 | V850EC_CR_STA);

	/* NIC ǂݍ */
	while (amount -- > 0)
		*dst ++ = sil_reb_mem((uint8_t *)(sc->asic_addr + V850EC_DATA_OFFSET));
}

/*
 * v850ec_pio_writemem -- vO I/O g NIC Ƀf[^
 */

static void
v850ec_pio_writemem (T_V850EC_SOFTC *sc, uint8_t *src, uint32_t dst, uint16_t amount)
{
	/* WX^y[W 0 IADMA ~B*/
	sil_wrb_mem((uint8_t *)(sc->nic_addr + V850EC_P0_CR),
	            V850EC_CR_RD2 | V850EC_CR_PAGE0 | V850EC_CR_STA);

	/* DMA ]ݒ肷B*/
	sil_wrb_mem((uint8_t *)(sc->nic_addr + V850EC_P0_RBCR0), amount);
	sil_wrb_mem((uint8_t *)(sc->nic_addr + V850EC_P0_RBCR1), amount >> 8);

	/* NIC ̓]AhXݒ肷B*/
	sil_wrb_mem((uint8_t *)(sc->nic_addr + V850EC_P0_RSAR0), dst);
	sil_wrb_mem((uint8_t *)(sc->nic_addr + V850EC_P0_RSAR1), dst >> 8);

	/* DMA ݂IB*/
	sil_wrb_mem((uint8_t *)(sc->nic_addr + V850EC_P0_CR),
	                 V850EC_CR_RD1 | V850EC_CR_PAGE0 | V850EC_CR_STA);

	/* NIC ɏ */
	while (amount -- > 0)
		sil_wrb_mem((uint8_t *)(sc->asic_addr + V850EC_DATA_OFFSET), *src ++);
}

/*
 * v850ec_get_frame -- Ethernet t[͂B
 */

static T_NET_BUF *
v850ec_get_frame (T_V850EC_SOFTC *sc, uint32_t ring, uint16_t len)
{
	T_NET_BUF	*input = NULL;
	uint16_t	sublen, align;
	uint8_t		*dst;
	ER		error;

	/*
	 *  +-----------+--------+---------+---------+
	 *  | Ehter HDR | IP HDR | TCP HDR | TCP SDU |
	 *  +-----------+--------+---------+---------+
	 *        14        20        20        n
	 *   <----------------- len ---------------->
	 *              ^
	 *              t_net_buf  4 INebgEɃACĂB
	 *
	 *  tcp_input  udp_input ł́A[wb_ SDU Ń`FbNT
	 *  vZ邪An  4 INebgEɂȂ悤 SDU ̌ 0 
	 *  pbfBOB̕l net_buf lȂ΂ȂȂB
	 */
	align = ((((len - sizeof(T_IF_HDR)) + 3) >> 2) << 2) + sizeof(T_IF_HDR);

	if ((error = tget_net_buf(&input, align, TMO_IF_V850EC_GET_NET_BUF)) == E_OK && input != NULL) {
		NET_COUNT_ETHER_NIC(net_count_ether_nic[NC_ETHER_NIC_IN_PACKETS], 1);
		NET_COUNT_ETHER_NIC(net_count_ether_nic[NC_ETHER_NIC_IN_OCTETS],  len);
		dst = input->buf + IF_ETHER_NIC_HDR_ALIGN;
		if (ring + len > V850EC_INT_RAM_BASE + V850EC_INT_RAM_SIZE) {
			sublen = (V850EC_INT_RAM_BASE + V850EC_INT_RAM_SIZE) - ring;
			v850ec_pio_readmem(sc, ring, dst, sublen);
			len -= sublen;
			dst += sublen;
			ring = V850EC_INT_RXBUF_START * V850EC_PAGE_SIZE;
		}
		v850ec_pio_readmem(sc, ring, dst, len);
	}
	else {
		NET_COUNT_ETHER_NIC(net_count_ether_nic[NC_ETHER_NIC_IN_ERR_PACKETS], 1);
		NET_COUNT_ETHER_NIC(net_count_ether_nic[NC_ETHER_NIC_NO_BUFS], 1);
	}
	return input;
}

/*
 *  v850ec_xmit -- t[𑗐MB
 *
 *    : NIC 荞݋֎~ԂŌĂяoƁB
 */

static void
v850ec_xmit (T_IF_SOFTC *ic)
{
	T_V850EC_SOFTC *sc = ic->sc;

	/* WX^y[W 0 IB*/
	sil_wrb_mem((uint8_t *)(sc->nic_addr + V850EC_P0_CR),
	            V850EC_CR_RD2 | V850EC_CR_PAGE0 | V850EC_CR_STA);

	/* My[Wݒ肷B*/
	sil_wrb_mem((uint8_t *)(sc->nic_addr + V850EC_P0_TPSR),
	            V850EC_INT_TXBUF_START + sc->txb_send * NUM_IF_V850EC_TXBUF_PAGE);

	/* MINebgݒ肷B*/
	sil_wrb_mem((uint8_t *)(sc->nic_addr + V850EC_P0_TBCR0), sc->txb_len[sc->txb_send]);
	sil_wrb_mem((uint8_t *)(sc->nic_addr + V850EC_P0_TBCR1), sc->txb_len[sc->txb_send] >> 8);

	/* MB*/
	sil_wrb_mem((uint8_t *)(sc->nic_addr + V850EC_P0_CR),
	            V850EC_CR_RD2 | V850EC_CR_PAGE0 | V850EC_CR_TXP | V850EC_CR_STA);

	/* Mobt@؂ւB*/
	sc->txb_send ++;
	if (sc->txb_send == NUM_IF_V850EC_TXBUF)
		sc->txb_send = 0;

	sc->txb_insend ++;

	/* M^CAEgݒ肷B*/
	ic->timer = TMO_IF_V850EC_XMIT;
}

/*
 *  v850ec_stop -- ed lbg[NC^tF[X~B
 *
 *    : NIC 荞݋֎~ԂŌĂяoƁB
 */

static void
v850ec_stop (T_V850EC_SOFTC *sc)
{
	int_t wait;

	/* DMA ~B*/
	sil_wrb_mem((uint8_t *)(sc->nic_addr + V850EC_P0_CR),
	            V850EC_CR_RD2 | V850EC_CR_PAGE0 | V850EC_CR_STP);

	/* NIC ~ԂɂȂ܂ő҂BA5[ms]ɂĂB*/
	for (wait = 5; ((sil_reb_mem((uint8_t *)(sc->nic_addr + V850EC_P0_ISR)) & V850EC_ISR_RST) == 0) && wait -- > 0; )
		syscall(dly_tsk(1));
}

/*
 *  v850ec_init_sub -- ed lbg[NC^tF[X̏
 *
 *    : NIC 荞݋֎~ԂŌĂяoƁB
 */

static void
v850ec_init_sub (T_IF_SOFTC *ic)
{
	T_V850EC_SOFTC	*sc = ic->sc;
	int_t		ix;

	/* My[W̐ݒ */
	sc->rxb_read = V850EC_INT_RXBUF_START + 1;

	/* Mobt@̐ݒ */
	NET_COUNT_ETHER_NIC(net_count_ether_nic[NC_ETHER_NIC_OUT_ERR_PACKETS], sc->txb_inuse);
	sc->txb_inuse  = 0;
	sc->txb_insend = 0;
	sc->txb_write  = 0;
	sc->txb_send   = 0;
	
	/* M^CAEgZbgB*/
	ic->timer = 0;

	/* C^tF[X~B*/
	sil_wrb_mem((uint8_t *)(sc->nic_addr + V850EC_P0_CR), V850EC_CR_PAGE0 | V850EC_CR_STP);

	/*
	 *  DCR ݒ肷B
	 *    EFIFO ̂l 8
	 *    E[vobN[h
	 */
	sil_wrb_mem((uint8_t *)(sc->nic_addr + V850EC_P0_DCR), V850EC_DCR_FT1 | V850EC_DCR_LS);

	/* RBCR NA[B*/
	sil_wrb_mem((uint8_t *)(sc->nic_addr + V850EC_P0_RBCR0), 0);
	sil_wrb_mem((uint8_t *)(sc->nic_addr + V850EC_P0_RBCR1), 0);

	/* ̓t[ۑȂB*/
	sil_wrb_mem((uint8_t *)(sc->nic_addr + V850EC_P0_RCR), V850EC_RCR_MON);

	/* [vobN[hɐݒ肷B*/
	sil_wrb_mem((uint8_t *)(sc->nic_addr + V850EC_P0_TCR), V850EC_TCR_LB0);

	/* MOobt@̐ݒ */
	sil_wrb_mem((uint8_t *)(sc->nic_addr + V850EC_P0_TPSR),   V850EC_INT_TXBUF_START);
	sil_wrb_mem((uint8_t *)(sc->nic_addr + V850EC_P0_PSTART), V850EC_INT_RXBUF_START);
	sil_wrb_mem((uint8_t *)(sc->nic_addr + V850EC_P0_PSTOP),  V850EC_INT_RXBUF_STOP);
	sil_wrb_mem((uint8_t *)(sc->nic_addr + V850EC_P0_BNRY),   V850EC_INT_RXBUF_START);

	/* SĂ̊荞݃tOZbgB*/
	sil_wrb_mem((uint8_t *)(sc->nic_addr + V850EC_P0_ISR), 0xff);

	/*
	 *  荞݂B
	 *    EM
	 *    EMG[
	 *    EMI[o[Cg
	 */
	sil_wrb_mem((uint8_t *)(sc->nic_addr + V850EC_P0_IMR),
	            V850EC_IMR_PRX | V850EC_IMR_PTX | V850EC_IMR_RXE | V850EC_IMR_TXE | V850EC_IMR_OVW);

	/* WX^y[W 1 IB*/
	sil_wrb_mem((uint8_t *)(sc->nic_addr + V850EC_P0_CR),
	            V850EC_CR_RD2 | V850EC_CR_PAGE1 | V850EC_CR_STP);

	/* MAC AhXݒ肷B*/
	for (ix = 0; ix < ETHER_ADDR_LEN; ix ++)
		sil_wrb_mem((uint8_t *)(sc->nic_addr + V850EC_P1_PAR(ix)), ic->ifaddr.lladdr[ix]);

	/* t[ރy[Wݒ肷B*/
	sil_wrb_mem((uint8_t *)(sc->nic_addr + V850EC_P1_CURR), sc->rxb_read);

 	/* M\WX^ (RCR) ݒ肷B*/
 	v850ec_setrcr(ic);

	/* [vobN[hʂB*/
	sil_wrb_mem((uint8_t *)(sc->nic_addr + V850EC_P0_TCR), 0);
	
	/* M\Z}tHB*/
	for (ix = NUM_IF_V850EC_TXBUF; ix --; )
		sig_sem(ic->semid_txb_ready);

#if defined(TARGET_KERNEL_ASP)

	/* ^[Qbgˑ̊ݏ */
	v850ec_inter_init();

#endif	/* of #if defined(TARGET_KERNEL_ASP) */

#if defined(TARGET_KERNEL_JSP) && TKERNEL_PRVER >= 0x1042u	/* JSP-1.4.2 ȍ~ */

	/* ^[Qbgˑ̊ݏ */
	v850ec_inter_init();

#endif	/* of #if defined(TARGET_KERNEL_JSP) && TKERNEL_PRVER >= 0x1042u */

}

#ifndef SUPPORT_INET6

/*
 * v850ec_setrcr -- M\WX^ (RCR) ݒ肷B
 */

static void
v850ec_setrcr (T_IF_SOFTC *ic)
{
	T_V850EC_SOFTC	*sc = ic->sc;
	int_t		ix;

	/* WX^y[W 1 IB*/
	sil_wrb_mem((uint8_t *)(sc->nic_addr + V850EC_P0_CR),
	            V850EC_CR_RD2 | V850EC_CR_PAGE1 | V850EC_CR_STP);

#ifdef IF_V850EC_CFG_ACCEPT_ALL

	/* }`LXg̎Mݒ */
	for (ix = 0; ix < 8; ix ++)

		/* }`LXgSĎMB*/
		sil_wrb_mem((uint8_t *)(sc->nic_addr + V850EC_P1_MAR(ix)), 0xff);

	/* WX^y[W 0 IB*/
	sil_wrb_mem((uint8_t *)(sc->nic_addr + V850EC_P0_CR),
	                 V850EC_CR_RD2 | V850EC_CR_PAGE0 | V850EC_CR_STP);

	/* }`LXgƃG[t[M悤ɐݒ肷B*/
	sil_wrb_mem((uint8_t *)(sc->nic_addr + V850EC_P0_RCR),
	            V850EC_RCR_PRO | V850EC_RCR_AM | V850EC_RCR_AB |V850EC_RCR_SEP);

#else	/* of #ifdef IF_V850EC_CFG_ACCEPT_ALL */

	/* }`LXg̎Mݒ */
	for (ix = 0; ix < 8; ix ++)

		/* }`LXgSĎMȂB*/
		sil_wrb_mem((uint8_t *)(sc->nic_addr + V850EC_P1_MAR(ix)), 0x00);

	/* WX^y[W 0 IB*/
	sil_wrb_mem((uint8_t *)(sc->nic_addr + V850EC_P0_CR),
	            V850EC_CR_RD2 | V850EC_CR_PAGE0 | V850EC_CR_STP);

	/* ƃu[hLXĝݎM悤ɐݒ肷B*/
	sil_wrb_mem((uint8_t *)(sc->nic_addr + V850EC_P0_RCR), V850EC_RCR_AB);

#endif	/* of #ifdef IF_V850EC_CFG_ACCEPT_ALL */

	/* NIC NB*/
	sil_wrb_mem((uint8_t *)(sc->nic_addr + V850EC_P0_CR),
	            V850EC_CR_RD2 | V850EC_CR_PAGE0 | V850EC_CR_STA);
}

#endif	/* of #ifndef SUPPORT_INET6 */

/*
 * v850ec_reset -- ed lbg[NC^tF[XZbgB
 */

void
v850ec_reset (T_IF_SOFTC *ic)
{
#ifdef TARGET_KERNEL_JSP
	IPM	ipm;
#endif

	/* NIC ̊荞݂֎~B*/
#ifdef TARGET_KERNEL_JSP
	ipm = v850ec_dis_inter();
#endif
#ifdef TARGET_KERNEL_ASP
	syscall(dis_int(INTNO_IF_V850EC_RX));
	syscall(dis_int(INTNO_IF_V850EC_TX));
#endif

	NET_COUNT_ETHER_NIC(net_count_ether_nic[NC_ETHER_NIC_RESETS], 1);
	v850ec_stop(ic->sc);
	v850ec_init_sub(ic);

	/* NIC ̊荞݂B*/
#ifdef TARGET_KERNEL_JSP
	v850ec_ena_inter(ipm);
#endif
#ifdef TARGET_KERNEL_ASP
	syscall(ena_int(INTNO_IF_V850EC_RX));
	syscall(ena_int(INTNO_IF_V850EC_TX));
#endif
}

/*
 *  get_v850ec_softc -- lbg[NC^tF[X̃\tgEFAԂB
 */

T_IF_SOFTC *
v850ec_get_softc (void)
{
	return &if_softc;
}

/*
 * v850ec_watchdog -- ed lbg[NC^tF[X̃b`hbO^CAEg
 */

void
v850ec_watchdog (T_IF_SOFTC *ic)
{
	NET_COUNT_ETHER_NIC(net_count_ether_nic[NC_ETHER_NIC_OUT_ERR_PACKETS], 1);
	NET_COUNT_ETHER_NIC(net_count_ether_nic[NC_ETHER_NIC_TIMEOUTS], 1);
	v850ec_reset(ic);
}

/*
 * v850ec_probe -- ed lbg[NC^tF[X̌o
 */

void
v850ec_probe (T_IF_SOFTC *ic)
{
#ifdef V850EC_CFG_HSB8S2638
	static const uint8_t mac_order[] = { 3, 1, 7, 5, 11, 9 };
#else	/* #ifdef V850EC_CFG_HSB8S2638 */
	static const uint8_t mac_order[] = { 1, 3, 5, 7, 9, 11 };
#endif	/* #ifdef V850EC_CFG_HSB8S2638 */

	uint8_t		romdata[ETHER_ADDR_LEN * 2], tmp;
	T_V850EC_SOFTC	*sc = ic->sc;
	int_t		ix;

#if defined(TARGET_KERNEL_ASP)

	/* ^[Qbgˑ̃oX̏ */
	v850ec_bus_init();

#endif	/* of #if defined(TARGET_KERNEL_ASP) */

#if defined(TARGET_KERNEL_JSP) && TKERNEL_PRVER >= 0x1042u	/* JSP-1.4.2 ȍ~ */

	/* ^[Qbgˑ̃oX̏ */
	v850ec_bus_init();

#endif	/* of #if defined(TARGET_KERNEL_JSP) && TKERNEL_PRVER >= 0x1042u */

	/* ZbgB*/
	tmp = sil_reb_mem((uint8_t *)(sc->asic_addr + V850EC_RESET_OFFSET));
	sil_wrb_mem((uint8_t *)(sc->asic_addr + V850EC_RESET_OFFSET), tmp);
	dly_tsk(5);

	/* DMA ~B*/
	sil_wrb_mem((uint8_t *)(sc->nic_addr + V850EC_P0_CR),
	            V850EC_CR_RD2 | V850EC_CR_PAGE0 | V850EC_CR_STP);
	dly_tsk(5);

	/* ̓t[ۑȂB*/
	sil_wrb_mem((uint8_t *)(sc->nic_addr + V850EC_P0_RCR), V850EC_RCR_MON);

	/*
	 *  DCR ݒ肷B
	 *    EFIFO ̂l 8
	 *    E[vobN[h
	 */
	sil_wrb_mem((uint8_t *)(sc->nic_addr + V850EC_P0_DCR), V850EC_DCR_FT1 | V850EC_DCR_LS);

	/* MAC AhXǂݍށB*/
	v850ec_pio_readmem(sc, 0, romdata, ETHER_ADDR_LEN * 2);
	for (ix = 0; ix < ETHER_ADDR_LEN; ix ++)
		ic->ifaddr.lladdr[ix] = romdata[mac_order[ix]];

	/* SĂ̊荞݃tOZbgB*/
	sil_wrb_mem((uint8_t *)(sc->nic_addr + V850EC_P0_ISR), 0xff);
}

/*
 * v850ec_init -- ed lbg[NC^tF[X̏
 */

void
v850ec_init (T_IF_SOFTC *ic)
{
#ifdef TARGET_KERNEL_JSP
	IPM	ipm;
#endif

	/* NIC ̊荞݂֎~B*/
#ifdef TARGET_KERNEL_JSP
	ipm = v850ec_dis_inter();
#endif
#ifdef TARGET_KERNEL_ASP
	syscall(dis_int(INTNO_IF_V850EC_RX));
	syscall(dis_int(INTNO_IF_V850EC_TX));
#endif

	/* v850ec_init {̂ĂяoB*/
	v850ec_init_sub(ic);

	/* NIC ̊荞݂B*/
#ifdef TARGET_KERNEL_JSP
	v850ec_ena_inter(ipm);
#endif
#ifdef TARGET_KERNEL_ASP
	syscall(ena_int(INTNO_IF_V850EC_RX));
	syscall(ena_int(INTNO_IF_V850EC_TX));
#endif
}

/*
 * v850ec_read -- t[̓ǂݍ
 */

T_NET_BUF *
v850ec_read (T_IF_SOFTC *ic)
{
	T_V850EC_FRAME_HDR	frame_hdr;
	T_V850EC_SOFTC	*sc = ic->sc;
	T_NET_BUF	*input = NULL;
	uint32_t	frame_ptr;
	int_t		len;
	uint8_t		boundry;
	uint8_t		curr;
#ifdef TARGET_KERNEL_JSP
	IPM	ipm;
#endif

	/* NIC ̊荞݂֎~B*/
#ifdef TARGET_KERNEL_JSP
	ipm = v850ec_dis_inter();
#endif
#ifdef TARGET_KERNEL_ASP
	syscall(dis_int(INTNO_IF_V850EC_RX));
#endif

	/* WX^y[W 1 IB*/
	sil_wrb_mem((uint8_t *)(sc->nic_addr + V850EC_P0_CR),
	            V850EC_CR_RD2 | V850EC_CR_PAGE1 | V850EC_CR_STA);

	curr = sil_reb_mem((uint8_t *)(sc->nic_addr + V850EC_P1_CURR));
	if (sc->rxb_read != curr) {

		/* Mt[̐擪𓾂B*/
		frame_ptr = sc->rxb_read * V850EC_PAGE_SIZE;

		/* Mt[wb_\̂oB*/
		v850ec_pio_readmem(sc, frame_ptr, (uint8_t *)&frame_hdr, sizeof(frame_hdr));

#if SIL_ENDIAN == SIL_ENDIAN_BIG

		frame_hdr.count = (frame_hdr.count << 8) | (frame_hdr.count >> 8);

#endif	/* of #if SIL_ENDIAN == SIL_ENDIAN_BIG */

		len = frame_hdr.count;
		if (len >  sizeof(T_V850EC_FRAME_HDR) &&
		    len <= IF_MTU + sizeof(T_ETHER_HDR) + sizeof(T_V850EC_FRAME_HDR) &&
		    frame_hdr.next >= V850EC_INT_RXBUF_START &&
		    frame_hdr.next <  V850EC_INT_RXBUF_STOP) {
			input = v850ec_get_frame(sc, frame_ptr + sizeof(T_V850EC_FRAME_HDR),
			                               len - sizeof(T_V850EC_FRAME_HDR));
		}
		else {
			/* MG[ƃZbgL^B*/
			NET_COUNT_ETHER_NIC(net_count_ether_nic[NC_ETHER_NIC_IN_ERR_PACKETS], 1);
			NET_COUNT_ETHER_NIC(net_count_ether_nic[NC_ETHER_NIC_RESETS], 1);
			v850ec_stop(sc);
			v850ec_init_sub(ic);

			/* NIC ̊荞݂B*/
#ifdef TARGET_KERNEL_JSP
			v850ec_ena_inter(ipm);
#endif
#ifdef TARGET_KERNEL_ASP
			syscall(ena_int(INTNO_IF_V850EC_RX));
#endif
			return NULL;
		}

		/* t[|C^XVB*/
		sc->rxb_read = frame_hdr.next;

		/* WX^y[W 0 IB*/
		sil_wrb_mem((uint8_t *)(sc->nic_addr + V850EC_P0_CR),
		            V850EC_CR_RD2 | V850EC_CR_PAGE0 | V850EC_CR_STA);

		/* NIC ̋E|C^XVB*/
		boundry = sc->rxb_read - 1;
		if (boundry < V850EC_INT_RXBUF_START)
			boundry = V850EC_INT_RXBUF_STOP - 1;
		sil_wrb_mem((uint8_t *)(sc->nic_addr + V850EC_P0_BNRY), boundry);

		/* WX^y[W 1 IB*/
		sil_wrb_mem((uint8_t *)(sc->nic_addr + V850EC_P0_CR),
		            V850EC_CR_RD2 | V850EC_CR_PAGE1 | V850EC_CR_STA);
	}

	/* MOobt@Ƀf[^cĂ΁AMpB*/
	curr = sil_reb_mem((uint8_t *)(sc->nic_addr + V850EC_P1_CURR));
	if (sc->rxb_read != curr)
		sig_sem(ic->semid_rxb_ready);

	/* NIC ̊荞݂B*/
#ifdef TARGET_KERNEL_JSP
	v850ec_ena_inter(ipm);
#endif
#ifdef TARGET_KERNEL_ASP
	syscall(ena_int(INTNO_IF_V850EC_RX));
#endif

	return input;
}

/*
 * v850ec_start -- Mt[obt@OB
 */

void
v850ec_start (T_IF_SOFTC *ic, T_NET_BUF *output)
{
	T_V850EC_SOFTC	*sc = ic->sc;
#ifdef TARGET_KERNEL_JSP
	IPM	ipm;
#endif

	NET_COUNT_ETHER_NIC(net_count_ether_nic[NC_ETHER_NIC_OUT_PACKETS], 1);
	NET_COUNT_ETHER_NIC(net_count_ether_nic[NC_ETHER_NIC_OUT_OCTETS],  output->len);

	/* NIC ̊荞݂֎~B*/
#ifdef TARGET_KERNEL_JSP
	ipm = v850ec_dis_inter();
#endif
#ifdef TARGET_KERNEL_ASP
	syscall(dis_int(INTNO_IF_V850EC_RX));
	syscall(dis_int(INTNO_IF_V850EC_TX));
#endif

	/* Mobt@ɏށB*/
	v850ec_pio_writemem(sc, output->buf + IF_ETHER_NIC_HDR_ALIGN,
	                V850EC_INT_RAM_BASE + sc->txb_write * NUM_IF_V850EC_TXBUF_PAGE * V850EC_PAGE_SIZE,
	                output->len);

	/* Mobt@ɏ񂾃INebgL^B*/
	if (output->len > ETHER_MIN_LEN - ETHER_CRC_LEN)
		sc->txb_len[sc->txb_write] = output->len;
	else
		sc->txb_len[sc->txb_write] = ETHER_MIN_LEN - ETHER_CRC_LEN;

	/* Mobt@؂ւB*/
	sc->txb_write ++;
	if (sc->txb_write == NUM_IF_V850EC_TXBUF)
		sc->txb_write = 0;

	sc->txb_inuse ++;

	/* MłȂ΁AMJnB*/
	if (sc->txb_insend == 0)
		v850ec_xmit(ic);

	/* NIC ̊荞݂B*/
#ifdef TARGET_KERNEL_JSP
	v850ec_ena_inter(ipm);
#endif
#ifdef TARGET_KERNEL_ASP
	syscall(ena_int(INTNO_IF_V850EC_RX));
	syscall(ena_int(INTNO_IF_V850EC_TX));
#endif
}

/*
 *  NIC 荞݃nh
 */

void
if_v850ec_rx_handler (void)
{
	T_V850EC_SOFTC	*sc;
	T_IF_SOFTC	*ic;
	uint8_t		isr, tsr;
	uint16_t	collisions;

	ic = &if_softc;
	sc = ic->sc;

	/* WX^y[W 0 IB*/
	sil_wrb_mem((uint8_t *)(sc->nic_addr + V850EC_P0_CR),
	            V850EC_CR_RD2 | V850EC_CR_PAGE0 | V850EC_CR_STA);

	isr = sil_reb_mem((uint8_t *)(sc->nic_addr + V850EC_P0_ISR));

	if (isr != 0) {

		/* SĂ̊荞݃tOZbgB*/
		sil_wrb_mem((uint8_t *)(sc->nic_addr + V850EC_P0_ISR), isr);

		if (isr & (V850EC_ISR_PRX | V850EC_ISR_RXE | V850EC_ISR_OVW)) {
			if (isr & V850EC_ISR_OVW) {

				/* ㏑G[ƃZbgL^B*/
				NET_COUNT_ETHER_NIC(net_count_ether_nic[NC_ETHER_NIC_IN_ERR_PACKETS], 1);
				NET_COUNT_ETHER_NIC(net_count_ether_nic[NC_ETHER_NIC_RESETS], 1);

				/* DMA ~B*/
				sil_wrb_mem((uint8_t *)(sc->nic_addr + V850EC_P0_CR),
				            V850EC_CR_RD2 | V850EC_CR_PAGE0 | V850EC_CR_STP);
				v850ec_init_sub(ic);
			}
			else {
				if (isr & V850EC_ISR_RXE) {

					/* MG[L^B*/
					NET_COUNT_ETHER_NIC(net_count_ether_nic[NC_ETHER_NIC_IN_ERR_PACKETS], 1);
				}
				/* M荞ݏ */
				if (isig_sem(ic->semid_rxb_ready) != E_OK)
					NET_COUNT_ETHER_NIC(net_count_ether_nic[NC_ETHER_NIC_RXB_QOVRS], 1);
			}
		}

		/* WX^y[W 0 IB*/
		sil_wrb_mem((uint8_t *)(sc->nic_addr + V850EC_P0_CR),
		            V850EC_CR_RD2 | V850EC_CR_PAGE0 | V850EC_CR_STA);

		/* lbg[NL^JE^I[ot[烊ZbgB*/
		if (isr & V850EC_ISR_CNT) {
			(void)sil_reb_mem((uint8_t *)(sc->nic_addr + V850EC_P0_CNTR0));
			(void)sil_reb_mem((uint8_t *)(sc->nic_addr + V850EC_P0_CNTR1));
			(void)sil_reb_mem((uint8_t *)(sc->nic_addr + V850EC_P0_CNTR2));
		}
	}

	/* ^[Qbgˑ̊݃NA */
#ifdef TARGET_KERNEL_JSP
	v850ec_inter_clear();
#endif
}

/*
 *  NIC 荞݃nh
 */

void
if_v850ec_tx_handler (void)
{
	T_V850EC_SOFTC	*sc;
	T_IF_SOFTC	*ic;
	uint8_t		isr, tsr;
	uint16_t	collisions;

	ic = &if_softc;
	sc = ic->sc;

	/* WX^y[W 0 IB*/
	sil_wrb_mem((uint8_t *)(sc->nic_addr + V850EC_P0_CR),
	            V850EC_CR_RD2 | V850EC_CR_PAGE0 | V850EC_CR_STA);

	isr = sil_reb_mem((uint8_t *)(sc->nic_addr + V850EC_P0_ISR));

	if (isr != 0) {

		/* SĂ̊荞݃tOZbgB*/
		sil_wrb_mem((uint8_t *)(sc->nic_addr + V850EC_P0_ISR), isr);

		if (isr & (V850EC_ISR_PTX | V850EC_ISR_TXE)) {
			collisions = sil_reb_mem((uint8_t *)(sc->nic_addr + V850EC_P0_NCR)) & 0x0f;

			/* M */
			tsr = sil_reb_mem((uint8_t *)(sc->nic_addr + V850EC_P0_TSR));
			if (isr & V850EC_ISR_TXE) {

				/* MG[L^B*/
				if ((tsr & V850EC_TSR_ABT) && (collisions == 0)) {
					/*
					 * RW 16 ̂ƂAP_NCR  0A
					 * TSR_ABT  1 ɂȂB
					 */
					collisions = 16;
				}
				NET_COUNT_ETHER_NIC(net_count_ether_nic[NC_ETHER_NIC_OUT_ERR_PACKETS], 1);
			}

			if (sc->txb_insend)
				sc->txb_insend --;
			if (sc->txb_inuse)
				sc->txb_inuse  --;

			/* M^CAEgZbgB*/
			ic->timer = 0;

			/* ܂Mobt@ɎcĂΑMB*/
			if (sc->txb_inuse)
				v850ec_xmit(ic);

			if (isig_sem(ic->semid_txb_ready) != E_OK)
				NET_COUNT_ETHER_NIC(net_count_ether_nic[NC_ETHER_NIC_TXB_QOVRS], 1);

			/* RWL^B*/
			NET_COUNT_ETHER_NIC(net_count_ether_nic[NC_ETHER_NIC_COLS], collisions);
		}

		/* WX^y[W 0 IB*/
		sil_wrb_mem((uint8_t *)(sc->nic_addr + V850EC_P0_CR),
		            V850EC_CR_RD2 | V850EC_CR_PAGE0 | V850EC_CR_STA);

		/* lbg[NL^JE^I[ot[烊ZbgB*/
		if (isr & V850EC_ISR_CNT) {
			(void)sil_reb_mem((uint8_t *)(sc->nic_addr + V850EC_P0_CNTR0));
			(void)sil_reb_mem((uint8_t *)(sc->nic_addr + V850EC_P0_CNTR1));
			(void)sil_reb_mem((uint8_t *)(sc->nic_addr + V850EC_P0_CNTR2));
		}
	}

	/* ^[Qbgˑ̊݃NA */
#ifdef TARGET_KERNEL_JSP
	v850ec_inter_clear();
#endif
}
