/*
 *  TOPPERS/SSP Kernel
 *      Smallest Set Profile Kernel
 *
 *  Copyright (C) 2000-2003 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 *  Copyright (C) 2005-2008 by Embedded and Real-Time Systems Laboratory
 *              Graduate School of Information Science, Nagoya Univ., JAPAN
 *  Copyright (C) 2010 by Naoki Saito
 *             Nagoya Municipal Industrial Research Institute, JAPAN
 * 
 *  L쌠҂́Cȉ (1)`(4) ̏𖞂ꍇɌC{\tgEF
 *  Ai{\tgEFAς̂܂ށDȉjgpEEρE
 *  ĔzziȉCpƌĂԁj邱Ƃ𖳏ŋD
 *  (1) {\tgEFA\[XR[ȟ`ŗpꍇɂ́CL̒쌠
 *      \C̗pщL̖ۏ؋K肪Ĉ܂܂̌`Ń\[X
 *      R[hɊ܂܂Ă邱ƁD
 *  (2) {\tgEFACCu`ȂǁC̃\tgEFAJɎgp
 *      ł`ōĔzzꍇɂ́CĔzzɔhLgip҃}
 *      jAȂǁjɁCL̒쌠\C̗pщL̖
 *      ؋Kfڂ邱ƁD
 *  (3) {\tgEFAC@ɑgݍނȂǁC̃\tgEFAJɎgp
 *      łȂ`ōĔzzꍇɂ́Ĉꂩ̏𖞂ƁD
 *    (a) ĔzzɔhLgip҃}jAȂǁjɁCL̒
 *        \C̗pщL̖ۏ؋Kfڂ邱ƁD
 *    (b) Ĕzž`ԂCʂɒ߂@ɂāCTOPPERSvWFNgɕ
 *        邱ƁD
 *  (4) {\tgEFA̗pɂ蒼ړI܂͊ԐړIɐ邢Ȃ鑹Q
 *      CL쌠҂TOPPERSvWFNgƐӂ邱ƁD܂C
 *      {\tgEFÃ[U܂̓Gh[ÛȂ闝RɊ
 *      CL쌠҂TOPPERSvWFNgƐӂ邱ƁD
 * 
 *  {\tgEFÁCۏ؂Œ񋟂Ă̂łDL쌠҂
 *  TOPPERSvWFNǵC{\tgEFAɊւāC̎gpړIɑ΂
 *  K܂߂āCȂۏ؂sȂD܂C{\tgEFA̗p
 *  ɂ蒼ړI܂͊ԐړIɐȂ鑹QɊւĂC̐ӔC
 *  ȂD
 * 
 */

/*
 *		^XNǗ@\
 */

#include "kernel_impl.h"
#include "check.h"
#include "task.h"


/*
 *  ^XN̋N
 */

ER
act_tsk(ID tskid)
{
	ER		ercd;
	uint_t	apri;

	CHECK_TSKCTX_UNL();
	CHECK_TSKID_SELF(tskid);
	
	apri = get_apri_self(tskid);

	t_lock_cpu();
	if (test_dormant(apri)) { /* x~Ԃ */
		if(make_active(apri)) {
			run_task(apri);
		}
		ercd = E_OK;
	}
#if 0 /* L[CO͌ */
	else if (!(actque[apri])) {
		actque[apri] = true;
		ercd = E_OK;
	}
#endif
	else {
		ercd = E_QOVR;
	}
	t_unlock_cpu();

  error_exit:
	return(ercd);
}


/*
 *  ^XN̋Ni^XNReLXgpj
 */

ER
iact_tsk(ID tskid)
{
	ER		ercd;
	uint_t	apri;

	CHECK_INTCTX_UNL();
	CHECK_TSKID(tskid);
	apri = get_apri(tskid);

	i_lock_cpu();
	if (test_dormant(apri)) {
		if(make_active(apri))
		{
			reqflg = true;
		}
		ercd = E_OK;
	}
#if 0
	else if (!(actque[apri])) {
		actque[apri] = true;
		ercd = E_OK;
	}
#endif
	else {
		ercd = E_QOVR;
	}
	i_unlock_cpu();

  error_exit:
	return(ercd);
}
