/*
 *  TOPPERS/SSP Kernel
 *      Smallest Set Profile Kernel
 *
 *  Copyright (C) 2000-2003 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 *  Copyright (C) 2005,2006 by Embedded and Real-Time Systems Laboratory
 *              Graduate School of Information Science, Nagoya Univ., JAPAN
 *  Copyright (C) 2008 by Witz Corporation, JAPAN
 *  Copyright (C) 2010 by Naoki Saito
 *             Nagoya Municipal Industrial Research Institute, JAPAN
 * 
 *  L쌠҂́Cȉ (1)`(4) ̏𖞂ꍇɌC{\tgEF
 *  Ai{\tgEFAς̂܂ށDȉjgpEEρE
 *  ĔzziȉCpƌĂԁj邱Ƃ𖳏ŋD
 *  (1) {\tgEFA\[XR[ȟ`ŗpꍇɂ́CL̒쌠
 *      \C̗pщL̖ۏ؋K肪Ĉ܂܂̌`Ń\[X
 *      R[hɊ܂܂Ă邱ƁD
 *  (2) {\tgEFACCu`ȂǁC̃\tgEFAJɎgp
 *      ł`ōĔzzꍇɂ́CĔzzɔhLgip҃}
 *      jAȂǁjɁCL̒쌠\C̗pщL̖
 *      ؋Kfڂ邱ƁD
 *  (3) {\tgEFAC@ɑgݍނȂǁC̃\tgEFAJɎgp
 *      łȂ`ōĔzzꍇɂ́Ĉꂩ̏𖞂ƁD
 *    (a) ĔzzɔhLgip҃}jAȂǁjɁCL̒
 *        \C̗pщL̖ۏ؋Kfڂ邱ƁD
 *    (b) Ĕzž`ԂCʂɒ߂@ɂāCTOPPERSvWFNgɕ
 *        邱ƁD
 *  (4) {\tgEFA̗pɂ蒼ړI܂͊ԐړIɐ邢Ȃ鑹Q
 *      CL쌠҂TOPPERSvWFNgƐӂ邱ƁD܂C
 *      {\tgEFÃ[U܂̓Gh[ÛȂ闝RɊ
 *      CL쌠҂TOPPERSvWFNgƐӂ邱ƁD
 * 
 *  {\tgEFÁCۏ؂Œ񋟂Ă̂łDL쌠҂
 *  TOPPERSvWFNǵC{\tgEFAɊւāC̎gpړIɑ΂
 *  K܂߂āCȂۏ؂sȂD܂C{\tgEFA̗p
 *  ɂ蒼ړI܂͊ԐړIɐȂ鑹QɊւĂC̐ӔC
 *  ȂD
 * 
 */

/*
 *		vZbTˑW[iM32Cpj
 *
 *  ̃CN[ht@ĆCtarget_config.hi܂́CCN
 *  [ht@Cĵ݂CN[hD̃t@C
 *  ڃCN[hĂ͂ȂȂD
 */

#ifndef TOPPERS_PRC_CONFIG_H
#define TOPPERS_PRC_CONFIG_H

/*
 *  vZbT̓ꖽ߂̃CC֐`
 */
#include "prc_insn.h"

/*
 *  ݊Ǘ@\̃vZbTˑ
 */
#include "prc_interrupt.h"

/*
 *  CPUOǗ@\̃vZbTˑ
 */
#include "prc_exception.h"


/*
 *  ^XNReLXgp̃X^bNl
 */
#define TOPPERS_ISTKPT(istk, istksz) ((STK_T *)((char *)(istk) + (istksz)))


/*
 *  CPUbNtOCyсCݗDx}XN̒`
 */

/*
 *  CPUbNԂł̊ݗDx}XN
 *
 *  TIPM_LOCḰCCPUbNԂ\DxD
 *
 *  ݏfɂ銄ݗDx̒ĺCۂ̃vZbTɂ
 *  ݗṽxlɑ(ݗDx̓\)𕄍]lɓD
 *
 *  Ⴆ΁CTIPM_LOCK-5ɒ`ꍇCx5ȉ̊ݗv
 *  J[lǗ̊݁Cx6ȏ݂̊̓J[lǗO݂̊Ƃ
 *  邱ƂɂȂD
 *
 *  M32C ɂẮCݗDxx̏ 7 łD̂߁C
 *  TIPM_LOCK  -7 ɐݒ肷ƁCNMI ȊOɃJ[lǗO݂̊
 *  ݂ȂƂӖɂȂD
 */
#ifndef TIPM_LOCK
#define TIPM_LOCK	(-5)
#endif /* TIPM_LOCK */

/*
 *  ݗDx}XN̊O\Ɠ\̕ϊ
 *
 *  M32Cł́CtOWX^iFLGj̉ʂ12`14rbgڂ3rbg
 *  ݗDxxiIPLj̒li[ꏊƂĊ蓖ĂĂD
 *  J[l͊ݗDx}XNi-1A̒ljpĊǗC
 *  vZbT̓vZbTɈˑlŊǗĂ邽߁CϊKvƂȂD
 */
#define IPM2IPL(ipm)	(((uint16_t)(-(ipm))) << 12U)		/* IPMIPL	*/

/*
 *  ݗDx}XN̓ʂȒlɑ΂\
 */
#define IPL_LOCK	(IPM2IPL(TIPM_LOCK))  	/* CPUbNԂł̊ݗDx}XNIPL */
#define IPL_ENAALL	(IPM2IPL(TIPM_ENAALL))	/* TIPM_ENAALLiݗDx}XNSjIPL */

#ifndef TOPPERS_MACRO_ONLY

/*
 *  CPUbNtÔ߂̕ϐ
 */
#if TIPM_LOCK != -7
extern bool_t	lock_flag;		/* CPUbNtO̒lێϐ */
extern uint16_t	saved_ipl;		/* CPUbNԈڍsO̊ݗDxxۑϐ */
#endif	/* TIPM_LOCK != -7	*/

/*
 *  CPUbNԂւ̈ڍs
 *
 *  IPMin[hEFÅݗDx}XNjCsaved_iipmɕۑCJ[
 *  lǗÔׂ̂Ă̊ݗv}XNliTIPM_LOCKj
 *  ɐݒ肷D܂Clock_flagTRUEɂD
 *
 *  IPMCŏTIPM_LOCKƓ荂ꍇɂ́C
 *  saved_iipmɕۑ݂̂ŁCTIPM_LOCKɂ͐ݒ肵ȂD́Cf
 *  ̊ݗDx}XNCTIPM_LOCKƓ荂xɐݒ
 *  ĂԂɂD
 *
 *  ̊֐́CCPUbNԁilock_flagTRUȄԁjŌĂ΂邱Ƃ
 *  Ȃ̂Ƒz肵ĂD
 */
Inline void
t_lock_cpu(void)
{
#if TIPM_LOCK == -7
	disint();
#else	/* TIPM_LOCK == -7	*/
	uint16_t	ipl;

	/* ^XNł́CݗDx}XN̒l 0 ̂͂ŁCipl ͕ۑȂ */
	ipl = get_flgreg();
	set_flgreg((ipl & ~FLG_IPL_MASK) | IPL_LOCK);
	lock_flag = true;
#endif	/* TIPM_LOCK == -7	*/
}

Inline void
i_lock_cpu(void)
{
#if TIPM_LOCK == -7
	disint();
#else	/* TIPM_LOCK == -7	*/
	uint16_t	ipl;

	/*
	 *  get_flg()̕Ԃl𒼐saved_iplɕۑCꎞϐipl
	 *  pĂ̂́Cget_flg()Ă񂾒Ɋ݂C
	 *  Nꂽݏsaved_iplύX\邽߂
	 *  D
	 */
	ipl = get_flgreg();
	if (IPL_LOCK > ipl) {
		set_flgreg((ipl & ~FLG_IPL_MASK) | IPL_LOCK);
	}
	saved_ipl = ipl;
	lock_flag = true;
#endif	/* TIPM_LOCK == -7	*/
}

/*
 *  CPUbNԂ̉
 *
 *  lock_flagFALSEɂCIPMin[hEFÅݗDx}XNjC
 *  saved_iipmɕۑlɖ߂D
 *
 *  ̊֐́CCPUbNԁilock_flagtruȅԁjł̂݌Ă΂
 *  ̂Ƒz肵ĂD
 */
Inline void
t_unlock_cpu(void)
{
#if TIPM_LOCK == -7
	enaint();
#else	/* TIPM_LOCK == -7	*/
	lock_flag = false;
	/* ^XNs̊ݗDx}XNTIPM_ENAALL̂͂Ȃ̂ŁCPɃNA΂悢 */
	set_flgreg(get_flgreg() & ~FLG_IPL_MASK);
#endif	/* TIPM_LOCK == -7	*/
}


Inline void
i_unlock_cpu(void)
{
#if TIPM_LOCK == -7
	enaint();
#else	/* TIPM_LOCK == -7	*/
	lock_flag = false;
	set_flgreg((get_flgreg() & ~FLG_IPL_MASK) | (saved_ipl & FLG_IPL_MASK));
#endif	/* TIPM_LOCK == -7	*/
}

/*
 *  CPUbNԂ̎Q
 */
Inline bool_t
x_sense_lock(void)
{
#if TIPM_LOCK == -7
	return((bool_t)((get_flgreg() & FLG_I_MASK) == 0));
#else	/* TIPM_LOCK == -7	*/
	return lock_flag;
#endif	/* TIPM_LOCK == -7	*/
}

#define t_sense_lock()	x_sense_lock()
#define i_sense_lock()	x_sense_lock()

/*
 * if́jݗDx}XN̐ݒ
 *
 *  CPUbNtONAĂ鎞́Cn[hEFÅݗDx}
 *  XNݒ肷DCPUbNtOZbgĂ鎞́Csaved_iipm
 *  ݒ肵CɁCn[hEFÅݗDx}XNCݒ肵悤
 *  if́jݗDx}XNTIPM_LOCK̍ɐݒ肷D
 */
Inline void
x_set_ipm(PRI intpri)
{
	set_flgreg((get_flgreg() & ~FLG_IPL_MASK) | IPM2IPL(intpri));
}

#define t_set_ipm(intpri)	x_set_ipm(intpri)
#define i_set_ipm(intpri)	x_set_ipm(intpri)


Inline PRI
x_get_ipm(void)
{
}

#define t_get_ipm()	x_get_ipm()
#define i_get_ipm()	x_get_ipm()


/*
 *  ReLXgɊւ`
 */

/*
 *  ݔ񐔂ۑϐ
 */
extern uint16_t intnest;

/*
 *  ReLXg̎Q
 *
 *  M32Cł́C݂̖߂悪^XNǂ𔻒f邽߂ intnest
 *  gpĂDpăReLXg𔻒fD
 */
Inline bool_t
sense_context(void)
{
	/*  lXgJE^0Ȃ^XNReLXg  */
	return (intnest > 0);
}

extern void start_dispatch(void);

/*
 *  J[l̏Ǐďoiprc_support.a30j
 *
 *  call_exit_kerneĺCJ[l̏IɌĂяôׂŁC^XN
 *  ReLXgɐ؂芷āCJ[l̏Iiexit_kerneljĂяo
 *  D
 */
extern void call_exit_kernel(void);

/*
 *  vZbTˑ̏(prc_config.c)
 */
extern void	prc_initialize(void);

/*
 *  vZbTˑ̏I(prc_config.c)
 */
extern void	prc_terminate(void);



#endif /* TOPPERS_MACRO_ONLY */
#endif /* TOPPERS_PRC_CONFIG_H */
