/*
 *  TOPPERS/SSP Kernel
 *      Smallest Set Profile Kernel
 *
 *  Copyright (C) 2000-2003 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 *  Copyright (C) 2005,2006 by Embedded and Real-Time Systems Laboratory
 *              Graduate School of Information Science, Nagoya Univ., JAPAN
 *  Copyright (C) 2008 by Witz Corporation, JAPAN
 *  Copyright (C) 2010 by Naoki Saito
 *             Nagoya Municipal Industrial Research Institute, JAPAN
 * 
 *  L쌠҂́Cȉ (1)`(4) ̏𖞂ꍇɌC{\tgEF
 *  Ai{\tgEFAς̂܂ށDȉjgpEEρE
 *  ĔzziȉCpƌĂԁj邱Ƃ𖳏ŋD
 *  (1) {\tgEFA\[XR[ȟ`ŗpꍇɂ́CL̒쌠
 *      \C̗pщL̖ۏ؋K肪Ĉ܂܂̌`Ń\[X
 *      R[hɊ܂܂Ă邱ƁD
 *  (2) {\tgEFACCu`ȂǁC̃\tgEFAJɎgp
 *      ł`ōĔzzꍇɂ́CĔzzɔhLgip҃}
 *      jAȂǁjɁCL̒쌠\C̗pщL̖
 *      ؋Kfڂ邱ƁD
 *  (3) {\tgEFAC@ɑgݍނȂǁC̃\tgEFAJɎgp
 *      łȂ`ōĔzzꍇɂ́Ĉꂩ̏𖞂ƁD
 *    (a) ĔzzɔhLgip҃}jAȂǁjɁCL̒
 *        \C̗pщL̖ۏ؋Kfڂ邱ƁD
 *    (b) Ĕzž`ԂCʂɒ߂@ɂāCTOPPERSvWFNgɕ
 *        邱ƁD
 *  (4) {\tgEFA̗pɂ蒼ړI܂͊ԐړIɐ邢Ȃ鑹Q
 *      CL쌠҂TOPPERSvWFNgƐӂ邱ƁD܂C
 *      {\tgEFÃ[U܂̓Gh[ÛȂ闝RɊ
 *      CL쌠҂TOPPERSvWFNgƐӂ邱ƁD
 * 
 *  {\tgEFÁCۏ؂Œ񋟂Ă̂łDL쌠҂
 *  TOPPERSvWFNǵC{\tgEFAɊւāC̎gpړIɑ΂
 *  K܂߂āCȂۏ؂sȂD܂C{\tgEFA̗p
 *  ɂ蒼ړI܂͊ԐړIɐȂ鑹QɊւĂC̐ӔC
 *  ȂD
 * 
 */

/*
 *		vZbTˑW[iM32Cpj
 */

#include "kernel_impl.h"


#define NDEBUG

/*
 *  ݔ񐔂ۑϐ
 */
uint16_t intnest;

/*
 *  CPUbNtÔ߂̕ϐ
 */
#if TIPM_LOCK != -7
bool_t		lock_flag;		/* CPUbNtO̒lێϐ */
uint16_t	saved_ipl;		/* ݗDxxۑϐ */
#endif	/* TIPM_LOCK != -7	*/

/*
 *  vZbTˑ̏
 */
void
prc_initialize(void)
{
	/*
	 *  CPUbN̏ԂɂĂ
	 */
#if TIPM_LOCK != -7
	set_flgreg((get_flgreg() & ~FLG_IPL_MASK) | IPL_LOCK);
	lock_flag = true;
	saved_ipl = IPL_ENAALL;
#endif	/* TIPM_LOCK != -7	*/
}


/*
 *  vZbTˑ̏I
 */
void
prc_terminate(void)
{
	/* ɕKvȏ͂Ȃ */
}


/*
 *  ݗvC̑̐ݒ
 *
 *  ASPJ[lł̗pz肵āCp[^G[̓AT[VŃ`Fb
 *  NĂDcfg_intT[rXR[݂ꍇɂ́CG[Ԃ悤
 *  ɂׂł낤D
 */
void
x_config_int(INTNO intno, ATR intatr, PRI intpri)
{
//	assert(VALID_INTNO_CFGINT(intno));
//	assert(TMIN_INTPRI <= intpri && intpri <= TMAX_INTPRI);

	/*
	 *  ݂̃}XN
	 *
	 *  ݂󂯕t܂܁CxgK^GbWgK̐ݒC
	 *  ݗDx̐ݒŝ͊댯Ȃ߁Cݑɂ炸C
	 *  U}XND
	 */
	(void) x_disable_int(intno);
	
	/* INT[q̏ꍇ͊݌m@ݒ肷 */
	if((intatr & TA_POSEDGE) != 0U)
	{
		/* オGbW */
		*(intc_reg[intno]) = (*(intc_reg[intno]) & ~INTC_LVSMASK) | INTC_POLHIGH;
	}
	else if((intatr & TA_NEGEDGE) != 0U)
	{
		/* GbW */
		*(intc_reg[intno]) &= (*(intc_reg[intno]) & ~(INTC_POLMASK|INTC_LVSMASK));
	}
	else if((intatr & TA_HIGHLEVEL) != 0U)
	{
		/* Hx */
		*(intc_reg[intno]) |= (INTC_POLHIGH | INTC_LVSLVL);
	}
	else if((intatr & TA_LOWLEVEL) != 0U)
	{
		/* Lx */
		*(intc_reg[intno]) = (*(intc_reg[intno]) & ~INTC_POLMASK) | INTC_LVSLVL;
	}

	/*
	 *  M32Cł͊݋֎~/ݗDxݒŎ邽߁C
	 *  ŊݗDx̐ݒ͍sȂ
	 */
	
	/*
	 *  ݂̃}XN
 	 */
	if ((intatr & TA_ENAINT) != 0U) {
		(void) x_enable_int(intno);
	}
	
}


/* 
 *  ݗvWX^̃AhXe[u
 *
 *  AhXlMCŨwb_t@C(m32cxx.h)ɂĒ`D
 */
volatile uint8_t * const intc_reg[INHNO_MAX] = 
{
	INTC_TABLE_DATA
};



