package jp.osoite.tomu.xmpp.core;

import java.util.regex.*;

final class WordReplacer {

    private static final String DOT_TAG = "#dot;";
    private static final String HTTP_TAG = "#hll9;";

    private WordReplacer() {
    }

    public static String replace(String str, String replace, String patternStr) {
        Pattern pattern = Pattern.compile(patternStr, Pattern.DOTALL | Pattern.CASE_INSENSITIVE);
        Matcher matcher = pattern.matcher(str);
        return matcher.replaceAll(replace);
    }

    public static String replaceDotAndHttp(String line) {
        String result = line.replace(".", DOT_TAG).replace("http", HTTP_TAG);
        return result;
    }

    public static String reverseDotAndHttp(String line) {
        String result = line.replace(DOT_TAG, ".").replace(HTTP_TAG, "http");
        return result;
    }
}
