package jp.osoite.tomu.xml.jaxb.wrapper;

import jp.osoite.tomu.xml.jaxb.object.KitokitoSensorData;
import jp.osoite.tomu.xml.jaxb.object.TomuMessage;
import jp.osoite.tomu.xml.jaxb.util.SensorType;

/**
 *
 * @author shima
 */
public class UploadKito2Wrapper extends TomuMessageWrapper {

    private KitokitoSensorData kito;

    public UploadKito2Wrapper(TomuMessage msg) {
        super(msg);
        kito = msg.getUpload().getSensorSourceDataSet().getKitokitoSensorData().get(0);
    }

    public SensorType getType() {
        return SensorType.IMAGE;
    }

    public long getSensorId() {
        return kito.getSensorID().longValue();
    }

    public long getSensedTime() {
        return kito.getSensedTime().longValue();
    }

    public int getCompass(){
        return kito.getDirection().intValue();
    }

    public double getLatitude(){
        return kito.getLocation().getLat().doubleValue();
    }

    public double getLongitude(){
        return kito.getLocation().getLon().doubleValue();
    }

    public int getDpi(){
        return kito.getDpi().intValue();
    }

    public String getImageUrl(){
        return kito.getImageUrl();
    }

    public String getThumbnailUrl(){
        return kito.getThumbnailUrl();
    }
}
