package jp.osoite.tomu.xml.jaxb.wrapper;

import jp.osoite.tomu.xml.jaxb.object.ChiefAxis;
import jp.osoite.tomu.xml.jaxb.object.Minus;
import jp.osoite.tomu.xml.jaxb.object.Plus;
import jp.osoite.tomu.xml.jaxb.object.SubAxis;

/**
 * 1軸を表すクラスです．
 * 軸の方角，人流の人数，人流の平均速度をもちます．
 * @author shima
 */
public class Axis {

    public enum Direction {

        PLUS, MINUS
    }
    private int plusCompass,  plusNum,  minCompass,  minNum;
    private double plusAvgSp,  minAvgSp;

    public Axis() {
    }

    public Axis(ChiefAxis cAxis) {
        Plus plus = cAxis.getPlus();
        Minus minus = cAxis.getMinus();
        setValue(plus.getCompass().intValue(),
                plus.getNum().intValue(),
                plus.getAverageSpeed().getMeterperSecond().doubleValue(),
                Direction.PLUS);
        setValue(minus.getCompass().intValue(),
                minus.getNum().intValue(),
                minus.getAverageSpeed().getMeterperSecond().doubleValue(),
                Direction.MINUS);
    }

    public Axis(SubAxis sAxis) {
        Plus plus = sAxis.getPlus();
        Minus minus = sAxis.getMinus();
        setValue(plus.getCompass().intValue(),
                plus.getNum().intValue(),
                plus.getAverageSpeed().getMeterperSecond().doubleValue(),
                Direction.PLUS);
        setValue(minus.getCompass().intValue(),
                minus.getNum().intValue(),
                minus.getAverageSpeed().getMeterperSecond().doubleValue(),
                Direction.MINUS);
    }

    public void setValue(int compass, int num, double avgSp, Direction dir) {
        if (dir == Direction.PLUS) {
            plusCompass = compass;
            plusNum = num;
            plusAvgSp = avgSp;
        } else {
            minCompass = compass;
            minNum = num;
            minAvgSp = avgSp;
        }
    }

    public int getCompass(Direction dir) {
        if (dir == Direction.PLUS) {
            return plusCompass;
        } else {
            return minCompass;
        }
    }

    public int getFlowValue(Direction dir) {
        if (dir == Direction.PLUS) {
            return plusNum;
        } else {
            return minNum;
        }
    }

    public double getAverageSpeed(Direction dir) {
        if (dir == Direction.PLUS) {
            return plusAvgSp;
        } else {
            return minAvgSp;
        }
    }
}