package jp.osoite.tomu.xml.jaxb.util.builder;

import java.util.ArrayList;
import java.util.List;
import jp.osoite.tomu.xml.jaxb.object.Area;
import jp.osoite.tomu.xml.jaxb.object.InitPedestrian;
import jp.osoite.tomu.xml.jaxb.object.InitTemperature;
import jp.osoite.tomu.xml.jaxb.object.TomuMessage;
import jp.osoite.tomu.xml.jaxb.util.TomuMessageType;

/**
 * Sfeerサーバに対するInitResponseメッセージを構築します．
 * @author shima
 */
public class SfeerInitResponseBuilder {

    private JAXBConstructor cnst;
    private List<Area> areas;

    /**
     * コンストラクタ
     * @param dest 送信先ID
     * @param src 送信元ID
     * @param msgId メッセージID
     */
    public SfeerInitResponseBuilder(String dest, String src, long msgId) {
        cnst = new JAXBConstructor(TomuMessageType.APPS_INIT_RESPONSE);
        cnst.setHeader(dest, src, msgId);
        areas = new ArrayList<Area>();
    }

    /**
     * Sfeerサーバ用のInitResponseメッセージを構築します．
     * @return TomuMessageオブジェクト
     */
    public TomuMessage build() {
        cnst.addSfeerInitMessage(areas);
        try {
            return cnst.build();
        } catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    /**
     * 各エリアの初期化情報を追加します．
     * @param id エリアID
     * @param initTemp 温度センサ初期化情報
     * @param initPed 人流センサ初期化情報
     */
    public void addArea(int id, InitTemperature initTemp, InitPedestrian initPed) {
        areas.add(JAXBConstructor.getResponseArea(id, initTemp, initPed));
    }

    /**
     * 温度センサのIDと，現在のステータスを持ったInitTemperatureオブジェクトを生成します．<br>
     * addArea()メソッドの引数に返されたオブジェクトを代入してください．
     * @param sensorId センサID
     * @param crr 現在の気温
     * @param max 最高気温
     * @param min 最低気温
     * @param avg 平均気温
     * @param fiveMinData 現在から5分間分の気温
     * @return InitTemperatureオブジェクト
     */
    public InitTemperature getInitTemperature(long sensorId, double crr, double max, double min, double avg, double[] fiveMinData) {
        return JAXBConstructor.getInitTemperature(sensorId, crr, max, min, avg, JAXBConstructor.getFiveMinuteTempData(fiveMinData));
    }

    /**
     * 人流センサのIDと，現在のステータスを持ったInitPedestrianオブジェクトを生成します．<br>
     * addArea()メソッドの引数に返されたオブジェクトを代入してください．
     * @param sensorId センサID
     * @param crrFlow 現在の人流
     * @param crrReg 現在の滞留人数
     * @param flowAvg 平均人流
     * @return InitPedestrianオブジェクト
     */
    public InitPedestrian getInitPedestrian(long sensorId, int crrFlow, int crrReg, double flowAvg) {
        return JAXBConstructor.getInitPedestrian(sensorId, crrFlow, crrReg, flowAvg);
    }
}
