package jp.osoite.tomu.xml.jaxb.util;

import java.io.StringReader;
import java.io.StringWriter;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.transform.stream.StreamSource;
import jp.osoite.tomu.xml.jaxb.object.*;

/**
 * XMLとJAXBの変換用クラスです．
 * @author shima
 */
public final class JAXBConverter {

    private static final String PATH = "jp.osoite.tomu.xml.jaxb.object";
    private static final JAXBContext USER;
    private static final Unmarshaller UNMARSHAL;
    private static final Marshaller MARSHAL;

    static {
        try {
            USER = JAXBContext.newInstance(PATH);
            UNMARSHAL = USER.createUnmarshaller();
            MARSHAL = USER.createMarshaller();
        } catch (Exception e) {
            throw new AssertionError("JAXBContext Initialize Error");
        }
    }

    private JAXBConverter(){}

    /**
     * XMLをJAXBオブジェクトに変換します．
     * @param xml XML文字列
     * @return TomuMessageオブジェクト
     * @throws javax.xml.bind.JAXBException
     */
    public static TomuMessage convertToObj(String xml) throws JAXBException {
        return (TomuMessage) UNMARSHAL.unmarshal(new StreamSource(new StringReader(xml)));
    }

    /**
     * JAXBオブジェクトをXMLに変換します．
     * @param tomuMsg TomuMessageオブジェクト
     * @return XML文字列
     * @throws javax.xml.bind.JAXBException
     */
    public static String convertToXml(TomuMessage tomuMsg) throws JAXBException {
        StringWriter sw = new StringWriter();
        MARSHAL.marshal(tomuMsg, sw);
        return sw.toString();
    }
    
}
