package jp.osoite.tomu.xml.jaxb.util;

import java.util.ArrayDeque;
import java.util.Deque;

/**
 *
 * @author shima
 */
public final class HashChecker {

    private final Deque<Integer> hashCodeList;
    private int size;

    public HashChecker(int size) {
        this.size = size;
        hashCodeList = new ArrayDeque<Integer>();
    }

    public void in(String xml) {
        synchronized (hashCodeList) {
            hashCodeList.offer(Integer.valueOf(xml.hashCode()));
            if (hashCodeList.size() >= size) {
                hashCodeList.poll();
            }
        }
    }

    public synchronized boolean checkIn(String xml) {
        boolean result = false;
        synchronized (hashCodeList) {
            result = !hashCodeList.contains(Integer.valueOf(xml.hashCode()));
        }
        return result;
    }
}