package jp.osoite.tomu.xml.jaxb.test;


import java.util.List;
import jp.osoite.tomu.xml.jaxb.object.TomuMessage;
import jp.osoite.tomu.xml.jaxb.util.TomuMessageSwitchManager;
import jp.osoite.tomu.xml.jaxb.util.builder.DummyTomuMessageFactory;
import jp.osoite.tomu.xml.jaxb.util.builder.DummyTomuMessageFactory.DummyMessageType;
import jp.osoite.tomu.xml.jaxb.wrapper.AreaSetting;
import jp.osoite.tomu.xml.jaxb.wrapper.Axis;
import jp.osoite.tomu.xml.jaxb.wrapper.Axis.Direction;
import jp.osoite.tomu.xml.jaxb.wrapper.InitRequestSfeerWrapper;
import jp.osoite.tomu.xml.jaxb.wrapper.Location;
import jp.osoite.tomu.xml.jaxb.wrapper.RequestSfeerWrapper;
import jp.osoite.tomu.xml.jaxb.wrapper.TomuMessageWrapper;
import jp.osoite.tomu.xml.jaxb.wrapper.UploadKito2Wrapper;
import jp.osoite.tomu.xml.jaxb.wrapper.UploadPedestrianWrapper;
import jp.osoite.tomu.xml.jaxb.wrapper.listener.InitRequestSfeerListener;
import jp.osoite.tomu.xml.jaxb.wrapper.listener.RequestSfeerListener;
import jp.osoite.tomu.xml.jaxb.wrapper.listener.UploadKito2Listener;
import jp.osoite.tomu.xml.jaxb.wrapper.listener.UploadPedestrianListener;

public class Test2 implements
        InitRequestSfeerListener,
        RequestSfeerListener,
        UploadPedestrianListener,
        UploadKito2Listener {

    private static final boolean PRINT_HEADER = true;
    private static final boolean PRINT_WRAPPER = true;

    public void doTest(){
        Test2 test = new Test2();

        TomuMessageSwitchManager manager = new TomuMessageSwitchManager();

        // InitRequestSfeerメッセージ
        manager.addInitRequestSfeerListener(test);
        TomuMessage mes = DummyTomuMessageFactory.getSfeerInitRequest(3);
        manager.switchMessage(mes);

        // SfeerRequestメッセージ
        manager.addRequestSfeerListener(test);
        mes = DummyTomuMessageFactory.getSfeerRequest();
        manager.switchMessage(mes);


        // きときとアップロードメッセージ
        manager.addUploadKito2Listener(test);
        mes = DummyTomuMessageFactory.getKitokitoUpload();
        manager.switchMessage(mes);

        // 人流センサアップロードメッセージ
        manager.addUploadPedestrianListener(test);
        mes = DummyTomuMessageFactory.getSourceUpload(DummyMessageType.PEDESTRIAN);
        manager.switchMessage(mes);
        
    }
    public static void main(String[] args) {
        new Test2().doTest();
    }

    public void receiveInitRequestSfeer(InitRequestSfeerWrapper wrapper) {
        System.out.println("!!!!! Received SfeerInitRequest !!!!!");
        this.printHeader(wrapper);
        if (PRINT_WRAPPER) {
            List<AreaSetting> list = wrapper.getAreaSettingList();
            for (AreaSetting area : list) {
                System.out.println("--------- Area ID : " + area.getAreaId() + " -----------");
                System.out.println("Lat : " + area.getLat());
                System.out.println("Lon : " + area.getLon());
                System.out.println("Radius : " + area.getRadius());
                System.out.println("TimeSpan : " + area.getTimeSpanBegin() + "～" + area.getTimeSpanEnd());
            }
        }
    }

    public void receiveRequestSfeer(RequestSfeerWrapper wrapper) {
        System.out.println("!!!!! Received SfeerRequest !!!!!");
        this.printHeader(wrapper);
        if (PRINT_WRAPPER) {
            long[] ids = wrapper.getTemperatureSensorIdList();
            System.out.println("--- Temperature Sensor ID ---");
            for (long id : ids) {
                System.out.println("  " + id);
            }
            ids = wrapper.getPedestrianSensorIdList();
            System.out.println("--- Pedestrian Sensor ID ---");
            for (long id : ids) {
                System.out.println("  " + id);
            }
            Location[] locs = wrapper.getLocationList();
            System.out.println("--- Location Area ---");
            for (Location loc : locs) {
                System.out.println("Lat : " + loc.getLat());
                System.out.println("Lon : " + loc.getLon());
                System.out.println("Radius : " + loc.getRadius());
                System.out.println(">>>");
            }
        }
    }

    public void receiveUploadPedestrian(UploadPedestrianWrapper wrapper) {
        System.out.println("!!!!! Received PedestrianUpload !!!!!");
        this.printHeader(wrapper);
        if (PRINT_WRAPPER) {
            System.out.println("SensorID : " + wrapper.getSensorId());
            System.out.println("SensedTime : " + wrapper.getSensedTime());
            System.out.println("MeasurementTime : " + wrapper.getMeasurementTime());
            System.out.println("Residence : " + wrapper.getResidence());
            Axis axis = wrapper.getChiefAxis();
            System.out.println("Plus Axis : ");
            System.out.println("(Compass) " + axis.getCompass(Direction.PLUS));
            System.out.println("(Num) " + axis.getFlowValue(Direction.PLUS));
            System.out.println("(AvgSp) " + axis.getAverageSpeed(Direction.PLUS));
            System.out.println("Minus Axis : ");
            System.out.println("(Compass) " + axis.getCompass(Direction.MINUS));
            System.out.println("(Num) " + axis.getFlowValue(Direction.MINUS));
            System.out.println("(AvgSp) " + axis.getAverageSpeed(Direction.MINUS));
        }
    }

    public void receiveUploadKito2(UploadKito2Wrapper wrapper) {
        System.out.println("!!!!! Received Kito2Upload !!!!!");
        this.printHeader(wrapper);
        if (PRINT_WRAPPER) {
            System.out.println("SensorID : " + wrapper.getSensorId());
            System.out.println("SensedTime : " + wrapper.getSensedTime());
            System.out.println("Compass : " + wrapper.getCompass());
            System.out.println("Lat : " + wrapper.getLatitude());
            System.out.println("Lon : " + wrapper.getLongitude());
            System.out.println("DPI : " + wrapper.getDpi());
            System.out.println("URL : " + wrapper.getImageUrl());
            System.out.println("Thumbnail : " + wrapper.getThumbnailUrl());
        }
    }

    private void printHeader(TomuMessageWrapper wrapper) {
        if (PRINT_HEADER) {
            System.out.println("--- Header ---");
            System.out.println("MsgID : " + wrapper.getMessageId());
            System.out.println("MsgDest : " + wrapper.getDestId());
            System.out.println("MsgSrc : " + wrapper.getSourceId());
            System.out.println("MsgType : " + wrapper.getMessageType());
            System.out.println("--------------");
        }
    }
}
