package jp.osoite.tomu.util;

import java.util.*;
import java.util.regex.*;

public class PatternMatcher {

    private static final String DOT_TAG = "#dot;";
    private static final String HTTP_TAG = "#hll9;";

    private PatternMatcher() {
    }

    public static String get(String str, String patternStr) {
        return get(str, patternStr, 1);
    }

    public static String get(String str, String patternStr, int group) {
        Pattern pattern = Pattern.compile(patternStr, Pattern.DOTALL | Pattern.CASE_INSENSITIVE);
        Matcher matcher = pattern.matcher(str);
        return (matcher.find()) ? matcher.group(group) : null;
    }

    public static String[] getStrings(String str, String patternStr) {
        return getStrings(str, patternStr, 1);
    }

    public static String[] getStrings(String str, String patternStr, int group) {
        Pattern pattern = Pattern.compile(patternStr, Pattern.DOTALL | Pattern.CASE_INSENSITIVE);
        Matcher matcher = pattern.matcher(str);
        ArrayList<String> list = new ArrayList<String>();
        while (matcher.find()) {
            list.add(matcher.group(group));
        }
        return list.toArray(new String[0]);
    }

    public static String remove(String str, String patternStr) {
        return replace(str, "", patternStr);
    }

    public static String replace(String str, String replace, String patternStr) {
        Pattern pattern = Pattern.compile(patternStr, Pattern.DOTALL | Pattern.CASE_INSENSITIVE);
        Matcher matcher = pattern.matcher(str);
        return matcher.replaceAll(replace);
    }

    public static String replaceDotAndHttp(String line) {
        String result = line.replace(".", DOT_TAG).replace("http", HTTP_TAG);
        return result;
    }

    public static String reverseDotAndHttp(String line) {
        String result = line.replace(DOT_TAG, ".").replace(HTTP_TAG, "http");
        return result;
    }
}
