package jp.osoite.tomu.util;

import javax.crypto.*;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;

/**
 *
 * @author shima
 */
public class CipherUtil {

    private static final CipherUtil cipherutil = new CipherUtil();
    private Cipher cipher;
    private byte[] byteKey = {0x01, 0x07, 0x06, 0x0a,
        0x01, 0x02, 0x07, 0x0f,
        0x0d, 0x0c, 0x03, 0x0c,
        0x0a, 0x01, 0x0c, 0x0b};
    private SecretKeySpec key = new SecretKeySpec(byteKey, 0, 16, "AES");

    private CipherUtil() {
        init();
    }

    private void init() {
        try {
            cipher = Cipher.getInstance("AES/ECB/PKCS5Padding");
            cipher.init(Cipher.ENCRYPT_MODE, key);
        } catch (Exception e) {
            throw new IllegalArgumentException("Fail");
        }
    }

    public static CipherUtil getInstance() {
        return cipherutil;
    }

    public byte[] encrypt(String line) throws Exception {
        byte input[] = line.getBytes();
        return cipher.doFinal(input);
    }

    public String decrypt(byte[] encrypted) throws Exception {
        byte iv[] = cipher.getIV();
        IvParameterSpec dps = new IvParameterSpec(iv);
        cipher.init(Cipher.DECRYPT_MODE, key, dps);
        byte output[] = cipher.doFinal(encrypted);
        return new String(output);
    }
}