package jp.osoite.tomu.sensor.tscan.socks;

import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import jp.osoite.tomu.sensor.tscan.TScanValue;

/**
 *
 * @author shima
 */
public final class TScanServerConnector {

    /** OSOITE Server IP & Port Number */
    private static final String DEF_IP = "tscan.osoite.jp";
    private static final int DEF_PORT = 23401;
    private String ip;
    private int port;
    private static StringTransportNode node;
    private List<TScanReceiveListener> listenerList;

    public TScanServerConnector(String ip, int port) {
        this.ip = ip;
        this.port = port;
        listenerList = new CopyOnWriteArrayList<TScanReceiveListener>();
        init();
    }

    public TScanServerConnector() {
        this(DEF_IP, DEF_PORT);
    }

    public void addTScanReceiveListener(TScanReceiveListener listener) {
        listenerList.add(listener);
    }

    public void removeTScanReceiveListener(TScanReceiveListener listener) {
        listenerList.remove(listener);
    }

    private void notifyTScanReceiveListener(TScanValue item) {
        for (TScanReceiveListener listener : listenerList) {
            listener.receive(item);
        }
    }

    private void init() {
        try {
            node = new StringTransportNode(ip, port);
            node.addMessageReceiveListener(new StringReceiveListener() {
                public void receive(String str) {
                    try {
                        notifyTScanReceiveListener(new TScanValue(str));
                    } catch (Exception e) {
                    }
                }
            });
        } catch (Exception e) {
        }
    }
}
