package jp.osoite.tomu.sensor.pedestrian;

import jp.osoite.tomu.xml.jaxb.util.SensorType;
import jp.osoite.tomu.xml.jaxb.wrapper.Axis;
import jp.osoite.tomu.xml.jaxb.wrapper.Axis.Direction;

/**
 *
 * @author shima
 */
public class PedestrianFlowValue {

    private long time;
    private Axis chiefAxis;
    private int residence;
    private long arrivedTime;
    private int frequency;
    private long sensorid;

    public PedestrianFlowValue(long time, Axis axis, int resi, int fre) {
        this.time = time;
        chiefAxis = axis;
        residence = resi;
        arrivedTime = System.currentTimeMillis();
    }

    public SensorType getType() {
        return SensorType.PEDESTRIAN;
    }

    public long getMeasurementTime() {
        return time;
    }

    public long getSensorID() {
        return sensorid;
    }

    public Axis getChiefAxis() {
        return chiefAxis;
    }

    public int getResidence() {
        return residence;
    }

    public long getTime() {
        return time;
    }

    public int getAllNumber() {
        return residence + chiefAxis.getFlowValue(Direction.PLUS) + chiefAxis.getFlowValue(Direction.MINUS);
    }

    public int getFrequency() {
        return frequency;
    }

    /**
     * @param sensorid the sensorid to set
     */
    public void setSensorid(long sensorid) {
        this.sensorid = sensorid;
    }

    public String printPedestrian() {

        StringBuilder bld = new StringBuilder();

        bld.append(", MeasurementTimeSec : " + this.getMeasurementTime() + ", ");


        bld.append("ChiefAxis Plus :(");
        bld.append("Num :" + this.getChiefAxis().getFlowValue(Direction.PLUS) + ",");
        bld.append("AvgSpd :" + getChiefAxis().getAverageSpeed(Direction.PLUS) + "), ");

        bld.append("ChiefAxis Minus :(");
        bld.append("Num :" + this.getChiefAxis().getFlowValue(Direction.MINUS) + ",");
        bld.append("AvgSpd :" + getChiefAxis().getAverageSpeed(Direction.MINUS) + "), ");

        bld.append("Residence : " + getResidence() + "");

        return bld.toString();

    }
}
