package jp.osoite.tomu.net.xmpp.utils;

/**
 * This class sends dammy messages.
 * created by shima at 2010/1/9
 * updated by shima at 2010/1/12
 * updated by shima at 2010/1/18
 * @author shima
 */
public class MessageFormatter {

    public static final int RES = 0;
    public static final int CONTROL = 1;
    public static final int ALL_SENSOR_PROPERTIES = 10;
    public static final int SENSOR_PROPERTIES = 11;
    public static final int SENSOR_DATASET = 12;
    public static final int CURRENT_SENSOR_DATA = 13;
    private static StringBuilder builder;

    public static String getTomuMessage(String destID, String srcID) {
        builder = new StringBuilder("<tomu_query>");
        setHeader(RES, destID, srcID);
        builder.append("<ResQuery><SensorDataSet><Seq>201004011200000</Seq><NumberOfSensorData>4</NumberOfSensorData>");
        builder.append("<StaticSensorData>");
        builder.append("<Type>TEMP</Type><SensedTime>201003310123456</SensedTime><StaticSensorID>201003251424053</StaticSensorID><Value>6.3</Value>");
        builder.append("</StaticSensorData>");
        builder.append("<StaticSensorData>");
        builder.append("<Type>IMAGE</Type><SensedTime>201003310154321</SensedTime><SensorName>dendai camera</SensorName>");
        builder.append("<Location><Lat>38.53</Lat><Lon>141.02</Lon></Location><Direction>283</Direction><Value>http://www.hogehoge.jp/picture/201003310154321.jpg</Value>");
        builder.append("</StaticSensorData>");
        builder.append("<StaticSensorData>");
        builder.append("<Type>PEDESTRIAN</Type><SensedTime>201003310130000</SensedTime><StaticSensorID>201003221542235</StaticSensorID>");
        builder.append("<Value><StreetPedestrianFlowValue><MeasurementTimeSec>60</MeasurementTimeSec>");
        builder.append("<ChiefAxis><Plus>1</Plus><Minus>10</Minus></ChiefAxis><Residence>6</Residence></StreetPedestrianFlowValue></Value>");
        builder.append("</StaticSensorData>");
        builder.append("<StaticSensorData>");
        builder.append("<Type>INTER_PEDESTRIAN</Type><SensedTime>201003310120000</SensedTime><StaticSensorID>201003202002539</StaticSensorID>");
        builder.append("<Value><StreetPedestrianFlowValue><MeasurementTimeSec>60</MeasurementTimeSec><ChiefAxis><Plus>1</Plus><Minus>10</Minus></ChiefAxis>");
        builder.append("<SubAxis><Plus>5</Plus><Minus>2</Minus></SubAxis><Residence>6</Residence></StreetPedestrianFlowValue></Value>");
        builder.append("</StaticSensorData>");
        builder.append("</SensorDataSet></ResQuery>");
        builder.append("</tomu_query>");
        return builder.toString();
    }

    /**
     * This class creates a dammy tomu query.
     * @param type message type
     * @param destID destination ID (XMPP ID such as Google talk account)
     * @param srcID source ID (XMPP ID such as Google talk account)
     * @return a dammy Tomu message
     */
    public static String getTomuMessage(int type, String destID, String srcID) {
        throw new UnsupportedOperationException("Please use \"getTomuMessage(String destID, String srcID)\"");
    /**
    builder = new StringBuilder("<tomu_query>");
    setHeader(type, destID, srcID);
    builder.append("<body>");
    switch (type) {
    case ALL_SENSOR_PROPERTIES:
    setAllSensorProperties();
    break;
    case SENSOR_PROPERTIES:
    setSensorProperty();
    break;
    case SENSOR_DATASET:
    setSensorDataSet();
    break;
    case CURRENT_SENSOR_DATA:
    setCurrentSensorData();
    break;
    case RES:
    break;
    case CONTROL:
    setControlMessage();
    break;
    }
    builder.append("</body>");
    builder.append("</tomu_query>");
    return builder.toString();
     */
    }

    /**
     * Adding header to Tomu message.
     * @param type message type
     * @param destID destination ID (XMPP ID such as Google talk account)
     * @param srcID source ID (XMPP ID such as Google talk account)
     */
    private static void setHeader(int type, String destID, String srcID) {
        builder.append("<head>");
        builder.append("<msg_type>" + type + "</msg_type>");
        builder.append("<msg_id>" + System.currentTimeMillis() + "</msg_id>");
        builder.append("<dest>" + destID + "</dest>");
        builder.append("<src>" + srcID + "</src>");
        builder.append("</head>");
    }

    private static void setAllSensorProperties() {
        builder.append("<SensorProperty>");
        builder.append("<SensorID>" + System.currentTimeMillis() + "</SensorID>");
        builder.append("<SensorName>CAMERA</SensorName>");
        builder.append("<location><Lat>0.0</Lat><Lon>0.0</Lon></location>");
        builder.append("<Direction>180</Direction>");
        builder.append("</SensorProperty>");
        setSensorProperty();
    }

    private static void setSensorProperty() {
        builder.append("<SensorProperty>");
        builder.append("<SensorID>" + System.currentTimeMillis() + "</SensorID>");
        builder.append("<SensorName>HUMI</SensorName>");
        builder.append("<location><Lat>1.11</Lat><Lon>1.11</Lon></location>");
        builder.append("<Direction>90</Direction>");
        builder.append("</SensorProperty>");
    }

}