package jp.osoite.tomu.net.xmpp.utils;


import java.util.Collection;
import jp.osoite.tomu.net.xmpp.KskMessageTransfer;


public class KskMessageCreator {
	/**
	 * Tomuメ�?��ージ生�?クラス
	 * ネットワーク上へ出るメ�?��ージの生�?を行う
	 **/

	public void createMessage(TomuMessageKskVersion tomuMsg){
		int code = Integer.parseInt(tomuMsg.getMsgCode());
		StringBuffer rawMsg = new StringBuffer();
		rawMsg.append("<tomu_msg>");
		rawMsg.append("<head>");
		rawMsg.append("<msg_code>" + tomuMsg.getMsgCode() + "</msg_code>");
		rawMsg.append("<msg_id>" + tomuMsg.getMsgID() + "</msg_id>");
		rawMsg.append("<dst>" + tomuMsg.getDst() + "</dst>");
		rawMsg.append("<src>" + tomuMsg.getSrc() + "</src>");
		rawMsg.append("</head>");
		rawMsg.append("<body>");

		if(code == 101){
			System.out.println("101@MessageCreator");
			Collection<Tomu> tomulist = tomuMsg.getTomuList();
			Tomu tomu = (Tomu)tomulist.toArray()[0];
			rawMsg.append("<usml_config>");
			rawMsg.append("<id>" + tomu.getID() + "</id>");
			rawMsg.append("<sensor_profile>");
			rawMsg.append("<cover_area>" + tomu.getCoverarea() + "</cover_area>");
			rawMsg.append("<timespan>" + tomu.getTimespan() + "</timespan>");
			Collection<BasicSensor> sensorlist = tomu.getSensorList();
			for(BasicSensor sensor : sensorlist){
				rawMsg.append("<sensor>");
				rawMsg.append("<type>" + sensor.getType() + "</type>");
				rawMsg.append("<cover_area>" + sensor.getCoverarea() + "</cover_area>");
				rawMsg.append("<timespan>" + sensor.getTimespan() + "</timespan>");
				rawMsg.append("</sensor>");
			}	
			rawMsg.append("</sensor_profile>");
			rawMsg.append("</usml_config>");
		}

		else if(code == 102){
			System.out.println("102@MessageCreator");			
			rawMsg.append("<eca>" + "</eca>");
			rawMsg.append("<usml_context>" + "USML Context" + "</usml_context>");
			rawMsg.append("<tomu_config>");
			Collection<Tomu> tomulist = tomuMsg.getTomuList();
			for(Tomu tomu : tomulist){
				rawMsg.append("<usml_config>");
				rawMsg.append("<id>" + tomu.getID() + "</id>");
				rawMsg.append("<sensor_profile>");
				rawMsg.append("<cover_area>" + tomu.getCoverarea() + "</cover_area>");
				rawMsg.append("<timespan>" + tomu.getTimespan() + "</timespan>");
				Collection<BasicSensor> sensorlist = tomu.getSensorList();
				for(BasicSensor sensor : sensorlist){
					rawMsg.append("<sensor>");
					rawMsg.append("<type>" + sensor.getType() + "</type>");
					rawMsg.append("<cover_area>" + sensor.getCoverarea()+ "</cover_area>");
					rawMsg.append("<timespan>" + sensor.getTimespan() + "</timespan>");
					rawMsg.append("</sensor>");	
				}
				rawMsg.append("</sensor_profile>");
				rawMsg.append("</usml_config>");
			}
			rawMsg.append("</tomu_config>");
		}

		else if(code == 103){
			System.out.println("103@MessageCreator");
			Collection<Tomu> tomulist = tomuMsg.getTomuList();
			Tomu tomu = (Tomu)tomulist.toArray()[0];
			rawMsg.append("<usml_config>");
			rawMsg.append("<id>" + tomu.getID() + "</id>");
			rawMsg.append("<sensor_profile>");
			rawMsg.append("<cover_area>" + tomu.getCoverarea() + "</cover_area>");
			rawMsg.append("<timespan>" + tomu.getTimespan() + "</timespan>");
			Collection<BasicSensor> sensorlist = tomu.getSensorList();
			for(BasicSensor sensor : sensorlist){
				rawMsg.append("<sensor>");
				rawMsg.append("<type>" + sensor.getType() + "</type>");
				rawMsg.append("<cover_area>" + sensor.getCoverarea() + "</cover_area>");
				rawMsg.append("<timespan>" + sensor.getTimespan() + "</timespan>");
				rawMsg.append("</sensor>");
			}	
			rawMsg.append("</sensor_profile>");
			rawMsg.append("</usml_config>");
		}

		rawMsg.append("</body>");
		rawMsg.append("</tomu_msg>");

		tomuMsg.setTomuMsg(rawMsg.toString());
		System.out.println("STR: " + tomuMsg.getTomuMsg());

		KskMessageTransfer mTransfer = new KskMessageTransfer(tomuMsg);
		Thread threadMT = new Thread(mTransfer);
		threadMT.start();
		//mTransfer.sendMessage(tomuMsg);
	}

}
