package jp.osoite.tomu.net.xmpp.usmls;

import jp.osoite.tomu.net.xmpp.utils.*;
import java.io.*;
import java.util.*;

import org.xml.sax.*;


public class KskUSMLParser extends KskXMLParser{
	
	private Tomu tomu;
	private BasicSensor sensor;
	private Hashtable<String, Tomu> mlist;

	//private Stack<StringBuffer> msgStack;
	private StringBuffer buffer;
	
	public KskUSMLParser(){}

	public void parseMessage(Hashtable<String, Tomu> mlist, File file){
		this.mlist = mlist;
		parseMessage(file);
	}		

	public void parseMessage(Hashtable<String, Tomu> mlist, String msg){
		this.mlist = mlist;
		parseMessage(msg);
	}

	public void startDocument(){
		//System.out.println("Start Document!!");
		//msgStack = new Stack<StringBuffer>();
	}

	public void startElement(String uri, String localName, String qName, Attributes attributes){
		//System.out.println("Start Element: " + uri);
		//System.out.println("Start Element: " + localName);
		//System.out.println("Start Element: " + qName);
		//System.out.println("Start Element: " + attributes);

		if("usml_config".equals(qName)){ 
			tomu = new Tomu(); 
		}
		else if("sensor".equals(qName)){
			sensor = new BasicSensor();
		}
		buffer = new StringBuffer();
		//msgStack.push(buffer);
	}

	public void characters(char[] ch, int offset, int length){
		//System.out.println("Text Data: " + new String(ch, offset, length));

		buffer.append(new String(ch, offset, length));
	}

	public void endElement(String uri, String localName, String qName){
		//System.out.println("End Element: " + uri);
		//System.out.println("End Element: " + localName);
		//System.out.println("End Element: " + qName);

		if("usml_config".equals(qName)){
			if(!(mlist.containsKey(tomu.getID()))){ 
				mlist.put(tomu.getID(), tomu); 
			}
			if(mlist.containsKey(tomu.getID())){
				mlist.remove(tomu.getID());
				mlist.put(tomu.getID(), tomu);
			}
			sensor = null;
		}
		else if("id".equals(qName)){
			tomu.setID(buffer.toString()); 
		}
		else if("cover_area".equals(qName)){
			if(sensor == null) 
				tomu.setCoverarea(buffer.toString());
			else
				sensor.setCoverarea(buffer.toString());
		}
		else if("timespan".equals(qName)){
			if(sensor == null)
				tomu.setTimespan(buffer.toString());
			else
				sensor.setTimespan(buffer.toString());
		}
		else if("type".equals(qName)){
			sensor.setType(buffer.toString());
		}
		else if("sensor".equals(qName)){
			tomu.addSensorList(sensor);
		}
	}

	public void endDocument(){
		//System.out.println("End Document!!");
	}
}

/*
	public String  getTagContent(String msg, String tag){
		String patternStr = new String("<" + tag + ">.*</" + tag + ">");
		Pattern pattern = Pattern.compile(patternStr, Pattern.DOTALL | Pattern.CASE_INSENSITIVE);
		Matcher matcher = pattern.matcher(msg);
		return (matcher.find()) ? matcher.group() : null;
	}
*/
/*
	public void parseMessage(String str){
		try{
			SAXParserFactory spfactory = SAXParserFactory.newInstance();
			SAXParser parser = spfactory.newSAXParser();
			//parser.parse(new ByteArrayInputStream(str.getBytes()),new KskXMLParser());
			parser.parse(new ByteArrayInputStream(str.getBytes()),this);
		} catch (Exception e) {
			e.printStackTrace();
		}
	}
*/
