/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package jp.osoite.tomu.net.mail;

/**
 *
 * @author tailor
 */
import java.security.Security;
import java.util.Date;
import java.util.Properties;

import java.util.logging.Level;
import java.util.logging.Logger;
import javax.mail.Authenticator;
import javax.mail.Message;
import javax.mail.PasswordAuthentication;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;

/**
 * メール送信クラス。
 *
 */
public class JavaMailSend {

    private Session session;

    static JavaMailSend send = new JavaMailSend();

    public static JavaMailSend getInstance(){
        if(send!=null)
                send = new JavaMailSend();
        return send;
    }
    public final String TO_MAIL_ADDRESS="notify_err_tomu@u-netlab.jp";
    //public final String TO_MAIL_ADDRESS="masa@iis.u-tokyo.ac.jp";
    //return send("masa@iis.u-tokyo.ac.jp","notify_err_tomu@u-netlab.jp"
    private JavaMailSend() {
        Security.addProvider(new com.sun.net.ssl.internal.ssl.Provider());
        final String SSL_FACTORY = "javax.net.ssl.SSLSocketFactory";
        /* property set */
        Properties props = System.getProperties();
        props.setProperty("mail.smtp.host", "smtp.gmail.com");
        props.setProperty("mail.smtp.socketFactory.class", SSL_FACTORY);
        props.setProperty("mail.smtp.socketFactory.fallback", "false");
        props.setProperty("mail.smtp.port","465");

        props.setProperty("mail.smtp.socketFactory.port","465");

        props.put("mail.smtp.auth", "true");
        session = Session.getDefaultInstance(props, new Authenticator() {

            protected PasswordAuthentication getPasswordAuthentication() {
                return new PasswordAuthentication("tomukanri@gmail.com", "osoiteTomu");
            }
        });


       

        
    }

    /**
    　 * メール送信。
    　 * 送信できたら、trueを返す。
    　 *
    　 * @param email
    　 * @param title
    　 * @param body
    　 * @return boolean
    　 */
    public boolean send(String email, String title, String body) {
        boolean sendCheck = true;
        try {
            MimeMessage mimeMessage = new MimeMessage(session);
            /* 送信元メールアドレスと送信者名を指定 */
            mimeMessage.setFrom(new InternetAddress("tomukanri@gmail.com",
                    "tomukanrisha", "iso-2022-jp"));
            /* 送信先メールアドレスを指定 */
            mimeMessage.setRecipients(Message.RecipientType.TO, email);
            /* メールのタイトルを指定 */
            mimeMessage.setSubject(title, "iso-2022-jp");
            /* メールの内容を指定 */
            mimeMessage.setText(body, "iso-2022-jp");
            /* 送信日付を指定 */
            mimeMessage.setSentDate(new Date());
            /* 送信します */
            Transport.send(mimeMessage);
        } catch (Exception e) {
            System.err.println("mail 送信エラー");
            e.printStackTrace();
            sendCheck = false;
        }

        return sendCheck;
    }

    public boolean send_againmsg(String msgbody,long sensorID){
        return send(TO_MAIL_ADDRESS,
                "[TomuTatebayashi]人流計測再開:"+sensorID,
                "人流センサ"+sensorID+"からのデータ受信を再開しました。\n" +
                "=======================\n"+
                msgbody+"\n"+
                "=======================\n"+
                "現在サーバ時間 :"+ new Date().toString()+"\n"+
                "-------------\n"+
                "From TomuCore Dev Group");
    }

    public boolean send_errmsg(int m,String msgbody,long sensorID){
        
        return send(TO_MAIL_ADDRESS,
                "[TomuTatebayashi]人流計測不可:"+sensorID,
                "注意 \n" +
                "人流センサ"+sensorID+"からのデータを"+m+"分以上受信していません。\n\n" +
                "=======================\n"+
                msgbody+"\n"+
                "=======================\n"+
                "現在サーバ時間 :"+ new Date().toString()+"\n"+
                "-------------\n"+
                "From TomuCore Dev Group");
    }
    /**
     * Main Method.
     * @param args
     */
    public static void main(String[] args) {
        JavaMailSend send = new JavaMailSend();
        send.send("notify_err_tomu@u-netlab.jp", "受信間隔エラー", "5分以上受信していません。");
    }   
}