package jp.osoite.tomu.itree.list;

import jp.osoite.tomu.itree.util.Constants;

/* class SortMbr is used to store mbrs to be sorted. Used in ITNode.split()
 * and ITDataNode.insert().
 */

public class SortMbr implements Sortable
{
    private int dimension; 	// the dimension of the MBR according to which the sorting is done
    public float mbr[]; 	// the data of the MBR
    private float center[];	// the MBR's centroid
    private int index;		// the MBR's index inside an array of mbrs
    
    private float compute_erg(Sortable s, int sortCriterion)
    {
        float erg = (float)0.0;
        switch(sortCriterion)
        {
            case Constants.SORT_LOWER_MBR:
                erg = this.mbr[2*getDimension()] - ((SortMbr)s).mbr[2*getDimension()];
                break;
            case Constants.SORT_UPPER_MBR:
                erg = this.mbr[2*getDimension()+1] - ((SortMbr)s).mbr[2*getDimension()+1];
                break;
            case Constants.SORT_CENTER_MBR:
                float d, e1, e2;
                
                e1 = e2 = (float)0.0;
                for (int i = 0; i < getDimension(); i++)
                {
                    d = ((this.mbr[2*i] + this.mbr[2*i+1]) / (float)2.0) - this.getCenter()[i];
                    e1 += d*d;
                    d = ((((SortMbr)s).mbr[2*i] + ((SortMbr)s).mbr[2*i+1]) / (float)2.0) - ((SortMbr)s).getCenter()[i];
                    e2 += d*d;
                }
                
                erg = e1 - e2;
                break;
        }
        return erg;
    }
    
    public boolean lessThan(Sortable s, int sortCriterion)
    {
        float erg = compute_erg(s, sortCriterion);
        if (erg < (float)0.0)
            return true;
        return false;
    }
                
    public boolean greaterThan(Sortable s, int sortCriterion)
    {
        float erg = compute_erg(s, sortCriterion);
        if (erg > (float)0.0)
            return true;
        return false;
    }

	public int setIndex(int index) {
		this.index = index;
		return index;
	}

	public int getIndex() {
		return index;
	}

	public int setDimension(int dimension) {
		this.dimension = dimension;
		return dimension;
	}

	public int getDimension() {
		return dimension;
	}

	public void setCenter(float center[]) {
		this.center = center;
	}

	public float[] getCenter() {
		return center;
	}

	public void setMbr(float[] get_mbr) {
		this.mbr = get_mbr;
	}
}