/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package jp.osoite.tomu.core.main;

//import com.sun.spot.util.IEEEAddress;
import jp.osoite.tomu.util.NumberUtil;
import java.io.Serializable;
import java.text.DateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Random;
import java.util.TimeZone;


//IEEEAddress.toDottedHex(fromAddrLong)
/**
 *
 * @author masa
 */
public class SensorVals implements Serializable{
    public int TILT_BASE = 500;
    public int ACCEL_BASE= 100;
    private double tempVal;
    private double accelX;
    private double accelY;
    private double accelZ;
    private double tiltX;
    private double tiltY;
    private double tiltZ;

    private int lightSensorVal;
    private double remainingBattery;
    private int internalCounter=0;
    private long fromAddrLong;
    private int freq;

    private int rssi=0;
    public static final String SN_LIGHT="light";
    public static  final String SN_AX="ax";
    public static  final String SN_AY="ay";
    public static  final String SN_AZ="az";
    public static  final String SN_TX="tx";
    public static  final String SN_TY="ty";
    public static  final String SN_TZ="tz";

    public static  final String SN_MOVE="move";
    public static  final String SN_TEMP="temp";
    public static  final String SN_BATT="batt";
    public static  final String SN_FREQ="freq";
    public static  final String SN_RSSI="rssi";
    public static  final String SN_ICOUNTER="counter";
    /*
    public static  final String  SN_HMP_N="hMP_N";
    public static  final String  SN_HMP_S="hMP_S";
    public static  final String  SN_HMM_N="hMM_N";
    public static  final String  SN_HMM_S="hMM_S";
    public static  final String  SN_HREG="hREG";
    */
    public static  final String  SN_HMP_N="右方向人数";
    public static  final String  SN_HMP_S="右方向速度";
    public static  final String  SN_HMM_N="左方向人数";
    public static  final String  SN_HMM_S="左方向速度";
    public static  final String  SN_HREG="滞留人数";

    public static  final int INT_LIGHT=0;
    public static  final int INT_AX=1;
    public static  final int INT_AY=2;
    public static  final int INT_AZ=3;
    public static  final int INT_TX=4;
    public static  final int INT_TY=5;
    public static  final int INT_TZ=6;

    public static  final int INT_MOVE=7;
    public static  final int INT_TEMP=8;
    public static  final int INT_BATT=9;
    public static  final int INT_RSSI=10;
    public static  final int INT_FREQ=11;
    public static  final int INT_ICOUNTER=12;


    public static  final int INT_HMP_N=13;
    public static  final int INT_HMP_S=14;
    public static  final int INT_HMM_N=15;
    public static  final int INT_HMM_S=16;
    public static  final int INT_HREG=17;
    
    private String sensorName="";
    private long dataArrivedTimer=0;
    
public SensorVals(long timer,long fromAddr,String sensorName,int internalCounter,double tempSensorVal, double accelX, double accelY, double accelZ, double tiltX, double tiltY, double tiltZ,int lightSensorVal, double remainingBattery,int freq,int rssi) {
    this(fromAddr,sensorName,internalCounter,tempSensorVal, accelX, accelY, accelZ, tiltX, tiltY, tiltZ,lightSensorVal, remainingBattery,freq,rssi);
    this.dataArrivedTimer=timer;
}

    public SensorVals(long fromAddr,String sensorName,int internalCounter,double tempSensorVal, double accelX, double accelY, double accelZ, double tiltX, double tiltY, double tiltZ,int lightSensorVal, double remainingBattery,int freq,int rssi) {
        //this(fromAddrLong,sensorName,internalCounter,tempSensorVal,accelX,accelY, accelZ, tiltX, tiltY, tiltZ,lightSensorVal,remainingBattery,freq);
        this.rssi=rssi;
        this.tiltX=tiltX;//NumberUtil.roundupThree(tiltX);
        this.tiltY=tiltY;//NumberUtil.roundupThree(tiltY);
        this.tiltZ=tiltZ;//NumberUtil.roundupThree(tiltZ);
        this.freq=freq;
        this.sensorName=sensorName;
        this.freq=freq;
        this.fromAddrLong=fromAddr;
        this.internalCounter=internalCounter;
        this.tempVal = tempSensorVal;
        //iwai
        this.accelX = accelX; //NumberUtil.roundupThree(accelX);
        this.accelY = accelY;//NumberUtil.roundupThree(accelY);
        this.accelZ = accelZ;//NumberUtil.roundupThree(accelZ);
        this.lightSensorVal = lightSensorVal;
        this.remainingBattery = remainingBattery;
        this.dataArrivedTimer=System.currentTimeMillis();
    }

    /*
    public SensorVals(long fromAddrLong,String sensorName,int internalCounter,double tempSensorVal, double accelX, double accelY, double accelZ, double tiltX, double tiltY, double tiltZ,int lightSensorVal, double remainingBattery,int freq) {
        this(fromAddrLong,internalCounter,tempSensorVal, accelX, accelY,accelZ, lightSensorVal, remainingBattery);
        this.tiltX=NumUtil.roundup(tiltX);
        this.tiltY=NumUtil.roundup(tiltY);
        this.tiltZ=NumUtil.roundup(tiltZ);
        this.freq=freq;
        this.sensorName=sensorName;

    }


    public SensorVals(long fromAddrLong,String sensorName,int internalCounter,double tempSensorVal, double accelX, double accelY, double accelZ, int lightSensorVal, double remainingBattery,int freq) {
        this(fromAddrLong,internalCounter,tempSensorVal, accelX, accelY,accelZ, lightSensorVal, remainingBattery);
        this.freq=freq;
        this.sensorName=sensorName;

    }

    public SensorVals(long fromAddrLong,int internalCounter,double tempSensorVal, double accelX, double accelY, double accelZ, int lightSensorVal, double remainingBattery) {
        this.fromAddrLong=fromAddrLong;
        this.internalCounter=internalCounter;
        this.tempVal = tempSensorVal;
        this.accelX = NumUtil.roundup(accelX);
        this.accelY = NumUtil.roundup(accelY);
        this.accelZ = NumUtil.roundup(accelZ);
        this.lightSensorVal = lightSensorVal;
        this.remainingBattery = remainingBattery;
    }

    */
    public SensorVals(){

        Random rand = new Random();
        
        this.fromAddrLong=9999999;
        this.sensorName="DammySensor";
        this.internalCounter=(int)System.currentTimeMillis();
        this.accelX = 0.1+(rand.nextDouble()/2);
        this.accelY = 0.1+(rand.nextDouble()/2);
        this.accelZ = 0.1+(rand.nextDouble()/2);

        this.tiltX = 0.1+(rand.nextDouble()/2);
        this.tiltY = 0.1+(rand.nextDouble()/2);
        this.tiltZ = 0.1+(rand.nextDouble()/2);
        
        this.tempVal = 32.0+(rand.nextDouble()*2);;
        this.lightSensorVal = (int) (300 + (rand.nextInt())%1);//6
        this.remainingBattery = 504.0+(rand.nextInt()%1);;//10
        this.freq=5;
        this.rssi=15;
        this.dataArrivedTimer=System.currentTimeMillis();
    }


    public SensorVals(String sensorName){
        this();
        this.sensorName=sensorName;
        //0014.4F01.0000.7221
    }
     
    
    public double getTempSensorVal() {
        return tempVal;
    }

        /**
     * @return the tempVal
     */
    public int getTempSensorValbyIngeter() {
        return (int)(tempVal*10);
    }

    

    
    /**
     * @return the lightSensorVal
     */
    public int getLightSensorVal() {
        return lightSensorVal;
    }


    /**
     * @return the remainingBattery
     */
    public double getRemainingBattery() {
        return remainingBattery;
    }

     /**
     * @return the remainingBattery
     */
    public int getRemainingBatterybyInteger() {
        return (int)remainingBattery;
    }

    /**
     * @param remainingBattery the remainingBattery to set
     */
    public void setRemainingBattery(double remainingBattery) {
        this.remainingBattery = remainingBattery;
    }


    public double getTiltX() {
        return tiltX;
    }
    public int getTiltXbyInteger() {
        
        return (int)(tiltX*100)+TILT_BASE;
    }
    public double getTiltY() {
        return tiltY;
    }
    public int getTiltYbyInteger() {
        return (int)(tiltY*100)+TILT_BASE;
    }
    public double getTiltZ() {
        return tiltZ;
    }
    public int getTiltZbyInteger() {
        return (int)(tiltZ*100)+TILT_BASE;
    }

    /**
     * @return the accelX
     */
    public double getAccelX() {
        return accelX;
    }
    public int getAccelXbyInteger() {
        return (int)(accelX*100)+ACCEL_BASE;
    }

    /**
     * @param accelX the accelX to set
     */
    public void setAccelX(double accelX) {
        this.accelX = accelX;
    }

    /**
     * @return the accelY
     */
    public double getAccelY() {
        return accelY;
    }

    public int getAccelYbyInteger() {
        return (int)(accelY*100)+ACCEL_BASE;
    }

    /**
     * @param accelY the accelY to set
     */
    public void setAccelY(double accelY) {
        this.accelY = accelY;
    }

    /**
     * @return the accelZ
     */
    public double getAccelZ() {
        return accelZ;
    }
    public int getAccelZbyInteger() {
        return (int)(accelZ*100)+ACCEL_BASE;
    }

    /**
     * @param accelZ the accelZ to set
     */
    public void setAccelZ(double accelZ) {
        this.accelZ = accelZ;
    }

    public int getAllMovementbyInteger() {
        int movement=(int)( 100*(Math.abs(this.getAccelX()) + Math.abs(this.getAccelY()) + Math.abs(this.getAccelZ()) + Math.abs(this.getTiltX()) + Math.abs(this.getTiltY()) + Math.abs(this.getTiltZ())));
        return   movement;
    }



    /**
     * @return the internalCounter
     */
    public int getInternalCounter() {
        return internalCounter;
    }


    /**
     * @param internalCounter the internalCounter to set
     */
    public void setInternalCounter(int incounter) {
        this.internalCounter = incounter;
    }


    public String getSensorName() {
        return sensorName;
    }

     public static String getShortSensorName(String sensorname) {
        return sensorname.substring(15);
    }

    public String getShortSensorName() {
        return sensorName.substring(15);
    }
    /**
     * @return the fromAddrLong
     */
    public long getFromAddrLong() {
        return fromAddrLong;
    }

    /**
     * @param fromAddrLong the fromAddrLong to set
     */
    public void setFromAddrLong(long fromAddrLong) {
        this.fromAddrLong = fromAddrLong;
    }


    /*
    public String getTimeFormatted(){
        DateFormat fmt = DateFormat.getDateTimeInstance();
        return fmt.format(new Date(internalCounter));
        
    }*/
    

    public String getTimeStamp(){
        Calendar cal =Calendar.getInstance(TimeZone.getTimeZone("Asia/Tokyo"));
        String ts = null;

        //���̏C������
        cal.setTime(new Date(this.getDataArrivedTimer()));
        //cal.setTime(new Date(System.currentTimeMillis()));
        cal.setTimeZone(TimeZone.getTimeZone("Asia/Tokyo"));

        ts = cal.get(Calendar.YEAR) + "-" +
                (1 + cal.get(Calendar.MONTH)) + "-" +
                cal.get(Calendar.DAY_OF_MONTH) + " " +
                cal.get(Calendar.HOUR_OF_DAY) + ":" +
                cal.get(Calendar.MINUTE) + ":" +
                cal.get(Calendar.SECOND);
        return ts;
    }

    /**
     * @return the freq
     */
    public int getFreq() {
        return freq;
    }

    /**
     * @param freq the freq to set
     */
    public void setFreq(int freq) {
        this.freq = freq;
    }

    public String getSQLInsertStmt(String DATA_TABLE_NAME){
        String  insertStmtStr="INSERT INTO " + DATA_TABLE_NAME +
                //"(sensorid,timestamp,internalCounter,light,temp,ax,ay,az,movement,battery,frequency)" +
                "(sensorid,timestamp,timer,light,temp,ax,ay,az,tx,ty,tz,movement,rssi,battery,frequency)" +
                " VALUES(\'" + getSensorName() + "\',\'"+ getTimeStamp()+ "\',\'"+this.getDataArrivedTimer()//+getInternalCounter()
                + "\',\'" + getLightSensorVal()
                + "\',\'" + getTempSensorVal()
                + "\',\'" + getAccelX()
                + "\',\'" + getAccelY()
                + "\',\'" + getAccelZ()
                + "\',\'" + getTiltX()
                + "\',\'" + getTiltY()
                + "\',\'" + getTiltZ()
                + "\',\'" + getAllMovementbyInteger()
                + "\',\'" + getRssi()
                + "\',\'" + getRemainingBattery()
                + "\',\'" + getFreq()
                + "\')";
          return insertStmtStr;

    }

    public void printConsl(){


        System.out.println("======================");
          String str=getSensorName() + "\',\'"+ getTimeStamp()+ "\',\'"+getInternalCounter()
                + "\',\'" + getLightSensorVal()
                + "\',\'" + getTempSensorVal()
                + "\',\'" + getAccelX()
                + "\',\'" + getAccelY()
                + "\',\'" + getAccelZ()
                + "\',\'" + getAllMovementbyInteger()
                + "\',\'" + getRemainingBattery();
          System.out.println(str);
          System.out.println("======================");
          
    }

    public String toStringByAllIntVal(){
        StringBuffer strbuff = new StringBuffer();
        strbuff.append("@("+getShortSensorName()+")");
        strbuff.append(" : ");
        //strbuff.append(this.getTimeFormatted());
        strbuff.append(this.getTimeStamp());
        strbuff.append(" : ");
        strbuff.append(SN_AX+"*"+"="+this.getAccelX()+", ");
        strbuff.append(SN_AY+"*"+"="+this.getAccelY()+", ");
        strbuff.append(SN_AZ+"*"+"="+this.getAccelZ()+", ");
        strbuff.append(SN_TX+"*"+"="+this.getTiltX()+", ");
        strbuff.append(SN_TY+"*"+"="+this.getTiltY()+", ");
        strbuff.append(SN_TZ+"*"+"="+this.getTiltZ()+", ");
        strbuff.append(SN_MOVE+"="+this.getAllMovementbyInteger()+", ");

        strbuff.append(SN_LIGHT+"="+this.getLightSensorVal()+", ");
/*        strbuff.append(SN_AX+"="+this.getAccelXbyInteger()+", ");
        strbuff.append(SN_AY+"="+this.getAccelYbyInteger()+", ");
        strbuff.append(SN_AZ+"="+this.getAccelZbyInteger()+", ");*/
        strbuff.append(SN_TEMP+"="+this.getTempSensorVal()+", ");
        strbuff.append(SN_BATT+"="+this.getRemainingBatterybyInteger()+", ");
        strbuff.append(SN_RSSI+"="+this.getRssi()+", ");
        strbuff.append(SN_FREQ+"="+this.getFreq());


        return strbuff.toString();

    }

    /**
     * @param sensorName the sensorName to set
     */
    public void setSensorName(String sensorName) {
        this.sensorName = sensorName;
    }

    /**
     * @return the rssi
     */
    public int getRssi() {
        return rssi;
    }

    public int getRssiByInteger() {
        return rssi*2+300;
    }

    /**
     * @return the dataArrivedTimer
     */
    public long getDataArrivedTimer() {
        return dataArrivedTimer;
    }

    /**
     * @param dataArrivedTimer the dataArrivedTimer to set
     */
    public void setDataArrivedTimer(long dataArrivedTimer) {
        this.dataArrivedTimer = dataArrivedTimer;
    }


}
