/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package jp.osoite.tomu.core.db.mysql;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.TimeZone;
import jp.osoite.tomu.core.main.UtilSensorID;
import jp.osoite.tomu.sensor.pedestrian.PedestrianFlowValue;
import jp.osoite.tomu.xml.jaxb.util.TimeConverter;
import jp.osoite.tomu.xml.jaxb.wrapper.Axis.Direction;

/**
 *
 * @author tailor
 */
public class PedestrianSensorValueHelper {

    public static String getPSQLStmt2CreatePedestrianTable(String datatablename2) {
        System.out.println("@@@@ pedestrian db is called :" + datatablename2);
        String stmtStatistics3_create_predestrian = "CREATE TABLE IF NOT EXISTS " + datatablename2 +
                "(`counter` bigint(20) NOT NULL auto_increment," +
                "`sensorid` char(20) NOT NULL," +
                "`timestamp` timestamp NOT NULL default CURRENT_TIMESTAMP," +
                "`timer` long NOT NULL ," + //default"+defTimer+"
                "`sum_num_of_pedestrians` int(11) ," + //NOT NULL
                "`chief_plus_num` double ," +
                "`chief_plus_compass` int ," +
                "`chief_plus_speed` double ," +
                "`chief_minus_num` double ," +
                "`chief_minus_compass` int ," +
                "`chief_minus_speed` double ," +
                "`sub_plus_num` double ," +
                "`sub_plus_compass` int ," +
                "`sub_plus_speed` double ," +
                "`sub_minus_num` double ," +
                "`sub_minus_compass` int ," +
                "`sub_minus_speed` double ," +
                "`residence_num` double ," +
                "`frequency` int ," +//NOT NULL
                "PRIMARY KEY  (`counter`))" +
                " ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=1";
        ;
        return stmtStatistics3_create_predestrian;
    }

    public static String getNEOSQLInsertStmt(PedestrianFlowValue pval, String PED_TABLE_NAME) {
        String insertStmtStr = "INSERT INTO " + PED_TABLE_NAME +
                //"(sensorid,timestamp,internalCounter,light,temp,ax,ay,az,movement,battery,frequency)" +
                "(sensorid,timestamp,timer," +
                " sum_num_of_pedestrians, " +
                "chief_plus_num,  chief_plus_compass,  chief_plus_speed,  " +
                "chief_minus_num,  chief_minus_compass,  chief_minus_speed,  " +
                "residence_num,  " +
                "frequency)" +
                " VALUES(\'" + pval.getSensorID()//+"@@"
                + "\',\'" + TimeConverter.convertToString(pval.getTime()) + "\',\'" + pval.getMeasurementTime() + "\',\'" + pval.getAllNumber() + "\',\'" + pval.getChiefAxis().getFlowValue(Direction.PLUS) + "\',\'" + pval.getChiefAxis().getCompass(Direction.PLUS) + "\',\'" + pval.getChiefAxis().getAverageSpeed(Direction.PLUS) + "\',\'" + pval.getChiefAxis().getFlowValue(Direction.MINUS) + "\',\'" + pval.getChiefAxis().getCompass(Direction.MINUS) + "\',\'" + pval.getChiefAxis().getAverageSpeed(Direction.MINUS) + "\',\'" + pval.getResidence() + "\',\'" + pval.getFrequency() + "\')";
        return insertStmtStr;

    }

    public static String getSQLStmt9BkupHumanFileColums(String PED_TABLE_NAME) {
        SimpleDateFormat sdf1 = new SimpleDateFormat("yyyyMMdd_HHmmss");//yyyyMMdd_HHmmss_Z
        TimeZone tz1 = TimeZone.getTimeZone("Asia/Tokyo");
        Calendar cal1 = Calendar.getInstance(tz1);

        String stripid = "Colums";
        String tailstr = "_" + stripid + "_" + sdf1.format(cal1.getTime());//sdf1.format(date1);//System.currentTimeMillis();


        String str = "show COLUMNS from ";
        //String saving="INTO OUTFILE \'c:/SunSPOT/Human_tatebayashi_data" + tailstr + ".csv\' FIELDS TERMINATED BY \',\'";
        return str + PED_TABLE_NAME;
    }

    public static String getSQLStmt9BkupHumanFile(String sensorname, String PED_TABLE_NAME) {

        SimpleDateFormat sdf1 = new SimpleDateFormat("yyyyMMdd_HHmmss");//yyyyMMdd_HHmmss_Z
        TimeZone tz1 = TimeZone.getTimeZone("Asia/Tokyo");
        Calendar cal1 = Calendar.getInstance(tz1);

        String stripid = "";
        if (UtilSensorID.isHuman(sensorname)) {
            stripid = sensorname.substring("Human".length(), "Human1271543717046".length());

            
        }
        String tailstr = "_" + stripid + "_" + sdf1.format(cal1.getTime());//sdf1.format(date1);//System.currentTimeMillis();

        String stmtbk9 = "";
        stmtbk9 = "SELECT * FROM " + PED_TABLE_NAME + " where sensorid=\'" + stripid + "\' ORDER BY 1 INTO OUTFILE \'c:/SunSPOT/Human_tatebayashi_data" + tailstr + ".csv\' FIELDS TERMINATED BY \',\'";//ORDER BY 1 LIMIT 5,30

        return stmtbk9;

    }
}
