/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.transcoder;

import java.awt.Dimension;
import java.awt.geom.AffineTransform;
import java.awt.geom.Dimension2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.LinkedList;
import java.util.List;
import java.util.StringTokenizer;
import org.apache.batik.bridge.BaseScriptingEnvironment;
import org.apache.batik.bridge.BridgeContext;
import org.apache.batik.bridge.BridgeException;
import org.apache.batik.bridge.DefaultScriptSecurity;
import org.apache.batik.bridge.GVTBuilder;
import org.apache.batik.bridge.NoLoadScriptSecurity;
import org.apache.batik.bridge.RelaxedScriptSecurity;
import org.apache.batik.bridge.ScriptSecurity;
import org.apache.batik.bridge.UserAgent;
import org.apache.batik.bridge.UserAgentAdapter;
import org.apache.batik.bridge.ViewBox;
import org.apache.batik.dom.svg.SAXSVGDocumentFactory;
import org.apache.batik.dom.svg.SVGDOMImplementation;
import org.apache.batik.dom.svg.SVGOMDocument;
import org.apache.batik.dom.util.DOMUtilities;
import org.apache.batik.dom.util.DocumentFactory;
import org.apache.batik.gvt.CanvasGraphicsNode;
import org.apache.batik.gvt.CompositeGraphicsNode;
import org.apache.batik.gvt.GraphicsNode;
import org.apache.batik.transcoder.TranscoderException;
import org.apache.batik.transcoder.TranscoderInput;
import org.apache.batik.transcoder.TranscoderOutput;
import org.apache.batik.transcoder.TranscodingHints;
import org.apache.batik.transcoder.XMLAbstractTranscoder;
import org.apache.batik.transcoder.keys.BooleanKey;
import org.apache.batik.transcoder.keys.FloatKey;
import org.apache.batik.transcoder.keys.LengthKey;
import org.apache.batik.transcoder.keys.Rectangle2DKey;
import org.apache.batik.transcoder.keys.StringKey;
import org.apache.batik.util.ParsedURL;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public abstract class SVGAbstractTranscoder
extends XMLAbstractTranscoder {
    public static final String DEFAULT_DEFAULT_FONT_FAMILY = "Arial, Helvetica, sans-serif";
    protected Rectangle2D curAOI;
    protected AffineTransform curTxf;
    protected GraphicsNode root;
    protected BridgeContext ctx;
    protected GVTBuilder builder;
    protected float width = 400.0f;
    protected float height = 400.0f;
    protected UserAgent userAgent = this.createUserAgent();
    public static final TranscodingHints.Key KEY_WIDTH = new LengthKey();
    public static final TranscodingHints.Key KEY_HEIGHT = new LengthKey();
    public static final TranscodingHints.Key KEY_MAX_WIDTH = new LengthKey();
    public static final TranscodingHints.Key KEY_MAX_HEIGHT = new LengthKey();
    public static final TranscodingHints.Key KEY_AOI = new Rectangle2DKey();
    public static final TranscodingHints.Key KEY_LANGUAGE = new StringKey();
    public static final TranscodingHints.Key KEY_MEDIA = new StringKey();
    public static final TranscodingHints.Key KEY_DEFAULT_FONT_FAMILY = new StringKey();
    public static final TranscodingHints.Key KEY_ALTERNATE_STYLESHEET = new StringKey();
    public static final TranscodingHints.Key KEY_USER_STYLESHEET_URI = new StringKey();
    public static final TranscodingHints.Key KEY_PIXEL_UNIT_TO_MILLIMETER;
    public static final TranscodingHints.Key KEY_PIXEL_TO_MM;
    public static final TranscodingHints.Key KEY_EXECUTE_ONLOAD;
    public static final TranscodingHints.Key KEY_ALLOWED_SCRIPT_TYPES;
    public static final String DEFAULT_ALLOWED_SCRIPT_TYPES = "text/ecmascript, application/java-archive";
    public static final TranscodingHints.Key KEY_CONSTRAIN_SCRIPT_ORIGIN;

    protected SVGAbstractTranscoder() {
        this.hints.put(XMLAbstractTranscoder.KEY_DOCUMENT_ELEMENT_NAMESPACE_URI, "http://www.w3.org/2000/svg");
        this.hints.put(XMLAbstractTranscoder.KEY_DOCUMENT_ELEMENT, "svg");
        this.hints.put(XMLAbstractTranscoder.KEY_DOM_IMPLEMENTATION, SVGDOMImplementation.getDOMImplementation());
        this.hints.put(KEY_MEDIA, "screen");
        this.hints.put(KEY_DEFAULT_FONT_FAMILY, DEFAULT_DEFAULT_FONT_FAMILY);
        this.hints.put(KEY_EXECUTE_ONLOAD, Boolean.FALSE);
        this.hints.put(KEY_ALLOWED_SCRIPT_TYPES, DEFAULT_ALLOWED_SCRIPT_TYPES);
    }

    protected UserAgent createUserAgent() {
        return new SVGAbstractTranscoderUserAgent();
    }

    protected DocumentFactory createDocumentFactory(DOMImplementation dOMImplementation, String string) {
        return new SAXSVGDocumentFactory(string);
    }

    public void transcode(TranscoderInput transcoderInput, TranscoderOutput transcoderOutput) throws TranscoderException {
        super.transcode(transcoderInput, transcoderOutput);
        if (this.ctx != null) {
            this.ctx.dispose();
        }
    }

    protected void transcode(Document document, String string, TranscoderOutput transcoderOutput) throws TranscoderException {
        AffineTransform affineTransform;
        Object object;
        GraphicsNode graphicsNode;
        Object object2;
        Object object3;
        if (document != null && !(document.getImplementation() instanceof SVGDOMImplementation)) {
            object3 = (DOMImplementation)this.hints.get(XMLAbstractTranscoder.KEY_DOM_IMPLEMENTATION);
            document = DOMUtilities.deepCloneDocument((Document)document, (DOMImplementation)object3);
            if (string != null) {
                try {
                    object2 = new URL(string);
                    ((SVGOMDocument)document).setURLObject((URL)object2);
                }
                catch (MalformedURLException malformedURLException) {
                    // empty catch block
                }
            }
        }
        this.ctx = this.createBridgeContext();
        object3 = (SVGOMDocument)document;
        object2 = object3.getRootElement();
        this.builder = new GVTBuilder();
        boolean bl = this.hints.containsKey(KEY_EXECUTE_ONLOAD) && (Boolean)this.hints.get(KEY_EXECUTE_ONLOAD) != false && this.ctx.isDynamicDocument((Document)object3);
        try {
            if (bl) {
                this.ctx.setDynamicState(2);
            }
            graphicsNode = this.builder.build(this.ctx, (Document)object3);
            if (this.ctx.isDynamic()) {
                BaseScriptingEnvironment baseScriptingEnvironment = new BaseScriptingEnvironment(this.ctx);
                baseScriptingEnvironment.loadScripts();
                baseScriptingEnvironment.dispatchSVGLoadEvent();
            }
        }
        catch (BridgeException bridgeException) {
            throw new TranscoderException((Exception)((Object)bridgeException));
        }
        float f = (float)this.ctx.getDocumentSize().getWidth();
        float f2 = (float)this.ctx.getDocumentSize().getHeight();
        this.setImageSize(f, f2);
        if (this.hints.containsKey(KEY_AOI)) {
            object = (Rectangle2D)this.hints.get(KEY_AOI);
            affineTransform = new AffineTransform();
            double d = (double)this.width / ((RectangularShape)object).getWidth();
            double d2 = (double)this.height / ((RectangularShape)object).getHeight();
            double d3 = Math.min(d, d2);
            affineTransform.scale(d3, d3);
            double d4 = -((RectangularShape)object).getX() + ((double)this.width / d3 - ((RectangularShape)object).getWidth()) / 2.0;
            double d5 = -((RectangularShape)object).getY() + ((double)this.height / d3 - ((RectangularShape)object).getHeight()) / 2.0;
            affineTransform.translate(d4, d5);
            this.curAOI = object;
        } else {
            object = new ParsedURL(string).getRef();
            try {
                affineTransform = ViewBox.getViewTransform((String)object, (Element)object2, (float)this.width, (float)this.height);
            }
            catch (BridgeException bridgeException) {
                throw new TranscoderException((Exception)((Object)bridgeException));
            }
            if (affineTransform.isIdentity() && (this.width != f || this.height != f2)) {
                float f3 = this.width / f;
                float f4 = this.height / f2;
                float f5 = Math.min(f3, f4);
                affineTransform = AffineTransform.getScaleInstance(f5, f5);
            }
            this.curAOI = new Rectangle2D.Float(0.0f, 0.0f, this.width, this.height);
        }
        object = this.getCanvasGraphicsNode(graphicsNode);
        if (object != null) {
            object.setViewingTransform(affineTransform);
            this.curTxf = new AffineTransform();
        } else {
            this.curTxf = affineTransform;
        }
        this.root = graphicsNode;
    }

    protected CanvasGraphicsNode getCanvasGraphicsNode(GraphicsNode graphicsNode) {
        if (!(graphicsNode instanceof CompositeGraphicsNode)) {
            return null;
        }
        CompositeGraphicsNode compositeGraphicsNode = (CompositeGraphicsNode)graphicsNode;
        List list = compositeGraphicsNode.getChildren();
        if (list.size() == 0) {
            return null;
        }
        graphicsNode = (GraphicsNode)list.get(0);
        if (!(graphicsNode instanceof CanvasGraphicsNode)) {
            return null;
        }
        return (CanvasGraphicsNode)graphicsNode;
    }

    protected BridgeContext createBridgeContext() {
        return new BridgeContext(this.userAgent);
    }

    protected void setImageSize(float f, float f2) {
        float f3 = -1.0f;
        if (this.hints.containsKey(KEY_WIDTH)) {
            f3 = ((Float)this.hints.get(KEY_WIDTH)).floatValue();
        }
        float f4 = -1.0f;
        if (this.hints.containsKey(KEY_HEIGHT)) {
            f4 = ((Float)this.hints.get(KEY_HEIGHT)).floatValue();
        }
        if (f3 > 0.0f && f4 > 0.0f) {
            this.width = f3;
            this.height = f4;
        } else if (f4 > 0.0f) {
            this.width = f * f4 / f2;
            this.height = f4;
        } else if (f3 > 0.0f) {
            this.width = f3;
            this.height = f2 * f3 / f;
        } else {
            this.width = f;
            this.height = f2;
        }
        float f5 = -1.0f;
        if (this.hints.containsKey(KEY_MAX_WIDTH)) {
            f5 = ((Float)this.hints.get(KEY_MAX_WIDTH)).floatValue();
        }
        float f6 = -1.0f;
        if (this.hints.containsKey(KEY_MAX_HEIGHT)) {
            f6 = ((Float)this.hints.get(KEY_MAX_HEIGHT)).floatValue();
        }
        if (f6 > 0.0f && this.height > f6) {
            this.width = f * f6 / f2;
            this.height = f6;
        }
        if (f5 > 0.0f && this.width > f5) {
            this.width = f5;
            this.height = f2 * f5 / f;
        }
    }

    static {
        KEY_PIXEL_TO_MM = KEY_PIXEL_UNIT_TO_MILLIMETER = new FloatKey();
        KEY_EXECUTE_ONLOAD = new BooleanKey();
        KEY_ALLOWED_SCRIPT_TYPES = new StringKey();
        KEY_CONSTRAIN_SCRIPT_ORIGIN = new BooleanKey();
    }

    protected class SVGAbstractTranscoderUserAgent
    extends UserAgentAdapter {
        protected List scripts;

        public SVGAbstractTranscoderUserAgent() {
            this.addStdFeatures();
        }

        public AffineTransform getTransform() {
            return SVGAbstractTranscoder.this.curTxf;
        }

        public void setTransform(AffineTransform affineTransform) {
            SVGAbstractTranscoder.this.curTxf = affineTransform;
        }

        public Dimension2D getViewportSize() {
            return new Dimension((int)SVGAbstractTranscoder.this.width, (int)SVGAbstractTranscoder.this.height);
        }

        public void displayError(String string) {
            try {
                SVGAbstractTranscoder.this.handler.error(new TranscoderException(string));
            }
            catch (TranscoderException transcoderException) {
                throw new RuntimeException();
            }
        }

        public void displayError(Exception exception) {
            try {
                exception.printStackTrace();
                SVGAbstractTranscoder.this.handler.error(new TranscoderException(exception));
            }
            catch (TranscoderException transcoderException) {
                throw new RuntimeException();
            }
        }

        public void displayMessage(String string) {
            try {
                SVGAbstractTranscoder.this.handler.warning(new TranscoderException(string));
            }
            catch (TranscoderException transcoderException) {
                throw new RuntimeException();
            }
        }

        public float getPixelUnitToMillimeter() {
            Object object = SVGAbstractTranscoder.this.hints.get(KEY_PIXEL_UNIT_TO_MILLIMETER);
            if (object != null) {
                return ((Float)object).floatValue();
            }
            return super.getPixelUnitToMillimeter();
        }

        public String getLanguages() {
            if (SVGAbstractTranscoder.this.hints.containsKey(KEY_LANGUAGE)) {
                return (String)SVGAbstractTranscoder.this.hints.get(KEY_LANGUAGE);
            }
            return super.getLanguages();
        }

        public String getMedia() {
            String string = (String)SVGAbstractTranscoder.this.hints.get(KEY_MEDIA);
            if (string != null) {
                return string;
            }
            return super.getMedia();
        }

        public String getDefaultFontFamily() {
            String string = (String)SVGAbstractTranscoder.this.hints.get(KEY_DEFAULT_FONT_FAMILY);
            if (string != null) {
                return string;
            }
            return super.getDefaultFontFamily();
        }

        public String getAlternateStyleSheet() {
            String string = (String)SVGAbstractTranscoder.this.hints.get(KEY_ALTERNATE_STYLESHEET);
            if (string != null) {
                return string;
            }
            return super.getAlternateStyleSheet();
        }

        public String getUserStyleSheetURI() {
            String string = (String)SVGAbstractTranscoder.this.hints.get(KEY_USER_STYLESHEET_URI);
            if (string != null) {
                return string;
            }
            return super.getUserStyleSheetURI();
        }

        public String getXMLParserClassName() {
            String string = (String)SVGAbstractTranscoder.this.hints.get(XMLAbstractTranscoder.KEY_XML_PARSER_CLASSNAME);
            if (string != null) {
                return string;
            }
            return super.getXMLParserClassName();
        }

        public boolean isXMLParserValidating() {
            Boolean bl = (Boolean)SVGAbstractTranscoder.this.hints.get(XMLAbstractTranscoder.KEY_XML_PARSER_VALIDATING);
            if (bl != null) {
                return bl;
            }
            return super.isXMLParserValidating();
        }

        public ScriptSecurity getScriptSecurity(String string, ParsedURL parsedURL, ParsedURL parsedURL2) {
            if (this.scripts == null) {
                this.computeAllowedScripts();
            }
            if (!this.scripts.contains(string)) {
                return new NoLoadScriptSecurity(string);
            }
            boolean bl = true;
            if (SVGAbstractTranscoder.this.hints.containsKey(KEY_CONSTRAIN_SCRIPT_ORIGIN)) {
                bl = (Boolean)SVGAbstractTranscoder.this.hints.get(KEY_CONSTRAIN_SCRIPT_ORIGIN);
            }
            if (bl) {
                return new DefaultScriptSecurity(string, parsedURL, parsedURL2);
            }
            return new RelaxedScriptSecurity(string, parsedURL, parsedURL2);
        }

        protected void computeAllowedScripts() {
            this.scripts = new LinkedList();
            if (!SVGAbstractTranscoder.this.hints.containsKey(KEY_ALLOWED_SCRIPT_TYPES)) {
                return;
            }
            String string = (String)SVGAbstractTranscoder.this.hints.get(KEY_ALLOWED_SCRIPT_TYPES);
            StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
            while (stringTokenizer.hasMoreTokens()) {
                this.scripts.add(stringTokenizer.nextToken());
            }
        }
    }
}

