/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ddlutils.platform.sybase;

import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.apache.ddlutils.DdlUtilsException;
import org.apache.ddlutils.Platform;
import org.apache.ddlutils.model.Column;
import org.apache.ddlutils.model.ForeignKey;
import org.apache.ddlutils.model.Index;
import org.apache.ddlutils.model.Reference;
import org.apache.ddlutils.model.Table;
import org.apache.ddlutils.model.TypeMap;
import org.apache.ddlutils.platform.DatabaseMetaDataWrapper;
import org.apache.ddlutils.platform.JdbcModelReader;

public class SybaseModelReader
extends JdbcModelReader {
    private Pattern _isoDatePattern;
    private Pattern _isoTimePattern;

    public SybaseModelReader(Platform platform) {
        super(platform);
        this.setDefaultCatalogPattern(null);
        this.setDefaultSchemaPattern(null);
        this.setDefaultTablePattern("%");
        try {
            this._isoDatePattern = Pattern.compile("'(\\d{4}\\-\\d{2}\\-\\d{2})'");
            this._isoTimePattern = Pattern.compile("'(\\d{2}:\\d{2}:\\d{2})'");
        }
        catch (PatternSyntaxException ex) {
            throw new DdlUtilsException(ex);
        }
    }

    protected Table readTable(DatabaseMetaDataWrapper metaData, Map values) throws SQLException {
        Table table = super.readTable(metaData, values);
        if (table != null) {
            this.determineAutoIncrementFromResultSetMetaData(table, table.getColumns());
        }
        return table;
    }

    protected Column readColumn(DatabaseMetaDataWrapper metaData, Map values) throws SQLException {
        Column column = super.readColumn(metaData, values);
        if (column.getTypeCode() == 3 && column.getSizeAsInt() == 19 && column.getScale() == 0) {
            column.setTypeCode(-5);
        } else if (column.getDefaultValue() != null) {
            if (column.getTypeCode() == 93) {
                Matcher matcher = this._isoDatePattern.matcher(column.getDefaultValue());
                Timestamp timestamp = null;
                if (matcher.matches()) {
                    timestamp = new Timestamp(Date.valueOf(matcher.group(1)).getTime());
                } else {
                    matcher = this._isoTimePattern.matcher(column.getDefaultValue());
                    if (matcher.matches()) {
                        timestamp = new Timestamp(Time.valueOf(matcher.group(1)).getTime());
                    }
                }
                if (timestamp != null) {
                    column.setDefaultValue(timestamp.toString());
                }
            } else if (TypeMap.isTextType(column.getTypeCode())) {
                column.setDefaultValue(this.unescape(column.getDefaultValue(), "'", "''"));
            }
        }
        return column;
    }

    protected void readIndex(DatabaseMetaDataWrapper metaData, Map values, Map knownIndices) throws SQLException {
        String indexName;
        if (this.getPlatform().isDelimitedIdentifierModeOn() && (indexName = (String)values.get("INDEX_NAME")) != null) {
            String delimiter = this.getPlatformInfo().getDelimiterToken();
            if (indexName != null && indexName.startsWith(delimiter) && indexName.endsWith(delimiter)) {
                indexName = indexName.substring(delimiter.length(), indexName.length() - delimiter.length());
                values.put("INDEX_NAME", indexName);
            }
        }
        super.readIndex(metaData, values, knownIndices);
    }

    protected Collection readForeignKeys(DatabaseMetaDataWrapper metaData, String tableName) throws SQLException {
        String colQuery = "SELECT refobjs.name, localtables.id, remotetables.name, remotetables.id,       refs.fokey1, refs.refkey1, refs.fokey2, refs.refkey2, refs.fokey3, refs.refkey3, refs.fokey4, refs.refkey4,       refs.fokey5, refs.refkey5, refs.fokey6, refs.refkey6, refs.fokey7, refs.refkey7, refs.fokey8, refs.refkey8,       refs.fokey9, refs.refkey9, refs.fokey10, refs.refkey10, refs.fokey11, refs.refkey11, refs.fokey12, refs.refkey12,       refs.fokey13, refs.refkey13, refs.fokey14, refs.refkey14, refs.fokey15, refs.refkey15, refs.fokey16, refs.refkey16, FROM sysreferences refs, sysobjects refobjs, sysobjects localtables, sysobjects remotetables WHERE refobjs.type = 'RI' AND refs.constrid = refobjs.id AND       localtables.type = 'U' AND refs.tableid = localtables.id AND localtables.name = ?   AND remotetables.type = 'U' AND refs.reftabid = remotetables.id";
        String refObjQuery = "SELECT name FROM syscolumns WHERE id = ? AND colid = ?";
        PreparedStatement colStmt = null;
        PreparedStatement refObjStmt = null;
        ArrayList<ForeignKey> result = new ArrayList<ForeignKey>();
        try {
            colStmt = this.getConnection().prepareStatement("SELECT refobjs.name, localtables.id, remotetables.name, remotetables.id,       refs.fokey1, refs.refkey1, refs.fokey2, refs.refkey2, refs.fokey3, refs.refkey3, refs.fokey4, refs.refkey4,       refs.fokey5, refs.refkey5, refs.fokey6, refs.refkey6, refs.fokey7, refs.refkey7, refs.fokey8, refs.refkey8,       refs.fokey9, refs.refkey9, refs.fokey10, refs.refkey10, refs.fokey11, refs.refkey11, refs.fokey12, refs.refkey12,       refs.fokey13, refs.refkey13, refs.fokey14, refs.refkey14, refs.fokey15, refs.refkey15, refs.fokey16, refs.refkey16, FROM sysreferences refs, sysobjects refobjs, sysobjects localtables, sysobjects remotetables WHERE refobjs.type = 'RI' AND refs.constrid = refobjs.id AND       localtables.type = 'U' AND refs.tableid = localtables.id AND localtables.name = ?   AND remotetables.type = 'U' AND refs.reftabid = remotetables.id");
            refObjStmt = this.getConnection().prepareStatement("SELECT name FROM syscolumns WHERE id = ? AND colid = ?");
            ResultSet fkRs = colStmt.executeQuery();
            while (fkRs.next()) {
                ForeignKey fk = new ForeignKey(fkRs.getString(1));
                int localTableId = fkRs.getInt(2);
                int remoteTableId = fkRs.getInt(4);
                fk.setForeignTableName(fkRs.getString(3));
                int idx = 0;
                while (idx < 16) {
                    short fkColIdx = fkRs.getShort(5 + idx + idx);
                    short pkColIdx = fkRs.getShort(6 + idx + idx);
                    Reference ref = new Reference();
                    if (fkColIdx == 0) break;
                    refObjStmt.setInt(1, localTableId);
                    refObjStmt.setShort(2, fkColIdx);
                    ResultSet colRs = refObjStmt.executeQuery();
                    if (colRs.next()) {
                        ref.setLocalColumnName(colRs.getString(1));
                    }
                    colRs.close();
                    refObjStmt.setInt(1, remoteTableId);
                    refObjStmt.setShort(2, pkColIdx);
                    colRs = refObjStmt.executeQuery();
                    if (colRs.next()) {
                        ref.setForeignColumnName(colRs.getString(1));
                    }
                    colRs.close();
                    fk.addReference(ref);
                    ++idx;
                }
                result.add(fk);
            }
        }
        catch (Throwable throwable) {
            this.closeStatement(colStmt);
            this.closeStatement(refObjStmt);
            throw throwable;
        }
        this.closeStatement(colStmt);
        this.closeStatement(refObjStmt);
        return result;
    }

    protected boolean isInternalPrimaryKeyIndex(DatabaseMetaDataWrapper metaData, Table table, Index index) throws SQLException {
        String query = "SELECT name = sysindexes.name FROM sysindexes, sysobjects WHERE sysobjects.name = ? AND sysindexes.name = ? AND sysobjects.id = sysindexes.id AND (sysindexes.status & 2048) > 0";
        PreparedStatement stmt = null;
        try {
            stmt = this.getConnection().prepareStatement("SELECT name = sysindexes.name FROM sysindexes, sysobjects WHERE sysobjects.name = ? AND sysindexes.name = ? AND sysobjects.id = sysindexes.id AND (sysindexes.status & 2048) > 0");
            stmt.setString(1, table.getName());
            stmt.setString(2, index.getName());
            ResultSet rs = stmt.executeQuery();
            boolean bl = rs.next();
            return bl;
        }
        finally {
            this.closeStatement(stmt);
        }
    }
}

