/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ddlutils.platform.mysql;

import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import org.apache.ddlutils.Platform;
import org.apache.ddlutils.alteration.ColumnDefinitionChange;
import org.apache.ddlutils.model.Column;
import org.apache.ddlutils.model.ForeignKey;
import org.apache.ddlutils.model.Table;
import org.apache.ddlutils.model.TypeMap;
import org.apache.ddlutils.platform.SqlBuilder;

public class MySqlBuilder
extends SqlBuilder {
    public MySqlBuilder(Platform platform) {
        super(platform);
        this.addEscapedCharSequence("\\", "\\\\");
        this.addEscapedCharSequence("\u0000", "\\0");
        this.addEscapedCharSequence("'", "\\'");
        this.addEscapedCharSequence("\"", "\\\"");
        this.addEscapedCharSequence("\b", "\\b");
        this.addEscapedCharSequence("\n", "\\n");
        this.addEscapedCharSequence("\r", "\\r");
        this.addEscapedCharSequence("\t", "\\t");
        this.addEscapedCharSequence("\u001a", "\\Z");
        this.addEscapedCharSequence("%", "\\%");
        this.addEscapedCharSequence("_", "\\_");
    }

    public void dropTable(Table table) throws IOException {
        this.print("DROP TABLE IF EXISTS ");
        this.printIdentifier(this.getTableName(table));
        this.printEndOfStatement();
    }

    protected void writeColumnAutoIncrementStmt(Table table, Column column) throws IOException {
        this.print("AUTO_INCREMENT");
    }

    protected boolean shouldGeneratePrimaryKeys(Column[] primaryKeyColumns) {
        return true;
    }

    public String getSelectLastIdentityValues(Table table) {
        String autoIncrementKeyName = "";
        if (table.getAutoIncrementColumns().length > 0) {
            autoIncrementKeyName = table.getAutoIncrementColumns()[0].getName();
        }
        return "SELECT LAST_INSERT_ID() " + autoIncrementKeyName;
    }

    protected void writeTableCreationStmtEnding(Table table, Map parameters) throws IOException {
        if (parameters != null) {
            this.print(" ");
            Iterator it = parameters.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry entry = it.next();
                this.print(entry.getKey().toString());
                if (entry.getValue() != null) {
                    this.print("=");
                    this.print(entry.getValue().toString());
                }
                if (!it.hasNext()) continue;
                this.print(" ");
            }
        }
        super.writeTableCreationStmtEnding(table, parameters);
    }

    public void dropForeignKey(Table table, ForeignKey foreignKey) throws IOException {
        this.writeTableAlterStmt(table);
        this.print("DROP FOREIGN KEY ");
        this.printIdentifier(this.getForeignKeyName(table, foreignKey));
        this.printEndOfStatement();
        if (foreignKey.isAutoIndexPresent()) {
            this.writeTableAlterStmt(table);
            this.print("DROP INDEX ");
            this.printIdentifier(this.getForeignKeyName(table, foreignKey));
            this.printEndOfStatement();
        }
    }

    public void insertColumn(Table table, Column newColumn, Column prevColumn) throws IOException {
        this.print("ALTER TABLE ");
        this.printlnIdentifier(this.getTableName(table));
        this.printIndent();
        this.print("ADD COLUMN ");
        this.writeColumn(table, newColumn);
        if (prevColumn != null) {
            this.print(" AFTER ");
            this.printIdentifier(this.getColumnName(prevColumn));
        } else {
            this.print(" FIRST");
        }
        this.printEndOfStatement();
    }

    public void dropColumn(Table table, Column column) throws IOException {
        this.print("ALTER TABLE ");
        this.printlnIdentifier(this.getTableName(table));
        this.printIndent();
        this.print("DROP COLUMN ");
        this.printIdentifier(this.getColumnName(column));
        this.printEndOfStatement();
    }

    public void dropPrimaryKey(Table table) throws IOException {
        this.print("ALTER TABLE ");
        this.printlnIdentifier(this.getTableName(table));
        this.printIndent();
        this.print("DROP PRIMARY KEY");
        this.printEndOfStatement();
    }

    public void recreateColumn(Table table, Column column) throws IOException {
        this.print("ALTER TABLE ");
        this.printlnIdentifier(this.getTableName(table));
        this.printIndent();
        this.print("MODIFY COLUMN ");
        this.writeColumn(table, column);
        this.printEndOfStatement();
    }

    protected void writeCastExpression(Column sourceColumn, Column targetColumn) throws IOException {
        boolean sizeChanged = ColumnDefinitionChange.isSizeChanged(this.getPlatformInfo(), sourceColumn, targetColumn);
        boolean typeChanged = ColumnDefinitionChange.isTypeChanged(this.getPlatformInfo(), sourceColumn, targetColumn);
        if (sizeChanged || typeChanged) {
            String targetNativeType = this.getNativeType(targetColumn);
            switch (targetColumn.getTypeCode()) {
                case -7: 
                case -6: 
                case -5: 
                case 4: 
                case 5: 
                case 16: {
                    targetNativeType = "SIGNED";
                    break;
                }
                case 6: 
                case 7: 
                case 8: {
                    targetNativeType = "SIGNED";
                    break;
                }
                case 2: 
                case 3: {
                    targetNativeType = "DECIMAL";
                    break;
                }
                case 91: {
                    targetNativeType = "DATE";
                    break;
                }
                case 93: {
                    targetNativeType = "DATETIME";
                    break;
                }
                case -1: 
                case 1: 
                case 12: 
                case 2005: {
                    targetNativeType = "CHAR";
                    break;
                }
                default: {
                    targetNativeType = "BINARY";
                }
            }
            this.print("CAST(");
            if (TypeMap.isTextType(sourceColumn.getTypeCode()) && TypeMap.isTextType(targetColumn.getTypeCode()) && sizeChanged) {
                this.print("LEFT(");
                this.printIdentifier(this.getColumnName(sourceColumn));
                this.print(",");
                this.print(targetColumn.getSize());
                this.print(")");
            } else {
                this.printIdentifier(this.getColumnName(sourceColumn));
            }
            this.print(" AS ");
            this.print(this.getSqlType(targetColumn, targetNativeType));
            this.print(")");
        } else {
            this.printIdentifier(this.getColumnName(sourceColumn));
        }
    }
}

