/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ddlutils.platform.mckoi;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.collections.map.ListOrderedMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ddlutils.Platform;
import org.apache.ddlutils.model.Column;
import org.apache.ddlutils.model.Table;
import org.apache.ddlutils.model.TypeMap;
import org.apache.ddlutils.platform.DatabaseMetaDataWrapper;
import org.apache.ddlutils.platform.JdbcModelReader;

public class MckoiModelReader
extends JdbcModelReader {
    protected Log _log;
    static /* synthetic */ Class class$0;

    public MckoiModelReader(Platform platform) {
        super(platform);
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.apache.ddlutils.platform.mckoi.MckoiModelReader");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this._log = LogFactory.getLog((Class)clazz);
        this.setDefaultCatalogPattern(null);
        this.setDefaultSchemaPattern(null);
    }

    protected Table readTable(DatabaseMetaDataWrapper metaData, Map values) throws SQLException {
        String query = "SELECT uniqueColumns.column, uniqueColumns.seq_no, uniqueInfo.name FROM SYS_INFO.sUSRUniqueColumns uniqueColumns, SYS_INFO.sUSRUniqueInfo uniqueInfo WHERE uniqueColumns.un_id = uniqueInfo.id AND uniqueInfo.table = ?";
        String queryWithSchema = "SELECT uniqueColumns.column, uniqueColumns.seq_no, uniqueInfo.name FROM SYS_INFO.sUSRUniqueColumns uniqueColumns, SYS_INFO.sUSRUniqueInfo uniqueInfo WHERE uniqueColumns.un_id = uniqueInfo.id AND uniqueInfo.table = ? AND uniqueInfo.schema = ?";
        Table table = super.readTable(metaData, values);
        if (table != null) {
            ListOrderedMap indices = new ListOrderedMap();
            PreparedStatement stmt = null;
            try {
                stmt = this.getConnection().prepareStatement(table.getSchema() == null ? "SELECT uniqueColumns.column, uniqueColumns.seq_no, uniqueInfo.name FROM SYS_INFO.sUSRUniqueColumns uniqueColumns, SYS_INFO.sUSRUniqueInfo uniqueInfo WHERE uniqueColumns.un_id = uniqueInfo.id AND uniqueInfo.table = ?" : "SELECT uniqueColumns.column, uniqueColumns.seq_no, uniqueInfo.name FROM SYS_INFO.sUSRUniqueColumns uniqueColumns, SYS_INFO.sUSRUniqueInfo uniqueInfo WHERE uniqueColumns.un_id = uniqueInfo.id AND uniqueInfo.table = ? AND uniqueInfo.schema = ?");
                stmt.setString(1, table.getName());
                if (table.getSchema() != null) {
                    stmt.setString(2, table.getSchema());
                }
                ResultSet resultSet = stmt.executeQuery();
                HashMap<String, Object> indexValues = new HashMap<String, Object>();
                indexValues.put("NON_UNIQUE", Boolean.FALSE);
                while (resultSet.next()) {
                    indexValues.put("COLUMN_NAME", resultSet.getString(1));
                    indexValues.put("ORDINAL_POSITION", new Short(resultSet.getShort(2)));
                    indexValues.put("INDEX_NAME", resultSet.getString(3));
                    this.readIndex(metaData, indexValues, (Map)indices);
                }
            }
            catch (Throwable throwable) {
                this.closeStatement(stmt);
                throw throwable;
            }
            this.closeStatement(stmt);
            table.addIndices(indices.values());
        }
        return table;
    }

    protected Column readColumn(DatabaseMetaDataWrapper metaData, Map values) throws SQLException {
        String defaultValue;
        Column column = super.readColumn(metaData, values);
        if (column.getSize() != null && column.getSizeAsInt() <= 0) {
            column.setSize(null);
        }
        if ((defaultValue = column.getDefaultValue()) != null) {
            if (defaultValue.toLowerCase().startsWith("nextval('") || defaultValue.toLowerCase().startsWith("uniquekey('")) {
                column.setDefaultValue(null);
                column.setAutoIncrement(true);
            } else if (TypeMap.isTextType(column.getTypeCode())) {
                column.setDefaultValue(this.unescape(column.getDefaultValue(), "'", "\\'"));
            }
        }
        return column;
    }
}

