/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ddlutils.platform.h2;

import java.io.IOException;
import org.apache.ddlutils.Platform;
import org.apache.ddlutils.alteration.ColumnDefinitionChange;
import org.apache.ddlutils.model.Column;
import org.apache.ddlutils.model.Index;
import org.apache.ddlutils.model.Table;
import org.apache.ddlutils.model.TypeMap;
import org.apache.ddlutils.platform.SqlBuilder;

public class H2Builder
extends SqlBuilder {
    public H2Builder(Platform platform) {
        super(platform);
        this.addEscapedCharSequence("'", "''");
    }

    public void dropTable(Table table) throws IOException {
        this.print("DROP TABLE ");
        this.printIdentifier(this.getTableName(table));
        this.print(" IF EXISTS");
        this.printEndOfStatement();
    }

    public String getSelectLastIdentityValues(Table table) {
        return "CALL IDENTITY()";
    }

    public void dropIndex(Table table, Index index) throws IOException {
        this.print("DROP INDEX ");
        this.printIdentifier(this.getIndexName(index));
        this.print(" IF EXISTS");
        this.printEndOfStatement();
    }

    public void insertColumn(Table table, Column newColumn, Column nextColumn) throws IOException {
        this.print("ALTER TABLE ");
        this.printlnIdentifier(this.getTableName(table));
        this.printIndent();
        this.print("ADD COLUMN ");
        this.writeColumn(table, newColumn);
        if (nextColumn != null) {
            this.print(" BEFORE ");
            this.printIdentifier(this.getColumnName(nextColumn));
        }
        this.printEndOfStatement();
    }

    public void dropColumn(Table table, Column column) throws IOException {
        this.print("ALTER TABLE ");
        this.printlnIdentifier(this.getTableName(table));
        this.printIndent();
        this.print("DROP COLUMN ");
        this.printIdentifier(this.getColumnName(column));
        this.printEndOfStatement();
    }

    protected void writeCastExpression(Column sourceColumn, Column targetColumn) throws IOException {
        boolean sizeChanged = ColumnDefinitionChange.isSizeChanged(this.getPlatformInfo(), sourceColumn, targetColumn);
        boolean typeChanged = ColumnDefinitionChange.isTypeChanged(this.getPlatformInfo(), sourceColumn, targetColumn);
        if (sizeChanged || typeChanged) {
            boolean needSubstr = false;
            int targetSize = 0;
            if (TypeMap.isTextType(targetColumn.getTypeCode()) && sizeChanged) {
                Integer platformDefaultSize;
                targetSize = targetColumn.getSizeAsInt();
                if (targetSize == 0 && (platformDefaultSize = this.getPlatformInfo().getDefaultSize(targetColumn.getTypeCode())) != null) {
                    targetSize = platformDefaultSize;
                }
                boolean bl = needSubstr = sourceColumn.getSizeAsInt() > targetSize;
            }
            if (needSubstr) {
                this.print("SUBSTR(");
            }
            this.print("CAST(");
            this.printIdentifier(this.getColumnName(sourceColumn));
            this.print(" AS ");
            if (needSubstr) {
                this.print(this.getNativeType(targetColumn));
            } else {
                this.print(this.getSqlType(targetColumn));
            }
            this.print(")");
            if (needSubstr) {
                this.print(",1,");
                this.print(Integer.toString(targetSize));
                this.print(")");
            }
        } else {
            super.writeCastExpression(sourceColumn, targetColumn);
        }
    }
}

