/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ddlutils.alteration;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import org.apache.ddlutils.alteration.TableChangeImplBase;
import org.apache.ddlutils.model.Column;
import org.apache.ddlutils.model.Database;
import org.apache.ddlutils.model.Table;

public class ColumnOrderChange
extends TableChangeImplBase {
    private Map _newPositions;

    public ColumnOrderChange(String tableName, Map newPositions) {
        super(tableName);
        this._newPositions = newPositions;
    }

    public int getNewPosition(String sourceColumnName, boolean caseSensitive) {
        Integer newPos = null;
        if (caseSensitive) {
            newPos = (Integer)this._newPositions.get(sourceColumnName);
        } else {
            Iterator it = this._newPositions.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry entry = it.next();
                if (!sourceColumnName.equalsIgnoreCase((String)entry.getKey())) continue;
                newPos = (Integer)entry.getValue();
                break;
            }
        }
        return newPos == null ? -1 : newPos;
    }

    public void apply(Database database, boolean caseSensitive) {
        Table table = this.findChangedTable(database, caseSensitive);
        ArrayList<Column> newColumns = new ArrayList<Column>();
        int idx = 0;
        while (idx < table.getColumnCount()) {
            newColumns.add(table.getColumn(idx));
            ++idx;
        }
        idx = 0;
        while (idx < table.getColumnCount()) {
            Column column = table.getColumn(idx);
            int newPos = this.getNewPosition(column.getName(), caseSensitive);
            if (newPos >= 0) {
                newColumns.set(newPos, column);
            }
            ++idx;
        }
        table.removeAllColumns();
        table.addColumns(newColumns);
    }
}

