/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ddlutils.platform.maxdb;

import java.io.IOException;
import org.apache.ddlutils.Platform;
import org.apache.ddlutils.model.Column;
import org.apache.ddlutils.model.ForeignKey;
import org.apache.ddlutils.model.Table;
import org.apache.ddlutils.platform.sapdb.SapDbBuilder;

public class MaxDbBuilder
extends SapDbBuilder {
    public MaxDbBuilder(Platform platform) {
        super(platform);
    }

    @Override
    public void createPrimaryKey(Table table, Column[] primaryKeyColumns) throws IOException {
        if (primaryKeyColumns.length > 0 && this.shouldGeneratePrimaryKeys(primaryKeyColumns)) {
            this.print("ALTER TABLE ");
            this.printlnIdentifier(this.getTableName(table));
            this.printIndent();
            this.print("ADD CONSTRAINT ");
            this.printIdentifier(this.getConstraintName(null, table, "PK", null));
            this.print(" ");
            this.writePrimaryKeyStmt(table, primaryKeyColumns);
            this.printEndOfStatement();
        }
    }

    @Override
    public void dropForeignKey(Table table, ForeignKey foreignKey) throws IOException {
        this.writeTableAlterStmt(table);
        this.print("DROP CONSTRAINT ");
        this.printIdentifier(this.getForeignKeyName(table, foreignKey));
        this.printEndOfStatement();
    }
}

