/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ddlutils.platform.derby;

import java.io.IOException;
import org.apache.ddlutils.Platform;
import org.apache.ddlutils.alteration.ColumnDefinitionChange;
import org.apache.ddlutils.model.Column;
import org.apache.ddlutils.model.Index;
import org.apache.ddlutils.model.Table;
import org.apache.ddlutils.model.TypeMap;
import org.apache.ddlutils.platform.cloudscape.CloudscapeBuilder;

public class DerbyBuilder
extends CloudscapeBuilder {
    public DerbyBuilder(Platform platform) {
        super(platform);
    }

    @Override
    protected String getNativeDefaultValue(Column column) {
        if (column.getTypeCode() == -7 || column.getTypeCode() == 16) {
            return this.getDefaultValueHelper().convert(column.getDefaultValue(), column.getTypeCode(), 5);
        }
        return super.getNativeDefaultValue(column);
    }

    @Override
    protected void writeColumnAutoIncrementStmt(Table table, Column column) throws IOException {
        this.print("GENERATED BY DEFAULT AS IDENTITY");
    }

    @Override
    public void dropIndex(Table table, Index index) throws IOException {
        this.print("DROP INDEX ");
        this.printIdentifier(this.getIndexName(index));
        this.printEndOfStatement();
    }

    @Override
    protected void writeCastExpression(Column sourceColumn, Column targetColumn) throws IOException {
        if (ColumnDefinitionChange.isSizeChanged(this.getPlatformInfo(), sourceColumn, targetColumn) || ColumnDefinitionChange.isTypeChanged(this.getPlatformInfo(), sourceColumn, targetColumn)) {
            String targetNativeType = this.getNativeType(targetColumn);
            if (TypeMap.isNumericType(sourceColumn.getTypeCode()) && "VARCHAR".equalsIgnoreCase(targetNativeType)) {
                targetNativeType = "CHAR";
            }
            this.print("CAST (");
            this.printIdentifier(this.getColumnName(sourceColumn));
            this.print(" AS ");
            this.print(this.getSqlType(targetColumn, targetNativeType));
            this.print(")");
        } else {
            this.printIdentifier(this.getColumnName(sourceColumn));
        }
    }
}

