/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ddlutils.model;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.apache.ddlutils.model.Database;
import org.apache.ddlutils.model.ForeignKey;
import org.apache.ddlutils.model.ModelException;
import org.apache.ddlutils.model.Table;

public class ModelHelper {
    public void checkForForeignKeysToAndFromTables(Database model, Table[] tables) throws ModelException {
        List<Table> tableList = Arrays.asList(tables);
        int tableIdx = 0;
        while (tableIdx < model.getTableCount()) {
            Table curTable = model.getTable(tableIdx);
            boolean curTableIsInList = tableList.contains(curTable);
            int fkIdx = 0;
            while (fkIdx < curTable.getForeignKeyCount()) {
                ForeignKey curFk = curTable.getForeignKey(fkIdx);
                if (curTableIsInList != tableList.contains(curFk.getForeignTable())) {
                    throw new ModelException("The table " + curTable.getName() + " has a foreign key to table " + curFk.getForeignTable().getName());
                }
                ++fkIdx;
            }
            ++tableIdx;
        }
    }

    public void removeForeignKeysToAndFromTables(Database model, Table[] tables) {
        List<Table> tableList = Arrays.asList(tables);
        int tableIdx = 0;
        while (tableIdx < model.getTableCount()) {
            Table curTable = model.getTable(tableIdx);
            boolean curTableIsInList = tableList.contains(curTable);
            ArrayList<ForeignKey> fksToRemove = new ArrayList<ForeignKey>();
            int fkIdx = 0;
            while (fkIdx < curTable.getForeignKeyCount()) {
                ForeignKey curFk = curTable.getForeignKey(fkIdx);
                if (curTableIsInList != tableList.contains(curFk.getForeignTable())) {
                    fksToRemove.add(curFk);
                }
                Iterator fkIt = fksToRemove.iterator();
                while (fkIt.hasNext()) {
                    curTable.removeForeignKey((ForeignKey)fkIt.next());
                }
                ++fkIdx;
            }
            ++tableIdx;
        }
    }
}

