#include <stdio.h>
#include "bootpack.h"

struct FIFO32 *fdfifo;

void inthandler26(int *esp)
/* FDRg[̊荞 */
{
 	/**/
 	io_out8(PIC0_OCW2, 0x66);	/* IRQ-06tPICɒʒm */
 
	fifo32_put(fdfifo,3000);

	return;
}

void init_fd(struct FIFO32 *fifo)
{
  fdfifo = fifo;
  return;
}

//ZN^[0̏񂩂BPEъe_ZN^ʒuZo
void bpe_read(struct FD_BPE *fdbpe,char *buf)
{
  int i;

  fdbpe->sec_suu=buf[12]*0x100 + buf[11];
  fdbpe->cras_size=buf[13];
  fdbpe->fat_start=buf[15]*0x100 + buf[14];
  fdbpe->fat_suu=buf[16];

  fdbpe->root_len=buf[18]*0x100 + (buf[17] & 0xf0);

  fdbpe->disk_size=buf[20]*0x100 + buf[19];
  fdbpe->fat_len=buf[23]*0x100 + buf[22];
  fdbpe->track_suu=buf[25]*0x100 + buf[24];
  fdbpe->head_suu=buf[27]*0x100 + buf[26];
  fdbpe->allsec_suu=buf[35]*0x100000 + buf[34]*0x1000 + buf[33]*0x100 + buf[32];

  for ( i = 0; i <= 11; i++)
    {
      fdbpe->volume[i] = buf[43 + i];
    }

  for ( i = 0; i <= 5; i++)
    {
      fdbpe->disktype[i]= buf[54 + i];
    }

  //_ZN^ւ̉Z
  fdbpe->r_ipl = 0;

  fdbpe->r_fat1s = fdbpe->r_ipl + fdbpe->fat_start;
  fdbpe->r_fat1e = fdbpe->r_fat1s + fdbpe->fat_len - 1;
  //ʂ邪AFATȂꍇ̑Ώ
  if ( fdbpe->fat_suu == 2 )
    {
      fdbpe->r_fat2s = fdbpe->r_fat1s + fdbpe->fat_len;
      fdbpe->r_fat2e = fdbpe->r_fat2s + fdbpe->fat_len - 1;
    }
  else
    {
      //蔲EEEE
      fdbpe->r_fat2s = 0;
      fdbpe->r_fat2e = 0;
    }

  //[g̈
  fdbpe->r_roots = fdbpe->r_fat1s + ( fdbpe->fat_suu * fdbpe->fat_len);
  fdbpe->r_roote = fdbpe->r_roots + ( fdbpe->root_len * 32 / fdbpe->sec_suu)-1;

  //f[^̈
  fdbpe->r_datas = fdbpe->r_roote + 1;
  fdbpe->r_datae = fdbpe->allsec_suu - 1;


  return;
}


void fd_dma_set(int onoff)
{
  //DMȀꏊ
  char *DMA_ADD;
  DMA_ADD = 0x7c00;





  if(onoff == 0)
    {
      //=============ǂݍݗpDMAݒ=============
      //[hݒFf}hEAhXEւ̏݁Ech2
      io_out8(0x000b, 0x06);
      // ǂݍރoCg̐ݒ i512oCgݒ肵j
      io_out8(0x0005, 0xff);
      io_out8(0x0005, 1 * 2 - 1);
      // ǂݍރԒn̐ݒ 
      io_out8(0x0004, ((int)DMA_ADD) & 0xff);
      io_out8(0x0004, ((int)DMA_ADD >> 8) & 0xff); 
      io_out8(0x0081, ((int)DMA_ADD >> 16) & 0xff);
      // }X^ch2DMA}XN 
      io_out8(0x000a, 0x02); 
      //=============================================
    }
  else
    {
      io_out8(0x000a, 0x06); /* }X^ch2DMA}XN */
    }






  return;

}


//_ZN^𕨗ZN^ɕϊ
void fd_r2b(int rsec, int *parm, struct FDTIME fdtime)
{
  int Mc = 80;
  int Mh = 2;
  int Ms = 18;

  parm[2] = rsec % Ms +1;
  parm[1] = (rsec / Ms) % Mh;
  parm[0] = (rsec / Ms) / Mh;

}





int send_sec_read(int C, int H, int S,struct FDTIME fdtime1)
{
  int f;

  //[^[mFAĂȂȂ܂킷
  if ( fdtime1.moter_now == 0)
    {
      fd_moter(1,fdtime1);
    }

  //R}hMO̊mFё҂
  //^C}[3bɐݒBȏ㔽ȂȂG[B
  timer_settime(fdtime1.timer,300);
  while(io_in8(0x03f4) & 0x11 != 0x00 )
    {
      if (fifo32_status(fdtime1.fifo) !=0)
	{
	f = fifo32_get(fdtime1.fifo);
	if ( f == 10)
	    {
	      return 105;
	    }
	}
    }

  //ǂݍ݃R}hsiC0AH0AS1j
  //  timer_settime(fdtime1.timer,300);
  while(io_in8(0x03f4) & 0xC0 != 0x80 )
    {
      if (fifo32_status(fdtime1.fifo) !=0)
	{
	f = fifo32_get(fdtime1.fifo);
	if ( f == 10)
	    {
	      return 110;
	    }
	}
    }
  io_out8(0x03f5, 0xE6);

  //============ H << 2 ================
  //  timer_settime(fdtime1.timer,300);
  while(io_in8(0x03f4) & 0xC0 != 0x80 )
    {
      if (fifo32_status(fdtime1.fifo) !=0)
	{
	f = fifo32_get(fdtime1.fifo);
	if ( f == 10)
	    {
	      return 115;
	    }
	}
    }
  io_out8(0x03f5, H << 2);

  //============ C ================
  //  timer_settime(fdtime1.timer,300);
  while(io_in8(0x03f4) & 0xC0 != 0x80 )
    {
      if (fifo32_status(fdtime1.fifo) !=0)
	{
	f = fifo32_get(fdtime1.fifo);
	if ( f == 10)
	    {
	      return 120;
	    }
	}
    }
  io_out8(0x03f5, C);

  //============ H ================
  //  timer_settime(fdtime1.timer,300);
  while(io_in8(0x03f4) & 0xC0 != 0x80 )
    {
      if (fifo32_status(fdtime1.fifo) !=0)
	{
	f = fifo32_get(fdtime1.fifo);
	if ( f == 10)
	    {
	      return 125;
	    }
	}
    }
  io_out8(0x03f5, H);

  //============ S ================
  //  timer_settime(fdtime1.timer,300);
  while(io_in8(0x03f4) & 0xC0 != 0x80 )
    {
      if (fifo32_status(fdtime1.fifo) !=0)
	{
	f = fifo32_get(fdtime1.fifo);
	if ( f == 10)
	    {
	      return 130;
	    }
	}
    }
  io_out8(0x03f5, S);
	  
  //  timer_settime(fdtime1.timer,300);
  while(io_in8(0x03f4) & 0xC0 != 0x80 )
    {
      if (fifo32_status(fdtime1.fifo) !=0)
	{
	f = fifo32_get(fdtime1.fifo);
	if ( f == 10)
	    {
	      return 135;
	    }
	}
    }
  io_out8(0x03f5, 0x02);

  //  timer_settime(fdtime1.timer,300);
  while(io_in8(0x03f4) & 0xC0 != 0x80 )
    {
      if (fifo32_status(fdtime1.fifo) !=0)
	{
	f = fifo32_get(fdtime1.fifo);
	if ( f == 10)
	    {
	      return 140;
	    }
	}
    }
  io_out8(0x03f5, 0x12);

  //  timer_settime(fdtime1.timer,300);
  while(io_in8(0x03f4) & 0xC0 != 0x80 )
    {
      if (fifo32_status(fdtime1.fifo) !=0)
	{
	f = fifo32_get(fdtime1.fifo);
	if ( f == 10)
	    {
	      return 145;
	    }
	}
    }
  io_out8(0x03f5, 0x01);

  //  timer_settime(fdtime1.timer,300);
  while(io_in8(0x03f4) & 0xC0 != 0x80 )
    {
      if (fifo32_status(fdtime1.fifo) !=0)
	{
	f = fifo32_get(fdtime1.fifo);
	if ( f == 10)
	    {
	      return 150;
	    }
	}
    }
  io_out8(0x03f5, 0xFF);
  //sB
  timer_cancel(fdtime1.timer);

  return 0;

}




//UgR[h̎Mߔs==============================
int get_rez(struct FDTIME fdtime1)
{
  int f;
  //Ug̎󂯎M
  int rez[40];


  //uCN̂ŃUgQbg
	  
  timer_settime(fdtime1.timer,300);

  while(io_in8(0x03f4) & 0xC0 != 0xC0 )
    {
      if (fifo32_status(fdtime1.fifo) !=0)
	{
	f = fifo32_get(fdtime1.fifo);
	if ( f == 10)
	    {
	      return 205;
	    }
	}
    }
  rez[0] = io_in8(0x03f5);

  while(io_in8(0x03f4) & 0xC0 != 0xC0 )
    {
      if (fifo32_status(fdtime1.fifo) !=0)
	{
	f = fifo32_get(fdtime1.fifo);
	if ( f == 10)
	    {
	      return 210;
	    }
	}
    }
  rez[1] = io_in8(0x03f5);

  while(io_in8(0x03f4) & 0xC0 != 0xC0 )
    {
      if (fifo32_status(fdtime1.fifo) !=0)
	{
	f = fifo32_get(fdtime1.fifo);
	if ( f == 10)
	    {
	      return 215;
	    }
	}
    }
  rez[2] = io_in8(0x03f5);
  
  while(io_in8(0x03f4) & 0xC0 != 0xC0 )
    {
      if (fifo32_status(fdtime1.fifo) !=0)
	{
	f = fifo32_get(fdtime1.fifo);
	if ( f == 10)
	    {
	      return 220;
	    }
	}
    }
  rez[3] = io_in8(0x03f5);

  while(io_in8(0x03f4) & 0xC0 != 0xC0 )
    {
      if (fifo32_status(fdtime1.fifo) !=0)
	{
	f = fifo32_get(fdtime1.fifo);
	if ( f == 10)
	    {
	      return 220;
	    }
	}
    }
  rez[4] = io_in8(0x03f5);

  while(io_in8(0x03f4) & 0xC0 != 0xC0 )
    {
      if (fifo32_status(fdtime1.fifo) !=0)
	{
	f = fifo32_get(fdtime1.fifo);
	if ( f == 10)
	    {
	      return 225;
	    }
	}
    }
  rez[5] = io_in8(0x03f5);

  while(io_in8(0x03f4) & 0xC0 != 0xC0 )
    {
      if (fifo32_status(fdtime1.fifo) !=0)
	{
	f = fifo32_get(fdtime1.fifo);
	if ( f == 10)
	    {
	      return 225;
	    }
	}
    }
  rez[6] = io_in8(0x03f5);

  //ȂƂȂAŏIƂƂŒǉ
  rez[7] = 0x00;

  //ɏI悤Ȃ̂Ń^C}[̌n
  timer_cancel(fdtime1.timer);

  return rez[0] & 0xc0 ;
}


//=========FD[^[̐============
void fd_moter(char v,struct FDTIME fdtime1)
{
  int f;


  if (v == 0)
    {
      //[^[~
      io_out8(0x03f2, 0x0c); 
      //[^[~mɂ邽߁Ab҂
      //      sprintf(s,"start!%02d",t);
      //      putfonts8_asc(0xa0000,800,8,16*3,COL8_008484,"aaaaa");

      timer_settime(fdtime1.timer,100);
      for (;;)
	{
	  if (fifo32_status(fdtime1.fifo) !=0)
	    {
	      f = fifo32_get(fdtime1.fifo);
	      if ( f == 10)
		{
		  break;
		}
	    }
	}
      fdtime1.moter_now = 0;
      fdtime1.moter_time = 0;

    }
  else
    {
      //[^[]
      io_out8(0x03f2, 0x1c); 
      //[^[]mɂ邽߁Ab҂
      timer_settime(fdtime1.timer,100);
      for (;;)
	{
	  if (fifo32_status(fdtime1.fifo) !=0)
	    {
	      f = fifo32_get(fdtime1.fifo);
	      if ( f == 10)
		{
		  break;
		}
	    }
	}
      fdtime1.moter_now = 1;
      fdtime1.moter_time = 1;
    }

  return;
}

//=========================================================
//====================@֐ҁ@======================
//=========================================================
int read_sector(int c,int h,int s,char *ssbuf,struct FDTIME fdtime1)
{
  int err1;
  int fifodata;

  int i;

  //DMAJ
  fd_dma_set(0);
  //ǂݍ݃R}hM
  err1 = send_sec_read(c,h,s,fdtime1);
  if ( err1 == 0 )
    {
      //fifoNBɂĂ
      //      while( fifo32_status(fdtime1.fifo) != 0 )
      //	{
      //	  fifodata = fifo32_get(fdtime1.fifo);
      //	}

      //^C}[ݒuĂB
      //荞݂߂ĂȂꍇɔ
      timer_settime(fdtime1.timer,900);
      for (;;)
	{
	  io_cli();
	  if (fifo32_status(fdtime1.fifo) ==0)
	    {
	      io_sti();
	    }
	  else
	    {
	      fifodata = fifo32_get(fdtime1.fifo);
	      io_sti();
	      //荞݂uCN
	      break;
	    }
	}

      if ( fifodata == 3000)
	{
	  //I^C}̌n
	  timer_cancel(fdtime1.timer);

	  //{ɐ킩ǂAUg
	  err1 = get_rez(fdtime1);
		
	  //UgɎ擾ł
	  if ( err1 == 0)
	    { 
	      //YꂸDMAĂ
	      fd_dma_set(1);
	
	      //̃^XÑobt@ɓǂݍ
	      for (i=0;i <= 511;i++)
		{
		  ssbuf[i] = fdtime1.DMA_ADD[i];
		}

	    }

	  //Ug̃G[
	  else
	    {
	      err1 = 300;
	    }
	}
      //^C}荞݂G[
      else if ( fifodata == 10 )
	{
	  err1 = 200;
	}

      //s̃G[H
      else 
	{
	  //	  err1 = 200;
	  err1 = fifodata;
	}
    }
  return err1;
}

int read_r_sec (int r_sec, char *ssbuf,struct FDTIME fdtime1)
{
  int err1;

  int bsec[3];

  fd_r2b(r_sec,bsec,fdtime1);


  //  bsec[0] = 0;
  //  bsec[1] = 0;
  //  bsec[2] = 1;


  err1 = read_sector(bsec[0],bsec[1],bsec[2],ssbuf,fdtime1);




  return err1;
}
