/* bootpack̃C */

#include "bootpack.h"
#include <stdio.h>

#define KEYCMD_LED		0xed

#define taskbar_y   20

void keywin_off(struct SHEET *key_win);
void keywin_on(struct SHEET *key_win);
void close_console(struct SHEET *sht);
void close_constask(struct TASK *task);

void tbartask(struct SHEET *sheet);
void cmos_get(unsigned char *t);

void test_task(struct SHEET *sheet);

void HariMain(void)
{
	struct BOOTINFO *binfo = (struct BOOTINFO *) ADR_BOOTINFO;
	struct SHTCTL *shtctl;
	char s[40];
	struct FIFO32 fifo, keycmd;
	int fifobuf[128], keycmd_buf[32];
	int mx, my, i, new_mx = -1, new_my = 0, new_wx = 0x7fffffff, new_wy = 0;
	unsigned int memtotal;
	struct MOUSE_DEC mdec;
	struct MEMMAN *memman = (struct MEMMAN *) MEMMAN_ADDR;
	unsigned char *buf_back, buf_mouse[256];
	struct SHEET *sht_back, *sht_mouse;
	struct TASK *task_a, *task;
	static char keytable0[0x80] = {
		0,   0,   '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '-', '^', 0x08, 0,
		'Q', 'W', 'E', 'R', 'T', 'Y', 'U', 'I', 'O', 'P', '@', '[', 0x0a, 0, 'A', 'S',
		'D', 'F', 'G', 'H', 'J', 'K', 'L', ';', ':', 0,   0,   ']', 'Z', 'X', 'C', 'V',
		'B', 'N', 'M', ',', '.', '/', 0,   '*', 0,   ' ', 0,   0,   0,   0,   0,   0,
		0,   0,   0,   0,   0,   0,   0,   '7', '8', '9', '-', '4', '5', '6', '+', '1',
		'2', '3', '0', '.', 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
		0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
		0,   0,   0,   0x5c, 0,  0,   0,   0,   0,   0,   0,   0,   0,   0x5c, 0,  0
	};
	static char keytable1[0x80] = {
		0,   0,   '!', 0x22, '#', '$', '%', '&', 0x27, '(', ')', '~', '=', '~', 0x08, 0,
		'Q', 'W', 'E', 'R', 'T', 'Y', 'U', 'I', 'O', 'P', '`', '{', 0x0a, 0, 'A', 'S',
		'D', 'F', 'G', 'H', 'J', 'K', 'L', '+', '*', 0,   0,   '}', 'Z', 'X', 'C', 'V',
		'B', 'N', 'M', '<', '>', '?', 0,   '*', 0,   ' ', 0,   0,   0,   0,   0,   0,
		0,   0,   0,   0,   0,   0,   0,   '7', '8', '9', '-', '4', '5', '6', '+', '1',
		'2', '3', '0', '.', 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
		0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
		0,   0,   0,   '_', 0,   0,   0,   0,   0,   0,   0,   0,   0,   '|', 0,   0
	};
	int key_shift = 0, key_leds = (binfo->leds >> 4) & 7, keycmd_wait = -1;
	int j, x, y, mmx = -1, mmy = -1, mmx2 = 0;
	struct SHEET *sht = 0, *key_win, *sht2;
	int *fat;
	unsigned char *nihongo;
	struct FILEINFO *finfo;
	extern char hankaku[4096];

	init_gdtidt();
	init_pic();
	io_sti(); /* IDT/PIC̏ÎCPŮ荞݋֎~ */
	fifo32_init(&fifo, 128, fifobuf, 0);
	*((int *) 0x0fec) = (int) &fifo;
	init_pit();
	init_keyboard(&fifo, 256);
	enable_mouse(&fifo, 512, &mdec);
	//	init_fd(&fifo);
	//	io_out8(PIC0_IMR, 0xf8); /* PITPIC1ƃL[{[h(11111000) */
	io_out8(PIC0_IMR, 0xb8); /* PIT,PIC1,L[{[h,fd(10111000) */
	io_out8(PIC1_IMR, 0xef); /* }EX(11101111) */
	fifo32_init(&keycmd, 32, keycmd_buf, 0);

	memtotal = memtest(0x00400000, 0xbfffffff);
	memman_init(memman);
	memman_free(memman, 0x00001000, 0x0009e000); /* 0x00001000 - 0x0009efff */
	memman_free(memman, 0x00400000, memtotal - 0x00400000);

	init_palette();
	shtctl = shtctl_init(memman, binfo->vram, binfo->scrnx, binfo->scrny);
	task_a = task_init(memman);
	fifo.task = task_a;
	task_run(task_a, 1, 2);
	*((int *) 0x0fe4) = (int) shtctl;
	task_a->langmode = 0;


	/*wiƃjZ^XNo[̕`*/
	/* sht_back */
	sht_back  = sheet_alloc(shtctl);
	buf_back  = (unsigned char *) memman_alloc_4k(memman, binfo->scrnx * binfo->scrny);
	sheet_setbuf(sht_back, buf_back, binfo->scrnx, binfo->scrny, -1); /* FȂ */
	init_screen8(buf_back, binfo->scrnx, binfo->scrny);

	/* sht_cons */
		key_win = open_console(shtctl, memtotal);


	//======= ^XNo[{v======================
	struct SHEET *tbar_sht = sheet_alloc(shtctl);
	tbar_sht->titlebar = 1;
	tbar_sht->closedbutton = 1;
	unsigned char *tbarbuf=(unsigned char *) memman_alloc_4k(memman,binfo->scrnx*taskbar_y);
	sheet_setbuf(tbar_sht,tbarbuf,binfo->scrnx,taskbar_y,-1);
	struct TASK *tbar_task = task_alloc();
	int *tbar_fifo = (int *) memman_alloc_4k(memman,128*4);
	tbar_task->cons_stack = memman_alloc_4k(memman,64*1024);
	tbar_task->tss.esp = tbar_task->cons_stack + 64 * 1024 - 12;
	tbar_task->tss.eip = (int) &tbartask;
	tbar_task->tss.es = 1 * 8;
	tbar_task->tss.cs = 2 * 8;
	tbar_task->tss.ss = 1 * 8;
	tbar_task->tss.ds = 1 * 8;
	tbar_task->tss.fs = 1 * 8;
	tbar_task->tss.gs = 1 * 8;
	*((int *) (tbar_task->tss.esp + 4)) = (int) tbar_sht;
	tbar_sht->task = tbar_task;
	task_run(tbar_task, 2, 2); /* level=2, priority=2 */
	fifo32_init(&tbar_task->fifo, 128, tbar_fifo, tbar_task);
	//==============================================



	//eXgEBhD
	//=============================
	//܂~Ă
	struct SHEET *testsht = sheet_alloc(shtctl);
	//̉~͈ړN[YȂ̂Ń}[NB
	//	testsht->titlebar = 1;
	//	testsht->closedbutton = 1;
	//̃V[gɏ߂悤Aobt@mۂB
	//傫̂memman_allocgifj
	unsigned char *testbuf=(unsigned char *) memman_alloc_4k(memman,400*400);
	//̃obt@testwin~Ŏgpł悤ɓč
	sheet_setbuf(testsht,testbuf,400,400,-1);
	//obt@ɃEBhD쐬
	make_window8(testbuf,400,400,"testwin",0);
	//V^XN邽߁Ataskman^XNĂ
	struct TASK *testtask = task_alloc();



	//̃^XNŎgfifoobt@mۂ
	int *testfifo = (int *) memman_alloc_4k(memman,128*4);
	//^XÑWX^
	testtask->cons_stack = memman_alloc_4k(memman,64*1024);
	testtask->tss.esp = testtask->cons_stack + 64 * 1024 - 12;
	//^XN̎s֐̃AhX𓖂č
	testtask->tss.eip = (int) &test_task;
	testtask->tss.es = 1 * 8;
	testtask->tss.cs = 2 * 8;
	testtask->tss.ss = 1 * 8;
	testtask->tss.ds = 1 * 8;
	testtask->tss.fs = 1 * 8;
	testtask->tss.gs = 1 * 8;
	//͎s֐ɓni *sheetnj
	*((int *) (testtask->tss.esp + 4)) = (int) testsht;
	//	*((int *) (testtask->tss.esp + 8)) = memtotal;
	//ŌɁAsheetł^XN悤sheet\̂ɂ̃^XN𓖂č
	testsht->task = testtask;
	//^XN𑖂点
	task_run(testtask, 2, 2); /* level=2, priority=2 */
	//^XNfiroɓč݂s
	fifo32_init(&testtask->fifo, 128, testfifo, testtask);

	//=================================================



	/* sht_mouse */
	sht_mouse = sheet_alloc(shtctl);
	sheet_setbuf(sht_mouse, buf_mouse, 16, 16, 99);
	init_mouse_cursor8(buf_mouse, 99);
	mx = (binfo->scrnx - 16) / 2; /* ʒɂȂ悤ɍWvZ */
	my = (binfo->scrny - 28 - 16) / 2;

	/*  eV[gԂɂ*/
	sheet_slide(sht_back,  0,  0);
	sheet_slide(key_win,   32, 32);
	sheet_slide(sht_mouse, mx, my);
	sheet_updown(sht_back,  0);
	sheet_updown(key_win,   1);
	sheet_updown(sht_mouse, 2);
	keywin_on(key_win);
	//==== ^XNo[@========
	sheet_slide(tbar_sht,   0, 0);
	sheet_updown(tbar_sht,   1);

	//==== eXg^XN@========
	sheet_slide(testsht,   32, 32);
	sheet_updown(testsht,   1);




	/* ŏɃL[{[hԂƂ̐HႢȂ悤ɁAݒ肵ĂƂɂ */
	fifo32_put(&keycmd, KEYCMD_LED);
	fifo32_put(&keycmd, key_leds);

	/* nihongo.fnt̓ǂݍ */
	fat = (int *) memman_alloc_4k(memman, 4 * 2880);
	file_readfat(fat, (unsigned char *) (ADR_DISKIMG + 0x000200));

	finfo = file_search("nihongo.fnt", (struct FILEINFO *) (ADR_DISKIMG + 0x002600), 224);
	if (finfo != 0) {
		i = finfo->size;
		nihongo = file_loadfile2(finfo->clustno, &i, fat);
	} else {
		nihongo = (unsigned char *) memman_alloc_4k(memman, 16 * 256 + 32 * 94 * 47);
		for (i = 0; i < 16 * 256; i++) {
			nihongo[i] = hankaku[i]; /* tHgȂ̂ŔpRs[ */
		}
		for (i = 16 * 256; i < 16 * 256 + 32 * 94 * 47; i++) {
			nihongo[i] = 0xff; /* tHgȂ̂őSp0xffŖߐs */
		}
	}
	*((int *) 0x0fe8) = (int) nihongo;
	memman_free_4k(memman, (int) fat, 4 * 2880);

	for (;;) {
		if (fifo32_status(&keycmd) > 0 && keycmd_wait < 0) {
			/* L[{[hRg[ɑf[^΁A */
			keycmd_wait = fifo32_get(&keycmd);
			wait_KBC_sendready();
			io_out8(PORT_KEYDAT, keycmd_wait);
		}
		io_cli();
		if (fifo32_status(&fifo) == 0) {
			/* FIFOۂɂȂ̂ŁAۗĂ`悪Ύs */
			if (new_mx >= 0) {
				io_sti();
				sheet_slide(sht_mouse, new_mx, new_my);
				new_mx = -1;
			} else if (new_wx != 0x7fffffff) {
				io_sti();
				sheet_slide(sht, new_wx, new_wy);
				new_wx = 0x7fffffff;
			} else {
				task_sleep(task_a);
				io_sti();
			}
		} else {
			i = fifo32_get(&fifo);

			io_sti();
			if (key_win != 0 && key_win->flags == 0) {	/* EBhEꂽ */
				if (shtctl->top == 1) {	/* }EXƔwiȂ */
					key_win = 0;
				} else {
					key_win = shtctl->sheets[shtctl->top - 1];
					keywin_on(key_win);
				}
			}
			if (256 <= i && i <= 511) { /* L[{[hf[^ */
				if (i < 0x80 + 256) { /* L[R[h𕶎R[hɕϊ */
					if (key_shift == 0) {
						s[0] = keytable0[i - 256];
					} else {
						s[0] = keytable1[i - 256];
					}
				} else {
					s[0] = 0;
				}
				if ('A' <= s[0] && s[0] <= 'Z') {	/* ͕At@xbg */
					if (((key_leds & 4) == 0 && key_shift == 0) ||
							((key_leds & 4) != 0 && key_shift != 0)) {
						s[0] += 0x20;	/* 啶ɕϊ */
					}
				}
				if (s[0] != 0 && key_win != 0) { /* ʏ핶AobNXy[XAEnter */

					  fifo32_put(&key_win->task->fifo, s[0] + 256);
				}

				if (i == 256 + 0x0f && key_win != 0) {	/* Tab */
					keywin_off(key_win);
					j = key_win->height - 1;
					if (j == 0) {
						j = shtctl->top - 1;
					}
					key_win = shtctl->sheets[j];
					keywin_on(key_win);
				}
				if (i == 256 + 0x2a) {	/* Vtg ON */
					key_shift |= 1;
				}
				if (i == 256 + 0x36) {	/* EVtg ON */
					key_shift |= 2;
				}
				if (i == 256 + 0xaa) {	/* Vtg OFF */
					key_shift &= ~1;
				}
				if (i == 256 + 0xb6) {	/* EVtg OFF */
					key_shift &= ~2;
				}
				if (i == 256 + 0x3a) {	/* CapsLock */
					key_leds ^= 4;
					fifo32_put(&keycmd, KEYCMD_LED);
					fifo32_put(&keycmd, key_leds);
				}
				if (i == 256 + 0x45) {	/* NumLock */
					key_leds ^= 2;
					fifo32_put(&keycmd, KEYCMD_LED);
					fifo32_put(&keycmd, key_leds);
				}
				if (i == 256 + 0x46) {	/* ScrollLock */
					key_leds ^= 1;
					fifo32_put(&keycmd, KEYCMD_LED);
					fifo32_put(&keycmd, key_leds);
				}
				if (i == 256 + 0x3b && key_shift != 0 && key_win != 0) {	/* Shift+F1 */
					task = key_win->task;
					if (task != 0 && task->tss.ss0 != 0) {
						cons_putstr0(task->cons, "\nBreak(key) :\n");
						io_cli();	/* IɃ^XNςƍ邩 */
						task->tss.eax = (int) &(task->tss.esp0);
						task->tss.eip = (int) asm_end_app;
						io_sti();
						task_run(task, -1, 0);	/* Imɂ点邽߂ɁAQĂN */
					}
				}
				if (i == 256 + 0x3c && key_shift != 0) {	/* Shift+F2 */
					/* VR\[͑IԂɂîقe؂ˁHj */
					if (key_win != 0) {
						keywin_off(key_win);
					}
					key_win = open_console(shtctl, memtotal);
					sheet_slide(key_win, 32, 4);
					sheet_updown(key_win, shtctl->top);
					keywin_on(key_win);
				}
				if (i == 256 + 0x57) {	/* F11 */
					sheet_updown(shtctl->sheets[1], shtctl->top - 1);
				}
				if (i == 256 + 0xfa) {	/* L[{[hf[^𖳎Ɏ󂯎 */
					keycmd_wait = -1;
				}
				if (i == 256 + 0xfe) {	/* L[{[hf[^𖳎Ɏ󂯎Ȃ */
					wait_KBC_sendready();
					io_out8(PORT_KEYDAT, keycmd_wait);
				}
			} else if (512 <= i && i <= 767) { /* }EXf[^ */
				if (mouse_decode(&mdec, i - 512) != 0) {
					/* }EXJ[\̈ړ */
					mx += mdec.x;
					my += mdec.y;
					if (mx < 0) {
						mx = 0;
					}
					if (my < 0) {
						my = 0;
					}
					if (mx > binfo->scrnx - 1) {
						mx = binfo->scrnx - 1;
					}
					if (my > binfo->scrny - 1) {
						my = binfo->scrny - 1;
					}
					new_mx = mx;
					new_my = my;
					if ((mdec.btn & 0x01) != 0) {
						/* {^Ă */
						if (mmx < 0) {
							/* ʏ탂[h̏ꍇ */
							/* ̉珇ԂɃ}EXwĂ鉺T */
							for (j = shtctl->top - 1; j > 0; j--) {
								sht = shtctl->sheets[j];
								x = mx - sht->vx0;
								y = my - sht->vy0;
								if (0 <= x && x < sht->bxsize && 0 <= y && y < sht->bysize) {
									if (sht->buf[y * sht->bxsize + x] != sht->col_inv) {
										sheet_updown(sht, shtctl->top - 1);
										if (sht != key_win) {
											keywin_off(key_win);
											key_win = sht;
											keywin_on(key_win);
										}
										if (3 <= x && x < sht->bxsize - 3 && 3 <= y && y < 21 && sht->titlebar == 0 ) {
											mmx = mx;	/* EBhEړ[h */
											mmy = my;
											mmx2 = sht->vx0;
											new_wy = sht->vy0;
										}
										if (sht->bxsize - 20 <= x && x < sht->bxsize - 4 && 7 <= y && y < 18 && sht->closedbutton == 0 ) {
											/* u~v{^NbN */
											if ((sht->flags & 0x10) != 0) {		/* AvEBhEH */
												task = sht->task;
												cons_putstr0(task->cons, "\nBreak(mouse) :\n");
												io_cli();	/* IɃ^XNςƍ邩 */
												task->tss.eax = (int) &(task->tss.esp0);
												task->tss.eip = (int) asm_end_app;
												io_sti();
												task_run(task, -1, 0);
											} else {	/* R\[ */
												task = sht->task;
												sheet_updown(sht, -1); /* Ƃ肠\ɂĂ */
												keywin_off(key_win);
												key_win = shtctl->sheets[shtctl->top - 1];
												keywin_on(key_win);
												io_cli();
												fifo32_put(&task->fifo, 4);
												io_sti();
											}
										}
										break;
									}
								}
							}
						} else {
							/* EBhEړ[h̏ꍇ */
							x = mx - mmx;	/* }EẌړʂvZ */
							y = my - mmy;
							new_wx = (mmx2 + x + 2) & ~3;
							new_wy = new_wy + y;
							mmy = my;	/* ړ̍WɍXV */
						}
					} else {
						/* {^ĂȂ */
						mmx = -1;	/* ʏ탂[h */
						if (new_wx != 0x7fffffff) {
							sheet_slide(sht, new_wx, new_wy);	/* xm肳 */
							new_wx = 0x7fffffff;
						}
					}
				}
			} else if (768 <= i && i <= 1023) {	/* R\[I */
				close_console(shtctl->sheets0 + (i - 768));
			} else if (1024 <= i && i <= 2023) {
				close_constask(taskctl->tasks0 + (i - 1024));
			} else if (2024 <= i && i <= 2279) {	/* R\[ */
				sht2 = shtctl->sheets0 + (i - 2024);
				memman_free_4k(memman, (int) sht2->buf, 256 * 165);
				sheet_free(sht2);
			}
			//	else if (3000 <= i && i <= 3999){
			//			  fifo32_put(&testtask->fifo,i);
			//			}
			

		}
	}
}

void keywin_off(struct SHEET *key_win)
{
	change_wtitle8(key_win, 0);
	if ((key_win->flags & 0x20) != 0) {
		fifo32_put(&key_win->task->fifo, 3); /* R\[̃J[\OFF */
	}
	return;
}

void keywin_on(struct SHEET *key_win)
{
	change_wtitle8(key_win, 1);
	if ((key_win->flags & 0x20) != 0) {
		fifo32_put(&key_win->task->fifo, 2); /* R\[̃J[\ON */
	}
	return;
}

struct TASK *open_constask(struct SHEET *sht, unsigned int memtotal)
{
	struct MEMMAN *memman = (struct MEMMAN *) MEMMAN_ADDR;
	struct TASK *task = task_alloc();
	int *cons_fifo = (int *) memman_alloc_4k(memman, 128 * 4);
	task->cons_stack = memman_alloc_4k(memman, 64 * 1024);
	task->tss.esp = task->cons_stack + 64 * 1024 - 12;
	task->tss.eip = (int) &console_task;
	task->tss.es = 1 * 8;
	task->tss.cs = 2 * 8;
	task->tss.ss = 1 * 8;
	task->tss.ds = 1 * 8;
	task->tss.fs = 1 * 8;
	task->tss.gs = 1 * 8;
	*((int *) (task->tss.esp + 4)) = (int) sht;
	*((int *) (task->tss.esp + 8)) = memtotal;
	task_run(task, 2, 2); /* level=2, priority=2 */
	fifo32_init(&task->fifo, 128, cons_fifo, task);
	return task;
}

struct SHEET *open_console(struct SHTCTL *shtctl, unsigned int memtotal)
{
	struct MEMMAN *memman = (struct MEMMAN *) MEMMAN_ADDR;
	struct SHEET *sht = sheet_alloc(shtctl);
	unsigned char *buf = (unsigned char *) memman_alloc_4k(memman, 656 * 421);
	sheet_setbuf(sht, buf, 656, 421, -1); /* FȂ */
	make_window8(buf, 656, 421, "console", 0);
	make_textbox8(sht, 8, 28, 640, 384, COL8_000000);
	sht->task = open_constask(sht, memtotal);
	sht->flags |= 0x20;	/* J[\ */
	return sht;
}

void close_constask(struct TASK *task)
{
	struct MEMMAN *memman = (struct MEMMAN *) MEMMAN_ADDR;
	task_sleep(task);
	memman_free_4k(memman, task->cons_stack, 64 * 1024);
	memman_free_4k(memman, (int) task->fifo.buf, 128 * 4);
	task->flags = 0; /* task_free(task); ̑ */
	return;
}

void close_console(struct SHEET *sht)
{
	struct MEMMAN *memman = (struct MEMMAN *) MEMMAN_ADDR;
	struct TASK *task = sht->task;
	memman_free_4k(memman, (int) sht->buf, 256 * 165);
	sheet_free(sht);
	close_constask(task);
	return;
}


void tbartask(struct SHEET *sheet){
  struct TASK *task = task_now();
  struct TIMER *timer1 = timer_alloc();
  int i;
  int fifodata;
  char s[40];

  //^XNo[Ƃĕ`
  boxfill8(sheet->buf, sheet->bxsize, COL8_FFFFFF, 0, 0, sheet->bxsize-1, taskbar_y);
  boxfill8(sheet->buf, sheet->bxsize, COL8_C6C6C6, 0, taskbar_y - 2, sheet->bxsize-1, taskbar_y - 2);
  boxfill8(sheet->buf, sheet->bxsize, COL8_000000, 0, taskbar_y-1, sheet->bxsize-1, taskbar_y-1);

  //l𗎂Ƃ
	char ptn_tl[8][9] = {
          "*********",
	  "******...",
	  "***......",
	  "**.......",
          "*........",
	  "*........",
	  "*........",
	  "........."
	  };
	ptboxfill8(sheet->buf,sheet->bxsize,0,0,9,8,ptn_tl,8,9,COL8_000000,COL8_FFFFFF);

	char ptn_tr[8][9] = {
          "*********",
	  "...******",
	  "......***",
	  ".......**",
          "........*",
	  "........*",
	  "........*",
	  "........."
	  };
	ptboxfill8(sheet->buf,sheet->bxsize,sheet->bxsize-10,0,sheet->bxsize+1,8,ptn_tr,8,9,COL8_000000,COL8_FFFFFF);

	char ptn_bbl[14][10] = {
          "********..",
          "*****.***.",
          ".****.****",
          ".****.****",
          ".****.****",
          ".********.",
          ".*******..",
          ".****.****",
          ".****.****",
          ".****.****",
          ".****.****",
          ".****.****",
          "*****.***.",
          "********.."

	  };
	ptboxfill8(sheet->buf,sheet->bxsize,10,2,20,16,ptn_bbl,14,10,COL8_000084,COL8_FFFFFF);

	putfonts8_asc_sht(sheet,8*4,2,COL8_000000,COL8_FFFFFF,"THE-BBL",7);






  sheet_refresh(sheet,0,0,sheet->bxsize-1,taskbar_y);





  //CMOS̎擾
    unsigned char t[7];
    cmos_get(t);

    //QbgCMOSf[^Ƃ肠\iɕϊ
    char timecalk[6];

    timecalk[0] = (t[5] >> 4) * 10 + (t[5] & 0x0f);
    timecalk[1] = (t[4] >> 4) * 10 + (t[4] & 0x0f);
    timecalk[2] = (t[3] >> 4) * 10 + (t[3] & 0x0f);
    timecalk[3] = (t[2] >> 4) * 10 + (t[2] & 0x0f);
    timecalk[4] = (t[1] >> 4) * 10 + (t[1] & 0x0f);
    timecalk[5] = (t[0] >> 4) * 10 + (t[0] & 0x0f);
    
  timer_init(timer1,&task->fifo,10);
  timer_settime(timer1,100);

  for(;;){

    io_cli();

    if (fifo32_status(&task->fifo) ==0){
      io_sti();
    }
    else{
      fifodata = fifo32_get(&task->fifo);

      if (fifodata == 10){
	timecalk[5]++;
	if (timecalk[5] >= 60){
	  timecalk[5] = 0;
	  timecalk[4]++;
	}
	if (timecalk[4] >= 60){
	  timecalk[4] = 0;
	  timecalk[3]++;
	}
	if (timecalk[3] >= 24){
	  timecalk[3] = 0;
	  timecalk[2]++;
	}

	timer_settime(timer1,100);
	io_sti();
      }


    sprintf(s, "%02d:%02d:%02d", timecalk[3], timecalk[4], timecalk[5]);
    putfonts8_asc_sht(sheet,sheet->bxsize-74,2,COL8_000000,COL8_FFFFFF,s,8);

    }
  }
}

void cmos_get(unsigned char *t)
{
    char err;
    static unsigned char adr[7] = { 0x00, 0x02, 0x04, 0x07, 0x08, 0x09, 0x32 };
    static unsigned char max[7] = { 0x60, 0x59, 0x23, 0x31, 0x12, 0x99, 0x99 };
    int i;
    for (;;) { /* ǂݍ݂܂ŌJԂ */
        err = 0;
        for (i = 0; i < 7; i++) {
            io_out8(0x70, adr[i]);
            t[i] = io_in8(0x71);
        }
        for (i = 0; i < 7; i++) {
            io_out8(0x70, adr[i]);
            if (t[i] != io_in8(0x71) || (t[i] & 0x0f) > 9 || t[i] > max[i]) {
                err = 1;
            }
        }
        if (err == 0) {
            return;
        }
    }
}


void test_task(struct SHEET *sheet){
  struct MEMMAN *memman = (struct MEMMAN *) MEMMAN_ADDR;

  //DMȀꏊ
  char *DMA_ADD;
  DMA_ADD = 0x7c00;

  char sector[512];

  struct TASK *task = task_now();
  struct TIMER *timer1 = timer_alloc();
  timer_init(timer1,&task->fifo,10);

  int i;
  int fifodata;
  char s[40];
  char ascii;
  int cmdmode;


  //BPEۑp\
  struct FD_BPE fdbpe;

  //Ԍvp̃^C}[FIFO
  struct TIMER *ttimer = timer_alloc();
  int tfifobuf[32];
  struct FIFO32 *tfifo;
  fifo32_init(tfifo,32,tfifobuf,0);
  timer_init(ttimer,tfifo,10);

  //[^[AԌvKvȂ̂̃p[^̍\
  //ʂɔzł񂾂ǂ₱̂ŖO
  struct FDTIME fdtime1;
  fdtime1.timer = ttimer;
  fdtime1.fifo = tfifo;
  fdtime1.DMA_ADD = DMA_ADD;
  
  //[^[~BňUmɂƂ߂
  fd_moter(0,fdtime1);





  int counter;
  int counter2;
  counter = 0;
  counter2=0;

  //====== DMȀ===============
  io_out8(0x00d6, 0xc0); /* }X^ch0JXP[h[h */
  io_out8(0x00c0, 0x00); /* X[uDMA */
  io_out8(0x000a, 0x06); /* }X^ch2DMA}XN */


  //FDC̊荞݂ɐ؂ւĂ
  init_fd(tfifo);




  for(;;){
    counter++;
    if ( counter >100000 ){counter=0;}

    io_cli();

    if (fifo32_status(&task->fifo) ==0){
      io_sti();
    }
    else{
      fifodata = fifo32_get(&task->fifo);
      io_sti();
      if (fifodata >= 3000) {fifodata=fifodata+cmdmode;}


      sprintf(s, "fifo=%05d", fifodata);
      putfonts8_asc_sht(sheet,20,16*4,COL8_008484,COL8_FFFFFF,s,10);


      //==========^C}[̎
      if (fifodata == 10)
	{
	  sprintf(s, "TIME=%04d", counter2);
	  putfonts8_asc_sht(sheet,20,16*5,COL8_008484,COL8_FFFFFF,s,9);
	  counter2++;
	  timer_settime(ttimer,100);
	}

      //========== L[{[hꍇ̏ ========
      if (256 <= fifodata && fifodata <=511){ 
	ascii=fifodata-256;

	sprintf(s, "ASCII=%02x", ascii);
	putfonts8_asc_sht(sheet,20,16*5,COL8_008484,COL8_FFFFFF,s,8);
	//-------[1]ꍇiǂݍ݃R[h̎sj
	if (ascii == 0x31)
	  {

	    int err1;
	    //DMAJ
	    fd_dma_set(0);
	    //ǂݍ݃R}hM
	    err1 = send_sec_read(0,0,1,fdtime1);
	    if ( err1 == 0 )
	      {
		//^C}[ݒuĂB
		//荞݂߂ĂȂꍇɔ
		timer_settime(ttimer,300);
		for (;;)
		  {
		    io_cli();
		    if (fifo32_status(tfifo) ==0)
		      {
			io_sti();
		      }
		    else
		      {
			fifodata = fifo32_get(tfifo);
			io_sti();
			//荞݂uCN
			break;
		      }
		  }

		if ( fifodata == 3000)
		  {
		    //I^C}̌n
		    timer_cancel(ttimer);

		    //{ɐ킩ǂAUg
		    err1 = get_rez(fdtime1);
		
		    //UgɎ擾ł
		    if ( err1 == 0)
		      { 
			//YꂸDMAĂ
			fd_dma_set(1);
	
			//̃^XÑobt@ɓǂݍ
			for (i=0;i <= 511;i++)
			  {
			    sector[i] = DMA_ADD[i];
			  }
			
			//ǂݍ񂾂̂̓ZN^[0Ȃ̂BPÉI
			bpe_read(&fdbpe,sector);
		      }

		    //Ug̃G[
		    else
		      {
			err1 = 300;
		      }
		  }
		//^C}荞݂G[
		else if ( fifodata == 10 )
		  {
		    err1 = 6;
		  }

		//s̃G[H
		else {
		  err1 = 999;
		}


		//SĐȂEEEEEE
		if ( err1 == 0 )
		  {
		    //ʂɕ\Ă݂II
		    //ZN^
		    sprintf(s, "sector=%4d",fdbpe.sec_suu);
		    putfonts8_asc_sht(sheet,8,16*10,COL8_008484,COL8_FFFFFF,s,11);
		    //NX^
		    sprintf(s, "craster=%4d",fdbpe.cras_size);
		    putfonts8_asc_sht(sheet,8,16*11,COL8_008484,COL8_FFFFFF,s,12);
		    //FATJnn_
		    sprintf(s, "s_fat=%4d",fdbpe.fat_start);
		    putfonts8_asc_sht(sheet,8,16*12,COL8_008484,COL8_FFFFFF,s,10);
		    //FAT̐
		    sprintf(s, "fassuu=%4d",fdbpe.fat_suu);
		    putfonts8_asc_sht(sheet,8,16*13,COL8_008484,COL8_FFFFFF,s,11);
		    //[gfBNg̒
		    sprintf(s, "rootlen=%4d",fdbpe.root_len);
		    putfonts8_asc_sht(sheet,8,16*14,COL8_008484,COL8_FFFFFF,s,12);
		    //fBXN̑TCY
		    sprintf(s, "diskmax=%4d",fdbpe.disk_size);
		    putfonts8_asc_sht(sheet,8,16*15,COL8_008484,COL8_FFFFFF,s,12);
		    //Ƃ΂
		    //fat̒
		    sprintf(s, "fatlen=%4d",fdbpe.fat_len);
		    putfonts8_asc_sht(sheet,8,16*16,COL8_008484,COL8_FFFFFF,s,11);
		    //gbNɂZN^邩
		    sprintf(s, "tracksuu=%4d",fdbpe.track_suu);
		    putfonts8_asc_sht(sheet,8,16*17,COL8_008484,COL8_FFFFFF,s,13);
		    //wbh̐͂邩
		    sprintf(s, "headsuu=%4d",fdbpe.head_suu);
		    putfonts8_asc_sht(sheet,8,16*18,COL8_008484,COL8_FFFFFF,s,12);
		    //4Ƃ΂
		    //SZN^[
		    sprintf(s, "allsecsuu=%4d",fdbpe.allsec_suu);
		    putfonts8_asc_sht(sheet,8,16*19,COL8_008484,COL8_FFFFFF,s,14);
		    //6Ƃ΂
		    //{[xi11Hj
		    putfonts8_asc_sht(sheet,8,16*20,COL8_008484,COL8_FFFFFF,fdbpe.volume,11);
		    //ŌBifat̖ڈH@HHj
		    putfonts8_asc_sht(sheet,8,16*21,COL8_008484,COL8_FFFFFF,fdbpe.disktype,5);
		  }
		else
		  {
		    sprintf(s, "ERROR!! -%4d",err1);
		    putfonts8_asc_sht(sheet,8,16*3,COL8_008484,COL8_FFFFFF,s,13);
		  }





	      }


	    //fifoNBɂĂ
	    while( fifo32_status(fdtime1.fifo) != 0 )
	      {
		fifodata = fifo32_get(fdtime1.fifo);
		sprintf(s, "%08X",fifodata);
		putfonts8_asc_sht(sheet,8,16*(i+11),COL8_008484,COL8_FFFFFF,s,8);
	      }










	  }


	//L[{[h[2]EEE
	if (ascii == 0x32)
	  {
	    //ZN^[ǂݏo̊֐
	    //܂͕ZN^ŁEEE
	    int CC = 0;
	    int HH = 0;
	    int SS = 1;

	    int err1;
	    char ssbuf[512];

	    err1 = read_sector(CC,HH,SS,ssbuf,fdtime1);



	    //fifoNBɂĂ
	    while( fifo32_status(fdtime1.fifo) != 0 )
	      {
		fifodata = fifo32_get(fdtime1.fifo);
		sprintf(s, "%08X",fifodata);
		putfonts8_asc_sht(sheet,8,16*(i+11),COL8_008484,COL8_FFFFFF,s,8);
	      }




	    //ǂݍ񂾂̂̓ZN^[0Ȃ̂BPÉI
	    bpe_read(&fdbpe,ssbuf);


	    //BPE`FbN
	    sprintf(s,"IPL=%04d",fdbpe.r_ipl);
	    putfonts8_asc_sht(sheet,150,16*10,COL8_008484,COL8_FFFFFF,s,8);

	    sprintf(s,"FAT1s=%04d",fdbpe.r_fat1s);
	    putfonts8_asc_sht(sheet,150,16*11,COL8_008484,COL8_FFFFFF,s,10);

	    sprintf(s,"FAT1e=%04d",fdbpe.r_fat1e);
	    putfonts8_asc_sht(sheet,150,16*12,COL8_008484,COL8_FFFFFF,s,10);

	    sprintf(s,"FAT2s=%04d",fdbpe.r_fat2s);
	    putfonts8_asc_sht(sheet,150,16*13,COL8_008484,COL8_FFFFFF,s,10);

	    sprintf(s,"FAT2e=%04d",fdbpe.r_fat2e);
	    putfonts8_asc_sht(sheet,150,16*14,COL8_008484,COL8_FFFFFF,s,10);

	    sprintf(s,"RootS=%04d",fdbpe.r_roots);
	    putfonts8_asc_sht(sheet,150,16*15,COL8_008484,COL8_FFFFFF,s,10);

	    sprintf(s,"RootE=%04d",fdbpe.r_roote);
	    putfonts8_asc_sht(sheet,150,16*16,COL8_008484,COL8_FFFFFF,s,10);

	    sprintf(s,"DataS=%04d",fdbpe.r_datas);
	    putfonts8_asc_sht(sheet,150,16*17,COL8_008484,COL8_FFFFFF,s,10);

	    sprintf(s,"DataE=%04d",fdbpe.r_datae);
	    putfonts8_asc_sht(sheet,150,16*18,COL8_008484,COL8_FFFFFF,s,10);








	    /*	    	    for ( i = 0; i <= 8; i++)
	      {
		sprintf(s,"%08X\n",ssbuf[i]);
		putfonts8_asc_sht(sheet,8,16*i+96,COL8_008484,COL8_FFFFFF,s,8);
		}

	    for ( i = 0; i <= 8; i++)
	      {
		sprintf(s,"%08X\n",fdtime1.DMA_ADD[i]);
		putfonts8_asc_sht(sheet,80,16*i+96,COL8_008484,COL8_FFFFFF,s,8);
	      }


		sprintf(s,"%08X\n",fdtime1.DMA_ADD);
		putfonts8_asc_sht(sheet,8,280,COL8_008484,COL8_FFFFFF,s,8);
		sprintf(s,"%08X\n",DMA_ADD);
		putfonts8_asc_sht(sheet,8,296,COL8_008484,COL8_FFFFFF,s,8);


	    */



		//SĐȂEEEEEE
		if ( err1 == 0 )
		  {
		    //ʂɕ\Ă݂II
		    //ZN^
		    sprintf(s, "sector=%4d",fdbpe.sec_suu);
		    putfonts8_asc_sht(sheet,8,16*10,COL8_008484,COL8_FFFFFF,s,11);
		    //NX^
		    sprintf(s, "craster=%4d",fdbpe.cras_size);
		    putfonts8_asc_sht(sheet,8,16*11,COL8_008484,COL8_FFFFFF,s,12);
		    //FATJnn_
		    sprintf(s, "s_fat=%4d",fdbpe.fat_start);
		    putfonts8_asc_sht(sheet,8,16*12,COL8_008484,COL8_FFFFFF,s,10);
		    //FAT̐
		    sprintf(s, "fassuu=%4d",fdbpe.fat_suu);
		    putfonts8_asc_sht(sheet,8,16*13,COL8_008484,COL8_FFFFFF,s,11);
		    //[gfBNg̒
		    sprintf(s, "rootlen=%4d",fdbpe.root_len);
		    putfonts8_asc_sht(sheet,8,16*14,COL8_008484,COL8_FFFFFF,s,12);
		    //fBXN̑TCY
		    sprintf(s, "diskmax=%4d",fdbpe.disk_size);
		    putfonts8_asc_sht(sheet,8,16*15,COL8_008484,COL8_FFFFFF,s,12);
		    //Ƃ΂
		    //fat̒
		    sprintf(s, "fatlen=%4d",fdbpe.fat_len);
		    putfonts8_asc_sht(sheet,8,16*16,COL8_008484,COL8_FFFFFF,s,11);
		    //gbNɂZN^邩
		    sprintf(s, "tracksuu=%4d",fdbpe.track_suu);
		    putfonts8_asc_sht(sheet,8,16*17,COL8_008484,COL8_FFFFFF,s,13);
		    //wbh̐͂邩
		    sprintf(s, "headsuu=%4d",fdbpe.head_suu);
		    putfonts8_asc_sht(sheet,8,16*18,COL8_008484,COL8_FFFFFF,s,12);
		    //4Ƃ΂
		    //SZN^[
		    sprintf(s, "allsecsuu=%4d",fdbpe.allsec_suu);
		    putfonts8_asc_sht(sheet,8,16*19,COL8_008484,COL8_FFFFFF,s,14);
		    //6Ƃ΂
		    //{[xi11Hj
		    putfonts8_asc_sht(sheet,8,16*20,COL8_008484,COL8_FFFFFF,fdbpe.volume,11);
		    //ŌBifat̖ڈH@HHj
		    putfonts8_asc_sht(sheet,8,16*21,COL8_008484,COL8_FFFFFF,fdbpe.disktype,5);

		  }
		else
		  {
		    sprintf(s, "ERROR!! -%4d",err1);
		    putfonts8_asc_sht(sheet,8,16*3,COL8_008484,COL8_FFFFFF,s,13);
		  }



	    //fifoNBɂĂ
	    while( fifo32_status(fdtime1.fifo) != 0 )
	      {
		fifodata = fifo32_get(fdtime1.fifo);
		sprintf(s, "%08X",fifodata);
		putfonts8_asc_sht(sheet,8,16*(i+11),COL8_008484,COL8_FFFFFF,s,8);
	      }













	  }

	//L[{[h[4]EEE
	if (ascii == 0x34)
	  {

	    //_ZN^œǂݏo̊֐
	    //	    ZN^[OI
	    int r_sec = 0;


	    int err1;
	    char ssbuf[512];

	    err1 = read_r_sec(r_sec,ssbuf,fdtime1);


	    //	    err1 = read_sector(0,0,1,ssbuf,fdtime1);



	    //ǂݍ񂾂̂̓ZN^[0Ȃ̂BPÉI
	    bpe_read(&fdbpe,ssbuf);

	    




	    //fifoNBɂĂ
	    while( fifo32_status(fdtime1.fifo) != 0 )
	      {
		fifodata = fifo32_get(fdtime1.fifo);
		sprintf(s, "%08X",fifodata);
		putfonts8_asc_sht(sheet,8,16*(i+11),COL8_008484,COL8_FFFFFF,s,8);
	      }






	    //fat̍ŏǂł݂

	    

	    sprintf(s, "roots=%02d",fdbpe.r_roots);
	    putfonts8_asc_sht(sheet,8,16*6,COL8_008484,COL8_FFFFFF,s,8);


	    err1 = read_r_sec(fdbpe.r_roots,ssbuf,fdtime1);

	    sprintf(s, "ERR=%04d",err1);
	    putfonts8_asc_sht(sheet,8,16*7,COL8_008484,COL8_FFFFFF,s,8);



	    //ʂɕ\Ă݂
	    for ( i = 0; i <= 8; i++)
	      {
		sprintf(s, "%08X",ssbuf[i]);
		putfonts8_asc_sht(sheet,8,16*(i+9),COL8_008484,COL8_FFFFFF,s,8);

	      }







	  }






	if (ascii == 0x33)
	  {
	    int r_sec = 128;

	    int b_sec[3];

	    fd_r2b(r_sec,b_sec,fdtime1);


	    sprintf(s, "C=%02d,H=%02d,S=%02d",b_sec[0],b_sec[1],b_sec[2]);
	    putfonts8_asc_sht(sheet,20,16*21,COL8_008484,COL8_FFFFFF,s,14);




	  }














	//L[{[h[5]EEE
	if (ascii == 0x35)
	  {

	    //_ZN^œǂݏo̊֐
	    //	    ZN^[OI
	    int err1;
	    char ssbuf[512];

	    err1 = read_r_sec(0,ssbuf,fdtime1);


	    //ǂݍ񂾂̂̓ZN^[0Ȃ̂BPÉI
	    bpe_read(&fdbpe,ssbuf);

	    //fifoNBɂĂ
	    while( fifo32_status(fdtime1.fifo) != 0 )
	      {
		fifodata = fifo32_get(fdtime1.fifo);
		sprintf(s, "%08X",fifodata);
		putfonts8_asc_sht(sheet,8,16*(i+11),COL8_008484,COL8_FFFFFF,s,8);
	      }

	    //fat̍ŏǂł݂

	    int sss;
	    sss = 0;
	    //	    char *ssbuf2 = ( char *) memman_alloc_4k(memman, 512 * 14);
	    //	    char *ssbuf;
	    //	    ssbuf = ssbuf2;
	    char *ssbuf2;
	    ssbuf2 = memman_alloc_4k(memman, 512 * 14);

	    //	    err1 = read_r_sec(19,ssbuf2,fdtime1);
	    for ( i = fdbpe.r_roots; i <= fdbpe.r_roote; i++)
	      {
		err1 = read_r_sec(i,ssbuf2+(512*sss),fdtime1);

		sprintf(s, "sect=%04d",i);
		putfonts8_asc_sht(sheet,8,16*7,COL8_008484,COL8_FFFFFF,s,9);

		sss++;
	      }

	    
	    //ʂɕ\Ă݂
	    for ( i = 0; i <= 8; i++)
	      {
		sprintf(s, "%08X",ssbuf2[i]);
		putfonts8_asc_sht(sheet,8,16*(i+9),COL8_008484,COL8_FFFFFF,s,8);

	      }
	    
	    struct FILEINFO *finfo ;
	    finfo = ssbuf2;


	    //	    sprintf(s, &finfo->name);
	    putfonts8_asc_sht(sheet,8,16*21,COL8_008484,COL8_FFFFFF,&finfo->name,8);






	  }


      }

    }

      sprintf(s, "COUNTER=%5d",counter);
      putfonts8_asc_sht(sheet,20,16*2,COL8_008484,COL8_FFFFFF,s,13);
  }
}
