using System;
using System.Collections.Generic;
using System.Text;
using System.Diagnostics;
using System.Web;
using System.IO;
using System.Net;

using Bellagio.Data;
using Bellagio.ExternalData;
using Bellagio.Screening;

#if UNITTEST
using NUnit.Framework
#endif

namespace Bellagio.Personal {
    //_E[hăf[^𖄂߂{
    //ŏɕKvCSVt@C擾 _data ̒g쐬AɊet@CɏŃf[^XVB
    internal class DailyDataUpdateProcess {
        public enum ErrorCodeT {
            Unknown, Login, Network
        }
        public interface IProcessHost {
            void OnDownloadStart(string msg);
            void OnImportData(int stock_count, int max_count);
        }

        //indexɊ܂܂Ȃ擾̂ŁAL[Stockł͂Ȃ̖R[h
        //_E[hԂ̓rŏp~VKꂪ̂ŁAValue̔znull܂܂邱Ƃ
        private Dictionary<string, SimpleCandle[]> _data;
        private string _account;
        private string _password;
        private int[] _targetDates;
        private ErrorCodeT _errorCode;
        private string _errorMessage;
        private IProcessHost _host;

        private class MarginDataTag {
            public MarginDataTag(DateTime d, int b, int e) {
                date = d;
                begin_index = b;
                end_index = e;
            }

            public DateTime date; //Mpc̓t@T̑cƓ
            public int begin_index;  //ΉtargetDates͈̔
            public int end_index; 
        }

        public DailyDataUpdateProcess(IProcessHost host, string account, string password, int[] dates) {
            _host = host;
            _targetDates = dates;
            _account = account;
            _password = password;
            _data = new Dictionary<string, SimpleCandle[]>();
        }

        public ErrorCodeT ErrorCode {
            get {
                return _errorCode;
            }
        }
        public string ErrorMessage {
            get {
                return _errorMessage;
            }
        }

        //XV葱
        public bool Start() {
            if(!DownloadData()) return false;
            _host.OnDownloadStart("");
            WriteData();

            return true;
        }

        private bool DownloadData() {
            string temp_dir = PersonalPlugin.Instance.BellagioEnvironment.DataHomeDir + "temp";
            if(!Directory.Exists(temp_dir)) Directory.CreateDirectory(temp_dir);

            //Mpc
            MarginDataTag[] margins_dates = GetMarginDates();

            for(int i=0; i<_targetDates.Length; i++) {
                try {
                    int date = _targetDates[i];
                    _host.OnDownloadStart(String.Format("{0}{1}̓_E[h...", (date%10000)/100, date % 100));
                    string filename = DownloadAndSaveToTempFile(date, temp_dir);
                    ReadTempCSV(i, temp_dir + "\\" + filename);
                }
                catch(WebException ex) {
                    Debug.WriteLine(ex.Message);
                    if(ex.Message.IndexOf("401")!=-1) {
                        _errorCode = ErrorCodeT.Login;
                        _errorMessage = "F؃G[ł";
                    }
                    else if(ex.Message.IndexOf("404")!=-1) {
                        _errorCode = ErrorCodeT.Network;
                        _errorMessage = "f[^擾ł܂B\nf[^\Ȏԑтł邩ǂAPC̓tݒ肪mFĂB";
                    }
                    else {
                        _errorCode = ErrorCodeT.Network;
                        _errorMessage = ex.Message;
                    }
                    return false;
                }
            }

            for(int i=0; i<margins_dates.Length; i++) {
                //Mpc̓tj̔zûߎ擾łȂ\̂
                MarginDataTag tag = margins_dates[i];
                try {
                    string filename = DownloadMarginDataToTempFile(tag, temp_dir);
                    _host.OnDownloadStart("Mpc̃_E[h...");
                    if(filename.Length > 0) {
                        ReadMarginDataCSV(tag, temp_dir + "\\" + filename);
                    }
                }
                catch(WebException ex) {
                    _errorCode = ErrorCodeT.Network;
                    _errorMessage = ex.Message;
                    return false;
                }
            }

            Directory.Delete(temp_dir, true);
            return true;
        }

        private string DownloadAndSaveToTempFile(int date, string temp_dir) {
            HttpWebRequest req = (HttpWebRequest)WebRequest.Create(String.Format("http://www.data-get.com/data/{0}/{1}.php", (date / 10000).ToString(), date));
            req.AllowAutoRedirect = true;
            req.Credentials = new NetworkCredential(_account, _password);

            //_E[hă[Jɕۑ
            Stream input = req.GetResponse().GetResponseStream();
            string temp_zip = String.Format("{0}\\{1}.zip", temp_dir, date);
            Stream output = new FileStream(temp_zip, FileMode.Create, FileAccess.Write);

            //SRs[
            PUtil.CopyStream(input, output, 0x10000);

            output.Close();
            input.Close();

            Shell32.Folder f = PUtil.Unzip(temp_zip, temp_dir, false);

            Shell32.FolderItem item = f.Items().Item(0);
            return ReformatTextFile(item.Name);
        }
        //Mpc擾Bt̎擾Ɏs邩ȂƂɒ
        private string DownloadMarginDataToTempFile(MarginDataTag tag, string temp_dir) {

            int try_count = 0;
            string temp_zip;
            while(true) {
                try {
                    int int_date = PUtil.DateTimeToInt(tag.date);
                    //DG̃oO邽߂̃NCbNnbN
                    if(int_date<=20080506 && int_date<=20080509) {
                        int_date = 20080508;
                    }

                    HttpWebRequest req = (HttpWebRequest)WebRequest.Create(String.Format("http://www.data-get.com/data/sinyou/z{0}.php", int_date));
                    req.AllowAutoRedirect = true;
                    req.Credentials = new NetworkCredential(_account, _password);

                    //_E[hă[Jɕۑ
                    Stream input = req.GetResponse().GetResponseStream();
                    Debug.WriteLine(String.Format("MpcHTTPStatus {0} {1}", int_date, ((HttpWebResponse)req.GetResponse()).StatusCode.ToString()));
                    temp_zip = String.Format("{0}\\Z{1}.zip", temp_dir, int_date);
                    Stream output = new FileStream(temp_zip, FileMode.Create, FileAccess.Write);

                    //SRs[
                    PUtil.CopyStream(input, output, 0x10000);

                    output.Close();
                    input.Close();
                    break;
                }
                catch(WebException ex) {
                    if(ex.Message.IndexOf("404")!=-1) {
                        tag.date = tag.date.AddDays(1);
                        try_count++;
                        if(try_count==3) return ""; //Ō܂ŌȂP[X
                    }
                    else
                        throw ex;
                }
            }

            //zip
            Shell32.Folder src = PUtil.Unzip(temp_zip, temp_dir, false);
            return ReformatTextFile(src.Items().Item(0).Name);
        }

        private void ReadTempCSV(int date_index, string file) {
            if(!File.Exists(file)) throw new BellagioException("FILE NOT FOUND/"+file);
            StreamReader r = new StreamReader(file, Encoding.Default);

            string line = r.ReadLine();
            string cand_code = "";
            string[] cand_data = null;

            while(line!=null) {
                string[] t = line.Split(',');
                //    0    1  2    3    4    5    6        7
                //20080417,9984,t1,2000,2025,1984,1994,12778800
                //sɏꂵĂƏdȂ肪̂ŏ
                if(t.Length==8) {
                    string code = t[1];
                    if(code!=cand_code) {
                        if(cand_code.Length>0)
                            GetCandleArray(cand_code)[date_index] = new SimpleCandle(cand_code[0]=='0', cand_data);
                        cand_code = code;
                        cand_data = t; //ɏׂ̂Qbg
                    }
                    else {
                        //ȏق̗p
                        if(Int32.Parse(t[7]) > Int32.Parse(cand_data[7])) cand_data = t;
                    }
                }
                line = r.ReadLine();
            }
            r.Close();

            GetCandleArray(cand_code)[date_index] = new SimpleCandle(false, cand_data);
        }

        private void ReadMarginDataCSV(MarginDataTag tag, string filename) {
            StreamReader r = new StreamReader(filename, Encoding.Default);

            string line = r.ReadLine();
            string cand_code = "";
            string[] cand_data = null;

            while(line!=null) {
                string[] t = line.Split(',');
                //    0    1  2    3      4         5      6        7       8        9    
                //20080311,6502,t1,20080307,1438000,1521000,2688000,18587000,4126000,20108000
                //f[^͔cAc̏f[^tH[}bg͋tȂ̂Œ
                //sɏꂵĂƏdȂ肪̂ŏ
                if(t.Length==10) {
                    string code = t[1];
                    if(code!=cand_code) {
                        if(cand_code.Length > 0)
                            FillMarginData(tag, cand_code, Int32.Parse(cand_data[9]), Int32.Parse(cand_data[8]));
                        cand_code = code;
                        cand_data = t; //ɏׂ̂Qbg
                    }
                    else {
                        //c̑ق̗p
                        if(Int32.Parse(t[9]) > Int32.Parse(cand_data[9])) cand_data = t;
                    }
                }
                line = r.ReadLine();
            }
            r.Close();

            FillMarginData(tag, cand_code, Int32.Parse(cand_data[9]), Int32.Parse(cand_data[8]));
        }
        private void FillMarginData(MarginDataTag tag, string code, int long_vol, int short_vol) {
            SimpleCandle[] ca = GetCandleArray(code);
            if(ca!=null) {
                for(int i=tag.begin_index; i<tag.end_index; i++) {
                    SimpleCandle c = ca[i];
                    if(c!=null) {
                        unsafe {
                            fixed(byte* p = c.rawdata) {
                                int* h = (int*)p;
                                *(h + 6) = long_vol;
                                *(h + 7) = short_vol;
                            }
                        }
                    }
                }
            }

        }

        private SimpleCandle[] GetCandleArray(string code) {
            SimpleCandle[] r;
            if(!_data.TryGetValue(code, out r)) {
                r = new SimpleCandle[_targetDates.Length];
                _data.Add(code, r);
            }
            return r;
        }

        //VFݒŊgqĂ܂I
        private static string ReformatTextFile(string fn) {
            if(fn.EndsWith(".txt")) return fn;
            else return fn + ".txt";
        }

        //Mpcɂ
        //f[^Qbgdlł́Ã[ŐMpct@C擾ł
        //* TcƓ̓tŃt@C擾ł
        //* ̃f[^AKpJnijlȂ΂PTԁj  ŃP~ƃf[^͈v
        //Ȃ̂ŁA擾t`jł΂̏T̉ΗjAłȂΑOTΗjǉB
        private MarginDataTag[] GetMarginDates() {
            List<MarginDataTag> r = new List<MarginDataTag>();
            for(int i=0; i<_targetDates.Length; i++) {
                int int_dt = _targetDates[i];
                DateTime dt = PUtil.IntToDateTime(int_dt);
                int m = 0;
                switch(dt.DayOfWeek) {
                    case DayOfWeek.Monday:
                        m = -6;
                        break;
                    case DayOfWeek.Tuesday:
                        m = -7;
                        break;
                    case DayOfWeek.Wednesday:
                        m = -1;
                        break;
                    case DayOfWeek.Thursday:
                        m = -2;
                        break;
                    case DayOfWeek.Friday:
                        m = -3;
                        break;
                }

                if(m < 0) {
                    dt = dt.AddDays(m);
                    int result_dt = PUtil.DateTimeToInt(dt);
                    if(r.Count==0 || r[r.Count-1].date!=dt)
                        r.Add(new MarginDataTag(dt, i, i+1));
                    else { //tg
                        MarginDataTag tag = r[r.Count-1];
                        tag.end_index = i+1;
                    }
                }
            }
#if DEBUG
            for(int i=0; i<r.Count; i++) {
                MarginDataTag mt = r[i];
                Debug.WriteLine(String.Format("Margin date={0} {1}-{2}", mt.date.ToShortDateString(), _targetDates[mt.begin_index], _targetDates[mt.end_index-1]));
            }
#endif
            return r.ToArray();
        }

        private void WriteData() {
            Dictionary<string, SimpleCandle[]>.Enumerator e = _data.GetEnumerator();
            int max_count = _data.Count;
            int count = 0;
            //builderɓĂ܂
            MMFQuoteBaseBuilder builder = ScreeningPlugin.Instance.Preferences.MMFQuoteAutoUpdate?
                new MMFQuoteBaseBuilder(ScreeningPlugin.Instance.DailyDataBasePath, ScreeningPlugin.Instance.Preferences.MaximumDailyDataLength) : null;

            while(e.MoveNext()) {
                string code = e.Current.Key;
                SimpleCandle[] value = e.Current.Value;

                int latest_date;
                FileStream fs = OpenDailyDataStream(code, out latest_date);
                for(int i=0; i<value.Length; i++) {
                    SimpleCandle c = value[i];
                    if(c != null) {
                        if(latest_date==-1 || c.date > latest_date) //Ƃ̂ݏ
                            fs.Write(c.rawdata, 0, c.rawdata.Length);
                    }
                }
                BasicStockProfile bp = BellagioRoot.GlobalStockCollection.FindExact(code) as BasicStockProfile;
                if(bp!=null && builder!=null)
                    builder.AppendQuote(bp, fs);

                fs.Close();

                _host.OnImportData(count++, max_count);
            }

            if(builder!=null)
                builder.Close();
        }

        //f[^t@Cւ̏݁Bt@C̏ꍇAŌ̓tlatest_dateɕԂBłȂ-1Ԃ
        private FileStream OpenDailyDataStream(string code, out int latest_date) {
            string filename = PersonalPlugin.Instance.BellagioEnvironment.DataHomeDir + "daily\\" + code;
            if(File.Exists(filename)) {
                FileStream fs = new FileStream(filename, FileMode.Open, FileAccess.ReadWrite);
                try {
                    fs.Seek(-32, SeekOrigin.End);
                }
                catch(IOException ex) { //{肦Ȃ͂ATCYÕt@CłĂႪBrł̒~Ƃ
                    latest_date = -1;
                    fs.Seek(0, SeekOrigin.Begin);
                    return fs;
                }

                //펞
                byte[] b = new byte[32];
                fs.Read(b, 0, b.Length);
                unsafe {
                    fixed(byte* p = b) {
                        latest_date = *(int*)p;
                    }
                }
                return fs;
            }
            else {
                latest_date = -1;
                return new FileStream(filename, FileMode.Create, FileAccess.ReadWrite);
            }
        }
    }

    internal class SimpleCandle {
        public int date;
        public byte[] rawdata;
        public SimpleCandle(bool is_indices, string[] t) {
            date = Int32.Parse(t[0]);
            rawdata = new byte[32];
            unsafe {
                fixed(byte* p = rawdata) {
                    int* h = (int*)p;
                    *h = date;
                    *(h + 1) = AdjustPrice(t, 3, is_indices);
                    *(h + 2) = AdjustPrice(t, 4, is_indices);
                    *(h + 3) = AdjustPrice(t, 5, is_indices);
                    *(h + 4) = AdjustPrice(t, 6, is_indices);
                    *(h + 5) = AdjustVolume(t, 7, is_indices);
                }
            }
        }
        private int AdjustPrice(string[] t, int index, bool is_indices) {
            int value;
            if(Int32.TryParse(t[index], out value)) {
                if(is_indices) value *= 100;
                return value;
            }
            else
                throw new FormatException(t[index] + "͐lł͂܂");

        }
        private int AdjustVolume(string[] t, int index, bool is_indices) {
            int value;
            if(Int32.TryParse(t[index], out value)) {
                if(is_indices) value /= 1000;
                return value;
            }
            else {
                //longŎ
                long lv;
                if(Int64.TryParse(t[index], out lv)) {
                    if(is_indices) lv /= 1000;
                    return (int)lv;
                }
                else
                    throw new FormatException(t[index] + "͐lł͂܂");
            }

        }
    }
}
