using System;
using System.Collections.Generic;
using System.Diagnostics;

using System.Windows.Forms;
namespace Sansa.Runtime {
public class RootTimer {

	private Timer _timer;
	private int _tick;
	private int _interval;
    private MAECollection<AbstractTimer> _timers;
    private MAECollection<ITickListener> _tickListeners;

	public RootTimer(int interval) {
        if(interval > 0) { //ÔƂ͎ۂɃ^C}[𓮂킯ł͂ȂAtickForTestȂǂŎ蓮œƂz肵Ă
            _timer = new Timer();
            _timer.Interval = interval;
            _timer.Tick += new EventHandler(TickRoot);
        }
		_interval = interval;
        _timers = new MAECollection<AbstractTimer>();
        _tickListeners = new MAECollection<ITickListener>();
	}
	public void start() {
		_tick = 0;
		_timer.Start();
	}
	public void stop() {
		_timer.Stop();
	}
	public int getTick() {
		return _tick;
	}
	public void addTimer(AbstractTimer t) {
        Debug.Assert(!_timers.Contains(t));
    	_timers.Add(t);
	}
	public void removeTimer(AbstractTimer t) {
		_timers.Remove(t);
	}
    public void addTickListener(ITickListener t) {
        _tickListeners.Add(t);
    }
    public void removeTickListener(ITickListener t) {
        _tickListeners.Remove(t);
    }
    public int getTimerCount() {
        return _timers.Count;
    }
	
	
	private void TickRoot(object sender, EventArgs args) {
	  tickCore();
	}
	public int secondToTick(double sec) {
        if(_interval==0) //UnitTest
            return (int)sec;
        else
    		return Math.Max(1, (int)(sec * 1000) / _interval);
	}
	public void tickForTest() {
	  tickCore();
	}
	private void tickCore() {
		_tick++;
		//tickɃRNVXV̂ŕʂ̗񋓂ł͂
        int ts_count, ls_count;
        AbstractTimer[] ts;
        _timers.PrepareEnum(out ts, out ts_count);
        ITickListener[] ls;
        _tickListeners.PrepareEnum(out ls, out ls_count);

        //beforeTick, tick, afterTick̏
        for(int i=0; i<ls_count; i++) ls[i].beforeTick();
		for(int i=0; i<ts_count; i++) ts[i].tick();
        for(int i=0; i<ls_count; i++) ls[i].afterTick();
		
	}

}
}