using System.Diagnostics;
namespace Sansa.Runtime {
    public class DoubleTimer : AbstractTimer {

        private double _initial;
        private double _final;
        private int _length; //񂩂ēB邩
        private int _step; //݂stepB0_length܂ł̒lƂ
        private double _value;

        public DoubleTimer(IPlatformBridge bridge, ITimerDownstream handler)
            : base(bridge, handler) {
        }

        public void reset(int sleep, int interval, double initial, double final_, int length, bool loop) {
            base.resetBase(sleep, interval, loop);
            Debug.Assert(length>0);
            _initial = initial;
            _final = final_;
            _length = length;
            _step = 0;
            _value = _initial;
        }
        public double InitialValue {
            get {
                return _initial;
            }
        }
        public double FinalValue {
            get {
                return _final;
            }
        }

        public void reset(double initial, double final_, int length) {
            reset(0, 1, initial, final_, length, false);
        }

        protected override bool stepValue() {
            _step++;
            if(_step==_length) {
                _value = _final; //덷
                return true;
            }
            else {
                _value = _initial + (_final - _initial) * _step / _length;
                return false;
            }
        }
        protected override void stepToLast() {
            _step = _length;
            _value = _final;
        }
        protected override void stepToFirst() {
            _step = 0;
            _value = _initial;
        }

        public virtual double value() {
            return _value;
        }

    }
}
