﻿/*
 * Trading Platform "Bellagio"
 * Copyright (c) 2006, 2007  Lagarto Technology, Inc.
 * 
 * $Id$
 * $DateTime$
 */
using System;
using System.Collections.Generic;
using System.Text;

using Bellagio.Environment;
using Bellagio.Forms;
using Bellagio.Chart;

using Poderosa.Plugins;
using Poderosa.Preferences;


namespace Bellagio.Screening {

    //自動売買検証で、表示する結果は条件成立時か取引日か
    public enum AutoTradingDateDisplay {
        Condition,
        Trade
    }

    public class ScreeningPreferences : PreferenceSupplierImpl, IPreferenceChangeListener {
        private IIntPreferenceItem _maximumDailyDataLength;
        private EnumPreferenceItem<AutoTradingDateDisplay> _autotradingDateDisplay;
        private EnumPreferenceItem<MouseWheelAction> _mouseWheelOnResultPane;
        private IStringPreferenceItem _lastExecutedScreening;
        private IStringPreferenceItem _lastExecutedAutoTrading;
        //日々のデータを更新したとき同時にDBアップデートもするかどうか
        private IBoolPreferenceItem _MMFQuoteAutoUpdate;

        private IBoolPreferenceItem _enableAutoTradingVerboseLog;
        private IStringPreferenceItem _autoTradingVerboseLogFileName;
        private IBoolPreferenceItem _autoTradingVerboseLogImmediatelyOpen;
        private IIntPreferenceItem _signalCountBoxIndex; //シグナルを打ち切る上限数

        private IStringPreferenceItem _chartSchemaForScreeningResultActivation; //スクリーニング/ATの結果欄をクリックしたときに表示するチャートのスキーマ。日足でなければならない。
        


        public ScreeningPreferences()
            : base("tactico.screening") {
        }

        public void RegisterExtension(IExtensionPoint pt) {

            pt.RegisterExtension(this);
        }

        public override void InitializePreference(IPreferenceBuilder builder, IPreferenceFolder folder) {
            //_tradeSoundFile = builder.DefineStringValue(folder, "tradeSoundFile", "Execution.wav", null);
            _maximumDailyDataLength = builder.DefineIntValue(folder, "maximumDailyDataLength", 2000, null);
            _autotradingDateDisplay = new EnumPreferenceItem<AutoTradingDateDisplay>(builder.DefineStringValue(folder, "autotradingDateDisplay", "Condition", null), AutoTradingDateDisplay.Condition);
            _mouseWheelOnResultPane = new EnumPreferenceItem<MouseWheelAction>(builder.DefineStringValue(folder, "mouseWheelOnResultPane", "Scroll", null), MouseWheelAction.Scroll);

            _lastExecutedScreening = builder.DefineStringValue(folder, "lastExecutedScreening", "", null);
            _lastExecutedAutoTrading = builder.DefineStringValue(folder, "lastExecutedAutoTrading", "", null);
            _chartSchemaForScreeningResultActivation = builder.DefineStringValue(folder, "chartSchemaForScreeningResultActivation", "tactico.daily-default", null);

            _enableAutoTradingVerboseLog = builder.DefineBoolValue(folder, "enableAutoTradingVerboseLog", false, null);
            _autoTradingVerboseLogFileName = builder.DefineStringValue(folder, "autoTradingVerboseLogFileName", "", null);
            _autoTradingVerboseLogImmediatelyOpen = builder.DefineBoolValue(folder, "autoTradingVerboseLogImmediatelyOpen", false, null);
            _signalCountBoxIndex = builder.DefineIntValue(folder, "signalCountBoxIndex", 2, null);

            _MMFQuoteAutoUpdate = builder.DefineBoolValue(folder, "MMFQuoteAutoUpdate", false, null);

        }

        public void OnPreferenceImport(IPreferenceFolder oldvalues, IPreferenceFolder newvalues) {
        }

        //必ずしも必要な項目が変更されたとは限らないが、何度もReloadPreferenceを実行するのを避けるため代表してFixedPreferenceが通知を受ける
        public void OnPreferenceImportFinish() {
        }


        public void ReloadPreference() {
        }

        public void Dispose() {
        }

        public int MaximumDailyDataLength {
            get {
                return _maximumDailyDataLength.Value;
            }
        }
        public IIntPreferenceItem MaximumDailyDataLengthItem {
            get {
                return _maximumDailyDataLength;
            }
        }
        public AutoTradingDateDisplay AutoTradingDateDisplay {
            get {
                return _autotradingDateDisplay.Value;
            }
        }
        public EnumPreferenceItem<AutoTradingDateDisplay> AutoTradingDateDisplayItem {
            get {
                return _autotradingDateDisplay;
            }
        }
        public MouseWheelAction MouseWheelOnResultPane {
            get {
                return _mouseWheelOnResultPane.Value;
            }
        }
        public IStringPreferenceItem MouseWheelOnResultPaneItem {
            get {
                return _mouseWheelOnResultPane.PreferenceItem;
            }
        }

        public string LastExecutedScreening {
            get {
                return _lastExecutedScreening.Value;
            }
            set {
                _lastExecutedScreening.Value = value;
            }
        }
        public string LastExecutedAutoTrading {
            get {
                return _lastExecutedAutoTrading.Value;
            }
            set {
                _lastExecutedAutoTrading.Value = value;
            }
        }
        public IStringPreferenceItem ChartSchemaForScreeningResultActivationItem {
            get {
                return _chartSchemaForScreeningResultActivation;
            }
        }
        public string ChartSchemaForScreeningResultActivation {
            get {
                return _chartSchemaForScreeningResultActivation.Value;
            }
        }

        public bool EnableAutoTradingVerboseLog {
            get {
                return _enableAutoTradingVerboseLog.Value;
            }
            set {
                _enableAutoTradingVerboseLog.Value = value;
            }
        }
        public string AutoTradingVerboseLogFileName {
            get {
                return _autoTradingVerboseLogFileName.Value;
            }
            set {
                _autoTradingVerboseLogFileName.Value = value;
            }
        }
        public bool AutoTradingVerboseLogImmediatelyOpen {
            get {
                return _autoTradingVerboseLogImmediatelyOpen.Value;
            }
            set {
                _autoTradingVerboseLogImmediatelyOpen.Value = value;
            }
        }
        public int SignalCountBoxIndex {
            get {
                return _signalCountBoxIndex.Value;
            }
            set {
                _signalCountBoxIndex.Value = value;
            }
        }

        public bool MMFQuoteAutoUpdate {
            get {
                return _MMFQuoteAutoUpdate.Value;
            }
        }
        public IBoolPreferenceItem MMFQuoteAutoUpdateItem {
            get {
                return _MMFQuoteAutoUpdate;
            }
        }


    }
}
