/*
 * Trading Platform "Bellagio"
 * Copyright (c) 2006, 2007  Lagarto Technology, Inc.
 * 
 * $Id: //depot/Bellagio/Demeter/Ordering/TradeNotificationDialog.cs#9 $
 * $DateTime: 2008/05/14 13:05:12 $
 * 
 * ʒmtH[
 */
using System;
using System.Collections.Generic;
using System.Text;
using System.Diagnostics;
using System.Windows.Forms;
using System.Drawing;
using System.Media;
using System.IO;

using Bellagio.Environment;
using Bellagio.Forms;

namespace Bellagio.Ordering {
    public class TradeNotificationDialog : BellagioDefaultForm {
        private TradeNotificationDrawing _drawing;
        private TradeNotificationDrawingSettings _settings; //staticɂł
        private bool _firstDraw;
        private Rectangle _bodyRect;
        private TradeOrderItem _item;
        private TradeOrderItem.Element _tradeElement;
        private IOrderItemFormatter _formatter;
        private int _step;
        private Timer _timer;
        private BellagioDefaultPanel _mainPanel;

        private static int _instanceCount; //\ʒuKxɂ炷

        public TradeNotificationDialog(TradeOrderItem item, TradeOrderItem.Element element) {

            this.Text = "ʒm";
            this.TopMost = true;

            Button ok = FormUtil.CreateOKButton();
            ok.Text = "mF";
            ok.Click += delegate(object sender, EventArgs args) { this.Close(); };
            this.AcceptButton = ok;
            this.CancelButton = ok;

            FormUtil.AdjustStyleForModelessFixedDialog(this, BellagioPlugin.Instance.MainWindow);
            _settings = BellagioRoot.FixedPreferences.Ordering.TradeNotificationDrawingSettings;
            _drawing = new TradeNotificationDrawing();
            _drawing.DrawingSettings = _settings;

            _mainPanel = new BellagioDefaultPanel();
            _mainPanel.BackColor = Color.Black;
            _mainPanel.Paint += new PaintEventHandler(OnPaintContent);
            _mainPanel.Size = new Size(460, 128);
            _mainPanel.Location = new Point(0, 0);
            this.ClientSize = new Size(_mainPanel.Width, _mainPanel.Height + 32);
            ok.Location = new Point((this.ClientSize.Width - ok.Width)/2, this.ClientSize.Height-ok.Height-4);

            this.Controls.Add(ok);
            this.Controls.Add(_mainPanel);

            FormUtil.AdjustFormLocationToCenter(this, BellagioPlugin.Instance.MainWindow.RestoreBounds);
            this.Top += (_instanceCount++ % 5) * 8; //AIɏoĂʒudȂȂ悤

            _firstDraw = true;
            _item = item;
            _tradeElement = element;
            _bodyRect = new Rectangle(8, 8, this.ClientSize.Width-16, ok.Top - 16);
            _formatter = BellagioRoot.OrderDataProvider.OrderItemFormatter;
            _step = -5; //\Jn܂łɏԂ
            _timer = new Timer();
            _timer.Interval = 100;
            _timer.Tick += delegate(object sender, EventArgs args) { _step++;  _mainPanel.Invalidate(); };
            _timer.Start();

            string soundfile = Path.GetFullPath(Path.Combine(BellagioRoot.FixedPreferences.SoundDir, BellagioRoot.FixedPreferences.Ordering.TradeSoundFile));
            if(!String.IsNullOrEmpty(soundfile)) {
                SoundPlayer sp = new SoundPlayer(soundfile);
                try {
                    sp.Play();
                }
                catch(Exception) { //ĐG[͖
                }
            }
            
        }

        protected override void Dispose(bool disposing) {
            base.Dispose(disposing);
            if(disposing) {
                _timer.Dispose();
            }
        }

        private void OnPaintContent(object sender, PaintEventArgs e) {
            if(_firstDraw)
                _drawing.SetOrderItem(_item, _tradeElement, _formatter, _bodyRect);
            int s = _step<0? 0 : _step>=TradeNotificationDrawing.MaxAnimationStep? TradeNotificationDrawing.MaxAnimationStep-1 : _step;
            _drawing.Draw(e.Graphics, s);
            _firstDraw = false;
            if(_step>=TradeNotificationDrawing.MaxAnimationStep)
                _timer.Stop();
            base.OnPaint(e);

        }
    }
}
