/*
 * Trading Platform "Bellagio"
 * Copyright (c) 2006, 2007  Lagarto Technology, Inc.
 * 
 * $Id: //depot/Bellagio/Demeter/Ordering/OrderingOptionPanel.cs#5 $
 * $DateTime: 2008/04/17 18:18:30 $
 * 
 * Sʐݒ̃IvVpl
 */
using System;
using System.Collections.Generic;
using System.Text;
using System.Diagnostics;
using System.Windows.Forms;
using System.Drawing;
using System.IO;
using System.Media;

using Bellagio.Forms;
using Bellagio.Environment;

using Travis.LocationOperation;
using Poderosa.Usability;
using Poderosa.Preferences;

namespace Bellagio.Ordering {
    public class OrderingOptionPanelExtension : IOptionPanelExtension {
        private OrderingOptionPanel _panel;

        public string Caption {
            get {
                return "";
            }
        }

        public System.Drawing.Image Icon {
            get {
                return BellagioRoot.CommonIcons.OptionDialogButtons.GetBitmap(2);
            }
        }

        public string[] PreferenceFolderIDsToEdit {
            get {
                return new string[] { "tactico.common", "tactico.ordering" };
            }
        }

        public Panel ContentPanel {
            get {
                return _panel;
            }
        }

        public void InitiUI(IPreferenceFolder[] values) {
            if(_panel==null) _panel = new OrderingOptionPanel();
            _panel.InitUI(values[0], values[1]);
        }

        public bool Commit(IPreferenceFolder[] values) {
            return _panel.Commit(values[0], values[1]);
        }

        public void Dispose() {
            if(_panel!=null) _panel.Dispose();
        }

    }

    public class OrderingOptionPanel : Panel {
        private Label _orderFormStyleLabel;
        private ComboBox _orderFormStyleBox;
        private CheckBox _omitConfirmDialog;
        private CheckBox _showTradeNotification;
        private CheckBox _showSuccessfulOrderMessage;
        private CheckBox _askPriceDragDropOrder;
        private CheckBox _closeFormOnOrder;
        private Label _tradeNotificationSoundLabel;
        private TextBox _tradeNotificationSoundFile;
        private Button _playButton;

        public OrderingOptionPanel() {
            _orderFormStyleLabel = FormUtil.CreateLabel("ʂ̃X^C(&O)");
            _orderFormStyleLabel.Size = new Size(150, 19);
            _orderFormStyleLabel.Location = new Point(8, 8);
            _orderFormStyleBox = FormUtil.CreateComboBox("CEBhȆO", "ƗEBhE");
            _orderFormStyleBox.Size = new Size(180, 19);
            _orderFormStyleBox.Location = new Point(158, 8);

            _showSuccessfulOrderMessage = new CheckBox();
            _showSuccessfulOrderMessage.Text = "tbZ[W\(&S)";
            _showSuccessfulOrderMessage.Size = new Size(360, 19);
            _showSuccessfulOrderMessage.Location = new Point(8, 32);

            _askPriceDragDropOrder = new CheckBox();
            _askPriceDragDropOrder.Text = "ihbvł̔ɃbZ[W\(&D)";
            _askPriceDragDropOrder.Size = new Size(360, 19);
            _askPriceDragDropOrder.Location = new Point(8, 56);

            _closeFormOnOrder = new CheckBox();
            _closeFormOnOrder.Text = "ɒʂ(&L)";
            _closeFormOnOrder.Size = new Size(360, 19);
            _closeFormOnOrder.Location = new Point(8, 80);

            _omitConfirmDialog = new CheckBox();
            _omitConfirmDialog.Text = "mFʂȗ(&C)";
            _omitConfirmDialog.Size = new Size(180, 19);
            _omitConfirmDialog.Location = new Point(8, 104);
        
            _tradeNotificationSoundLabel = FormUtil.CreateLabel("ʒmwavt@C(&W)");
            _tradeNotificationSoundLabel.Location = new Point(8, 128);
            _tradeNotificationSoundLabel.Size = new Size(150, 19);
            _tradeNotificationSoundFile = new TextBox();
            _tradeNotificationSoundFile.Location = new Point(_tradeNotificationSoundLabel.Right, _tradeNotificationSoundLabel.Top);
            _tradeNotificationSoundFile.Size = new Size(200, 19);

            _playButton = new Button();
            _playButton.Text = "mF";
            _playButton.Click += new EventHandler(OnPlaySound);
            _playButton.Location = new Point(_tradeNotificationSoundFile.Right+4, _tradeNotificationSoundFile.Top-2);
            _playButton.Size = new Size(48, 24);

            _showTradeNotification = new CheckBox();
            _showTradeNotification.Text = "ʒm_CAO\(&T)";
            _showTradeNotification.Size = new Size(360, 19);
            _showTradeNotification.Location = new Point(8, 152);
            _showTradeNotification.CheckedChanged += delegate(object sender, EventArgs args) {
                _tradeNotificationSoundFile.Enabled = _showTradeNotification.Checked;
            };

            this.Controls.Add(_orderFormStyleLabel);
            this.Controls.Add(_orderFormStyleBox);
            this.Controls.Add(_showSuccessfulOrderMessage);
            this.Controls.Add(_askPriceDragDropOrder);
            this.Controls.Add(_closeFormOnOrder);
            this.Controls.Add(_omitConfirmDialog);
            this.Controls.Add(_tradeNotificationSoundLabel);
            this.Controls.Add(_tradeNotificationSoundFile);
            this.Controls.Add(_playButton);
            this.Controls.Add(_showTradeNotification);

        }

        public void InitUI(IPreferenceFolder c, IPreferenceFolder o) {
            FixedPreferences cp = BellagioRoot.FixedPreferences;
         
            OrderingPreferences op = cp.Ordering;
            _omitConfirmDialog.Checked = !o.ChildAt(op.ShowOrderConfirmDialogItem.Index).AsItem().AsBool().Value;
            _showTradeNotification.Checked = o.ChildAt(op.ShowTradeNotificationItem.Index).AsItem().AsBool().Value;
            _showSuccessfulOrderMessage.Checked = o.ChildAt(op.ShowSuccessfulOrderMessageItem.Index).AsItem().AsBool().Value;
            _askPriceDragDropOrder.Checked = o.ChildAt(op.AskPriceDragDropOrderItem.Index).AsItem().AsBool().Value;
            _closeFormOnOrder.Checked = o.ChildAt(op.CloseFormOnOrderItem.Index).AsItem().AsBool().Value;
            _orderFormStyleBox.SelectedIndex = (int) Poderosa.ParseUtil.ParseEnum<OrderFormStyle>(o.ChildAt(op.OrderFormStyleItem.PreferenceItem.Index).AsItem().AsString().Value, OrderFormStyle.Owned);
            _tradeNotificationSoundFile.Text = o.ChildAt(op.TradeSoundFileItem.Index).AsItem().AsString().Value;
            _tradeNotificationSoundFile.Enabled = _showTradeNotification.Checked;
        }

        public bool Commit(IPreferenceFolder c, IPreferenceFolder o) {

            FixedPreferences cp = BellagioRoot.FixedPreferences;
            OrderingPreferences op = cp.Ordering;
            //QueryAdapterĂȂ̂Ŗʓ|
            o.ChildAt(op.ShowTradeNotificationItem.Index).AsItem().AsBool().Value = _showTradeNotification.Checked;
            o.ChildAt(op.ShowOrderConfirmDialogItem.Index).AsItem().AsBool().Value = !_omitConfirmDialog.Checked;
            o.ChildAt(op.ShowSuccessfulOrderMessageItem.Index).AsItem().AsBool().Value = _showSuccessfulOrderMessage.Checked;
            o.ChildAt(op.AskPriceDragDropOrderItem.Index).AsItem().AsBool().Value = _askPriceDragDropOrder.Checked;
            o.ChildAt(op.CloseFormOnOrderItem.Index).AsItem().AsBool().Value = _closeFormOnOrder.Checked;
            o.ChildAt(op.OrderFormStyleItem.PreferenceItem.Index).AsItem().AsString().Value = ((OrderFormStyle)_orderFormStyleBox.SelectedIndex).ToString();
            o.ChildAt(op.TradeSoundFileItem.Index).AsItem().AsString().Value = _tradeNotificationSoundFile.Text;

            return true;
        }

        private void OnPlaySound(object sender, EventArgs args) {
            string file = GetSoundFileFullPath();
            if(file.Length==0) {
                BUtil.ShowWarningMessageBox("t@Cw肳Ă܂");
            }

            try {
                SoundPlayer sp = new SoundPlayer(file);
                sp.Play();
            }
            catch(Exception ex) {
                BUtil.ShowWarningMessageBox(ex.Message);
            }
        }

        private string GetSoundFileFullPath() {
            return Path.GetFullPath(Path.Combine(BellagioRoot.FixedPreferences.SoundDir, _tradeNotificationSoundFile.Text));
        }
    }

}
