/*
 * Trading Platform "Bellagio"
 * Copyright (c) 2006, 2007  Lagarto Technology, Inc.
 * 
 * $Id: //depot/Bellagio/Demeter/Ordering/OrderAndPositionItem.cs#10 $
 * $DateTime: 2008/05/14 13:05:12 $
 * 
 * 
 */
using System;
using System.Collections;
using System.Collections.Generic;
using System.Text;
using System.Diagnostics;

using Bellagio.Data;
using Bellagio.Values;
using Poderosa.Util;

namespace Bellagio.Ordering {

    //P\NX
    public class TradeOrderItem {
        //P\NX OrderItemƂƂɓ@̂Ƃ͂̌쐬
        public class Element {
            private int _price;
            private int _volume;
            private BDate _date; //T̒ł͈ꉞU
            private BTime _time;

            public Element() {
            }
            public Element Clone() {
                Element e = new Element();
                e._price = _price;
                e._volume = _volume;
                e._date = _date==null? null  : new BDate(_date);
                e._time = _time==null? null : new BTime(_time);
                return e;
            }

            public int TimeAsInt {
                get {
                    return _time==null? 0 : _time.AsInt();
                }
                set {
                    if(_time==null) _time = new BTime(value);
                    else _time.LetInt(value);
                }
            }
            public int DateAsInt {
                get {
                    return _date==null? 0 : _date.AsInt();
                }
                set {
                    if(_date==null) _date = new BDate(value);
                    else _date.LetInt(value);
                }
            }
            

            public int Price {
                get {
                    return _price;
                }
                set {
                    _price = value;
                }
            }
            public int Volume {
                get {
                    return _volume;
                }
                set {
                    _volume = value;
                }
            }
            internal BTime Time {
                get {
                    return _time;
                }
                set {
                    _time = value;
                }
            }
            internal BDate Date {
                get {
                    return _date;
                }
                set {
                    _date = value;
                }
            }
            //󂯓nintႠӂ댯̂long
            public long TradeAmount {
                get {
                    long p = (long)_price;
                    return p * _volume;
                }
            }
        }

        private Stock _stock;
        private string _uniqueString; //͏،Ђt^ID
        private string _uniqueStringEx; //GMȌꍇA\pԍʓrBT|[g邽߂ɓ
        private string[] _marketAsText; //ԂȂǂ̂ŌŗL̕Ŏs
        private BDate _orderDate; //tE
        private BTime _orderTime;
        private int _volume;
        private int _sashine;
        private OrderCondition _condition;
        private OrderDealType _dealType;
        private LongShort _direction; //ԍς̏ꍇ̓|WV̕Zbg邱
        private OrderNewClose _newOrClose;
        private SpecialOrderClose _specialClose;
        private OrderStatus _status;
        private OrderTransactionStatus _transaction;
        private string _orderStatusMessage; //ʓr̃Xe[^XBRȂǁBg_statusɈˑ
        private OrderLimitDate _limitDate;
        private BDate _limitDateValue; //t`̗L
        private OrderKouza _kouza;
        private PTSOrder _ptsOrder;
        private OrderRestriction _restriction;
        private OrderTriggerType _triggerType;
        private int _triggerPrice;
        //ȉRڂ͕ۗł̂ݎgp
        private TradePositionItem _targetPosition;          //ԍς̏ڍׁBgȂꍇnull
        private TradePositionItem.Element _targetPositionElement;
        private PositionAndVolumeList _closePositionDetail; //ǂ̌ċʂԍς邩̃f[^BgȂꍇnull

        private List<Element> _trades; //

        public TradeOrderItem(Stock stock) {
            _stock = stock;
            //̏̓vpeBZbg
        }
        public TradeOrderItem Clone() {
            TradeOrderItem r = new TradeOrderItem(_stock);
            r._uniqueString = _uniqueString;
            r._uniqueStringEx = _uniqueStringEx;
            r._marketAsText = _marketAsText==null? null : (string[])_marketAsText.Clone();
            r._orderDate = new BDate(_orderDate);
            r._orderTime = new BTime(_orderTime);
            r._volume = _volume;
            r._sashine = _sashine;
            r._condition = _condition;
            r._dealType = _dealType;
            r._direction = _direction;
            r._newOrClose = _newOrClose;
            r._specialClose = _specialClose;
            r._status = _status;
            r._transaction = _transaction;
            r._orderStatusMessage = _orderStatusMessage;
            r._limitDate = _limitDate;
            r._limitDateValue = _limitDateValue==null? null : new BDate(_limitDateValue);
            r._kouza = _kouza;
            r._ptsOrder = _ptsOrder;
            r._restriction = _restriction;
            r._triggerType = _triggerType;
            r._triggerPrice = _triggerPrice;
            r._targetPosition = _targetPosition==null? null : _targetPosition.Clone();
            r._targetPositionElement = _targetPositionElement==null? null : _targetPositionElement.Clone();
            r._closePositionDetail = _closePositionDetail==null? null : _closePositionDetail.Clone();
            if(_trades!=null) {
                r._trades = new List<Element>();
                foreach(Element e in _trades) r._trades.Add(e.Clone());
            }
            return r;
        }

        public Stock Stock {
            get {
                return _stock;
            }
        }
        public int ElementCount {
            get {
                return _trades==null? 0 : _trades.Count;
            }
        }
        public string UniqueString {
            get {
                return _uniqueString;
            }
            set {
                _uniqueString = value;
            }
        }
        public string UniqueStringEx {
            get {
                return _uniqueStringEx;
            }
            set {
                _uniqueStringEx = value;
            }
        }
        public string[] MarketAsText {
            get {
                return _marketAsText;
            }
            set {
                _marketAsText = value;
            }
        }
        internal BDate OrderDate {
            get {
                return _orderDate;
            }
            set {
                _orderDate = value;
            }
        }
        internal BTime OrderTime {
            get {
                return _orderTime;
            }
            set {
                _orderTime = value;
            }
        }
        public int OrderTimeAsInt {
            get {
                return _orderTime==null? 0 : _orderTime.AsInt();
            }
            set {
                if(_orderTime==null) _orderTime = new BTime(value);
                else _orderTime.LetInt(value);
            }
        }
        public int OrderDateAsInt {
            get {
                return _orderDate==null? 0 : _orderDate.AsInt();
            }
            set {
                if(_orderDate==null) _orderDate = new BDate(value);
                else _orderDate.LetInt(value);
            }
        }

        public int Volume {
            get {
                return _volume;
            }
            set {
                _volume = value;
            }
        }
        public int Sashine {
            get {
                return _sashine;
            }
            set {
                _sashine = value;
            }
        }
        public OrderCondition Condition {
            get {
                return _condition;
            }
            set {
                _condition = value;
            }
        }
        public OrderDealType DealType {
            get {
                return _dealType;
            }
            set {
                _dealType = value;
            }
        }
        public LongShort LongShort {
            get {
                return _direction;
            }
            set {
                _direction = value;
            }
        }
        public OrderNewClose NewOrClose {
            get {
                return _newOrClose;
            }
            set {
                _newOrClose = value;
            }
        }
        public SpecialOrderClose SpecialClose {
            get {
                return _specialClose;
            }
            set {
                _specialClose = value;
            }
        }
        public OrderStatus OrderStatus {
            get {
                return _status;
            }
            set {
                _status = value;
            }
        }
        public OrderTransactionStatus TransactionStatus {
            get {
                return _transaction;
            }
            set {
                _transaction = value;
            }
        }
        public string OrderStatusMessage {
            get {
                return _orderStatusMessage;
            }
            set {
                _orderStatusMessage = value;
            }
        }
        public OrderLimitDate LimitDate {
            get {
                return _limitDate;
            }
            set {
                _limitDate = value;
            }
        }
        internal BDate LimitDateValue {
            get {
                return _limitDateValue;
            }
        }
        public int LimitDateValueAsInt {
            get {
                return _limitDateValue==null? 0 : _limitDateValue.AsInt();
            }
            set {
                _limitDateValue = new BDate(value);
            }
        }
        public OrderKouza Kouza {
            get {
                return _kouza;
            }
            set {
                _kouza = value;
            }
        }
        public PTSOrder PTSOrder {
            get {
                return _ptsOrder;
            }
            set {
                _ptsOrder = value;
            }
        }
        public OrderRestriction OrderRestriction {
            get {
                return _restriction;
            }
            set {
                _restriction = value;
            }
        }
        public OrderTriggerType TriggerType {
            get {
                return _triggerType;
            }
            set {
                _triggerType = value;
            }
        }
        public int TriggerPrice {
            get {
                return _triggerPrice;
            }
            set {
                _triggerPrice = value;
            }
        }
        public TradePositionItem TargetPosition {
            get {
                return _targetPosition;
            }
            set {
                _targetPosition = value;
            }
        }
        public TradePositionItem.Element TargetPositionElement {
            get {
                return _targetPositionElement;
            }
            set {
                _targetPositionElement = value;
            }
        }
        public PositionAndVolumeList ClosePositionDetail {
            get {
                return _closePositionDetail;
            }
            set {
                _closePositionDetail = value;
            }
        }
        public bool IsClosePositionDetailAvailable {
            get {
                return _closePositionDetail!=null;
            }
        }

        public IEnumerable<Element> Trades {
            get {
                return _trades==null? null : _trades;
            }
        }
        public Element LastTradeItem {
            get {
                return _trades==null || _trades.Count==0? null : _trades[_trades.Count-1];
            }
        }
        public bool IsPartialTraded {
            get {
                int v = this.TradedVolume;
                return v>0 && v<_volume;
            }
        }
        //萔
        public int TradedVolume {
            get {
                int v = 0;
                if(_trades!=null) {
                    for(int i=0; i<_trades.Count; i++) v += _trades[i].Volume;
                }
                return v;
            }
        }
        public double AverageTradePrice {
            get {
                long v = 0;
                if(_trades!=null) {
                    for(int i=0; i<_trades.Count; i++) v += _trades[i].TradeAmount;
                }

                if(v==0)
                    return 0;
                else {
                    double p = ((double)(v)) / this.TradedVolume;
                    return AdjustPriceD(p);
                }
            }
        }
        //󂯓n
        public long TotalTradeAmount {
            get {
                long v = 0;
                if(_trades!=null) {
                    for(int i=0; i<_trades.Count; i++) v += _trades[i].TradeAmount;
                }
                v *= _stock.Profile.ImplicitPriceFactor;
                return AdjustPriceL(v);
            }
        }
        //tort
        public bool IsBuying {
            get {
                return OrderingUtil.IsLong(_direction) ^ _newOrClose==OrderNewClose.Close;
            }
        }

        public void AddTradeItem(Element e) {
            if(_trades==null) _trades = new List<Element>();
            _trades.Add(e);
        }
        public void AddTradeItem(int time, int price, int voluem) {
            Element e = new Element();
            e.TimeAsInt = time;
            e.Volume = voluem;
            e.Price = price;
            AddTradeItem(e);
        }

        //l@敨SQ̂Ŗl̂ƂB̒
        public long AdjustPriceL(long rawvalue) {
            if(_stock.Profile.IsDerivative)
                return rawvalue / 100;
            else
                return rawvalue;
        }
        public double AdjustPriceD(double rawvalue) {
            if(_stock.Profile.IsDerivative)
                return rawvalue / 100.0;
            else
                return rawvalue;
        }
        public int AdjustPriceI(int rawvalue) {
            if(_stock!=null && _stock.Profile.IsDerivative)
                return rawvalue / 100;
            else
                return rawvalue;
        }
        public int AdjustReversePriceI(int value) {
            if(_stock!=null && _stock.Profile.IsDerivative)
                return value * 100;
            else
                return value;
        }
    }

    //|WV
    //ElementĂ\ɂȂĂBAPIxł͓̌ċʕʂɃf[^邪A\IvVɂĂ͂܂Ƃ߂Ĉꌏɂ邱ƂB
    public class TradePositionItem {
        //|WV̍ڂ́AMpł͕ɂȂ肤B̈Ⴂ̂
        public class Element {
            private BDate _date;
            private int _price100; //Ăl100{ Qʂ܂œO
            private int _volume;
            private int _orderingVolume;
            private int _keihi;  //o
            private int _risoku; //
            //v͑̍ڂvZ\ł͂邪AGMȌꍇ|WV擾ŒlԂ̂łD悷
            private long _profit; //]v(z)
            private float _profitRatio; //]v(%)

            private string _positionID;

            public Element() {
            }
            public Element Clone() {
                Element r = new Element();
                r._date = _date==null? null : new BDate(_date);
                r._price100 = _price100;
                r._volume = _volume;
                r._orderingVolume = _orderingVolume;
                r._keihi = _keihi;
                r._risoku = _risoku;
                r._profit = _profit;
                r._profitRatio = _profitRatio;
                r._positionID = _positionID;
                return r;
            }

            public int DateAsInt {
                get {
                    return _date==null? 0 : _date.AsInt();
                }
                set {
                    if(_date==null)
                        _date = new BDate(value);
                    else
                        _date.LetInt(value);
                }
            }
            internal BDate Date {
                get {
                    return _date;
                }
                set {
                    _date = value;
                }
            }
            public int Price100 {
                get {
                    return _price100;
                }
                set {
                    _price100 = value;
                }
            }
            public int Volume {
                get {
                    return _volume;
                }
                set {
                    _volume = value;
                }
            }
            public int OrderingVolume {
                get {
                    return _orderingVolume;
                }
                set {
                    _orderingVolume = value;
                }
            }
            
            public int Keihi {
                get {
                    return _keihi;
                }
                set {
                    _keihi = value;
                }
            }
            public int Risoku {
                get {
                    return _risoku;
                }
                set {
                    _risoku = value;
                }
            }
            public string UniqueID {
                get {
                    return _positionID;
                }
                set {
                    _positionID = value;
                }
            }
            public long Profit {
                get {
                    return _profit;
                }
                set {
                    _profit = value;
                }
            }
            public float ProfitRatio {
                get {
                    return _profitRatio;
                }
                set {
                    _profitRatio = value;
                }
            }

        }
        private Stock _stock;
        private OrderDealType _dealType;
        private LongShort _longShort;
        private OrderKouza _kouza;
        private int _currentPrice100; //敨ł͐ZlƂďɂȂ邱Ƃ
        private OrderRestriction _restriction;
        private List<Element> _positionElements;

        public TradePositionItem(Stock stock) {
            _stock = stock;
            _positionElements = new List<Element>();
        }
        public TradePositionItem Clone() {
            TradePositionItem r = new TradePositionItem(_stock);
            r._dealType = _dealType;
            r._longShort = _longShort;
            r._currentPrice100 = _currentPrice100;
            r._kouza = _kouza;
            r._restriction = _restriction;
            foreach(Element e in _positionElements) r._positionElements.Add(e.Clone());
            return r;
        }
        public void AddPositionElement(Element item) {
            _positionElements.Add(item);
        }
        public int ElementCount {
            get {
                return _positionElements.Count;
            }
        }
        public List<Element> ElementCollectionCopy() {
            List<Element> r = new List<Element>();
            foreach(Element e in _positionElements) r.Add(e.Clone());
            return r;
        }
        public Stock Stock {
            get {
                return _stock;
            }
        }
        public OrderDealType DealType {
            get {
                return _dealType;
            }
            set {
                _dealType = value;
            }
        }
        public LongShort LongShort {
            get {
                return _longShort;
            }
            set {
                _longShort = value;
            }
        }
        public OrderKouza OrderKouza {
            get {
                return _kouza;
            }
            set {
                _kouza = value;
            }
        }
        public int CurrentPrice100 {
            get {
                return _currentPrice100;
            }
            set {
                _currentPrice100 = value;
            }
        }
        public OrderRestriction OrderRestriction {
            get {
                return _restriction;
            }
            set {
                _restriction = value;
            }
        }

        public Element LastTradeItem {
            get {
                Debug.Assert(_positionElements.Count > 0);
                return _positionElements[_positionElements.Count-1];
            }
        }
        public Element GetPositionAt(int index) {
            return _positionElements[index];
        }

        //vԂ
        private delegate int TradeItemEnum(Element item);
        private int SumTradeItem(TradeItemEnum e) {
            int r = 0;
            foreach(Element item in _positionElements)
                r += e(item);
            return r;
        }
        public int TotalVolume {
            get {
                return SumTradeItem(delegate(Element item) { return item.Volume; });
            }
        }
        public int TotalOrderingVolume {
            get {
                return SumTradeItem(delegate(Element item) { return item.OrderingVolume; });
            }
        }
        public int LeftVolume {
            get {
                return this.TotalVolume - this.TotalOrderingVolume;
            }
        }
        public int TotalKeihi {
            get {
                return SumTradeItem(delegate(Element item) { return item.Keihi; });
            }
        }
        public int TotalRisoku {
            get {
                return SumTradeItem(delegate(Element item) { return item.Risoku; });
            }
        }
        public double AveragePrice {
            get {
                //intŉ񂷂ƃI[o[t[̊댯B21炢Ȃ񌻎ł͂Ȃ
                double sum = 0;
                int volume = 0;
                foreach(Element item in _positionElements) {
                    sum += (double)item.Price100 * item.Volume;
                    volume += item.Volume;
                }
                return sum / 100.0 / volume;
            }
        }
        public string AveragePriceAsString(string format) {
            double value = this.AveragePrice;
            if(value==0) return "-";
            string t = value.ToString(format);
            if(t.EndsWith(".00"))
                return t.Substring(0, t.Length-3);
            else
                return t;

        }
        public long TotalProfit {
            get {
                long sum = 0;
                foreach(Element item in _positionElements)
                    sum += item.Profit;
                return sum;
            }
        }

        public bool HasMultipleTatebi {
            get {
                Debug.Assert(_dealType!=OrderDealType.Genbutsu);
                int d = -1;
                foreach(Element item in _positionElements) {
                    if(d==-1)
                        d = item.DateAsInt;
                    else if(d!=item.DateAsInt)
                        return true;
                }
                return false;
            }
        }
    }

    //ꂼ̃RNVNX
    public abstract class OrderOrPositionList<T> : IEnumerable<T> {
        protected List<T> _data;
        public OrderOrPositionList() {
            _data = new List<T>();
        }
        public int Count {
            get {
                return _data.Count;
            }
        }
        public void AddItem(T item) {
            Debug.Assert(item!=null);
            _data.Add(item);
        }
        public void RemoveItem(T item) {
            _data.Remove(item);
        }
        public T this[int index] {
            get {
                return _data[index];
            }
        }
        public IEnumerator<T> GetEnumerator() {
            return _data.GetEnumerator();
        }
        IEnumerator IEnumerable.GetEnumerator() {
            return _data.GetEnumerator();
        }

        public void Sort(Comparison<T> c) {
            _data.Sort(c);
        }
    }

    public class TradeOrderList : OrderOrPositionList<TradeOrderItem> {
        public TradeOrderItem FindTradeOrderItemByID(string id) {
            foreach(TradeOrderItem item in _data)
                if(item.UniqueString==id) return item;
            return null;
        }
        public void AddFirst(TradeOrderItem item) {
            Debug.Assert(item!=null);
            _data.Insert(0, item);
        }
        public void Replace(string id, TradeOrderItem item) {
            for(int i=0; i<_data.Count; i++) {
                if(_data[i].UniqueString==id) {
                    _data[i] = item;
                    return;
                }
            }
        }
    }
    public class TradePositionList : OrderOrPositionList<TradePositionItem> {
        //(+s)AʁAʂvĂ|WV邩
        public TradePositionItem FindByPositionType(Stock stock, OrderDealType dt, LongShort ls, OrderKouza kouza) {
            for(int i=0; i<_data.Count; i++) {
                TradePositionItem p = _data[i];
                if(p.Stock==stock && p.DealType==dt && p.LongShort==ls && p.OrderKouza==kouza) return p;
            }
            return null;
        }
    }
}
